#!/bin/bash
####################################################################################
#
#   AUTORES: Jaime Sáiz de la Peña y los alumnos de la asignatura Sistemas Operativos del Grado en Ingeniería Informática (2012-2024) - Universidad de Burgos
#	TUTOR: José Manuel Saiz Diez
#
####################################################################################
# Script realizado para la simulación de un SO que utilice diferentes modelos de gestión de procesos y memoria con un total de 32 opciones diferentes.
# El algoritmo de gestión de procesos se basará en FCFS, SJF, SRPT, Prioridad Mayor y Menor (Apropiativo y No Apropiativo) y Round-Robin.
# La gestión de memoria se implementa según las necesidades de los procesos y podrá ser Continua y No continua, y Reubicable y no resubicable.

####################################################################################
# VARIABLES DE EJECUCIÓN
####################################################################################
# seleccionMenuInicio - Opciones iniciales de ayuda y ejecución
# seleccionMenuAyuda - Opciones de ayuda
# seleccionMenuDOCPDF - Opciones de elección de ficheros PDF de ayuda de los algoritmos
# seleccionMenuDOCVideo - Opciones de elección de ficheros de vídeo de ayuda de los algoritmos
# seleccionMenuAlgoritmoGestionProcesos - Opciones de elección de algoritmo d gestión de Procesos (FCFS/SJF/SRPT/Prioridades/Round-Robin)
# seleccionTipoPrioridad - Opciones del tipo de Prioridad (Mayor/Menor)
# seleccionMenuApropiatividad - Opciones del tipo de Apropiatividad (Apropiativo/No Apropiativo)
# seleccionMenuReubicabilidad - Opciones del tipo de memoria (Reubicable/No Reubicable)
# seleccionMenuContinuidad - Opciones del tipo de memoria (Continua/No Continua)
# seleccionMenuEleccionEntradaDatos - Opciones para la elección de fuente en la introducción de datos (Datos manual/Fichero de datos de última ejecución/Fichero de datos por defecto/Otro fichero de datos...
# .../Rangos manual/Fichero de rangos de última ejecución/Fichero de rangos por defecto/Otro fichero de rangos...
# .../Rangos aleatorios manual/Fichero de rangos aleatorios de última ejecución/Fichero de rangos aleatorios por defecto/Otro fichero de rangos aleatorios)
# .../Rangos aleatorios amplios manual/Fichero de rangos aleatorios amplios de última ejecución/Fichero de rangos aleatorios amplios por defecto/Otro fichero de rangos aleatorios amplios)
# seleccionMenuModoTiempoEjecucionAlgormitmo - Opciones para la elección del tipo de ejecución (Por eventos/Automatico/Completo)
# seleccionMenuPreguntaDondeGuardarDatosManuales - Opciones para la selección del fichero de datos de salida (datosDefault, Otros)
# seleccionMenuPreguntaDondeGuardarRangosManuales - Opciones para la selección del fichero de rangos de salida (rangosDefault, Otros)
# seleccionMenuPreguntaDondeGuardarRangosAleTManuales - Opciones para la selección del fichero de rangos amplios (ficheroRangosAleTotalDefault, Otros)
####################################################################################
# VARIABLES DE REPRESENTACIÓN DEL MAPA DE MEMORIA
####################################################################################
terminal=0 # Ancho del terminal en cada Enter de ejecución de volcados
longCampoTablaEstrecho=3 # ancho de columnas estrechas en tabla resumen de procesos en los volcados
longCampoTablaAncho=4 # ancho de columnas anchas en tabla resumen de procesos en los volcados
longCampoTablaMasAncho=5 # ancho de columnas más anchas en tabla resumen de procesos en los volcados
longCampoTablaMuyAncho=17 # ancho de columnas muy anchas en tabla resumen de procesos en los volcados
longCampoTablaRangosCortos=3 # ancho de columnas estrechas en tabla de rangos
longCampoTablaRangosLargos=9 # ancho de columnas anchas en tabla de rangos
varhuecos="                                                                                     "
varguiones="------------------------------------------------------------------------------------"
varasteriscos="*********************************************************************************"
varfondos="█████████████████████████████████████████████████████████████████████████████████████"
esc=$(echo -en "\033")
RESET=$esc"[0m"

####################################################################################
# VARIABLES PARA DESTACAR TEXTO CON COLOR
####################################################################################
NORMAL=$esc"[0;m"		#NORMAL=$esc"[1;m"
ROJO=$esc"[0;31m"		#ROJO=$esc"[1;31m"
VERDE=$esc"[0;32m"		#VERDE=$esc"[1;32m"
AMARILLO=$esc"[0;33m"	#AMARILLO=$esc"[1;33m"
AZUL=$esc"[0;34m"		#AZUL=$esc"[1;34m"
MORADO=$esc"[0;35m"		#MORADO=$esc"[1;35m"
CYAN=$esc"[0;36m"		#CYAN=$esc"[1;36m"
#Variables de colores
amarillo="\033[1;33m";
verde='\e[1;32m';
morado='\e[1;35m';
rojo='\e[1;31m';
cian='\e[1;36m';
gris='\e[1;30m';
azul='\e[1;34m';
blanco='\e[1bold;37m';
NC='\e[0m'; #default	#reset
#Vector de colores
coloress=();
#coloress[0]='\e[0;36m' #cian	 		#
coloress[0]='\e[1;36m' 	#cian res		#
coloress[1]='\e[1;32m' 	#verde res    	#
coloress[2]='\e[1;35m' 	#morad res    	#FMAG="\033[0;35m" # foreground magenta
coloress[3]='\e[1;33m' 	#amarillo res  	#
coloress[4]='\e[1;31m' 	#rojo res    	#
#coloress[5]='\e[0;34m' 	#azul 			#FBLE="\033[0;34m" # foreground blue
coloress[5]='\e[1;34m' 	#azul res		#FBLE="\033[1;34m" # foreground blue
coloress[6]='\e[0;33m' 	#amarillo		#FYEL="\033[0;33m" # foreground yellow
coloress[7]='\e[1;36m' 	#cian res		#
coloress[8]='\e[0;31m' 	#rojo			#FRED="\033[0;31m" # foreground red
coloress[9]='\e[1;34m' 	#azul re		#
coloress[10]='\e[0;35m' #morado			#
coloress[11]='\e[1;33m' #amarillo res	#
coloress[12]='\e[1;32m' #verde res		#
coloress[13]='\e[0;36m' #cian			#FCYN="\033[0;36m" # foreground cyan
coloress[14]='\e[1;35m' #morad res		#
coloress[15]='\e[0;32m' #verde			#FGRN="\033[0;32m" # foreground green
coloress[16]='\e[1;31m' #rojo res		#
coloress[97]='\e[1;m' 	#default		#
coloress[98]='\e[0;97m' #blanco			#
coloress[99]='\e[8m' 	#INVISIBLE
#Vector de colores con el fondo pintado.
colorfondo=();
colorfondos[0]='\e[1;97;46m' 	#colorfondos[0]='\e[0;36;46m' 		#cian			#BCYN="\033[0;46m" # background cyan
colorfondos[1]='\e[1;97;1;42m' 	#colorfondos[1]='\e[1;32;1;42m' 	#verde_res		#
colorfondos[2]='\e[1;97;1;45m' 	#colorfondos[2]='\e[1;35;1;45m' 	#morado_res		#
colorfondos[3]='\e[1;97;1;43m' 	#colorfondos[3]='\e[1;33;1;43m' 	#amarillo_res	#
colorfondos[4]='\e[1;97;1;41m' 	#colorfondos[4]='\e[1;31;1;41m' 	#rojo_res		#
colorfondos[5]='\e[1;97;44m' 	#colorfondos[5]='\e[0;34;44m' 		#azul			#BBLE="\033[0;44m" # background blue
colorfondos[6]='\e[1;97;43m' 	#colorfondos[6]='\e[0;33;43m' 		#amarillo		#BYEL="\033[0;43m" # background yellow
colorfondos[7]='\e[1;97;1;46m' 	#colorfondos[7]='\e[1;36;1;46m' 	#cian_res		#
colorfondos[8]='\e[1;97;41m' 	#colorfondos[8]='\e[0;31;41m' 		#rojo			#BRED="\033[0;41m" # background red
colorfondos[9]='\e[1;97;1;44m' 	#colorfondos[9]='\e[1;34;1;44m' 	#azul_res		#
colorfondos[10]='\e[1;97;45m' 	#colorfondos[10]='\e[0;35;45m' 		#morado			#BMAG="\033[0;45m" # background magenta
colorfondos[15]='\e[1;97;42m' 	#colorfondos[15]='\e[0;32;42m' 		#verde			#BGRN="\033[0;42m" # background green
colorfondos[98]='\e[97;47m' 	#colorfondos[98]='\e[97;47m' 		#blanco			#BWHT="\033[0;47m" # background white
# ANSI color codes
HC="\033[1m"    # hicolor
UL="\033[4m"    # underline
INV="\033[7m"   # inverse background and foreground
FBLK="\033[0;30m" # foreground black
FWHT="\033[0;37m" # foreground white
BBLK="\033[0;40m" # background black

#################################################################################
#                         VARIABLES
#################################################################################
# Se declaran los arrays y variables con los que trabajaremos en el script.
# Los procesos tendrán casi todos los elementos de cada una de estas tablas.
# A cada proceso se le asocia un índice, que será el mismo en todas las tablas, es decir, el proceso 1 tendrá la primera posición de cada array.
#
# reloj - Instante de tiempo que se está tratando en el programa (reloj).
# nprocesos - Número total de procesos.
# encola() Contendrá qué procesos pueden entrar en memoria. Los valores son:
#	0 : El proceso no ha entrado en la cola (no ha "llegado" - Estado "Fuera del sistema") 
#	1 : El proceso está en la cola (Estado "En espera")
# enmemoria() - Procesos que se encuentran en memoria. Los valores son:
#	0 : El proceso no está en memoria
#	1 : El proceso está en memoria esperando a ejecutarse (Estado "En memoria")
# Estados de los procesos:
#	${estad[$i]}=0 - ${estado[$i]}="Fuera del Sistema"
#	${estad[$i]}=1 - ${estado[$i]}="En espera"
#	${estad[$i]}=2 - ${estado[$i]}="En memoria" 
#	${estad[$i]}=3 - ${estado[$i]}="En ejecución" 
#	${estad[$i]}=4 - ${estado[$i]}="En pausa" 
#	${estad[$i]}=5 - ${estado[$i]}="Finalizado"
#
# El tamaño de cada array será el valor de nprocesos, excepto los relacionados con la memoria que serán dinámicos.
#################################################################################

# Declaración de los arrays:
reloj=0 #Variable que guarda el tiempo de ejecución actual
declare -a dibujasNC #Contiene el número de unidades de ejecución y será usado para controlar que serán representadas en las bandas.
declare -a nombre #Variacble intermedia usada para la creación automática de los nombres de los procesos.
declare -a proceso #Índices: (proceso). Nombre de los procesos (P01,...).
declare -a llegada #Índices: (proceso). Tiempo de llegada de los procesos
declare -a ejecucion #Índices: (proceso). Tiempo de ejecución de los procesos
declare -a memoria #Índices: (proceso). Unidades de memoria asociados a los procesos
declare -a numeroproceso #Variable recogida de datos para ordenar el temporal por tiempo de llegada
declare -a temp_exec #Índices: (proceso). Tiempo ya ejecutado de los procesos
declare -a temp_wait #Índices: (proceso). Tiempo ya esperado por los procesos
declare -a temp_ret #Índices: (proceso). Tiempo de retorno de los procesos
declare -a temp_rej #Índices: (proceso). Tiempo restante de ejecución de los procesos
declare -a pos_inicio #Índices: (proceso). Posición inicial de cada uno de los huecos de memoria asociados a cada proceso.
declare -a pos_final  #Índices: (proceso). Posición final de cada uno de los huecos de memoria asociados a cada proceso.
declare -a nollegado #Índices: (proceso). Estado inicial de los procesos cuando aún no han llegado al sistema.
declare -a encola #Índices: (proceso). Estado de los procesos cuando han llegado al sistema, pero aún no han entrado a la memoria.    
declare -a enmemoria #Índices: (proceso). Estado de los procesos cuando han entrado en memoria, pero aún no han empezado a ejecutarse.
declare -a enpausa #Índices: (proceso). Estado de los procesos cuando un proceso ya ha empezado a ejecutarse, pero aunque no han terminado de ejecutarse, otro proceso ha comenzado a ejecutarse.
declare -a enejecucion #Índices: (proceso). Estado de los procesos cuando un proceso ya ha empezado a ejecutarse
declare -a bloqueados #Índices: (proceso). Estado de los procesos cuando un proceso está "En Espera" porque ha llegado al sistema pero no puede entrar a memoria.
declare -a terminados #Índices: (proceso). Estado de los procesos cuando ya han terminado de ejecutarse
declare -a estad #Índices: (proceso). Número asociado a cada estado de los procesos (de 1 a 5).
declare -A estado #Índices: (proceso). Texto asociado a cada estado de los procesos (de "Fuera del Sistema" a "Finalizado").
declare -a unidMemOcupadas #Índices: (ordinal del número de marco). Secuencia de los procesos que ocupan cada marco de la memoria completa
declare -a unidMemOcupadasAux #Índices: (ordinal del número de marco)Matriz auxiliar de la memoria no continua (para reubicar)
declare -a escrito #Índices: (proceso). Bandera para no escibir dos veces un proceso en memoria. Se marca los procesos que se encuentran en memoria y a los que se les ha encontrado espacio sufiente en la banda de memoria. 
declare -a bloques #Almacena el número de bloques en los que se fragmenta un proceso
declare -a inicialNC #Posición inicial de cada bloque en la memoria NO CONTINUA
declare -a finalNC #Posición final de cada bloque en la memoria NO CONTINUA
declare -a inicialNCaux #Posición inicial en la memoria NO CONTINUA para impresiones (cuadrado en tabla)
declare -a finalNCaux #Posición final en la memoria NO CONTINUA para impresiones (cuadrado en tabla)
declare -a inicialNCmodelo #borrar posiciones innecesarias tras la impresión
declare -a finalNCmodelo #borrar posiciones innecesarias tras la impresión
declare -a nomtiempo #Para saber si un proceso en la barra de tiempo está nombrado, si se ha introducido en las variables de las diferentes líneas.
blancos=1 #Autorizar el paso de blancos - NO PARECE USARSE
hayproanterior=0 #bandera para saber si hay un proceso anterior que finalizar de dibujar
proanterior="_" #Contiene el proceso que se esté tratando en la asignación de dígitos en la representación de la banda de tiempo
declare -a coloresPartesMemoria #Guarda de uno en uno los colores para cada caracter de la barra de memoria (necesario impresión ventana)
declare -a coloresPartesTiempo #Guarda de uno en uno los colores para cada caracter de la línea del tiempo (necesario impresión ventana)
declare -a guardadoMemoria #Array que va a guardar el orden de la reubicacion
declare -a tamanoGuardadoMemoria #Array que guarda en orden de reubicación la memoria que ocupan
reubicabilidadNo0Si1=0 #Si vale 0 no es reubicable. Si vale 1 es reubicable.
continuidadNo0Si1=0 #Si vale 0 es no continua. Si vale 1 es continua.
declare -a procPorUnidadTiempoBT #En cada casilla (instante actual - reloj) se guarda el número de orden del proceso que se ejecuta en cada instante.
anteriorProcesoEjecucion=-1 #Usada en gestionProcesosSRPT, gestionProcesosPrioridades y gestionProcesosRoundRobin para determinar la anteriorproceso en ejecución que se compara con el actual tiempo restante de ejecución más corto y que va a ser definida como el actual proceso en ejecución.

####################################################################################
# Ficheros de salida.
####################################################################################
dirFLast="./FLast" #Directorio que contiene los ficheros de última ejecución (datos (DatosLast.txt), rangos (RangosLast.txt) y rangos amplios (RangosAleTotalLast)).
dirFDatos="./FDatos" #Directorio con los ficheros de datos generados por defecto (DatosDefault.txt) o por decisión del susuario.
dirFRangos="./FRangos" #Directorio con los ficheros de datos generados por defecto (RangosDefault.txt) o con el nombre por decisión del susuario.
dirFRangosAleT="./FRangosAleT" #Directorio con los ficheros de datos generados por defecto (RangosAleTotalDefault.txt) o con el nombre por decisión del susuario.
dirInformes="./Informes" #Directorio con los ficheros que contendrán todos los volcados de la ejecución del script en color (informeCOLOR.txt) y en blanco y negro (informeBN.txt).
informeSinColorTotal="./Informes/informeBN.txt" #Informe en blanco/negro de todo lo visto en pantalla durante la ejecución del script.
informeConColorTotal="./Informes/informeCOLOR.txt" #Informe a color de todo lo visto en pantalla durante la ejecución del script.

ficheroDatosAnteriorEjecucion="./FLast/DatosLast.txt" #Datos de particiones y procesos de la ejecución anterior.
ficheroDatosDefault="./FDatos/DatosDefault.txt" #Datos de particiones y procesos de la copia estándar (por defecto).

ficheroRangosAnteriorEjecucion="./FLast/RangosLast.txt" #Rangos de particiones y procesos de la ejecución anterior.
ficheroRangosDefault="./FRangos/RangosDefault.txt" #Rangos de particiones y procesos de la copia estándar (por defecto).

ficheroRangosAleTotalAnteriorEjecucion="./FLast/RangosAleTotalLast.txt" #Rangos amplios de particiones y procesos de la ejecución anterior para la extracción de subrangos.
ficheroRangosAleTotalDefault="./FRangosAleT/RangosAleTotalDefault.txt" #Rangos amplios de particiones y procesos de la copia estándar (por defecto) para la extracción de subrangos.

nomFicheroDatos="./FDatos/DatosDefault.txt" #Se inicializa la variable de fichero de datos
nomFicheroRangos="./FRangos/RangosDefault.txt" #Se inicializa la variable de fichero de rangos
nomFicheroRangosAleT="./FRangosAleT/RangosAleTotalDefault.txt" #Se inicializa la variable de fichero de rangos amplios

####################################################################################
####################################################################################
#             FUNCIONES
####################################################################################
####################################################################################
# Sinopsis: Al inicio del programa muestra la cabecera por pantalla y la envía a los informes de B/N y COLOR.
####################################################################################
function presentacionPantallaInforme {
#	clear
	echo -e "\t$azul┌──────────────────────────────────────────────────────────┐\n"\
	"\t$azul│             $cian Creative Commons (CC BY-NC-SA) $NC             $azul│\n"\
	"\t$azul│                                                          $azul│\n"\
	"\t$azul│             $cian BY - Atribución - Reconocimiento $NC           $azul│\n"\
	"\t$azul│             $cian NC - Uso No Comercial $NC                      $azul│\n"\
	"\t$azul│             $cian SA - Compartir Igual $NC                       $azul│\n"\
	"\t$azul└──────────────────────────────────────────────────────────┘$NC\n"\
	"$azul  ┌───────────────────────────────────────────────────────────────────┐\n"\
	"$azul  │         $cian Algoritmo de Gestión de Procesos: $NC                       $azul│\n"\
	"$azul  │         $cian       FCFS/SJF/SRPT/Prioridad Mayor y Menor, $NC            $azul│\n"\
	"$azul  │         $cian       Apropiativo y No Apropiativo/Round-Robin $NC          $azul│\n"\
	"$azul  │         $cian Algoritmo de Gestión de Memoria:                  $NC       $azul│\n"\
	"$azul  │         $cian       Según necesidades (Continua y No Continua, $NC        $azul│\n"\
	"$azul  │         $cian       Reubicable y No Reubicable) $NC                       $azul│\n"\
	"$azul  │                                                                   $azul│\n"\
	"$azul  │ $cian         Autores: Jaime Sáiz de la Peña                     $NC      $azul│\n"\
	"$azul  │ $cian     y los alumnos de la asignatura Sistemas Operativos$NC           $azul│\n"\
	"$azul  │     $cian                                          $NC                    $azul│\n"\
	"$azul  │     $cian     Grado en Ingeniería Informática (2012-2024)        $NC      $azul│\n"\
	"$azul  │     $cian             Universidad de Burgos  $NC                          $azul│\n"\
	"$azul  │     $cian                                          $NC                    $azul│\n"\
	"$azul  │     $cian Tutor: José Manuel Sáiz Diez $NC                                $azul│\n"\
	"$azul  │                                                                   $azul│$NC\n"\
	"$azul  │               $cian Versión junio 2024 (V-0.1) $NC                        $azul│\n"\
	"$azul  │                                                                   $azul│$NC\n"\
	"$azul  └───────────────────────────────────────────────────────────────────┘\n"\ | tee -a $informeConColorTotal #La opción -a lo crea inicialmente en caso de no estar creado
	DIA=$(date +"%d/%m/%Y")
	HORA=$(date +"%H:%M")
	echo -e $NORMAL" ÚLTIMA EJECUCIÓN: $DIA - $HORA\n" | tee -a $informeConColorTotal

	echo -e "\t┌──────────────────────────────────────────────────────────┐\n"\
	"\t│               Creative Commons (CC BY-NC-SA)             │\n"\
	"\t│                                                          │\n"\
	"\t│               BY - Atribución - Reconocimiento           │\n"\
	"\t│               NC - Uso No Comercial                      │\n"\
	"\t│               SA - Compartir Igual                       │\n"\
	"\t└──────────────────────────────────────────────────────────┘\n"\
	"  ┌───────────────────────────────────────────────────────────────────┐\n"\
	"  │           Algoritmo de Gestión de Procesos:                       │\n"\
	"  │                 FCFS/SJF/SRPT/Prioridad Mayor y Menor,            │\n"\
	"  │                 Apropiativo y No Apropiativo/Round-Robin          │\n"\
	"  │           Algoritmo de Gestión de Memoria:                        │\n"\
	"  │                 Según necesidades (Continua y No Continua,        │\n"\
	"  │                 Reubicable y No Reubicable)                       │\n"\
	"  │                                                                   │\n"\
	"  │           Autores: Jaime Sáiz de la Peña                          │\n"\
	"  │       y los alumnos de la asignatura Sistemas Operativos          │\n"\
	"  │                                                                   │\n"\
	"  │           Grado en Ingeniería Informática (2012-2024)             │\n"\
	"  │                     Universidad de Burgosz                        │\n"\
	"  │                                                                   │\n"\
	"  │           Tutor: José Manuel Sáiz Diez                            │\n"\
	"  │                                                                   │\n"\
	"  │           Versión junio 2024 (V-0.1)                              │\n"\
	"  │                                                                   │\n"\
	"  └───────────────────────────────────────────────────────────────────┘\n"\ >> $informeSinColorTotal #La opción >> lo crea inicialmente
	DIA=$(date +"%d/%m/%Y")
	HORA=$(date +"%H:%M")
	echo -e " ÚLTIMA EJECUCIÓN: $DIA - $HORA\n" >> $informeSinColorTotal

	echo -ne $ROJO"\n\n Pulsa ENTER para continuar "$NORMAL
	read enterContinuar
} #Fin de presentacionPantallaInforme()

####################################################################################
# Sinopsis: Cabecera de inicio
####################################################################################
function cabecerainicio {
	echo -e "$azul   ┌─────────────────────────────────────────────────────────────────────────────┐\n"\
	"$azul  │                                                                             $azul│$NC\n"\
	"$azul  │   $cian GESTIÓN DE PROCESOS: FCFS/SJF/SRPT/Prioridad Mayor y Menor/Round-Robin$NC   $azul│$NC\n"\
	"$azul  │   $cian GESTIÓN DE MEMORIA: SEGÚN NECESIDADES$NC                                    $azul│$NC\n"\
	"$azul  │                                                                             $azul│$NC\n"\
	"$azul  └─────────────────────────────────────────────────────────────────────────────┘\n"\ | tee -a $informeConColorTotal
	echo -e "   ┌────────────────────────────────────────────────────────────────────────────┐\n"\
	"  │                                                                            │\n"\
	"  │   GESTIÓN DE PROCESOS: FCFS/SJF/SRPT/Prioridad Mayor y Menor/Round-Robin   │\n"\
	"  │   GESTIÓN DE MEMORIA: SEGÚN NECESIDADES                                    │\n"\
	"  │                                                                            │\n"\
	"  └────────────────────────────────────────────────────────────────────────────┘\n"\ >> $informeSinColorTotal
} #Fin de cabecerainicio()

####################################################################################
# Sinopsis: Menú inicial con ayuda y ejecución
####################################################################################
function menuInicio {
#	clear
	cabecerainicio
	echo -ne "\n MENÚ INICIO\n"\
	"\n  1. Ejecutar el algoritmo - Memoria Según Necesidades\n"\
	"\n  2. Menú de ayuda (requiere 'evince' para los ficheros PDF, o 'mplayer' para los ficheros de vídeo)\n"\
	"\n  3. Crear informe de código mediante zshelldoc\n"\
	"\n  4. Salir\n\n  --> " | tee -a $informeConColorTotal $informeSinColorTotal
	read seleccionMenuInicio
	echo -ne "$seleccionMenuInicio\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuInicio\n\n" >> $informeSinColorTotal
	until [[ $seleccionMenuInicio > 0 && $seleccionMenuInicio < 5 ]]; do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuInicio
		echo -e "$seleccionMenuInicio\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuInicio\n\n" >> $informeSinColorTotal
	done
	case "$seleccionMenuInicio" in
		'1')
			menuAlgoritmoGestionProcesos #Menú de elección de algoritmo de gestión de procesos.
			menuContinuidad #Menú de elección de continuidad.
			menuReubicabilidad #Menú de elección de reubicabilidad.
			menuEleccionEntradaDatos #Menú de elección de entrada de datos.
			;;
		'2')
			menuAyuda #Permite ver los ficheros de ayuda en formato PDF y de vídeo
			;;
		'3')
			echo $0
			echo " El informe resultante es ./zsdoc/$0.adc junto con el subdirectorio ./zsdoc/data." | tee -a $informeConColorTotal
			echo " El informe resultante es ./zsdoc/$0.adc junto con el subdirectorio ./zsdoc/data." >> $informeSinColorTotal
			echo " Si el formato no es el adecuado o para estandarizar ese formato, se puede imprimir o transformar el documento a fichero pdf." | tee -a $informeConColorTotal
			echo " Si el formato no es el adecuado o para estandarizar ese formato, se puede imprimir o transformar el documento a fichero pdf." >> $informeSinColorTotal
			/home/$USER/opt/local/bin/zsd --verbose $0 #...O el directorio que se corresponda con la localización de zshelldoc, dependiendo de dónde se haya instalado
			exit 0
			;;
		'4')
			echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0 ;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal ;;
	esac
} #Fin de menuInicio()

####################################################################################
# Sinopsis: Menú de ayuda con ficheros PDF y de vídeo
####################################################################################
function menuAyuda {
#	clear
	cabecerainicio
	echo -ne "\n MENÚ DE AYUDA\n"\
	"\n  1. Ver documentos de ayuda del en formato PDF desde el listado de problemas (requiere 'evince')\n"\
	"\n  2. Ver documentos de ayuda en formato PDF desde el listado de ficheros (requiere 'evince')\n"\
	"\n  3. Ver documentos de ayuda en formato Vídeo desde el listado de problemas (requiere 'mplayer')\n"\
	"\n  4. Ver documentos de ayuda en formato Vídeo desde el listado de ficheros (requiere 'mplayer')\n"\
	"\n  5. Salir\n\n  --> " | tee -a $informeConColorTotal $informeSinColorTotal
	read seleccionMenuInicio
	until [[ $seleccionMenuInicio > 0 && $seleccionMenuInicio < 6 ]]; do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuInicio
		echo -e "$seleccionMenuInicio\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuInicio\n\n" >> $informeSinColorTotal
	done
	case "$seleccionMenuInicio" in
		'1')
			menuDOCPDF
			;;
		'2') #Un fichero a elegir
			echo -e "\n\nFicheros de ayuda existentes en formato PDF:\n$NORMAL" | tee -a $informeConColorTotal
			echo -e "\n\nFicheros de ayuda existentes en formato PDF:\n" >> $informeSinColorTotal
			files=("./DOCPDF"/*)
			for i in "${!files[@]}"; do #Localiza en qué posición encuentra el dato (da la posición, pero no la variable en el array)
				echo -e "$((i+1))) ${files[$i]}" | tee -a $informeConColorTotal
				echo -e "$((i+1))) ${files[$i]}" >> $informeSinColorTotal
			done
			echo -ne "\n$AMARILLO\nIntroduce el número correspondiente al fichero elegido: $NORMAL" | tee -a $informeConColorTotal
			echo -ne "\n\nIntroduce el número correspondiente al fichero elegido: " >> $informeSinColorTotal
			read -r numeroFicheroPDF
			echo -e "$numeroFicheroPDF\n\n" >> $informeConColorTotal
			echo -e "$numeroFicheroPDF\n\n" >> $informeSinColorTotal
			until [[ 0 -lt $numeroFicheroPDF && $numeroFicheroPDF -le ${#files[@]} && $numeroFicheroPDF -ne "" ]]; do
				echo -ne "Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
				echo -ne "Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
				read -r numeroFicheroPDF
				echo -e "$numeroFicheroPDF\n\n" >> $informeConColorTotal
				echo -e "$numeroFicheroPDF\n\n" >> $informeSinColorTotal
			done
			ficheroParaLecturaPDF="${files[$((numeroFicheroPDF-1))]}"
			evince $ficheroParaLecturaPDF
			menuInicio
			;;
		'3')
			menuDOCVideo
			;;
		'4')
			echo -e "\n\nFicheros de ayuda existentes en formato de Vídeo:\n$NORMAL" | tee -a $informeConColorTotal
			echo -e "\n\nFicheros de ayuda existentes en formato de Vídeo:\n" >> $informeSinColorTotal
			files=("./DOCVideo"/*)
			for i in "${!files[@]}"; do #Localiza en qué posición encuentra el dato (da la posición, pero no la variable en el array)
				echo -e "$((i+1))) ${files[$i]}" | tee -a $informeConColorTotal
				echo -e "$((i+1))) ${files[$i]}" >> $informeSinColorTotal
			done
			echo -ne "\n$AMARILLO\n\nIntroduce el número correspondiente al fichero elegido: $NORMAL" | tee -a $informeConColorTotal
			echo -ne "\n\n\nIntroduce el número correspondiente al fichero elegido: " >> $informeSinColorTotal
			read -r numeroFicheroVideo
			echo -e "$numeroFicheroVideo\n\n" >> $informeConColorTotal
			echo -e "$numeroFicheroVideo\n\n" >> $informeSinColorTotal
			until [[ 0 -lt $numeroFicheroVideo && $numeroFicheroVideo -le ${#files[@]} && $numeroFicheroVideo -ne "" ]]; do
				echo -ne "Error en la elección de una opción válida\n\n  --> " | tee -a $informeConColorTotal
				echo -ne "Error en la elección de una opción válida\n\n  --> " >> $informeSinColorTotal
				read -r numeroFicheroVideo
				echo -e "$numeroFicheroVideo\n\n" >> $informeConColorTotal
				echo -e "$numeroFicheroVideo\n\n" >> $informeSinColorTotal
			done
			ficheroParaLecturaVideo="${files[$((numeroFicheroVideo-1))]}"
			mplayer $ficheroParaLecturaVideo
			menuInicio
			;;
		'5')
			echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0 ;;
	esac
} #Fin de menuAyuda()

####################################################################################
# Sinopsis: Menú de elección del Algoritmo de Gestión de Procesos; FCFS, SJF, SRPT.
####################################################################################
function menuDOCPDF {
#    clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE DOCUMENTOS DE AYUDA (Texto en formato PDF - Necesita 'evince')\n"$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DE DOCUMENTOS DE AYUDA (Texto en formato PDF - Necesita 'evince')\n" >> $informeSinColorTotal
	echo -ne "\n  0. Gestión de Procesos y Gestión de Memoria - Introducción y Herramientas"\
	"\n  1. FCFS-Según Necesidades-No Continua-No Reubicable-Entrada manual de Datos"\
	"\n  2. SJF-Según Necesidades-Continua-No Reubicable-Entrada mediante Ficheros de Datos de Última Ejecución"\
	"\n  3. SRPT-Según Necesidades-No Continua-Reubicable-Entrada mediante Otros Ficheros de Datos"\
	"\n  4. Prioridades-Mayor-No Apropiativo-Según Necesidades-Continua-Reubicable-Entrada manual de Rangos"\
	"\n  5. Prioridades-Menor-Apropiativo-Según Necesidades-No Continua-Reubicable-Entrada mediante Ficheros de Rangos de Última Ejecución"\
	"\n  6. Round-Robin(RR)-Según Necesidades-No Continua-Reubicable-Entrada mediante Otros Ficheros de Rangos"\
	"\n  7. Prioridades-Mayor-No Apropiativo-Según Necesidades-Continua-No Reubicable-Entrada manual de Rangos Amplios"\
	"\n  8. Prioridades-Menor-Apropiativo-Según Necesidades-Continua-No Reubicable-Entrada mediante Ficheros de Rangos Amplios de Última Ejecución"\
	"\n  9. Round-Robin(RR)-Según Necesidades-No Continua-Reubicable-Entrada mediante Otros Ficheros de Rangos Amplios"\
	"\n  10. Salir\n\n  --> " | tee -a $informeConColorTotal $informeSinColorTotal
	read seleccionMenuDOCPDF
	echo -ne "$seleccionMenuDOCPDF\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuDOCPDF\n\n" >> $informeSinColorTotal

	#Comprobación de que el número introducido por el usuario es de 1 a 4
	until [[ "0" -lt $seleccionMenuDOCPDF && $seleccionMenuDOCPDF -lt "22" ]];	do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuDOCPDF
		echo -e "$seleccionMenuDOCPDF\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuDOCPDF\n\n" >> $informeSinColorTotal
	done

	if [[ $seleccionMenuDOCPDF -ge 0 && $seleccionMenuDOCPDF -le 9 ]]; then
		if [[ $seleccionMenuDOCPDF -eq 0 ]]; then evince ./DOCPDF/000-ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 1 ]]; then evince ./DOCPDF/2-001-FCFS-SN-NC-NR-MD.pdf
		elif [[ $seleccionMenuDOCPDF -eq 2 ]]; then evince ./DOCPDF/2-002-SJF-SN-C-NR-FDUE.pdf
		elif [[ $seleccionMenuDOCPDF -eq 3 ]]; then evince ./DOCPDF/2-003-SRPT-SN-NC-R-OFD.pdf
		elif [[ $seleccionMenuDOCPDF -eq 4 ]]; then evince ./DOCPDF/2-004-Prioridades-Mayor-NoAp-SN-C-R-MR.pdf
		elif [[ $seleccionMenuDOCPDF -eq 5 ]]; then evince ./DOCPDF/2-005-Prioridades-Menor-Ap-SN-NC-R-FRUE.pdf
		elif [[ $seleccionMenuDOCPDF -eq 6 ]]; then evince ./DOCPDF/2-006-RR-SN-NC-R-OFR.pdf
		elif [[ $seleccionMenuDOCPDF -eq 7 ]]; then evince ./DOCPDF/2-007-Prioridades-Mayor-NoAp-SN-C-NR-MRA.pdf
		elif [[ $seleccionMenuDOCPDF -eq 8 ]]; then evince ./DOCPDF/2-008-Prioridades-Menor-Ap-SN-C-NR-FRAUE.pdf
		elif [[ $seleccionMenuDOCPDF -eq 9 ]]; then evince ./DOCPDF/2-009-RR-SN-NC-R-OFRA.pdf
		fi
		menuInicio
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 10 ]]; then
		echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
	else
		echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
		echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
	fi
} #Fin de menuDOCPDF()

####################################################################################
# Sinopsis: Menú de elección del Algoritmo de Gestión de Procesos; FCFS, SJF, SRPT.
####################################################################################
function menuDOCPDF_ORI {
#    clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE DOCUMENTOS DE AYUDA (Texto en formato PDF - Necesita 'evince')\n"$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DE DOCUMENTOS DE AYUDA (Texto en formato PDF - Necesita 'evince')\n" >> $informeSinColorTotal
	echo -ne "\n  1. FCFS-Según Necesidades-Continua-Reubicable"\
	"\n  2. FCFS-Según Necesidades-Continua-No Reubicable"\
	"\n  3. FCFS-Según Necesidades-No Continua-Reubicable"\
	"\n  4. FCFS-Según Necesidades-No Continua-No Reubicable"\
	"\n  5. SJF-Según Necesidades-Continua-Reubicable"\
	"\n  6. SJF-Según Necesidades-Continua-No Reubicable"\
	"\n  7. SJF-Según Necesidades-No Continua-Reubicable"\
	"\n  8. SJF-Según Necesidades-No Continua-No Reubicable"\
	"\n  9. SRPT-Según Necesidades-Continua-Reubicable"\
	"\n  10. SRPT-Según Necesidades-Continua-No Reubicable"\
	"\n  11. SRPT-Según Necesidades-No Continua-Reubicable"\
	"\n  12. SRPT-Según Necesidades-No Continua-No Reubicable"\
	"\n  13. PrioridadesMayorMenor-Según Necesidades-Continua-Reubicable"\
	"\n  14. PrioridadesMayorMenor-Según Necesidades-Continua-No Reubicable"\
	"\n  15. PrioridadesMayorMenor-Según Necesidades-No Continua-Reubicable"\
	"\n  16. PrioridadesMayorMenor-Según Necesidades-No Continua-No Reubicable"\
	"\n  17. Round-Robin(RR)-Según Necesidades-Continua-Reubicable"\
	"\n  18. Round-Robin(RR)-Según Necesidades-Continua-No Reubicable"\
	"\n  19. Round-Robin(RR)-Según Necesidades-No Continua-Reubicable"\
	"\n  20. Round-Robin(RR)-Según Necesidades-No Continua-No Reubicable"\
	"\n  21. Salir\n\n  --> " | tee -a $informeConColorTotal $informeSinColorTotal
	read seleccionMenuDOCPDF
	echo -ne "$seleccionMenuDOCPDF\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuDOCPDF\n\n" >> $informeSinColorTotal

	#Comprobación de que el número introducido por el usuario es de 1 a 4
	until [[ "0" -lt $seleccionMenuDOCPDF && $seleccionMenuDOCPDF -lt "22" ]];	do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuDOCPDF
		echo -e "$seleccionMenuDOCPDF\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuDOCPDF\n\n" >> $informeSinColorTotal
	done

	if [[ $seleccionMenuDOCPDF -ge 1 && $seleccionMenuDOCPDF -le 20 ]]; then
		if [[ $seleccionMenuDOCPDF -eq 1 ]]; then
			evince ./DOCPDF/001-FCFS-SJF-SN-C-R-1.pdf
			evince ./DOCPDF/001-FCFS-SJF-SN-C-R-2.pdf
		elif [[ $seleccionMenuDOCPDF -eq 2 ]]; then evince ./DOCPDF/002-FCFS-SJF_SN_C_NR.pdf
		elif [[ $seleccionMenuDOCPDF -eq 3 ]]; then
			evince ./DOCPDF/003-FCFS-SJF-SN-NC-R-1.pdf
			evince ./DOCPDF/003-FCFS-SJF-SN-NC-R-2.pdf
			evince ./DOCPDF/003-FCFS-SJF-SN-NC-R-3.pdf
		elif [[ $seleccionMenuDOCPDF -eq 4 ]]; then
			evince ./DOCPDF/004-FCFS-SJF-SN-NC-NR-1.pdf
			evince ./DOCPDF/004-FCFS-SJF-SN-NC-NR-2.pdf
		elif [[ $seleccionMenuDOCPDF -eq 5 ]]; then
			evince ./DOCPDF/001-FCFS-SJF-SN-C-R-1.pdf
			evince ./DOCPDF/001-FCFS-SJF-SN-C-R-2.pdf
		elif [[ $seleccionMenuDOCPDF -eq 6 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 7 ]]; then
			evince ./DOCPDF/003-FCFS-SJF-SN-NC-R-1.pdf
			evince ./DOCPDF/003-FCFS-SJF-SN-NC-R-2.pdf
			evince ./DOCPDF/003-FCFS-SJF-SN-NC-R-3.pdf
		elif [[ $seleccionMenuDOCPDF -eq 8 ]]; then
			evince ./DOCPDF/004-FCFS-SJF-SN-NC-NR-1.pdf
			evince ./DOCPDF/004-FCFS-SJF-SN-NC-NR-2.pdf
		elif [[ $seleccionMenuDOCPDF -eq 9 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 10 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 11 ]]; then evince ./DOCPDF/011-SRPT-SN-NC-R.pdf
		elif [[ $seleccionMenuDOCPDF -eq 12 ]]; then evince ./DOCPDF/012-SRPT-SN-NC-NR.pdf
		elif [[ $seleccionMenuDOCPDF -eq 13 ]]; then
			evince ./DOCPDF/013-PRIMayorMenor-SN-C-R-1.pdf
			evince ./DOCPDF/013-PRIMayorMenor-SN-C-R-2.pdf
		elif [[ $seleccionMenuDOCPDF -eq 14 ]]; then evince ./DOCPDF/014-PRIMayorMenor-SN-C-NR.pdf
		elif [[ $seleccionMenuDOCPDF -eq 15 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 16 ]]; then evince ./DOCPDF/016-PRIMayorMenor-SN-NC-NR.pdf
		elif [[ $seleccionMenuDOCPDF -eq 17 ]]; then evince ./DOCPDF/017-RR-SN-C-R.pdf
		elif [[ $seleccionMenuDOCPDF -eq 18 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 19 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 20 ]]; then evince ./DOCPDF/020-RR-SN-NC-NR.pdf
		fi
		menuInicio
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 21 ]]; then
		echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
	else
		echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
		echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
	fi
} #Fin de menuDOCPDF_ORI()

####################################################################################
# Sinopsis: Menú de elección del Algoritmo de Gestión de Procesos; FCFS, SJF, SRPT.
####################################################################################
function menuDOCVideo {
#    clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE DOCUMENTOS DE AYUDA (Vídeos - Necesita 'mplayer')\n"$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DE DOCUMENTOS DE AYUDA (Vídeos - Necesita 'mplayer')\n" >> $informeSinColorTotal
	echo -ne "\n  1. FCFS-Según Necesidades-Continua-Reubicable"\
	"\n  2. FCFS-Según Necesidades-Continua-No Reubicable"\
	"\n  3. FCFS-Según Necesidades-No Continua-Reubicable"\
	"\n  4. FCFS-Según Necesidades-No Continua-No Reubicable"\
	"\n  5. SJF-Según Necesidades-Continua-Reubicable"\
	"\n  6. SJF-Según Necesidades-Continua-No Reubicable"\
	"\n  7. SJF-Según Necesidades-No Continua-Reubicable"\
	"\n  8. SJF-Según Necesidades-No Continua-No Reubicable"\
	"\n  9. SRPT-Según Necesidades-Continua-Reubicable"\
	"\n  10. SRPT-Según Necesidades-Continua-No Reubicable"\
	"\n  11. SRPT-Según Necesidades-No Continua-Reubicable"\
	"\n  12. SRPT-Según Necesidades-No Continua-No Reubicable"\
	"\n  13. PrioridadesMayorMenor-Según Necesidades-Continua-Reubicable"\
	"\n  14. PrioridadesMayorMenor-Según Necesidades-Continua-No Reubicable"\
	"\n  15. PrioridadesMayorMenor-Según Necesidades-No Continua-Reubicable"\
	"\n  16. PrioridadesMayorMenor-Según Necesidades-No Continua-No Reubicable"\
	"\n  17. Round-Robin(RR)-Según Necesidades-Continua-Reubicable"\
	"\n  18. Round-Robin(RR)-Según Necesidades-Continua-No Reubicable"\
	"\n  19. Round-Robin(RR)-Según Necesidades-No Continua-Reubicable"\
	"\n  20. Round-Robin(RR)-Según Necesidades-No Continua-No Reubicable"\
	"\n  25. Salir\n\n  --> " | tee -a $informeConColorTotal $informeSinColorTotal
	read seleccionMenuDOCVideo
	echo -ne "$seleccionMenuDOCVideo\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuDOCVideo\n\n" >> $informeSinColorTotal

	#Comprobación de que el número introducido por el usuario es de 1 a 4
	until [[ "0" -lt $seleccionMenuDOCVideo && $seleccionMenuDOCVideo -lt "22" ]];	do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuDOCVideo
		echo -e "$seleccionMenuDOCVideo\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuDOCVideo\n\n" >> $informeSinColorTotal
	done

	if [[ $seleccionMenuDOCVideo -ge 1 && $seleccionMenuDOCVideo -le 20 ]]; then
		if [[ $seleccionMenuDOCVideo -eq 1 ]]; then
			mplayer ./DOCVideo/001-FCFS-SN-C-R-1.mkv
			mplayer ./DOCVideo/001-FCFS-SN-C-R-2.mp4
		elif [[ $seleccionMenuDOCVideo -eq 2 ]]; then mplayer ./DOCVideo/002-FCFS-SJF_SN_C_NR.mp4
		elif [[ $seleccionMenuDOCVideo -eq 3 ]]; then
			mplayer ./DOCVideo/003-FCFS-SJF-SN-NC-R-1.mp4
			mplayer ./DOCVideo/003-FCFS-SJF-SN-NC-R-2.mp4
			mplayer ./DOCVideo/003-FCFS-SJF-SN-NC-R-3.mp4
		elif [[ $seleccionMenuDOCVideo -eq 4 ]]; then
			mplayer ./DOCVideo/004-FCFS-SJF-SN-NC-NR-1.mp4
			mplayer ./DOCVideo/004-FCFS-SJF-SN-NC-NR-2.mp4
		elif [[ $seleccionMenuDOCVideo -eq 5 ]]; then
			mplayer ./DOCVideo/001-FCFS-SN-C-R-1.mkv
			mplayer ./DOCVideo/001-FCFS-SN-C-R-2.mp4
		elif [[ $seleccionMenuDOCVideo -eq 6 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 7 ]]; then
			mplayer ./DOCVideo/003-FCFS-SJF-SN-NC-R-1.mp4
			mplayer ./DOCVideo/003-FCFS-SJF-SN-NC-R-2.mp4
			mplayer ./DOCVideo/003-FCFS-SJF-SN-NC-R-3.mp4
		elif [[ $seleccionMenuDOCVideo -eq 8 ]]; then
			mplayer ./DOCVideo/004-FCFS-SJF-SN-NC-NR-1.mp4
			mplayer ./DOCVideo/004-FCFS-SJF-SN-NC-NR-2.mp4
		elif [[ $seleccionMenuDOCVideo -eq 9 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 10 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 11 ]]; then mplayer ./DOCVideo/011-SRPT-SN-NC-R.mkv
		elif [[ $seleccionMenuDOCVideo -eq 12 ]]; then mplayer ./DOCVideo/012-SRPT-SN-NC-NR.mp4
		elif [[ $seleccionMenuDOCVideo -eq 13 ]]; then
			mplayer ./DOCVideo/013-PRIMayorMenor-SN-C-R-1.mp4
			mplayer ./DOCVideo/013-PRIMayorMenor-SN-C-R-2.mp4
		elif [[ $seleccionMenuDOCVideo -eq 14 ]]; then mplayer ./DOCVideo/014-PRIMayorMenor-SN-C-NR.mp4
		elif [[ $seleccionMenuDOCVideo -eq 15 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 16 ]]; then mplayer ./DOCVideo/016-PRIMayorMenor-SN-NC-NR.mp4
		elif [[ $seleccionMenuDOCVideo -eq 17 ]]; then mplayer ./DOCVideo/017-RR-SN-C-R.mp4
		elif [[ $seleccionMenuDOCVideo -eq 18 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 19 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 20 ]]; then mplayer ./DOCVideo/020-RR-SN-NC-NR.mkv
		fi
		menuInicio
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 21 ]]; then
		echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
	else
		echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
		echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
	fi
} #Fin de menuDOCVideo()

####################################################################################
# Sinopsis: Menú de elección del Algoritmo de Gestión de Procesos; FCFS, SJF, SRPT.
####################################################################################
function menuAlgoritmoGestionProcesos {
#	clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE ALGORITMO"$NORMAL\
	"\n\n  1. FCFS"\
	"\n\n  2. SJF"\
	"\n\n  3. SRPT"\
	"\n\n  4. Prioridades"\
	"\n\n  5. Round-Robin"\
	"\n\n  6. Salir\n\n  --> " | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DE ALGORITMO"\
	"\n\n  1. FCFS"\
	"\n\n  2. SJF"\
	"\n\n  3. SRPT"\
	"\n\n  4. Prioridades"\
	"\n\n  5. Round-Robin"\
	"\n\n  6. Salir\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuAlgoritmoGestionProcesos
	echo -ne "$seleccionMenuAlgoritmoGestionProcesos\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuAlgoritmoGestionProcesos\n\n" >> $informeSinColorTotal
	#Comprobación de que el número introducido por el usuario es de 1 a 6
	until [[ "0" -lt $seleccionMenuAlgoritmoGestionProcesos && $seleccionMenuAlgoritmoGestionProcesos -lt "7" ]];   do
		echo -ne "\nError en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\nError en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuAlgoritmoGestionProcesos
		echo -e "$seleccionMenuAlgoritmoGestionProcesos\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuAlgoritmoGestionProcesos\n\n" >> $informeSinColorTotal
	done
	case "$seleccionMenuAlgoritmoGestionProcesos" in
		'4')
			menuTipoPrioridad #Menú de elección del tipo de prioridad (Mayor/Menor).
			menuApropiatividad #Menú de elección de apropiatividad. Cuando se ejecuta con Prioridades. Se hace en menuAlgoritmoGestionProcesos()
			;;
		'6')
			echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0 ;;
	esac
	alg=$seleccionMenuAlgoritmoGestionProcesos #Para que se equipare al programa nuevo.
} #Fin de menuAlgoritmoGestionProcesos()

####################################################################################
# Sinopsis: Menú de elección de Tipo de Prioridad (Mayor/Menor). Cuando se ejecuta con Prioridades.
####################################################################################
function menuTipoPrioridad {
#	clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DEL TIPO DE PRIORIDAD"$NORMAL\
	"\n\n  1. Prioridad Mayor"\
	"\n\n  2. Prioridad Menor"\
	"\n\n  3. Salir\n\n  --> " | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DEL TIPO DE PRIORIDAD"\
	"\n\n  1. Prioridad Mayor"\
	"\n\n  2. Prioridad Menor"\
	"\n\n  3. Salir\n\n  --> " >> $informeSinColorTotal
	read seleccionTipoPrioridad
	echo -ne "$seleccionTipoPrioridad\n\n" >> $informeConColorTotal
	echo -ne "$seleccionTipoPrioridad\n\n" >> $informeSinColorTotal
	until [[ 0 -lt $seleccionTipoPrioridad && $seleccionTipoPrioridad -lt 4 ]]; do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionTipoPrioridad
		echo -e "$seleccionTipoPrioridad\n\n" >> $informeConColorTotal
		echo -e "$seleccionTipoPrioridad\n\n" >> $informeSinColorTotal
	done
} #Fin de menuApropiatividad()

####################################################################################
# Sinopsis: Menú de elección de Apropiatividad. Cuando se ejecuta con Prioridades.
####################################################################################
function menuApropiatividad {
#	clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE APROPIATIVIDAD"$NORMAL\
	"\n\n  1. No apropiativo"\
	"\n\n  2. Apropiativo"\
	"\n\n  3. Salir\n\n  --> " | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DE APROPIATIVIDAD"\
	"\n\n  1. No apropiativo"\
	"\n\n  2. Apropiativo"\
	"\n\n  3. Salir\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuApropiatividad
	echo -ne "$seleccionMenuApropiatividad\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuApropiatividad\n\n" >> $informeSinColorTotal
	until [[ 0 -lt $seleccionMenuApropiatividad && $seleccionMenuApropiatividad -lt 4 ]]; do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuApropiatividad
		echo -e "$seleccionMenuApropiatividad\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuApropiatividad\n\n" >> $informeSinColorTotal
	done
	case "$seleccionMenuApropiatividad" in
		'1')
			apropiatividadNo0Si1=0 ;;
		'2')
			apropiatividadNo0Si1=1 ;;
		'3')
			echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0 ;;
	esac
} #Fin de menuApropiatividad()

####################################################################################
# Sinopsis: Menú de elección de reubicabilidad.
####################################################################################
function menuReubicabilidad { #Si reubicabilidadNo0Si1 vale 0 no es reubicable. Si vale 1 es reubicable.
#	clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE REUBICABILIDAD"$NORMAL\
	"\n\n  1. Memoria No Reubicable"\
	"\n\n  2. Memoria Reubicable"\
	"\n\n  3. Salir\n\n  --> " | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DE REUBICABILIDAD"\
	"\n\n  1. Memoria No Reubicable"\
	"\n\n  2. Memoria Reubicable"\
	"\n\n  3. Salir\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuReubicabilidad
	echo -ne "$seleccionMenuReubicabilidad\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuReubicabilidad\n\n" >> $informeSinColorTotal

	#Comprobación de que el número introducido por el usuario es de 1 a 3
	until [[ "0" -lt $seleccionMenuReubicabilidad && $seleccionMenuReubicabilidad -lt "4" ]];   do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuReubicabilidad
		echo -e "$seleccionMenuReubicabilidad\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuReubicabilidad\n\n" >> $informeSinColorTotal
	done
	case "$seleccionMenuReubicabilidad" in
		'1')
			reubicabilidadNo0Si1=0
			;;
		'2')
			reubicabilidadNo0Si1=1
			;;
		'3')
			echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0
			;;
	esac
} #Fin de menuReubicabilidad()

####################################################################################
# Sinopsis: Menú de elección de continuidad.
####################################################################################
function menuContinuidad { #Si vale 0 es no continua. Si vale 1 es continua.
#	clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE CONTINUIDAD"$NORMAL\
	"\n\n  1. Memoria No Continua"\
	"\n\n  2. Memoria Continua"\
	"\n\n  3. Salir\n\n  --> " | tee -a $informeConColorTotal
	echo -ne "\n\n MENÚ DE ELECCIÓN DE CONTINUIDAD"\
	"\n\n  1. Memoria No Continua"\
	"\n\n  2. Memoria Continua"\
	"\n\n  3. Salir\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuContinuidad
	echo -ne "$seleccionMenuContinuidad\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuContinuidad\n\n" >> $informeSinColorTotal

	#Comprobación de que el número introducido por el usuario es de 1 a 3
	until [[ "0" -lt $seleccionMenuContinuidad && $seleccionMenuContinuidad -lt "4" ]];   do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuContinuidad
		echo -e "$seleccionMenuContinuidad\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuContinuidad\n\n" >> $informeSinColorTotal
	done
	case "$seleccionMenuContinuidad" in
		'1')
			continuidadNo0Si1=0
			;;
		'2')
			continuidadNo0Si1=1
			;;
		'3')
			echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0
			;;
	esac
} #Fin de menuContinuidad()

####################################################################################
# Sinopsis: Menú de elección de opciones de entrada de datos/rangos/rangos amplios del programa:
# Manul, Última ejecución, Otros ficheros.
####################################################################################
function menuEleccionEntradaDatos {
#	clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ INICIO"$NORMAL\
	"\n\n  1. Introducción de datos manual"\
	"\n\n  2. Fichero de datos de última ejecución (./FLast/DatosLast.txt)"\
	"\n\n  3. Otros ficheros de datos"\
	"\n\n  4. Introducción de rangos manual (modo aleatorio)"\
	"\n\n  5. Fichero de rangos de última ejecución (./FLast/DatosRangosLast.txt)"\
	"\n\n  6. Otros ficheros de rangos"\
	"\n\n  7. Introducción de rangos amplios manual (modo aleatorio total)"\
	"\n\n  8. Fichero de rangos amplios de última ejecución (./FLast/RangosAleTotalLast.txt)"\
	"\n\n  9. Otros ficheros de rangos amplios"\
	"\n\n  10. Salir\n\n  --> "| tee -a $informeConColorTotal

	echo -ne "\n MENÚ INICIO"\
	"\n\n  1. Introducción de datos manual"\
	"\n\n  2. Fichero de datos de última ejecución (./FLast/DatosLast.txt)"\
	"\n\n  3. Otros ficheros de datos"\
	"\n\n  4. Introducción de rangos manual (modo aleatorio)"\
	"\n\n  5. Fichero de rangos de última ejecución (./FLast/DatosRangosLast.txt)"\
	"\n\n  6. Otros ficheros de rangos"\
	"\n\n  7. Introducción de rangos amplios manual (modo aleatorio total)"\
	"\n\n  8. Fichero de rangos amplios de última ejecución (./FLast/RangosAleTotalLast.txt)"\
	"\n\n  9. Otros ficheros de rangos amplios"\
	"\n\n  10. Salir\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuEleccionEntradaDatos
	echo -ne "$seleccionMenuEleccionEntradaDatos\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuEleccionEntradaDatos\n\n" >> $informeSinColorTotal

	#Comprobación de que el número introducido por el usuario es de 1 a 10
	until [[ "0" -lt $seleccionMenuEleccionEntradaDatos && $seleccionMenuEleccionEntradaDatos -lt "11" ]];  do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuEleccionEntradaDatos
		echo -ne "$seleccionMenuEleccionEntradaDatos\n\n" >> $informeConColorTotal
		echo -ne "$seleccionMenuEleccionEntradaDatos\n\n" >> $informeSinColorTotal
	done
	case "$seleccionMenuEleccionEntradaDatos" in
		'1') #1. Introducción de datos manual
			nuevaEjecucion
			preguntaDondeGuardarDatosManuales
			entradaMemoriaTeclado
			entradaProcesosTeclado
			menuModoTiempoEjecucionAlgormitmo
			;;
		'2') #2. Fichero de datos de última ejecución (./FLast/DatosLast.txt).
			menuModoTiempoEjecucionAlgormitmo #Elección del algoritmo de gestión de procesos y la fuente de datos.
			leer_datos_desde_fichero $ficheroDatosAnteriorEjecucion
			ordenarDatosEntradaFicheros #Ordenar los datos sacados desde $ficheroDatosAnteriorEjecucion por el tiempo de llegada.
			;;
		'3') #3. Otros ficheros de datos $ficheroDatosAnteriorEjecucion
			entradaMemoriaDatosFichero #Elegir el fichero para la entrada de datos $ficheroParaLectura.
			menuModoTiempoEjecucionAlgormitmo #Elección del algoritmo de gestión de procesos y la fuente de datos.
			leer_datos_desde_fichero $ficheroParaLectura #Leer los datos desde el fichero elegido $ficheroParaLectura
			ordenarDatosEntradaFicheros #Ordenar los datos sacados desde $ficheroParaLectura por el tiempo de llegada.
			;;
		'4') #4. Introducción de rangos manual (modo aleatorio)
			preguntaDondeGuardarRangosManuales #Resuelve los nombres de los ficheros de rangos
			preguntaDondeGuardarDatosManuales #Resuelve los nombres de los ficheros de datos
			nuevaEjecucion
			entradaMemoriaRangosFichero_op_cuatro
			menuModoTiempoEjecucionAlgormitmo
			ordenarDatosEntradaFicheros
			;;
		'5') #5. Fichero de rangos de última ejecución (./FLast/RangosLast.txt)
			entradaMemoriaRangosFichero_op_cinco_Previo
			leer_rangos_desde_fichero $ficheroRangosAnteriorEjecucion #Leer los datos desde el fichero elegido $ficheroParaLectura
			entradaMemoriaRangosFichero_op_cinco_seis
			menuModoTiempoEjecucionAlgormitmo
			ordenarDatosEntradaFicheros
			;;
		'6') #6. Otros ficheros de rangos
			nuevaEjecucion
			entradaMemoriaRangosFichero_op_seis_Previo
			leer_rangos_desde_fichero $ficheroParaLectura #Leer los datos desde el fichero elegido $ficheroParaLectura
			entradaMemoriaRangosFichero_op_cinco_seis
			menuModoTiempoEjecucionAlgormitmo
			ordenarDatosEntradaFicheros
			;;
		'7') #7. Introducción de rangos amplios manual (modo aleatorio total)
			nuevaEjecucion
			entradaMemoriaRangosFichero_op_siete_Previo
			entradaMemoriaRangosFichero_op_siete_ocho_nueve
			menuModoTiempoEjecucionAlgormitmo
			ordenarDatosEntradaFicheros
			;;
		'8') #8. Fichero de rangos amplios de última ejecución
			entradaMemoriaRangosFichero_op_ocho_Previo #Pregunta en qué fichero guardar los rangos para la opción 8.
			leer_rangos_desde_fichero $ficheroRangosAleTotalAnteriorEjecucion #Leer los datos desde el fichero elegido $ficheroParaLectura
			entradaMemoriaRangosFichero_op_siete_ocho_nueve
			menuModoTiempoEjecucionAlgormitmo
			ordenarDatosEntradaFicheros
			;;
		'9') #9. Otros ficheros de rangos amplios
			nuevaEjecucion
			entradaMemoriaRangosFichero_op_nueve_Previo
			leer_rangos_desde_fichero $ficheroParaLectura #Leer los datos desde el fichero elegido $ficheroParaLectura
			entradaMemoriaRangosFichero_op_siete_ocho_nueve
			menuModoTiempoEjecucionAlgormitmo
			ordenarDatosEntradaFicheros
			;;
		'10') #10. Salir
			echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0
			;;
	esac
} #Fin de menuEleccionEntradaDatos()

####################################################################################
# Sinopsis: Se decide el modo de ejecución: Por eventos, Automática, Completa, Unidad de tiempo a unidad de tiempo
####################################################################################
function menuModoTiempoEjecucionAlgormitmo {
#	clear
	cabecerainicio
	echo -ne $AMARILLO"\n Introduce una opción: \n$NORMAL"\
	"\n\n  1. Ejecución por eventos. (Presionando Enter en cada evento)."\
	"\n\n  2. Ejecución automática. (Por eventos y sin pausas)"\
	"\n\n  3. Ejecución completa. (Con pausas de cierto número de segundos)."\
	"\n\n  4. Ejecución por unidad de tiempo. (Con un volcado en cada unidad de tiempo)."\
	"\n\n  5. Ejecución completa (Sin representación de resultados intermedios).\n\n  --> $NC" | tee -a $informeConColorTotal

	echo -ne "\n\n Introduce una opción: \n"\
	"\n\n  1. Ejecución por eventos. (Presionando Enter en cada evento)."\
	"\n\n  2. Ejecución automática. (Por eventos y sin pausas)"\
	"\n\n  3. Ejecución completa. (Con pausas de cierto número de segundos)."\
	"\n\n  4. Ejecución por unidad de tiempo. (Con un volcado en cada unidad de tiempo)."\
	"\n\n  5. Ejecución completa (Sin representación de resultados intermedios).\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuModoTiempoEjecucionAlgormitmo
	echo -ne "$seleccionMenuModoTiempoEjecucionAlgormitmo\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuModoTiempoEjecucionAlgormitmo\n" >> $informeSinColorTotal

	# Comprobación de que el número introducido por el usuario esta entre 1 y 5
	until [[ 0 -lt $seleccionMenuModoTiempoEjecucionAlgormitmo && $seleccionMenuModoTiempoEjecucionAlgormitmo -lt 6 ]]; do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuModoTiempoEjecucionAlgormitmo
		echo -e "$seleccionMenuModoTiempoEjecucionAlgormitmo\n" >> $informeConColorTotal
		echo -e "$seleccionMenuModoTiempoEjecucionAlgormitmo\n" >> $informeSinColorTotal
	done

	case $seleccionMenuModoTiempoEjecucionAlgormitmo in
		'1') # Por eventos
			optejecucion=1
			;;
		'2') # Automática
			tiempoejecucion=0
			optejecucion=2
			;;
		'3') # Completa
			echo -ne " Introduce el tiempo entre actualizaciones de datos (segundos): " | tee -a $informeConColorTotal
			echo -ne " Introduce el tiempo entre actualizaciones de datos (segundos): " >> $informeSinColorTotal
			read tiempoejecucion
			until [[ "0" -le $tiempoejecucion ]];   do
				echo -ne "\n Error en la elección de una opción válida. Debe ser mayor o igual a 0.\n  --> " | tee -a $informeConColorTotal
				echo -ne " Error en la elección de una opción válida. Debe ser mayor o igual a 0.\n  --> " >> $informeSinColorTotal
				read tiempoejecucion
				echo -e "$tiempoejecucion\n" >> $informeConColorTotal
				echo -e "$tiempoejecucion\n" >> $informeSinColorTotal
			done
			optejecucion=3
			;;
		'4') # De unidad de tiempo en unidad de tiempo
			optejecucion=4
			;;
		'5') # Sólo se muestra el resumen final
			optejecucion=5
			;;
	esac
#	clear
} #Fin de menuModoTiempoEjecucionAlgormitmo()

####################################################################################
# Sinopsis: Comprobar si existe el árbol de directorios utilizados en el programa
####################################################################################
function revisarArbolDirectorios { #Regenera el árbol de directorios si no se encuentra.
#	clear
	#Se regenera la estructura de directorios en caso de no existir
	if [[ ! -d $dirFLast ]]; then
		mkdir $dirFLast
	fi
	if [[ ! -d $dirFDatos ]]; then
		mkdir $dirFDatos
	fi
	if [[ ! -d $dirFRangos ]]; then
		mkdir $dirFRangos
	fi
	if [[ ! -d $dirFRangosAleT ]]; then
		mkdir $dirFRangosAleT
	fi
	if [[ ! -d $dirInformes ]]; then
		mkdir $dirInformes
	fi
	#Informes y temporales
	if [[ -f $informeConColorTotal ]]; then
		truncate -s 0 $informeConColorTotal #Se borran los ficheros de informes COLOR
	fi
	if [[ -f $informeSinColorTotal ]]; then
		truncate -s 0 $informeSinColorTotal #Se borran los ficheros de informes BN
	fi
} #Fin de revisarArbolDirectorios()

#######################################################################
# Sinopsis: Función menú de métodos impresión por pantalla - NO USADA
#######################################################################
function menu_impresion {
	cabecerainicio
	echo -e "\n Forma de impresión de los eventos por pantalla$NC" | tee -a $informeConColorTotal
	echo -e " $morado[1]$NC --> Por eventos (presionando ENTER)$NC" | tee -a $informeConColorTotal #Impresión de forma manual (pulsando enter para pasar)
	echo -e " $morado[2]$NC --> Automatico (Con un tiempo de espera a definir)$NC" | tee -a $informeConColorTotal #Impresión de forma automatica (esperando x segundo para pasar)
	echo -e " $morado[3]$NC --> Completo (Sin pausas)$NC" | tee -a $informeConColorTotal #Impresión de forma sin parar (pasa sin esperar, de golpe)
	echo -e "\n Forma de impresión de los eventos por pantalla" >>$informeSinColorTotal
	echo -e " [1] --> Por eventos (presionando ENTER)" >>$informeSinColorTotal
	echo -e " [2] --> Automatico (Con un tiempo de espera a definir)" >>$informeSinColorTotal
	echo -e " [3] --> Completo (Sin pausas)" >>$informeSinColorTotal
	read seleccionMenuModoTiempoEjecucionAlgormitmo #Se utiliza seleccionMenuModoTiempoEjecucionAlgormitmo como variable de selección para el menu de forma de impresion
	echo $seleccionMenuModoTiempoEjecucionAlgormitmo >> $informeConColorTotal
	echo $seleccionMenuModoTiempoEjecucionAlgormitmo >> $informeSinColorTotal
	until [[ "$seleccionMenuModoTiempoEjecucionAlgormitmo" == "1" || "$seleccionMenuModoTiempoEjecucionAlgormitmo" == "2" || "$seleccionMenuModoTiempoEjecucionAlgormitmo" == "3" ]]; do
		echo -e "$rojo Respuesta no válida, debe ser una de las opciones.$NC" | tee -a $informeConColorTotal
		echo -e "Respuesta no válida, debe ser una de las opciones." >> $informeSinColorTotal
		read seleccionMenuModoTiempoEjecucionAlgormitmo
		echo $seleccionMenuModoTiempoEjecucionAlgormitmo >> $informeConColorTotal
		echo $seleccionMenuModoTiempoEjecucionAlgormitmo >> $informeSinColorTotal
	done
	if [[ $seleccionMenuModoTiempoEjecucionAlgormitmo = "2" ]]; then
		echo -e "$cian Introduzca el tiempo de espera para pasar:$NC"
		read optejecucion
		echo -e "$cian Introduzca el tiempo de espera para pasar:$NC" >> $informeConColorTotal
		echo $optejecucion >> $informeConColorTotal
		echo -e " Introduzca el tiempo de espera para pasar" >> $informeSinColorTotal
		echo $optejecucion >> $informeSinColorTotal
	elif [[ $seleccionMenuModoTiempoEjecucionAlgormitmo = "3" ]]; then
		optejecucion=0
	fi
#	clear
} #Fin de menu_impresion()

####################################################################################
# Sinopsis: Se pregunta por las opciones de guardar lo datos de particiones y procesos.
# Se pregunta si se quiere guardar los datos en el fichero estándar (Default) o en otro.
# Si es en otro, pide el nombre del archivo.
####################################################################################
function preguntaDondeGuardarDatosManuales {
	cabecerainicio
	#Pregunta para los datos por teclado
	echo -e $AMARILLO"\n ¿Dónde quiere guardar los datos resultantes?\n"$NORMAL | tee -a $informeConColorTotal
	echo -e "  1- En el fichero estándar ($ficheroDatosDefault)" | tee -a $informeConColorTotal
	echo -ne "  2- En otro fichero\n\n  --> " | tee -a $informeConColorTotal
	echo -e "\n ¿Dónde quiere guardar los datos resultantes?\n\n" >> $informeSinColorTotal
	echo -e "  1- En el fichero estándar ($ficheroDatosDefault)" >> $informeSinColorTotal
	echo -ne "  2- En otro fichero\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuPreguntaDondeGuardarDatosManuales
	echo -e " $seleccionMenuPreguntaDondeGuardarDatosManuales\n\n" >> $informeConColorTotal
	echo -e " $seleccionMenuPreguntaDondeGuardarDatosManuales\n\n" >> $informeSinColorTotal

	# Comprobación de que el número introducido por el usuario esta entre 1 y 2
	until [[ "0" -lt $seleccionMenuPreguntaDondeGuardarDatosManuales && $seleccionMenuPreguntaDondeGuardarDatosManuales -lt "3" ]]; do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuPreguntaDondeGuardarDatosManuales
		echo -e " $seleccionMenuPreguntaDondeGuardarDatosManuales\n\n" >> $informeConColorTotal
		echo -e " $seleccionMenuPreguntaDondeGuardarDatosManuales\n\n" >> $informeSinColorTotal
	done

	case "${seleccionMenuPreguntaDondeGuardarDatosManuales}" in
		1) #En el fichero estándar
			truncate -s 0 $ficheroDatosDefault #Se borran los datos del fichero por defecto de la anterior ejecución
			nomFicheroDatos="$ficheroDatosDefault"
			;;
		2) #En otro fichero
			echo -e $ROJO"\n Ficheros de datos ya existentes en './FDatos/': "$NORMAL | tee -a $informeConColorTotal
			echo -e "\n Ficheros de datos ya existentes en './FDatos/': " >> $informeSinColorTotal
			files=($(ls -l ./FDatos/ | awk '{print $9}'))
			for i in "${!files[@]}"; do
				echo -e "   ${files[$i]}"
			done
			echo -e $AMARILLO" Introduce el nombre que le quieres dar al fichero de datos (sin '.txt'):\n"$NORMAL | tee -a $informeConColorTotal
			echo -e " Introduce el nombre que le quieres dar al fichero de datos (sin '.txt'):\n" >> $informeSinColorTotal
			read seleccionNombreFicheroDatos
			nomFicheroDatos="./FDatos/$seleccionNombreFicheroDatos.txt"
			echo -e " $seleccionNombreFicheroDatos" >> $informeConColorTotal
			echo -e " $seleccionNombreFicheroDatos" >> $informeSinColorTotal
			echo -e " $nomFicheroDatos\n\n" >> $informeConColorTotal
			echo -e " $nomFicheroDatos\n\n" >> $informeSinColorTotal
			until [[ ! -z "$seleccionNombreFicheroDatos" && ! -f "$nomFicheroDatos" && "$seleccionNombreFicheroDatos" != "" ]];do
				echo -e " Ya existe un archivo con el nombre introducido, o es nulo." | tee -a $informeConColorTotal
				echo -e " Ya existe un archivo con el nombre introducido, o es nulo."  >> $informeSinColorTotal
				echo -e " ¿Sobreescribirlo (S/N)?" | tee -a $informeConColorTotal
				echo -e " ¿Sobreescribirlo (S/N)?" >> $informeSinColorTotal
				read sobrescri
				echo $sobrescri >> $informeConColorTotal
				echo $sobrescri >> $informeSinColorTotal
				until [[ "$sobrescri" == "S" || "$sobrescri" == "s" || "$sobrescri" == "N" || "$sobrescri" == "n" ]]; do
					echo -e " Respuesta no válida, debe ser una de las opciones." | tee -a $informeConColorTotal
					echo -e " ¿Sobreescribirlo (S/N)?" | tee -a $informeConColorTotal
					echo -e " Respuesta no válida, debe ser S o N." >> $informeSinColorTotal
					echo -e " ¿Sobreescribirlo (S/N)?" >> $informeSinColorTotal
					read sobrescri
					echo $sobrescri >> $informeConColorTotal
					echo $sobrescri >> $informeSinColorTotal
				done
				if [[ $sobrescri == "S" || $sobrescri == "s" ]]; then
					echo -e " Los datos se guardaran en el archivo $nomFicheroDatos" | tee -a $informeConColorTotal
					echo -e " Los datos se guardaran en el archivo $nomFicheroDatos" >> $informeSinColorTotal
					rm $nomFicheroDatos
				fi
				if [[ $sobrescri == "N" || $sobrescri == "n" ]]; then
					echo -e " Introduzca un nombre correcto: \n" | tee -a $informeConColorTotal
					echo -e " Introduzca un nombre correcto: \n" >> $informeSinColorTotal
					read seleccionNombreFicheroDatos
					nomFicheroDatos="./FDatos/""$seleccionNombreFicheroDatos.txt"
					echo -e " $seleccionNombreFicheroDatos" >> $informeConColorTotal
					echo -e " $seleccionNombreFicheroDatos" >> $informeSinColorTotal
					echo -e " $nomFicheroDatos\n" >> $informeConColorTotal
					echo -e " $nomFicheroDatos\n" >> $informeSinColorTotal
				fi #cierre el sobreescribir NO
			done
			;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
			;;
	esac
#	clear
} #Fin de preguntaDondeGuardarDatosManuales()

####################################################################################
# Sinopsis: Se pregunta por las opciones de guardar lo rangos de particiones y procesos.
# Se pregunta si se quiere guardar los rangos en el fichero estándar (Default) o en otro.
# Si es en otro, pide el nombre del archivo.
####################################################################################
function preguntaDondeGuardarRangosManuales {
	cabecerainicio
	echo -e $AMARILLO"\n ¿Dónde quiere guardar los rangos?"$NORMAL | tee -a  $informeConColorTotal
	echo -e "\n  1- En el fichero de rangos estándar ($ficheroRangosDefault)" | tee -a  $informeConColorTotal
	echo -e "  2- En otro fichero\n" | tee -a  $informeConColorTotal
	echo -ne "\n  --> " | tee -a  $informeConColorTotal
	echo -e "\n ¿Dónde quiere guardar los rangos?" >> $informeSinColorTotal
	echo -e "\n  1- En el fichero de rangos estándar ($ficheroRangosDefault)" >> $informeSinColorTotal
	echo -e "  2- En otro fichero\n" >> $informeSinColorTotal
	echo -ne "\n  --> " >> $informeSinColorTotal
	read seleccionMenuPreguntaDondeGuardarRangosManuales
	echo -e "$seleccionMenuPreguntaDondeGuardarRangosManuales\n\n" >> $informeConColorTotal
	echo -e "$seleccionMenuPreguntaDondeGuardarRangosManuales\n\n" >> $informeSinColorTotal

	# Comprobación de que el número introducido por el usuario esta entre 1 y 2
	until [[ "0" -lt $seleccionMenuPreguntaDondeGuardarRangosManuales && $seleccionMenuPreguntaDondeGuardarRangosManuales -lt "3" ]];   do
		echo -e "\n Error en la elección de una opción válida" | tee -a $informeConColorTotal
		echo -e "\n Error en la elección de una opción válida" >> $informeSinColorTotal
		echo -ne "\n  --> " | tee -a  $informeConColorTotal
		echo -ne "\n  --> " >> $informeSinColorTotal
		read seleccionMenuPreguntaDondeGuardarRangosManuales
		echo -e "$seleccionMenuPreguntaDondeGuardarRangosManuales\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuPreguntaDondeGuardarRangosManuales\n\n" >> $informeSinColorTotal
	done

	case "${seleccionMenuPreguntaDondeGuardarRangosManuales}" in
		1) #En el fichero estándar
			truncate -s 0 $ficheroRangosDefault #Se borran los rangos del fichero por defecto de la anterior ejecución
			nomFicheroRangos="$ficheroRangosDefault"
			;;
		2) #En otro fichero
			echo -e $AMARILLO"Introduce el nombre que le quieres dar al fichero de datos (sin '.txt'):\n"$NORMAL | tee -a $informeConColorTotal
			echo -e "Introduce el nombre que le quieres dar al fichero de datos (sin '.txt'):\n" >> $informeSinColorTotal
			read seleccionNombreFicheroRangos
			nomFicheroRangos="./FRangos/""$seleccionNombreFicheroRangos.txt"
			echo -e "$seleccionNombreFicheroRangos" >> $informeConColorTotal
			echo -e "$seleccionNombreFicheroRangos" >> $informeSinColorTotal
			echo -e "$nomFicheroRangos\n" >> $informeConColorTotal
			echo -e "$nomFicheroRangos\n" >> $informeSinColorTotal
			until [[ ! -z "$seleccionNombreFicheroRangos" && ! -f "$nomFicheroRangos" && "$seleccionNombreFicheroRangos" != "" ]];do
				echo -e " Ya existe un archivo con el nombre introducido, o es nulo." | tee -a $informeConColorTotal
				echo -e " Ya existe un archivo con el nombre introducido, o es nulo."  >> $informeSinColorTotal
				echo -e " ¿Sobreescribirlo (S/N)?" | tee -a $informeConColorTotal
				echo -e " ¿Sobreescribirlo (S/N)?" >> $informeSinColorTotal
				read sobrescri
				echo $sobrescri >> $informeConColorTotal
				echo $sobrescri >> $informeSinColorTotal
				until [[ "$sobrescri" == "S" || "$sobrescri" == "s" || "$sobrescri" == "N" || "$sobrescri" == "n" ]]; do
					echo -e " Respuesta no válida, debe ser una de las opciones." | tee -a $informeConColorTotal
					echo -e " ¿Sobreescribirlo (S/N)?" | tee -a $informeConColorTotal
					echo -e " Respuesta no válida, debe ser S o N." >> $informeSinColorTotal
					echo -e " ¿Sobreescribirlo (S/N)?" >> $informeSinColorTotal
					read sobrescri
					echo $sobrescri >> $informeConColorTotal
					echo $sobrescri >> $informeSinColorTotal
				done
				if [[ $sobrescri == "S" || $sobrescri == "s" ]]; then
					echo -e " Los datos se guardaran en el archivo $nomFicheroRangos" | tee -a $informeConColorTotal
					echo -e " Los datos se guardaran en el archivo $nomFicheroRangos" >> $informeSinColorTotal
					rm $nomFicheroRangos
				fi
				if [[ $sobrescri == "N" || $sobrescri == "n" ]]; then
					echo -e " Introduzca un nombre correcto: \n" | tee -a $informeConColorTotal
					echo -e " Introduzca un nombre correcto: \n" >> $informeSinColorTotal
					read seleccionNombreFicheroRangos
					nomFicheroRangos="./FRangos/""$seleccionNombreFicheroRangos.txt"
					echo -e " $seleccionNombreFicheroRangos" >> $informeConColorTotal
					echo -e " $seleccionNombreFicheroRangos" >> $informeSinColorTotal
					echo -e " $nomFicheroRangos\n" >> $informeConColorTotal
					echo -e " $nomFicheroRangos\n" >> $informeSinColorTotal
				fi #cierre el sobreescribir NO
			done
			;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e "Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e "Error en la elección de una opción válida" >> $informeSinColorTotal
			;;
	esac
} #Fin de preguntaDondeGuardarRangosManuales()

####################################################################################
# Sinopsis: Se pregunta por las opciones de guardar los mínimos y máximos de los rangos amplios.
# Se pregunta si se quiere guardar los rangos en el fichero estándar (Default) o en otro.
# Si es en otro, pide el nombre del archivo.
####################################################################################
function preguntaDondeGuardarRangosAleTManuales {
	cabecerainicio
	echo -e $AMARILLO"\n ¿Dónde quiere guardar los mínimos y máximos de los rangos amplios?"$NORMAL | tee -a  $informeConColorTotal
	echo -e "\n  1- En el fichero de rangos amplios estándar ($ficheroRangosAleTotalDefault)" | tee -a  $informeConColorTotal
	echo -e "  2- En otro fichero\n" | tee -a  $informeConColorTotal
	echo -ne "\n  --> " | tee -a  $informeConColorTotal
	echo -e "\n ¿Dónde quiere guardar los mínimos y máximos de los rangos amplios?" >> $informeSinColorTotal
	echo -e "\n  1- En el fichero de rangos amplios estándar ($ficheroRangosAleTotalDefault)" >> $informeSinColorTotal
	echo -e "  2- En otro fichero\n" >> $informeSinColorTotal
	echo -ne "\n  --> " >> $informeSinColorTotal
	read seleccionMenuPreguntaDondeGuardarRangosAleTManuales
	echo -e "$seleccionMenuPreguntaDondeGuardarRangosAleTManuales\n\n" >> $informeConColorTotal
	echo -e "$seleccionMenuPreguntaDondeGuardarRangosAleTManuales\n\n" >> $informeSinColorTotal

	# Comprobación de que el número introducido por el usuario esta entre 1 y 2
	until [[ "0" -lt $seleccionMenuPreguntaDondeGuardarRangosAleTManuales && $seleccionMenuPreguntaDondeGuardarRangosAleTManuales -lt "3" ]];   do
		echo -e "\n Error en la elección de una opción válida" | tee -a $informeConColorTotal
		echo -e "\n Error en la elección de una opción válida" >> $informeSinColorTotal
		echo -ne "\n  --> " | tee -a  $informeConColorTotal
		echo -ne "\n  --> " >> $informeSinColorTotal
		read seleccionMenuPreguntaDondeGuardarRangosAleTManuales
		echo -e "$seleccionMenuPreguntaDondeGuardarRangosAleTManuales\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuPreguntaDondeGuardarRangosAleTManuales\n\n" >> $informeSinColorTotal
	done

	case "${seleccionMenuPreguntaDondeGuardarRangosAleTManuales}" in
		1) #En el fichero estándar
			truncate -s 0 $ficheroRangosDefault #Se borran los rangos del fichero por defecto de la anterior ejecución
			nomFicheroRangosAleT="$ficheroRangosAleTotalDefault"
			;;
		2) #En otro fichero
			echo -e $AMARILLO"Introduce el nombre que le quieres dar al fichero de rangos amplios (sin '.txt'):\n"$NORMAL | tee -a $informeConColorTotal
			echo -e "Introduce el nombre que le quieres dar al fichero de rangos amplios (sin '.txt'):\n" >> $informeSinColorTotal
			read seleccionNombreFicheroRangosAleT
			nomFicheroRangosAleT="./FRangosAleT/""$seleccionNombreFicheroRangosAleT.txt"
			echo -e "$seleccionNombreFicheroRangosAleT" >> $informeConColorTotal
			echo -e "$seleccionNombreFicheroRangosAleT" >> $informeSinColorTotal
			echo -e "$nomFicheroRangosAleT\n\n" >> $informeConColorTotal
			echo -e "$nomFicheroRangosAleT\n\n" >> $informeSinColorTotal
			until [[ ! -z "$seleccionNombreFicheroRangosAleT" && ! -f "$nomFicheroRangosAleT" && "$seleccionNombreFicheroRangosAleT" != "" ]];do
				echo -e " Ya existe un archivo con el nombre introducido, o es nulo." | tee -a $informeConColorTotal
				echo -e " Ya existe un archivo con el nombre introducido, o es nulo."  >> $informeSinColorTotal
				echo -e " ¿Sobreescribirlo (S/N)?" | tee -a $informeConColorTotal
				echo -e " ¿Sobreescribirlo (S/N)?" >> $informeSinColorTotal
				read sobrescri
				echo $sobrescri >> $informeConColorTotal
				echo $sobrescri >> $informeSinColorTotal
				until [[ "$sobrescri" == "S" || "$sobrescri" == "s" || "$sobrescri" == "N" || "$sobrescri" == "n" ]]; do
					echo -e " Respuesta no válida, debe ser una de las opciones." | tee -a $informeConColorTotal
					echo -e " ¿Sobreescribirlo (S/N)?" | tee -a $informeConColorTotal
					echo -e " Respuesta no válida, debe ser S o N." >> $informeSinColorTotal
					echo -e " ¿Sobreescribirlo (S/N)?" >> $informeSinColorTotal
					read sobrescri
					echo $sobrescri >> $informeConColorTotal
					echo $sobrescri >> $informeSinColorTotal
				done
				if [[ $sobrescri == "S" || $sobrescri == "s" ]]; then
					echo -e " Los datos se guardaran en el archivo $nomFicheroRangosAleT" | tee -a $informeConColorTotal
					echo -e " Los datos se guardaran en el archivo $nomFicheroRangosAleT" >> $informeSinColorTotal
					rm $nomFicheroRangosAleT
				fi
				if [[ $sobrescri == "N" || $sobrescri == "n" ]]; then
					echo -e " Introduzca un nombre correcto: \n" | tee -a $informeConColorTotal
					echo -e " Introduzca un nombre correcto: \n" >> $informeSinColorTotal
					read seleccionNombreFicheroRangosAleT
					nomFicheroRangosAleT="./FRangosAleT/""$seleccionNombreFicheroRangosAleT.txt"
					echo -e " $seleccionNombreFicheroRangosAleT" >> $informeConColorTotal
					echo -e " $seleccionNombreFicheroRangosAleT" >> $informeSinColorTotal
					echo -e " $nomFicheroRangosAleT\n" >> $informeConColorTotal
					echo -e " $nomFicheroRangosAleT\n" >> $informeSinColorTotal
				fi #cierre el sobreescribir NO
			done
			;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e "Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e "Error en la elección de una opción válida" >> $informeSinColorTotal
			;;
	esac
} #Fin de preguntaDondeGuardarRangosAleTManuales()

#######################################################################
#######################################################################
#    Funciones
#######################################################################
#######################################################################

#######################################################################
# Sinopsis: Para colorear lo impreso en pantalla.
#######################################################################
function cecho {
local default_msg="No message passed."
	message=${1:-$default_msg}
	color=${2:-$FWHT}
	echo -en "$color"
	echo "$message"
	tput sgr0
	return
} #Fin de cecho()

#######################################################################
# Sinopsis: Extrae los datos del fichero de datos de última ejecución.
#######################################################################
function leer_datos_desde_fichero {
	#Datos caso anterior
	mem_total=($(cat $1 | grep "MemoriaTotal" | cut -f 2 -d " "))
	variableReubicar=($(cat $1 | grep "VariableReubicar" | cut -f 2 -d " "))
	PriomInicial=($(cat $1 | grep "RangoPrioridad" | cut -f 2 -d " "))  #Segundo dato -> Prioridad menor
	PrioMInicial=($(cat $1 | grep "RangoPrioridad" | cut -f 3 -d " "))  #Tercero dato -> Prioridad mayor
	PrioR=($(cat $1 | grep "TipoPrioridad" | cut -f 2 -d " "))  #Cuarto dato -> Tipo de prioridad - Realmente no se usa porque se introduce por teclado al seleccionar el algoritmo de gestión de procesos mediante la variable de selección $seleccionTipoPrioridad.
	tratarRangoPrioridadesDirecta $PriomInicial $PrioMInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	quantum=($(cat $1 | grep "Quantum" | cut -f 2 -d " "))  #Séptimo dato -> Quantum de Round Robin (RR)
	llegada=($(cat $1 | grep "Llegada" | cut -f 2 -d " "))
	ejecucion=($(cat $1 | grep "Llegada" | cut -f 4 -d " "))
	memoria=($(cat $1 | grep "Llegada" | cut -f 6 -d " "))
	prioProc=($(cat $1 | grep "Llegada" | cut -f 8 -d " "))
} #Fin de leer_datos_desde_fichero()

#######################################################################
# Sinopsis: Extrae los límites de los rangos del fichero de rangos de última ejecución.
#######################################################################
function leer_rangos_desde_fichero {
	#Rangos de caso anterior
	memoria_min=($(cat $1 | grep "RangoMemoria" | cut -f 2 -d " "))
	memoria_max=($(cat $1 | grep "RangoMemoria" | cut -f 3 -d " "))
	programas_min=($(cat $1 | grep "RangoNumProc" | cut -f 2 -d " "))
	programas_max=($(cat $1 | grep "RangoNumProc" | cut -f 3 -d " "))
	reubicacion_min=($(cat $1 | grep "RangoReubicar" | cut -f 2 -d " "))
	reubicacion_max=($(cat $1 | grep "RangoReubicar" | cut -f 3 -d " "))
	prio_menor_min=($(cat $1 | grep "RangoPrioMenor" | cut -f 2 -d " "))
	prio_menor_max=($(cat $1 | grep "RangoPrioMenor" | cut -f 3 -d " "))
	prio_mayor_min=($(cat $1 | grep "RangoPrioMayor" | cut -f 2 -d " "))
	prio_mayor_max=($(cat $1 | grep "RangoPrioMayor" | cut -f 3 -d " "))
	llegada_min=($(cat $1 | grep "RangoLlegada" | cut -f 2 -d " "))
	llegada_max=($(cat $1 | grep "RangoLlegada" | cut -f 3 -d " "))
	tiempo_ejec_min=($(cat $1 | grep "RangoTEjecucion" | cut -f 2 -d " "))
	tiempo_ejec_max=($(cat $1 | grep "RangoTEjecucion" | cut -f 3 -d " "))
	tamano_proc_min=($(cat $1 | grep "RangoTamano" | cut -f 2 -d " "))
	tamano_proc_max=($(cat $1 | grep "RangoTamano" | cut -f 3 -d " "))
	prio_proc_min=($(cat $1 | grep "RangoPrioProc" | cut -f 2 -d " "))  #????? Realmente no se usan porque las prioridades se crean desde los rangos amplios.
	prio_proc_max=($(cat $1 | grep "RangoPrioProc" | cut -f 3 -d " "))
	quantum_min=($(cat $1 | grep "RangoQuantum" | cut -f 2 -d " "))
	quantum_max=($(cat $1 | grep "RangoQuantum" | cut -f 3 -d " "))
	memoria_minInicial=$memoria_min
	memoria_maxInicial=$memoria_max
	prio_menor_minInicial=$prio_menor_min #*Inicial - Datos a representar #Se invierten los rangos para calcular el mínimo, pero no para su representación, en la que se verán los datos originales *Inicial.
	prio_menor_maxInicial=$prio_menor_max #*Inicial - Datos a representar 
	tratarRangoPrioridadesDirecta $prio_menor_minInicial $prio_menor_maxInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	prio_menor_min=$PriomFinal
	prio_menor_max=$PrioMFinal
	prio_mayor_minInicial=$prio_mayor_min #*Inicial - Datos a representar #Se invierten los rangos para calcular el mínimo, pero no para su representación, en la que se verán los datos originales *Inicial.
	prio_mayor_maxInicial=$prio_mayor_max #*Inicial - Datos a representar
	tratarRangoPrioridadesDirecta $prio_mayor_minInicial $prio_mayor_maxInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	prio_mayor_min=$PriomFinal
	prio_mayor_max=$PrioMFinal
	programas_minInicial=$programas_min
	programas_maxInicial=$programas_max
	reubicacion_minInicial=$reubicacion_min
	reubicacion_maxInicial=$reubicacion_max
	llegada_minInicial=$llegada_min
	llegada_maxInicial=$llegada_max
	tiempo_ejec_minInicial=$tiempo_ejec_min
	tiempo_ejec_maxInicial=$tiempo_ejec_max
	tamano_proc_minInicial=$tamano_proc_min
	tamano_proc_maxInicial=$tamano_proc_max
	prio_proc_minInicial=$prio_proc_min
	prio_proc_maxInicial=$prio_proc_max
	quantum_minInicial=$quantum_min
	quantum_maxInicial=$quantum_max
	if [[ $memoria_min -gt $memoria_max ]]; then #Si el mayor es menor que el menor, se invierten los rangos
		invertirRangos $memoria_min $memoria_max
		memoria_min=$min
		memoria_max=$max
	fi
	if [[ $memoria_min -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
		desplazarRangos $memoria_min $memoria_max
		memoria_min=$min
		memoria_max=$max
	fi
	if [[ $programas_min -gt $programas_max ]]; then
		invertirRangos $programas_min $programas_max
		programas_min=$min
		programas_max=$max
	fi
	if [[ $programas_min -lt 0 ]]; then
		desplazarRangos $programas_min $programas_max
		programas_min=$min
		programas_max=$max
	fi
	if [[ $reubicacion_min -gt $reubicacion_max ]]; then
		invertirRangos $reubicacion_min $reubicacion_max
		reubicacion_min=$min
		reubicacion_max=$max
	fi
	if [[ $reubicacion_min -lt 0 ]]; then
		desplazarRangos $reubicacion_min $reubicacion_max
		reubicacion_min=$min
		reubicacion_max=$max
	fi
	if [[ $llegada_min -gt $llegada_max ]]; then
		invertirRangos $llegada_min $llegada_max
		llegada_min=$min
		llegada_max=$max
	fi
	if [[ $llegada_min -lt 0 ]]; then
		desplazarRangos $llegada_min $llegada_max
		llegada_min=$(($min - 1)) #Este valor podría ser 0
		llegada_max=$(($max - 1))
	fi
	if [[ $tiempo_ejec_min -gt $tiempo_ejec_max ]]; then
		invertirRangos $tiempo_ejec_min $tiempo_ejec_max
		tiempo_ejec_min=$min
		tiempo_ejec_max=$max
	fi
	if [[ $tiempo_ejec_min -lt 0 ]]; then
		desplazarRangos $tiempo_ejec_min $tiempo_ejec_max
		tiempo_ejec_min=$(($min - 1)) #Este valor podría ser 0
		tiempo_ejec_max=$(($max - 1))
	fi
	if [[ $tamano_proc_min -gt $tamano_proc_max ]]; then
		invertirRangos $tamano_proc_min $tamano_proc_max
		tamano_proc_min=$min
		tamano_proc_max=$max
	fi
	if [[ $tamano_proc_min -lt 0 ]]; then
		desplazarRangos $tamano_proc_min $tamano_proc_max
		tamano_proc_min=$min
		tamano_proc_max=$max
	fi
	if [[ $prio_proc_min -gt $prio_proc_max ]]; then  #????? Realmente no se usa porque las prioridades se crean desde los rangos amplios.
		invertirRangos $prio_proc_min $prio_proc_max
		prio_proc_min=$min #Los valres de las prioridades podrían ser 0 o negativos.
		prio_proc_max=$max
	fi
	if [[ $prio_proc_min -lt 0 ]]; then  #????? Realmente no se usa porque las prioridades se crean desde los rangos amplios.
		desplazarRangos $prio_proc_min $prio_proc_max
		prio_proc_min=$min
		prio_proc_max=$max
	fi
	if [[ $quantum_min -gt $quantum_max ]]; then
		invertirRangos $quantum_min $quantum_max
		quantum_min=$min
		quantum_max=$max
	fi
	if [[ $quantum_min -lt 1 ]]; then
		desplazarRangos $quantum_min $quantum_max
		quantum_min=$min
		quantum_max=$max
	fi
} #Fin de leer_rangos_desde_fichero()

#######################################################################
# Sinopsis: Compara variables con enteros y positivos.
#######################################################################
function es_entero {
	[[ "$1" -eq "$1" && "$1" -ge "0" ]] > /dev/null 2>&1 # En caso de error, sentencia falsa
	return $? # Retorna si la sentencia anterior fue verdadera
} #Fin de es_entero()

#####################################################################################
# Sinopsis: Permite ordenar los datos sacados desde fichero y de entrada por teclado.
####################################################################################
function ordenarDatosEntradaFicheros_cuatro_cinco_seis_siete_ocho_nueve {
	for ((j = $((${#llegada[@]} - 1)); j >= 0; j--)); do
		for ((i = 0; i <= $j; i++)); do
			if [[ ${llegada[$i]} -gt ${llegada[$(($i + 1))]} ]]; then
				aux=${proceso[$(($i + 1))]}
				proceso[$(($i + 1))]=${proceso[$i]}
				proceso[$i]=$aux
				aux=${llegada[$(($i + 1))]}
				llegada[$(($i + 1))]=${llegada[$i]}
				llegada[$i]=$aux
				aux=${ejecucion[$(($i + 1))]}
				ejecucion[$(($i + 1))]=${ejecucion[$i]}
				ejecucion[$i]=$aux
				aux=${memoria[$(($i + 1))]}
				memoria[$(($i + 1))]=${memoria[$i]}
				memoria[$i]=$aux
				aux=${prioProc[$(($i + 1))]}
				prioProc[$(($i + 1))]=${prioProc[$i]}
				prioProc[$i]=$aux
			fi
		done
	done
} #Fin de ordenarDatosEntradaFicheros_cuatro_cinco_seis_siete_ocho_nueve()

#######################################################################
# Sinopsis: Se ordenan por t.llegada únicamente los datos que se meten en la introducción de procesos
# (posteriormente se ordenará todo ya que se añaden el resto de arrays con todos los datos de cada proceso).
#######################################################################
function ordenSJF { #En este caso se intercambian todos los datos al ordenar por tiempo de llegada.
	for (( i=1; i<=${#llegada[@]}; i++ )); do
		for (( j=i; j<=${#llegada[@]}; j++ )); do
			a=${llegada[$i]};
			b=${llegada[$j]}; #Asignamos variables (tiempos de llegada)
			if [[ $a -gt $b ]];      then
				aux=${proceso[$i]};
				proceso[$i]=${proceso[$j]}; #Ordenar los nombres
				proceso[$j]=$aux;
				aux=${llegada[$i]};
				llegada[$i]=${llegada[$j]}; #Ordenar por menor tiempo de llegada
				llegada[$j]=$aux
				aux=${ejecucion[$i]};
				ejecucion[$i]=${ejecucion[$j]}; #Ordenar tiempos de ejecución
				ejecucion[$j]=$aux;
				aux=${memoria[$i]};
				memoria[$i]=${memoria[$j]}; #Ordenar los tamaños
				memoria[$j]=$aux;
				aux=${prioProc[$(($i + 1))]}
				prioProc[$(($i + 1))]=${prioProc[$i]} #Ordenar las prioridades
				prioProc[$i]=$aux
				aux=${numeroproceso[$i]};
				numeroproceso[$i]=${numeroproceso[$j]}; #Ordenar los números de proceso
				numeroproceso[$j]=$aux;
			fi
			if [[ $a -eq $b ]]; then #Si el orden de entrada coincide se arreglan dependiendo de cuál se ha metido primero
				c=${numeroproceso[$i]};
				d=${numeroproceso[$j]};
				if [[ $c -gt $d ]]; then
					aux=${proceso[$i]};
					proceso[$i]=${proceso[$j]}; #Ordenar los nombres
					proceso[$j]=$aux
					aux=${llegada[$i]};
					llegada[$i]=${llegada[$j]}; #Ordenar los tiempo de llegada
					llegada[$j]=$aux
					aux=${ejecucion[$i]};
					ejecucion[$i]=${ejecucion[$j]}; #Ordenar tiempos de ejecución
					ejecucion[$j]=$aux;
					aux=${memoria[$i]};
					memoria[$i]=${memoria[$j]}; #Ordenar los tamaños
					memoria[$j]=$aux;
					aux=${prioProc[$(($i + 1))]}
					prioProc[$(($i + 1))]=${prioProc[$i]} #Ordenar las prioridades
					prioProc[$i]=$aux
					aux=${numeroproceso[$i]};
					numeroproceso[$i]=${numeroproceso[$j]}; #Ordenar los números de proceso
					numeroproceso[$j]=$aux;
				fi
			fi
		done
	done
} #Fin de ordenSJF()

#######################################################################
#######################################################################
# Establecimiento de funciones para rangos
#######################################################################
#######################################################################
# Sinopsis: Presenta una tabla con los rangos y valores calculados
#######################################################################
function datos_memoria_tabla {
#	clear
	if [[ $seleccionMenuEleccionEntradaDatos -eq 4 ]]; then
		echo -e "$amarillo Por favor, establezca los rangos para datos"
	elif [[ $seleccionMenuEleccionEntradaDatos -eq 5 || $seleccionMenuEleccionEntradaDatos -eq 6 ]]; then
		echo -e "$amarillo Resultados actuales:"
	fi
	echo -e "$azul┌────────────────────────────────────────────────────────┐" | tee -a $informeConColorTotal
	printf "$azul│$NC""${varhuecos:1:$((32))}""Min-Max rango     Valor""$azul │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Tamaño memoria: ""${varhuecos:1:$((14 - ${#MIN_RANGE_MEM}))}""$MIN_RANGE_MEM"" - " | tee -a $informeConColorTotal
	printf "$MAX_RANGE_MEM""${varhuecos:1:$((4 - ${#MAX_RANGE_MEM}))}""     ""${varhuecos:1:$((4 - ${#mem}))}""$mem""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Reubicacion: ""${varhuecos:1:$((17 - ${#MIN_RANGE_REUB}))}""$MIN_RANGE_REUB"" - " | tee -a $informeConColorTotal
	printf "$MAX_RANGE_REUB""${varhuecos:1:$((4 - ${#MAX_RANGE_REUB}))}""     ""${varhuecos:1:$((4 - ${#reub}))}""$reub""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Mínimo de Prioridades: ""${varhuecos:1:$((7 - ${#prio_menor_minInicial}))}""$prio_menor_minInicial"" - " | tee -a $informeConColorTotal
#    printf "$MAX_RANGE_prio_menorInicial""${varhuecos:1:$((4 - ${#MAX_RANGE_prio_menorInicial}))}""     ""${varhuecos:1:$((4 - ${#prio_menor}))}""$prio_menor""$azul   │\n" | tee -a $informeConColorTotal
	echo -ne "$prio_menor_maxInicial""${varhuecos:1:$((4 - ${#prio_menor_maxInicial}))}""     ""${varhuecos:1:$((4 - ${#prio_menorInicial}))}""$prio_menorInicial""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Máximo de Prioridades: ""${varhuecos:1:$((7 - ${#prio_mayor_minInicial}))}""$prio_mayor_minInicial"" - " | tee -a $informeConColorTotal
#    printf "$MAX_RANGE_prio_mayorInicial""${varhuecos:1:$((4 - ${#MAX_RANGE_prio_mayorInicial}))}""     ""${varhuecos:1:$((4 - ${#prio_mayor}))}""$prio_mayor""$azul   │\n" | tee -a $informeConColorTotal
	echo -ne "$prio_mayor_maxInicial""${varhuecos:1:$((4 - ${#prio_mayor_maxInicial}))}""     ""${varhuecos:1:$((4 - ${#prio_mayorInicial}))}""$prio_mayorInicial""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Quantum: ""${varhuecos:1:$((21 - ${#MIN_RANGE_quantum}))}""$MIN_RANGE_quantum"" - " | tee -a $informeConColorTotal
	printf "$MAX_RANGE_quantum""${varhuecos:1:$((4 - ${#MAX_RANGE_quantum}))}""     ""${varhuecos:1:$((4 - ${#quantum}))}""$quantum""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Nº de procesos: ""${varhuecos:1:$((14 - ${#MIN_RANGE_NPROC}))}""$MIN_RANGE_NPROC"" - " | tee -a $informeConColorTotal
	printf "$MAX_RANGE_NPROC""${varhuecos:1:$((4 - ${#MAX_RANGE_NPROC}))}""     ""${varhuecos:1:$((4 - ${#n_prog}))}""$n_prog""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Tiempo de llegada: ""${varhuecos:1:$((11 - ${#MIN_RANGE_llegada}))}""$MIN_RANGE_llegada"" - " | tee -a $informeConColorTotal
	printf "$MAX_RANGE_llegada""${varhuecos:1:$((4 - ${#MAX_RANGE_llegada}))}""     ""${varhuecos:1:$((4))}""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Tiempo de ejecución: ""${varhuecos:1:$((9 - ${#MIN_RANGE_tiempo_ejec}))}""$MIN_RANGE_tiempo_ejec"" - " | tee -a $informeConColorTotal
	printf "$MAX_RANGE_tiempo_ejec""${varhuecos:1:$((4 - ${#MAX_RANGE_tiempo_ejec}))}""     ""${varhuecos:1:$((4))}""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Tamaño de los procesos: ""${varhuecos:1:$((6 - ${#MIN_RANGE_tamano_proc}))}""$MIN_RANGE_tamano_proc"" - " | tee -a $informeConColorTotal
	printf "$MAX_RANGE_tamano_proc""${varhuecos:1:$((4 - ${#MAX_RANGE_tamano_proc}))}""     ""${varhuecos:1:$((4))}""$azul   │\n" | tee -a $informeConColorTotal
	printf  "$azul│$NC Rango Prioridades/proceso: ""${varhuecos:1:$((9 - ${#prio_menorInicial}))}""$prio_menorInicial"" - " | tee -a $informeConColorTotal
	echo -ne "$prio_mayorInicial""${varhuecos:1:$((13 - ${#prio_mayorInicial}))}""$azul   │\n" | tee -a $informeConColorTotal
	echo -e "$azul└────────────────────────────────────────────────────────┘" | tee -a $informeConColorTotal
	echo -e "┌────────────────────────────────────────────────────────┐" >> $informeSinColorTotal
	printf "│""${varhuecos:1:$((32))}""Min-Max rango     Valor"" │\n" >> $informeSinColorTotal
	printf "│ Rango Tamaño memoria: ""${varhuecos:1:$((14 - ${#MIN_RANGE_MEM}))}""$MIN_RANGE_MEM"" - " >> $informeSinColorTotal
	printf "$MAX_RANGE_MEM""${varhuecos:1:$((4 - ${#MAX_RANGE_MEM}))}""     ""${varhuecos:1:$((4 - ${#mem}))}""$mem""   │\n" >> $informeSinColorTotal
	printf "│ Rango Reubicacion: ""${varhuecos:1:$((17 - ${#MIN_RANGE_REUB}))}""$MIN_RANGE_REUB"" - " >> $informeSinColorTotal
	printf "$MAX_RANGE_REUB""${varhuecos:1:$((4 - ${#MAX_RANGE_REUB}))}""     ""${varhuecos:1:$((4 - ${#reub}))}""$reub""   │\n" >> $informeSinColorTotal
	printf "│ Rango Mínimo de Prioridades: ""${varhuecos:1:$((7 - ${#prio_menor_minInicial}))}""$prio_menor_minInicial"" - " >> $informeSinColorTotal
#    printf "$MAX_RANGE_prio_menorInicial""${varhuecos:1:$((4 - ${#MAX_RANGE_prio_menorInicial}))}""     ""${varhuecos:1:$((4 - ${#prio_menor}))}""$prio_menor""   │\n" >> $informeSinColorTotal
	echo -ne "$prio_menor_maxInicial""${varhuecos:1:$((4 - ${#prio_menor_maxInicial}))}""     ""${varhuecos:1:$((4 - ${#prio_menorInicial}))}""$prio_menorInicial""   │\n" >> $informeSinColorTotal
	printf "│ Rango Máximo de Prioridades: ""${varhuecos:1:$((7 - ${#prio_mayor_minInicial}))}""$prio_mayor_minInicial"" - " >> $informeSinColorTotal
#    printf "$MAX_RANGE_prio_mayorInicial""${varhuecos:1:$((4 - ${#MAX_RANGE_prio_mayorInicial}))}""     ""${varhuecos:1:$((4 - ${#prio_mayor}))}""$prio_mayor""   │\n" >> $informeSinColorTotal
	echo -ne "$prio_mayor_maxInicial""${varhuecos:1:$((4 - ${#prio_mayor_maxInicial}))}""     ""${varhuecos:1:$((4 - ${#prio_mayorInicial}))}""$prio_mayorInicial""   │\n" >> $informeSinColorTotal
	printf "│ Rango Quantum: ""${varhuecos:1:$((21 - ${#MIN_RANGE_quantum}))}""$MIN_RANGE_quantum"" - " >> $informeSinColorTotal
	printf "$MAX_RANGE_quantum""${varhuecos:1:$((4 - ${#MAX_RANGE_quantum}))}""     ""${varhuecos:1:$((4 - ${#quantum}))}""$quantum""   │\n" >> $informeSinColorTotal
	printf "│ Rango Nº de procesos: ""${varhuecos:1:$((14 - ${#MIN_RANGE_NPROC}))}""$MIN_RANGE_NPROC"" - " >> $informeSinColorTotal
	printf "$MAX_RANGE_NPROC""${varhuecos:1:$((4 - ${#MAX_RANGE_NPROC}))}""     ""${varhuecos:1:$((4 - ${#n_prog}))}""$n_prog""   │\n" >> $informeSinColorTotal
	printf "│ Rango Tiempo de llegada: ""${varhuecos:1:$((11 - ${#MIN_RANGE_llegada}))}""$MIN_RANGE_llegada"" - " >> $informeSinColorTotal
	printf "$MAX_RANGE_llegada""${varhuecos:1:$((4 - ${#MAX_RANGE_llegada}))}""     ""${varhuecos:1:$((4))}""   │\n" >> $informeSinColorTotal
	printf "│ Rango Tiempo de ejecución: ""${varhuecos:1:$((9 - ${#MIN_RANGE_tiempo_ejec}))}""$MIN_RANGE_tiempo_ejec"" - " >> $informeSinColorTotal
	printf "$MAX_RANGE_tiempo_ejec""${varhuecos:1:$((4 - ${#MAX_RANGE_tiempo_ejec}))}""     ""${varhuecos:1:$((4))}""   │\n" >> $informeSinColorTotal
	printf "│ Rango Tamaño de los procesos: ""${varhuecos:1:$((6 - ${#MIN_RANGE_tamano_proc}))}""$MIN_RANGE_tamano_proc"" - " >> $informeSinColorTotal
	printf "$MAX_RANGE_tamano_proc""${varhuecos:1:$((4 - ${#MAX_RANGE_tamano_proc}))}""     ""${varhuecos:1:$((4))}""   │\n" >> $informeSinColorTotal
	printf  "│ Rango Prioridades/proceso: ""${varhuecos:1:$((9 - ${#prio_menorInicial}))}""$prio_menorInicial"" - " >> $informeSinColorTotal
	echo -ne "$prio_mayorInicial""${varhuecos:1:$((13 - ${#prio_mayorInicial}))}""   │\n" >> $informeSinColorTotal
	echo -e "└────────────────────────────────────────────────────────┘" >> $informeSinColorTotal
} #Fin de datos_memoria_tabla()

#######################################################################
# Sinopsis: Presenta una tabla con los rangos y valores calculados
#######################################################################
function datos_amplio_memoria_tabla {
#	clear
	if [[ $seleccionMenuEleccionEntradaDatos -eq 4 ]]; then
		echo -e "$amarillo Por favor, establezca los rangos para datos"
	elif [[ $seleccionMenuEleccionEntradaDatos -eq 5 || $seleccionMenuEleccionEntradaDatos -eq 6 ]]; then
		echo -e "$amarillo Resultados actuales:"
	fi

	echo -e "$azul┌─────────────────────────────────────────────────────────────────────────┐" | tee -a $informeConColorTotal
	printf "$azul│$NC""${varhuecos:1:$((32))}""Min-Max_amplio   Min-Max rango     Valor""$azul │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Tamaño memoria: ""${varhuecos:1:$((14 - ${#memoria_minInicial}))}""$memoria_minInicial"" - ""$memoria_maxInicial""${varhuecos:1:$((4 - ${#memoria_maxInicial}))}" | tee -a $informeConColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_MEM}))}""$MIN_RANGE_MEM"" - ""$MAX_RANGE_MEM""${varhuecos:1:$((4 - ${#MAX_RANGE_MEM}))}" | tee -a $informeConColorTotal
	printf "     ""${varhuecos:1:$((4 - ${#mem}))}""$mem""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Reubicacion: ""${varhuecos:1:$((17 - ${#reubicacion_minInicial}))}""$reubicacion_minInicial"" - ""$reubicacion_maxInicial""${varhuecos:1:$((4 - ${#reubicacion_maxInicial}))}" | tee -a $informeConColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_REUB}))}""$MIN_RANGE_REUB"" - ""$MAX_RANGE_REUB""${varhuecos:1:$((4 - ${#MAX_RANGE_REUB}))}" | tee -a $informeConColorTotal
	printf "     ""${varhuecos:1:$((4 - ${#reub}))}""$reub""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Mínimo de Prioridades: ""${varhuecos:1:$((7 - ${#prio_menor_minInicial}))}""$prio_menor_minInicial"" - ""$prio_menor_maxInicial""${varhuecos:1:$((4 - ${#prio_menor_maxInicial}))}" | tee -a $informeConColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_prio_menor}))}""$MIN_RANGE_prio_menor"" - ""$MAX_RANGE_prio_menor""${varhuecos:1:$((4 - ${#MAX_RANGE_prio_menor}))}" | tee -a $informeConColorTotal
#    printf "$prio_menor_maxInicial""${varhuecos:1:$((4 - ${#prio_menor_maxInicial}))}""     ""${varhuecos:1:$((4 - ${#prio_menorInicial}))}""$prio_menorInicial""$azul   │\n" | tee -a $informeConColorTotal
	echo -ne "     ""${varhuecos:1:$((4 - ${#prio_menorInicial}))}""$prio_menorInicial""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Máximo de Prioridades: ""${varhuecos:1:$((7 - ${#prio_mayor_minInicial}))}""$prio_mayor_minInicial"" - ""$prio_mayor_maxInicial""${varhuecos:1:$((4 - ${#prio_mayor_maxInicial}))}" | tee -a $informeConColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_prio_mayor}))}""$MIN_RANGE_prio_mayor"" - ""$MAX_RANGE_prio_mayor""${varhuecos:1:$((4 - ${#MAX_RANGE_prio_mayor}))}" | tee -a $informeConColorTotal
#    printf "$prio_mayor_maxInicial""${varhuecos:1:$((4 - ${#prio_mayor_maxInicial}))}""     ""${varhuecos:1:$((4 - ${#prio_mayorInicial}))}""$prio_mayorInicial""$azul   │\n" | tee -a $informeConColorTotal
	echo -ne "     ""${varhuecos:1:$((4 - ${#prio_mayorInicial}))}""$prio_mayorInicial""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Quantum: ""${varhuecos:1:$((21 - ${#quantum_minInicial}))}""$quantum_minInicial"" - ""$quantum_maxInicial""${varhuecos:1:$((4 - ${#quantum_maxInicial}))}" | tee -a $informeConColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_quantum}))}""$MIN_RANGE_quantum"" - ""$MAX_RANGE_quantum""${varhuecos:1:$((4 - ${#MAX_RANGE_quantum}))}" | tee -a $informeConColorTotal
	printf "     ""${varhuecos:1:$((4 - ${#quantum}))}""$quantum""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Nº de procesos: ""${varhuecos:1:$((14 - ${#programas_minInicial}))}""$programas_minInicial"" - ""$programas_maxInicial""${varhuecos:1:$((4 - ${#programas_maxInicial}))}" | tee -a $informeConColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_NPROC}))}""$MIN_RANGE_NPROC"" - ""$MAX_RANGE_NPROC""${varhuecos:1:$((4 - ${#MAX_RANGE_NPROC}))}" | tee -a $informeConColorTotal
	printf "     ""${varhuecos:1:$((4 - ${#n_prog}))}""$n_prog""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Tiempo de llegada: ""${varhuecos:1:$((11 - ${#llegada_minInicial}))}""$llegada_minInicial"" - ""$llegada_maxInicial""${varhuecos:1:$((4 - ${#llegada_maxInicial}))}" | tee -a $informeConColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_llegada}))}""$MIN_RANGE_llegada"" - ""$MAX_RANGE_llegada""${varhuecos:1:$((4 - ${#MAX_RANGE_llegada}))}" | tee -a $informeConColorTotal
	printf "     ""${varhuecos:1:$((4))}""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Tiempo de ejecución: ""${varhuecos:1:$((9 - ${#tiempo_ejec_minInicial}))}""$tiempo_ejec_minInicial"" - ""$tiempo_ejec_maxInicial""${varhuecos:1:$((4 - ${#tiempo_ejec_maxInicial}))}" | tee -a $informeConColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_tiempo_ejec}))}""$MIN_RANGE_tiempo_ejec"" - ""$MAX_RANGE_tiempo_ejec""${varhuecos:1:$((4 - ${#MAX_RANGE_tiempo_ejec}))}" | tee -a $informeConColorTotal
	printf "     ""${varhuecos:1:$((4))}""$azul   │\n" | tee -a $informeConColorTotal
	printf "$azul│$NC Rango Tamaño de los procesos: ""${varhuecos:1:$((6 - ${#tamano_proc_minInicial}))}""$tamano_proc_minInicial"" - ""$tamano_proc_maxInicial""${varhuecos:1:$((4 - ${#tamano_proc_maxInicial}))}" | tee -a $informeConColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_tamano_proc}))}""$MIN_RANGE_tamano_proc"" - ""$MAX_RANGE_tamano_proc""${varhuecos:1:$((4 - ${#MAX_RANGE_tamano_proc}))}" | tee -a $informeConColorTotal
	printf "     ""${varhuecos:1:$((4))}""$azul   │\n" | tee -a $informeConColorTotal
	printf  "$azul│$NC Rango Prioridades/proceso: ""${varhuecos:1:$((9 - ${#prio_menorInicial}))}""$prio_menorInicial"" - ""$prio_mayorInicial""${varhuecos:1:$((4 - ${#prio_mayorInicial}))}" | tee -a $informeConColorTotal
#	printf  "  ""${varhuecos:1:$((8 - ${#prio_menor}))}""$prio_menor"" - ""$prio_mayor""${varhuecos:1:$((13 - ${#prio_mayor}))}" | tee -a $informeConColorTotal
	printf  "  ""${varhuecos:1:$((8 - ${#prio_menorInicial}))}""$prio_menorInicial"" - ""$prio_mayorInicial""${varhuecos:1:$((13 - ${#prio_mayorInicial}))}" | tee -a $informeConColorTotal
	echo -ne "$azul   │\n" | tee -a $informeConColorTotal
	echo -e "$azul└─────────────────────────────────────────────────────────────────────────┘"  | tee -a $informeConColorTotal

	echo -e "┌─────────────────────────────────────────────────────────────────────────┐" >> $informeSinColorTotal
	printf "│""${varhuecos:1:$((32))}""Min-Max_amplio   Min-Max rango     Valor"" │\n" >> $informeSinColorTotal
	printf "│ Rango Tamaño memoria: ""${varhuecos:1:$((14 - ${#memoria_minInicial}))}""$memoria_minInicial"" - ""$memoria_maxInicial""${varhuecos:1:$((4 - ${#memoria_maxInicial}))}" >> $informeSinColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_MEM}))}""$MIN_RANGE_MEM"" - ""$MAX_RANGE_MEM""${varhuecos:1:$((4 - ${#MAX_RANGE_MEM}))}" >> $informeSinColorTotal
	printf "     ""${varhuecos:1:$((4 - ${#mem}))}""$mem""   │\n" >> $informeSinColorTotal
	printf "│ Rango Reubicacion: ""${varhuecos:1:$((17 - ${#reubicacion_minInicial}))}""$reubicacion_minInicial"" - ""$reubicacion_maxInicial""${varhuecos:1:$((4 - ${#reubicacion_maxInicial}))}" >> $informeSinColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_REUB}))}""$MIN_RANGE_REUB"" - ""$MAX_RANGE_REUB""${varhuecos:1:$((4 - ${#MAX_RANGE_REUB}))}" >> $informeSinColorTotal
	printf "     ""${varhuecos:1:$((4 - ${#reub}))}""$reub""   │\n" >> $informeSinColorTotal
	printf "│ Rango Mínimo de Prioridades: ""${varhuecos:1:$((7 - ${#prio_menor_minInicial}))}""$prio_menor_minInicial"" - ""$prio_menor_maxInicial""${varhuecos:1:$((4 - ${#prio_menor_maxInicial}))}" >> $informeSinColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_prio_menor}))}""$MIN_RANGE_prio_menor"" - ""$MAX_RANGE_prio_menor""${varhuecos:1:$((4 - ${#MAX_RANGE_prio_menor}))}" >> $informeSinColorTotal
#    printf "$prio_menor_maxInicial""${varhuecos:1:$((4 - ${#prio_menor_maxInicial}))}""     ""${varhuecos:1:$((4 - ${#prio_menorInicial}))}""$prio_menorInicial""   │\n" >> $informeSinColorTotal
	echo -ne "     ""${varhuecos:1:$((4 - ${#prio_menorInicial}))}""$prio_menorInicial""   │\n" >> $informeSinColorTotal
	printf "│ Rango Máximo de Prioridades: ""${varhuecos:1:$((7 - ${#prio_mayor_minInicial}))}""$prio_mayor_minInicial"" - ""$prio_mayor_maxInicial""${varhuecos:1:$((4 - ${#prio_mayor_maxInicial}))}" >> $informeSinColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_prio_mayor}))}""$MIN_RANGE_prio_mayor"" - ""$MAX_RANGE_prio_mayor""${varhuecos:1:$((4 - ${#MAX_RANGE_prio_mayor}))}" >> $informeSinColorTotal
#    printf "$prio_mayor_maxInicial""${varhuecos:1:$((4 - ${#prio_mayor_maxInicial}))}""     ""${varhuecos:1:$((4 - ${#prio_mayorInicial}))}""$prio_mayorInicial""   │\n" >> $informeSinColorTotal
	echo -ne "     ""${varhuecos:1:$((4 - ${#prio_mayorInicial}))}""$prio_mayorInicial""   │\n" >> $informeSinColorTotal
	printf "│ Rango Quantum: ""${varhuecos:1:$((21 - ${#quantum_minInicial}))}""$quantum_minInicial"" - ""$quantum_maxInicial""${varhuecos:1:$((4 - ${#quantum_maxInicial}))}" >> $informeSinColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_quantum}))}""$MIN_RANGE_quantum"" - ""$MAX_RANGE_quantum""${varhuecos:1:$((4 - ${#MAX_RANGE_quantum}))}" >> $informeSinColorTotal
	printf "     ""${varhuecos:1:$((4 - ${#quantum}))}""$quantum""   │\n" >> $informeSinColorTotal
	printf "│ Rango Nº de procesos: ""${varhuecos:1:$((14 - ${#programas_minInicial}))}""$programas_minInicial"" - ""$programas_maxInicial""${varhuecos:1:$((4 - ${#programas_maxInicial}))}" >> $informeSinColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_NPROC}))}""$MIN_RANGE_NPROC"" - ""$MAX_RANGE_NPROC""${varhuecos:1:$((4 - ${#MAX_RANGE_NPROC}))}" >> $informeSinColorTotal
	printf "     ""${varhuecos:1:$((4 - ${#n_prog}))}""$n_prog""   │\n" >> $informeSinColorTotal
	printf "│ Rango Tiempo de llegada: ""${varhuecos:1:$((11 - ${#llegada_minInicial}))}""$llegada_minInicial"" - ""$llegada_maxInicial""${varhuecos:1:$((4 - ${#llegada_maxInicial}))}" >> $informeSinColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_llegada}))}""$MIN_RANGE_llegada"" - ""$MAX_RANGE_llegada""${varhuecos:1:$((4 - ${#MAX_RANGE_llegada}))}" >> $informeSinColorTotal
	printf "     ""${varhuecos:1:$((4))}""   │\n" >> $informeSinColorTotal
	printf "│ Rango Tiempo de ejecución: ""${varhuecos:1:$((9 - ${#tiempo_ejec_minInicial}))}""$tiempo_ejec_minInicial"" - ""$tiempo_ejec_maxInicial""${varhuecos:1:$((4 - ${#tiempo_ejec_maxInicial}))}" >> $informeSinColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_tiempo_ejec}))}""$MIN_RANGE_tiempo_ejec"" - ""$MAX_RANGE_tiempo_ejec""${varhuecos:1:$((4 - ${#MAX_RANGE_tiempo_ejec}))}" >> $informeSinColorTotal
	printf "     ""${varhuecos:1:$((4))}""   │\n" >> $informeSinColorTotal
	printf "│ Rango Tamaño de los procesos: ""${varhuecos:1:$((6 - ${#tamano_proc_minInicial}))}""$tamano_proc_minInicial"" - ""$tamano_proc_maxInicial""${varhuecos:1:$((4 - ${#tamano_proc_maxInicial}))}" >> $informeSinColorTotal
	printf "  ""${varhuecos:1:$((8 - ${#MIN_RANGE_tamano_proc}))}""$MIN_RANGE_tamano_proc"" - ""$MAX_RANGE_tamano_proc""${varhuecos:1:$((4 - ${#MAX_RANGE_tamano_proc}))}" >> $informeSinColorTotal
	printf "     ""${varhuecos:1:$((4))}""   │\n" >> $informeSinColorTotal
	printf  "│ Rango Prioridades/proceso: ""${varhuecos:1:$((9 - ${#prio_menorInicial}))}""$prio_menorInicial"" - ""$prio_mayorInicial""${varhuecos:1:$((4 - ${#prio_mayorInicial}))}" >> $informeSinColorTotal
#	printf  "  ""${varhuecos:1:$((8 - ${#prio_menor}))}""$prio_menor"" - ""$prio_mayor""${varhuecos:1:$((13 - ${#prio_mayor}))}" >> $informeSinColorTotal
	printf  "  ""${varhuecos:1:$((8 - ${#prio_menorInicial}))}""$prio_menorInicial"" - ""$prio_mayorInicial""${varhuecos:1:$((13 - ${#prio_mayorInicial}))}" >> $informeSinColorTotal
	echo -ne "   │\n" >> $informeSinColorTotal
	echo -e "└─────────────────────────────────────────────────────────────────────────┘"  >> $informeSinColorTotal
} #Fin de datos_amplio_memoria_tabla()

#---------Funciones para el pedir por pantalla los mínimos y máximos de los rangos - Opción 4--------------
#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango de la memoria total
#######################################################################
function datos_tamano_memoria {
	datos_memoria_tabla
	until [[ $MAX_RANGE_MEM -ge $MIN_RANGE_MEM && $MIN_RANGE_MEM -gt 0 ]]; do
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para el tamaño de memoria$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para el tamaño de memoria: " >> $informeSinColorTotal
		read MIN_RANGE_MEM #Rango mínimo para la memoria
		echo "$MIN_RANGE_MEM" >> $informeConColorTotal
		echo "$MIN_RANGE_MEM" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el mñaximo del rango para el tamaño de memoria$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mñaximo del rango para el tamaño de memoria: " >> $informeSinColorTotal
		read MAX_RANGE_MEM #Rango máximo para la memoria
		echo "$MAX_RANGE_MEM" >> $informeConColorTotal
		echo "$MAX_RANGE_MEM" >> $informeSinColorTotal
		if [[ $MIN_RANGE_MEM -gt $MAX_RANGE_MEM ]]; then #Si el mayor es menor que el menor, se invierten los rangos
			invertirRangos $MIN_RANGE_MEM $MAX_RANGE_MEM
			MIN_RANGE_MEM=$min
			MAX_RANGE_MEM=$max
		fi
		if [[ $MIN_RANGE_MEM -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $MIN_RANGE_MEM $MAX_RANGE_MEM
			MIN_RANGE_MEM=$min
			MAX_RANGE_MEM=$max
		fi
	done
	mem_igual=$MIN_RANGE_MEM
	mem_es=$MAX_RANGE_MEM
} #Fin de datos_tamano_memoria()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango de la memoria total
#######################################################################
function datos_tamano_memoria_amplio {
	datos_amplio_memoria_tabla
	until [[ $memoria_maxInicial -ge $memoria_minInicial && $memoria_minInicial -gt 0 ]]; do
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para el tamaño de memoria$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para el tamaño de memoria: " >> $informeSinColorTotal
		read memoria_minInicial #Rango mínimo para la memoria
		echo "$memoria_minInicial" >> $informeConColorTotal
		echo "$memoria_minInicial" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el mñaximo del rango para el tamaño de memoria$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mñaximo del rango para el tamaño de memoria: " >> $informeSinColorTotal
		read memoria_maxInicial #Rango máximo para la memoria
		echo "$memoria_maxInicial" >> $informeConColorTotal
		echo "$memoria_maxInicial" >> $informeSinColorTotal
		if [[ $memoria_minInicial -gt $memoria_maxInicial ]]; then #Si el mayor es menor que el menor, se invierten los rangos
			invertirRangos $memoria_minInicial $memoria_maxInicial
			memoria_minInicial=$min
			memoria_maxInicial=$max
		fi
		if [[ $memoria_minInicial -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $memoria_minInicial $memoria_maxInicial
			memoria_minInicial=$min
			memoria_maxInicial=$max
		fi
	done
	memoria_min=$memoria_minInicial
	memoria_max=$memoria_maxInicial
	mem_igual=$memoria_min
	mem_es=$memoria_max
} #Fin de datos_tamano_memoria_amplio()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo para el mínimo del rango de la prioridad
#######################################################################
function datos_prio_menor {
	datos_memoria_tabla
	echo -ne "\n$cian Por favor, establezca el mínimo del rango para la prioridad menor$cian: $NC" | tee -a $informeConColorTotal
	echo -ne "\n Por favor, establezca el mínimo del rango para la prioridad menor: " >> $informeSinColorTotal
	read prio_menor_minInicial #Rango minimo para la variable prioridad
	echo "$prio_menor_minInicial" >> $informeConColorTotal
	echo "$prio_menor_minInicial" >> $informeSinColorTotal
	echo -ne "\n$cian Por favor, establezca el máximo del rango para la prioridad menor$cian: $NC" | tee -a $informeConColorTotal
	echo -ne "\n Por favor, establezca el máximo del rango para la prioridad menor: " >> $informeSinColorTotal
	read prio_menor_maxInicial #Rango maximo para la variable prioridad
	echo "$prio_menor_maxInicial" >> $informeConColorTotal
	echo "$prio_menor_maxInicial" >> $informeSinColorTotal
	prio_menor_min=$prio_menor_minInicial
	prio_menor_max=$prio_menor_maxInicial
} #Fin de datos_prio_menor()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo para el mínimo del rango de la prioridad
#######################################################################
function datos_prio_menor_amplio {
	datos_amplio_memoria_tabla
	echo -ne "\n$cian Por favor, establezca el mínimo del rango para la prioridad menor$cian: $NC" | tee -a $informeConColorTotal
	echo -ne "\n Por favor, establezca el mínimo del rango para la prioridad menor: " >> $informeSinColorTotal
	read prio_menor_minInicial #Rango minimo para la variable prioridad
	echo "$prio_menor_minInicial" >> $informeConColorTotal
	echo "$prio_menor_minInicial" >> $informeSinColorTotal
	echo -ne "\n$cian Por favor, establezca el máximo del rango para la prioridad menor$cian: $NC" | tee -a $informeConColorTotal
	echo -ne "\n Por favor, establezca el máximo del rango para la prioridad menor: " >> $informeSinColorTotal
	read prio_menor_maxInicial #Rango maximo para la variable prioridad
	echo "$prio_menor_maxInicial" >> $informeConColorTotal
	echo "$prio_menor_maxInicial" >> $informeSinColorTotal
	prio_menor_min=$prio_menor_minInicial
	prio_menor_max=$prio_menor_maxInicial
} #Fin de datos_prio_menor_amplio()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo para el máximo del rango de la prioridad
#######################################################################
function datos_prio_mayor {
	datos_memoria_tabla
	echo -ne "\n$cian Por favor, establezca el mínimo del rango para la prioridad mayor$cian: $NC" | tee -a $informeConColorTotal
	echo -ne "\n Por favor, establezca el mínimo del rango para la prioridad mayor: " >> $informeSinColorTotal
	read prio_mayor_minInicial #Rango minimo para la variable prioridad
	echo "$prio_mayor_minInicial" >> $informeConColorTotal
	echo "$prio_mayor_minInicial" >> $informeSinColorTotal
	echo -ne "\n$cian Por favor, establezca el máximo del rango para la prioridad mayor$cian: $NC" | tee -a $informeConColorTotal
	echo -ne "\n Por favor, establezca el máximo del rango para la prioridad mayor: " >> $informeSinColorTotal
	read prio_mayor_maxInicial #Rango maximo para la variable prioridad
	echo "$prio_mayor_maxInicial" >> $informeConColorTotal
	echo "$prio_mayor_maxInicial" >> $informeSinColorTotal
	prio_mayor_min=$prio_mayor_minInicial
	prio_mayor_max=$prio_mayor_maxInicial
} #Fin de datos_prio_mayor()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo para el máximo del rango de la prioridad
#######################################################################
function datos_prio_mayor_amplio {
	datos_amplio_memoria_tabla
	echo -ne "\n$cian Por favor, establezca el mínimo del rango para la prioridad mayor$cian: $NC" | tee -a $informeConColorTotal
	echo -ne "\n Por favor, establezca el mínimo del rango para la prioridad mayor: " >> $informeSinColorTotal
	read prio_mayor_minInicial #Rango minimo para la variable prioridad
	echo "$prio_mayor_minInicial" >> $informeConColorTotal
	echo "$prio_mayor_minInicial" >> $informeSinColorTotal
	echo -ne "\n$cian Por favor, establezca el máximo del rango para la prioridad mayor$cian: $NC" | tee -a $informeConColorTotal
	echo -ne "\n Por favor, establezca el máximo del rango para la prioridad mayor: " >> $informeSinColorTotal
	read prio_mayor_maxInicial #Rango maximo para la variable prioridad
	echo "$prio_mayor_maxInicial" >> $informeConColorTotal
	echo "$prio_mayor_maxInicial" >> $informeSinColorTotal
	prio_mayor_min=$prio_mayor_minInicial
	prio_mayor_max=$prio_mayor_maxInicial
} #Fin de datos_prio_mayor_amplio()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango del número de procesos
#######################################################################
function datos_numero_programas {
	datos_memoria_tabla
	until [[ $MAX_RANGE_NPROC -ge $MIN_RANGE_NPROC && $MIN_RANGE_NPROC -gt 0 ]]; do
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para el número de procesos$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para el número de procesos: " >> $informeSinColorTotal
		read MIN_RANGE_NPROC #Rango mínimo para la memoria
		echo "$MIN_RANGE_NPROC" >> $informeConColorTotal
		echo "$MIN_RANGE_NPROC" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el máximo del rango para el número de procesos$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el máximo del rango para el número de procesos: " >> $informeSinColorTotal
		read MAX_RANGE_NPROC #Rango máximo para la memoria
		echo "$MAX_RANGE_NPROC" >> $informeConColorTotal
		echo "$MAX_RANGE_NPROC" >> $informeSinColorTotal
		if [[ $MIN_RANGE_NPROC -gt $MAX_RANGE_NPROC ]]; then
			invertirRangos $MIN_RANGE_NPROC $MAX_RANGE_NPROC
			MIN_RANGE_NPROC=$min
			MAX_RANGE_NPROC=$max
		fi
		if [[ $MIN_RANGE_NPROC -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $MIN_RANGE_NPROC $MAX_RANGE_NPROC
			MIN_RANGE_NPROC=$min
			MAX_RANGE_NPROC=$max
		fi
	done
	NPROG_igual=$MIN_RANGE_NPROC
} #Fin de datos_numero_programas()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango del número de procesos
#######################################################################
function datos_numero_programas_amplio {
	datos_amplio_memoria_tabla
	until [[ $programas_maxInicial -ge $programas_minInicial && $programas_minInicial -gt 0 ]]; do
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para el número de procesos$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para el número de procesos: " >> $informeSinColorTotal
		read programas_minInicial #Rango mínimo para la memoria
		echo "$programas_minInicial" >> $informeConColorTotal
		echo "$programas_minInicial" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el máximo del rango para el número de procesos$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el máximo del rango para el número de procesos: " >> $informeSinColorTotal
		read programas_maxInicial #Rango máximo para la memoria
		echo "$programas_maxInicial" >> $informeConColorTotal
		echo "$programas_maxInicial" >> $informeSinColorTotal
		if [[ $programas_minInicial -gt $programas_maxInicial ]]; then
			invertirRangos $programas_minInicial $programas_maxInicial
			programas_minInicial=$min
			programas_maxInicial=$max
		fi
		if [[ $programas_minInicial -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $programas_minInicial $programas_maxInicial
			programas_minInicial=$min
			programas_maxInicial=$max
		fi
	done
	programas_min=$programas_minInicial
	programas_max=$programas_maxInicial
	NPROG_igual=$programas_min
} #Fin de datos_numero_programas_amplio()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango del máximo de unidades de memoria admisible para la reubicabilidad
#######################################################################
function datos_tamano_reubicacion {
	datos_memoria_tabla
	until [[ $MAX_RANGE_REUB -ge $MIN_RANGE_REUB && $MIN_RANGE_REUB -gt 0 ]]; do    #Si limite mínimo mayor que máximo
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para la variable de reubicacion$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para la variable de reubicacion: " >> $informeSinColorTotal
		read MIN_RANGE_REUB #Rango mínimo para la variable reubicacion
		echo "$MIN_RANGE_REUB" >> $informeConColorTotal
		echo "$MIN_RANGE_REUB" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el máximo del rango para la variable de reubicacion$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el máximo del rango para la variable de reubicacion: " >> $informeSinColorTotal
		read MAX_RANGE_REUB #Rango máximo para la variable reubicacion
		echo "$MAX_RANGE_REUB" >> $informeConColorTotal
		echo "$MAX_RANGE_REUB" >> $informeSinColorTotal
		if [[ $MIN_RANGE_REUB -gt $MAX_RANGE_REUB ]]; then
			invertirRangos $MIN_RANGE_REUB $MAX_RANGE_REUB
			MIN_RANGE_REUB=$min
			MAX_RANGE_REUB=$max
		fi
		if [[ $MIN_RANGE_REUB -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $MIN_RANGE_REUB $MAX_RANGE_REUB
			MIN_RANGE_REUB=$min
			MAX_RANGE_REUB=$max
		fi
	done
	REUB_igual=$MIN_RANGE_REUB
} #Fin de datos_tamano_reubicacion()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango del máximo de unidades de memoria admisible para la reubicabilidad
#######################################################################
function datos_tamano_reubicacion_amplio {
	datos_amplio_memoria_tabla
	until [[ $reubicacion_maxInicial -ge $reubicacion_minInicial && $reubicacion_minInicial -gt 0 ]]; do    #Si limite mínimo mayor que máximo
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para la variable de reubicacion$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para la variable de reubicacion: " >> $informeSinColorTotal
		read reubicacion_minInicial #Rango mínimo para la variable reubicacion
		echo "$reubicacion_minInicial" >> $informeConColorTotal
		echo "$reubicacion_minInicial" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el máximo del rango para la variable de reubicacion$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el máximo del rango para la variable de reubicacion: " >> $informeSinColorTotal
		read reubicacion_maxInicial #Rango máximo para la variable reubicacion
		echo "$reubicacion_maxInicial" >> $informeConColorTotal
		echo "$reubicacion_maxInicial" >> $informeSinColorTotal
		if [[ $reubicacion_minInicial -gt $reubicacion_maxInicial ]]; then
			invertirRangos $reubicacion_minInicial $reubicacion_maxInicial
			reubicacion_minInicial=$min
			MAX_RANGE_REUB=$max
		fi
		if [[ $reubicacion_minInicial -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $reubicacion_minInicial $reubicacion_maxInicial
			reubicacion_minInicial=$min
			reubicacion_maxInicial=$max
		fi
	done
	reubicacion_min=$reubicacion_minInicial
	reubicacion_max=$reubicacion_maxInicial
	REUB_igual=$reubicacion_min
} #Fin de datos_tamano_reubicacion_amplio()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango de la prioridad de los procesos
#######################################################################
function datos_prio_proc {
	datos_memoria_tabla
} #Fin de datos_prio_proc()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango de la prioridad de los procesos
#######################################################################
function datos_prio_proc_amplio {
	datos_amplio_memoria_tabla
} #Fin de datos_prio_proc_amplio()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango del tamaño en memoria de los procesos
#######################################################################
function datos_quantum {
	datos_memoria_tabla
	until [[ $MAX_RANGE_quantum -ge $MIN_RANGE_quantum && $MIN_RANGE_quantum -gt 0 ]]; do
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para el quantum$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para el quantum: " >> $informeSinColorTotal
		read MIN_RANGE_quantum #Rango minimo para la variable tamaño del proceso en direcciones
		echo "$MIN_RANGE_quantum" >> $informeConColorTotal
		echo "$MIN_RANGE_quantum" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el máximo del rango para el quantum$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el máximo del rango para el quantum: " >> $informeSinColorTotal
		read MAX_RANGE_quantum #Rango maximo para la variable tamaño del proceso en direcciones
		echo "$MAX_RANGE_quantum" >> $informeConColorTotal
		echo "$MAX_RANGE_quantum" >> $informeSinColorTotal
		if [[ $MIN_RANGE_quantum -gt $MAX_RANGE_quantum ]]; then #Si el mayor es menor que el menor, se invierten los rangos
			invertirRangos $MIN_RANGE_quantum $MAX_RANGE_quantum
			MIN_RANGE_quantum=$min
			MAX_RANGE_quantum=$max
		fi
		if [[ $MIN_RANGE_quantum -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $MIN_RANGE_quantum $MAX_RANGE_quantum
			MIN_RANGE_quantum=$min
			MAX_RANGE_quantum=$max
		fi
	done
} #Fin de datos_quantum()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango del tamaño en memoria de los procesos
#######################################################################
function datos_quantum_amplio {
	datos_amplio_memoria_tabla
	until [[ $quantum_maxInicial -ge $quantum_minInicial && $quantum_minInicial -gt 0 ]]; do
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para el quantum$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para el quantum: " >> $informeSinColorTotal
		read quantum_minInicial #Rango minimo para la variable tamaño del proceso en direcciones
		echo "$quantum_minInicial" >> $informeConColorTotal
		echo "$quantum_minInicial" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el máximo del rango para el quantum$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el máximo del rango para el quantum: " >> $informeSinColorTotal
		read quantum_maxInicial #Rango maximo para la variable tamaño del proceso en direcciones
		echo "$quantum_maxInicial" >> $informeConColorTotal
		echo "$quantum_maxInicial" >> $informeSinColorTotal
		if [[ $quantum_minInicial -gt $quantum_maxInicial ]]; then #Si el mayor es menor que el menor, se invierten los rangos
			invertirRangos $quantum_minInicial $quantum_maxInicial
			quantum_minInicial=$min
			quantum_maxInicial=$max
		fi
		if [[ $quantum_minInicial -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $quantum_minInicial $quantum_maxInicial
			quantum_minInicial=$min
			quantum_maxInicial=$max
		fi
		quantum_min=$quantum_minInicial
		quantum_max=$quantum_maxInicial
	done
} #Fin de datos_quantum_amplio()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango del tiempo de llegada de los procesos
#######################################################################
function datos_tiempo_llegada {
	datos_memoria_tabla
	MIN_RANGE_llegada=-1
	until [[ $MAX_RANGE_llegada -ge $MIN_RANGE_llegada && $(($MIN_RANGE_llegada + 1)) -gt 0 ]]; do  #Si limite mínimo mayor que máximo
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para el tiempo de llegada$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para el tiempo de llegada: " >> $informeSinColorTotal
		read MIN_RANGE_llegada #Rango mínimo para la variable tiempo de llegada
		echo "$MIN_RANGE_llegada" >> $informeConColorTotal
		echo "$MIN_RANGE_llegada" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el máximo del rango para el tiempo de llegada$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el máximo del rango para el tiempo de llegada: " >> $informeSinColorTotal
		read MAX_RANGE_llegada #Rango máximo para la variable tiempo de llegada
		echo "$MAX_RANGE_llegada" >> $informeConColorTotal
		echo "$MAX_RANGE_llegada" >> $informeSinColorTotal
		if [[ $MIN_RANGE_llegada -gt $MAX_RANGE_llegada ]]; then
			invertirRangos $MIN_RANGE_llegada $MAX_RANGE_llegada
			MIN_RANGE_llegada=$min
			MAX_RANGE_llegada=$max
		fi
		if [[ $MIN_RANGE_llegada -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $MIN_RANGE_llegada $MAX_RANGE_llegada
			MIN_RANGE_llegada=$(($min - 1)) #Este valor es el único que puede ser 0
			MAX_RANGE_llegada=$(($max - 1))
		fi
	done
	llegada_igual=$MIN_RANGE_llegada
} #Fin de datos_tiempo_llegada()


#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango del tiempo de llegada de los procesos
#######################################################################
function datos_tiempo_llegada_amplio {
	datos_amplio_memoria_tabla
	llegada_minInicial=-1
	until [[ $llegada_maxInicial -ge $llegada_minInicial && $(($llegada_minInicial + 1)) -gt 0 ]]; do  #Si limite mínimo mayor que máximo
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para el tiempo de llegada$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para el tiempo de llegada: " >> $informeSinColorTotal
		read llegada_minInicial #Rango mínimo para la variable tiempo de llegada
		echo "$llegada_minInicial" >> $informeConColorTotal
		echo "$llegada_minInicial" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el máximo del rango para el tiempo de llegada$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el máximo del rango para el tiempo de llegada: " >> $informeSinColorTotal
		read llegada_maxInicial #Rango máximo para la variable tiempo de llegada
		echo "$llegada_maxInicial" >> $informeConColorTotal
		echo "$llegada_maxInicial" >> $informeSinColorTotal
		if [[ $llegada_minInicial -gt $llegada_maxInicial ]]; then
			invertirRangos $llegada_minInicial $llegada_maxInicial
			llegada_minInicial=$min
			llegada_maxInicial=$max
		fi
		if [[ $llegada_minInicial -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $llegada_minInicial $llegada_maxInicial
			llegada_minInicial=$(($min - 1)) #Este valor es el único que puede ser 0
			llegada_maxInicial=$(($max - 1))
		fi
	done
	llegada_min=$llegada_minInicial
	llegada_max=$llegada_maxInicial
	llegada_igual=$llegada_minInicial
} #Fin de datos_tiempo_llegada_amplio()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango del tiempo de ejecución de los procesos
#######################################################################
function datos_tiempo_ejecucion {
	datos_memoria_tabla
	until [[ $MAX_RANGE_tiempo_ejec -ge $MIN_RANGE_tiempo_ejec && $MIN_RANGE_tiempo_ejec -gt 0 ]]; do
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para el tiempo de ejecución$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para el tiempo de ejecución: " >> $informeSinColorTotal
		read MIN_RANGE_tiempo_ejec #Rango mínimo para la variable tiempo de ejecución
		echo "$MIN_RANGE_tiempo_ejec" >> $informeConColorTotal
		echo "$MIN_RANGE_tiempo_ejec" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el máximo del rango para el tiempo de ejecución$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el máximo del rango para el tiempo de ejecución: " >> $informeSinColorTotal
		read MAX_RANGE_tiempo_ejec #Rango máximo para la variable tiempo de ejecución
		echo "$MAX_RANGE_tiempo_ejec" >> $informeConColorTotal
		echo "$MAX_RANGE_tiempo_ejec" >> $informeSinColorTotal
		if [[ $MIN_RANGE_tiempo_ejec -gt $MAX_RANGE_tiempo_ejec ]]; then
			invertirRangos $MIN_RANGE_tiempo_ejec $MAX_RANGE_tiempo_ejec
			MIN_RANGE_tiempo_ejec=$min
			MAX_RANGE_tiempo_ejec=$max
		fi
		if [[ $MIN_RANGE_tiempo_ejec -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $MIN_RANGE_tiempo_ejec $MAX_RANGE_tiempo_ejec
			MIN_RANGE_tiempo_ejec=$min
			MAX_RANGE_tiempo_ejec=$max
		fi
	done
	tiemp_igual=$MIN_RANGE_tiempo_ejec
} #Fin de datos_tiempo_ejecucion()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango del tiempo de ejecución de los procesos
#######################################################################
function datos_tiempo_ejecucion_amplio {
	datos_amplio_memoria_tabla
	until [[ $tiempo_ejec_maxInicial -ge $tiempo_ejec_minInicial && $tiempo_ejec_maxInicial -gt 0 ]]; do
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para el tiempo de ejecución$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para el tiempo de ejecución: " >> $informeSinColorTotal
		read tiempo_ejec_minInicial #Rango mínimo para la variable tiempo de ejecución
		echo "$tiempo_ejec_minInicial" >> $informeConColorTotal
		echo "$tiempo_ejec_minInicial" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el máximo del rango para el tiempo de ejecución$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el máximo del rango para el tiempo de ejecución: " >> $informeSinColorTotal
		read tiempo_ejec_maxInicial #Rango máximo para la variable tiempo de ejecución
		echo "$tiempo_ejec_maxInicial" >> $informeConColorTotal
		echo "$tiempo_ejec_maxInicial" >> $informeSinColorTotal
		if [[ $tiempo_ejec_minInicial -gt $tiempo_ejec_maxInicial ]]; then
			invertirRangos $tiempo_ejec_minInicial $tiempo_ejec_maxInicial
			tiempo_ejec_minInicial=$min
			tiempo_ejec_maxInicial=$max
		fi
		if [[ $tiempo_ejec_minInicial -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $tiempo_ejec_minInicial $tiempo_ejec_maxInicial
			tiempo_ejec_minInicial=$min
			tiempo_ejec_maxInicial=$max
		fi
	done
	tiempo_ejec_min=$tiempo_ejec_minInicial
	tiempo_ejec_max=$tiempo_ejec_maxInicial
	tiemp_igual=$tiempo_ejec_min
} #Fin de datos_tiempo_ejecucion_amplio()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango del tamaño en memoria de los procesos
#######################################################################
function datos_tamano_procesos {
	datos_memoria_tabla
	until [[ $MAX_RANGE_tamano_proc -ge $MIN_RANGE_tamano_proc && $MIN_RANGE_tamano_proc -gt 0 ]]; do
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para el tamaño del proceso$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para el tamaño del proceso: " >> $informeSinColorTotal
		read MIN_RANGE_tamano_proc #Rango mínimo para la variable tamaño del proceso
		echo "$MIN_RANGE_tamano_proc" >> $informeConColorTotal
		echo "$MIN_RANGE_tamano_proc" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el máximo del rango para el tamaño del proceso$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el máximo del rango para el tamaño del proceso: " >> $informeSinColorTotal
		read MAX_RANGE_tamano_proc #Rango máximo para la variable tamaño del proceso
		echo "$MAX_RANGE_tamano_proc" >> $informeConColorTotal
		echo "$MAX_RANGE_tamano_proc" >> $informeSinColorTotal
		if [[ $MIN_RANGE_tamano_proc -gt $MAX_RANGE_tamano_proc ]]; then
			invertirRangos $MIN_RANGE_tamano_proc $MAX_RANGE_tamano_proc
			MIN_RANGE_tamano_proc=$min
			MAX_RANGE_tamano_proc=$max
		fi
		if [[ $MIN_RANGE_tamano_proc -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $MIN_RANGE_tamano_proc $MAX_RANGE_tamano_proc
			MIN_RANGE_tamano_proc=$min
			MAX_RANGE_tamano_proc=$max
		fi
	done
	taman_igual=$MIN_RANGE_tamano_proc
} #Fin de datos_tamano_procesos()

#######################################################################
# Sinopsis: Se piden por pantalla el mínimo y máximo del rango del tamaño en memoria de los procesos
#######################################################################
function datos_tamano_procesos_amplio {
	datos_amplio_memoria_tabla
	until [[ $tamano_proc_maxInicial -ge $tamano_proc_minInicial && $tamano_proc_maxInicial -gt 0 ]]; do
		echo -ne "\n$cian Por favor, establezca el mínimo del rango para el tamaño del proceso$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el mínimo del rango para el tamaño del proceso: " >> $informeSinColorTotal
		read tamano_proc_minInicial #Rango mínimo para la variable tamaño del proceso
		echo "$tamano_proc_minInicial" >> $informeConColorTotal
		echo "$tamano_proc_minInicial" >> $informeSinColorTotal
		echo -ne "\n$cian Por favor, establezca el máximo del rango para el tamaño del proceso$cian: $NC" | tee -a $informeConColorTotal
		echo -ne "\n Por favor, establezca el máximo del rango para el tamaño del proceso: " >> $informeSinColorTotal
		read tamano_proc_maxInicial #Rango máximo para la variable tamaño del proceso
		echo "$tamano_proc_maxInicial" >> $informeConColorTotal
		echo "$tamano_proc_maxInicial" >> $informeSinColorTotal
		if [[ $tamano_proc_minInicial -gt $tamano_proc_maxInicial ]]; then
			invertirRangos $tamano_proc_minInicial $tamano_proc_maxInicial
			tamano_proc_minInicial=$min
			tamano_proc_maxInicial=$max
		fi
		if [[ $tamano_proc_minInicial -lt 0 ]]; then #Si el mínimo es negativo se desplaza a positivo
			desplazarRangos $tamano_proc_minInicial $tamano_proc_maxInicial
			tamano_proc_minInicial=$min
			tamano_proc_maxInicial=$max
		fi
	done
	tamano_proc_min=$tamano_proc_minInicial
	tamano_proc_max=$tamano_proc_maxInicial
	taman_igual=$tamano_proc_min
} #Fin de datos_tamano_procesos_amplio()

#---------Funciones para el cálculo de los datos desde los rangos--------------
#######################################################################
# Sinopsis: Dato del tamaño de la memoria total, calculado de forma aleatoria desde su rango
#######################################################################
#######################################################################
# Sinopsis: Dato del tamaño de la memoria total, calculado de forma aleatoria desde su rango
#######################################################################
function calcRango_tamano_memoria {
	datos_memoria_tabla
	MIN_RANGE_MEM=${memoria_min}
	MAX_RANGE_MEM=${memoria_max}
	mem_igual=$MIN_RANGE_MEM
} #Fin de calcRango_tamano_memoria()

#######################################################################
# Sinopsis: Dato del número de procesos, calculado de forma aleatoria desde su rango
#######################################################################
function calcRango_numero_programas {
	datos_memoria_tabla
	MIN_RANGE_NPROC=${programas_min}
	MAX_RANGE_NPROC=${programas_max}
	NPROG_igual=$MIN_RANGE_NPROC
} #Fin de calcRango_numero_programas()

#######################################################################
# Sinopsis: Dato del tamaño del máximo de unidades de memoria admisible para la reubicabilidad, calculado de forma aleatoria desde su rango
#######################################################################
function calcRango_tamano_reubicacion {
	datos_memoria_tabla
	MIN_RANGE_REUB=${reubicacion_min}
	MAX_RANGE_REUB=${reubicacion_max}
	REUB_igual=$MIN_RANGE_REUB
} #Fin de calcRango_tamano_reubicacion()

#######################################################################
# Sinopsis: Dato del tamaño del máximo de unidades de memoria admisible para la reubicabilidad, calculado de forma aleatoria desde su rango
#######################################################################
function calcRango_prio_menor {
	datos_memoria_tabla
	MIN_RANGE_prio_menor=${prio_menor_min}
	MAX_RANGE_prio_menor=${prio_menor_max}
	prio_menor_igual=$MIN_RANGE_prio_menor
} #Fin de calcRango_prio_menor()

#######################################################################
# Sinopsis: Dato del tamaño del máximo de unidades de memoria admisible para la reubicabilidad, calculado de forma aleatoria desde su rango
#######################################################################
function calcRango_prio_mayor {
	datos_memoria_tabla
	MIN_RANGE_prio_mayor=${prio_mayor_min}
	MAX_RANGE_prio_mayor=${prio_mayor_max}
	prio_mayor_igual=$MIN_RANGE_prio_mayor
} #Fin de calcRango_prio_mayor()

#######################################################################
# Sinopsis: Dato del tamaño del máximo de unidades de memoria admisible para la reubicabilidad, calculado de forma aleatoria desde su rango
#######################################################################
function calcRango_quantum {
	datos_memoria_tabla
	MIN_RANGE_quantum=${quantum_min}
	MAX_RANGE_quantum=${quantum_max}
	quantum_igual=$MIN_RANGE_quantum
} #Fin de calcRango_quantum()

#######################################################################
# Sinopsis: Dato del tiempo de llegada asociado a cada proceso, calculado de forma aleatoria desde su rango
#######################################################################
function calcRango_tiempo_llegada {
	datos_memoria_tabla
	MIN_RANGE_llegada=${llegada_min}
	MAX_RANGE_llegada=${llegada_max}
	llegada_igual=$MIN_RANGE_llegada
} #Fin de calcRango_tiempo_llegada()

#######################################################################
# Sinopsis: Dato del tiempo de ejecución asociado a cada proceso, calculado de forma aleatoria desde su rango
#######################################################################
function calcRango_tiempo_ejecucion {
	datos_memoria_tabla
	MIN_RANGE_tiempo_ejec=${tiempo_ejec_min}
	MAX_RANGE_tiempo_ejec=${tiempo_ejec_max}
	tiemp_igual=$MIN_RANGE_tiempo_ejec
} #Fin de calcRango_tiempo_ejecucion()

#######################################################################
# Sinopsis: Dato del tamaño de memoria asociado a cada proceso, calculado de forma aleatoria desde su rango
#######################################################################
function calcRango_tamano_procesos {
	datos_memoria_tabla
	MIN_RANGE_tamano_proc=${tamano_proc_min}
	MAX_RANGE_tamano_proc=${tamano_proc_max}
	taman_igual=$MIN_RANGE_tamano_proc
} #Fin de calcRango_tamano_procesos()

#Cálculo de los mínimos de los subrangos calculados desde los rangos amplios.
#Este mínimo será usado como el mínimo del subrango, para asegurar que el máximo del subrango siempre estará entre éste y el máximo del rango amplio.
#######################################################################
# Sinopsis: Mínimo del subrango del tamaño de la memoria total, calculado desde el rango amplio
#######################################################################
function calcMinGeneral {
	#Llamada: calcMinGeneral $memoria_min $memoria_max #Asignación: MIN_RANGE_MEM=$minGeneral
	min=$1 #min=$memoria_min
	max=$2 #max=$memoria_max
	minGeneral=$((RANDOM % ($max - $min + 1) + $min)) #MIN_RANGE_MEM=$((RANDOM % ($max - $min + 1) + $min)) # Generar un número aleatorio dentro del rango
} #Fin de calcMinGeneral()

#Cálculo de los máximos de los subrangos calculados desde los rangos amplios.
#El mínimo usado será el mínimo del subrango calculado antes para asegurar que siempre estará entre éste y el máximo del rango amplio.
#######################################################################
# Sinopsis: Máximo del subrango del número de procesos, calculado desde el rango amplio
#######################################################################
function calcMaxGeneral {
	#Llamada: calcMaxGeneral $MIN_RANGE_MEM $memoria_max #Asignación: MAX_RANGE_MEM=$maxGeneral
	min=$1 #min=$MIN_RANGE_MEM
	max=$2 #max=$memoria_max
	maxGeneral=$((RANDOM % ($max - $min + 1) + $min)) #MAX_RANGE_MEM=$((RANDOM % (max - min + 1) + min)) # Generar un número aleatorio dentro del rango
} #Fin de calcMaxGeneral()

#Cálculo de los valores generales con los que resolver el problema (Memoria, Reubicación y Nº de procesos)
#######################################################################
# Sinopsis: Dato del tamaño de la memoria total, calculado de forma aleatoria desde su subrango
#######################################################################
function calcDatoAleatorioGeneral {
	#Llamada: calcDatoAleatorioGeneral $MIN_RANGE_MEM $MAX_RANGE_MEM #Asignación: mem=$datoAleatorioGeneral
	min=$1 #min=$MIN_RANGE_MEM
	max=$2 #max=$MAX_RANGE_MEM
	datoAleatorioGeneral=$((RANDOM % ($max - $min + 1) + $min)) #mem=$((RANDOM % ($max - $min + 1) + $min)) # Generar un número aleatorio dentro del rango
} #Fin de calcDatoAleatorioGeneral()

#######################################################################
# Sinopsis: #Si los mínimos son mayores que los invierten los rangos.
#######################################################################
function invertirRangos {
	aux=$1
	min=$2
	max=$aux
} #Fin de invertirRangos()

#######################################################################
# Sinopsis: #Si mínimo y máximo son negativos se desplaza el mínimo hasta ser 0.
#######################################################################
function desplazarRangos {
	max=$(($2 - $1 + 1)) #La condición es estrictamente mayor para que si sólo hay una unidad de diferencia se quedan iguales.
	min=1 #Todos los valores mínimos tienen que ser 1 como mínimo, salvo el tiempo de llegada que podría ser 0
} #Fin de desplazarRangos()

#######################################################################
# Sinopsis: Cálculo del número de espacios necesarios delante para rellenar los campos de datos numéricos y mantener los anchos de las columnas de las tablas de la opción 8.
#######################################################################
function calcularEspacios {
	local valor=$1
	if [[ $valor -ge 0 ]]; then
		echo -n " "
	fi
	if [[ $valor -lt 10 && $valor -gt -10 ]]; then
		echo -n " "
	fi
} #Fin de calcularEspacios()

#######################################################################
# Sinopsis: Cálculo del número de espacios necesarios detrás para rellenar los campos de datos textuales y mantener los anchos de las columnas de las tablas de la opción 8.
#######################################################################
function calcularEspaciosDetras {
	local valor=$1
	if [[ $valor -lt 10 && $valor -gt -10 ]]; then
	echo -n " "
	fi
} #Fin de calcularEspaciosDetras()

#######################################################################
# Sinopsis: Define el color de cada dígito de cada unidad a representar - Color por defecto
#######################################################################
function colorDefaultInicio {
	for (( j=0; j<5; j++)); do
		coloresPartesTiempo=("${coloresPartesTiempo[@]}" "${coloress[97]}")
	done
} #Fin de colorDefaultInicio()

#######################################################################
# Sinopsis: Define el color de cada dígito de cada unidad a representar - Color del proceso anterior
#######################################################################
function colorAnterior {
	for (( j=0; j<$digitosUnidad; j++)); do
		coloresPartesTiempo=("${coloresPartesTiempo[@]}" "${coloress[proanterior]}")
	done
} #Fin de colorAnterior()

#######################################################################
# Sinopsis: Define el color de cada dígito de cada unidad a representar - Color del proceso actual
#######################################################################
function colorPO {
	for (( j=0; j<$digitosUnidad; j++)); do
		coloresPartesTiempo=("${coloresPartesTiempo[@]}" "${coloress[po]}")
	done
} #Fin de colorPO()

#######################################################################
# Sinopsis: Establece los colores de cada proceso
#######################################################################
function  Establecimiento_colores_proces {
	col=1
	aux=0
	for (( i=0,j=0; i<$nprocesos; i++,j++)); do
		auxiliar=$[ ${#coloress[@]} - 2 ]
		indice[$i]=$j
		while [[ ${indice[$i]} -ge $auxiliar ]]; do
			indice[$i]=$[ ${indice[$i]} - $auxiliar ]
		done
		colores[$i]=${coloress[${indice[$i]}]}
#        colorfondo[$i]=${colorfondos[${indice[$i]}]}
		if [[ $j -eq 16 ]]; then #Para que se reinicien los colores
			j=$((j-16))
		fi #Cierre para que se reinicien los colores
	done
} #Fin de Establecimiento_colores_proces()

#######################################################################
# Sinopsis: Define el color de cada dígito de cada unidad a representar - Color de otras unidades del proceso actual
#######################################################################
function colorunidMemOcupadas {
	for (( j=0; j<$digitosUnidad; j++)); do
		coloresPartesMemoria=("${coloresPartesMemoria[@]}" "${coloress[${unidMemOcupadas[$ra]}]}")
	done
} #Fin de colorunidMemOcupadas()

#######################################################################
# Sinopsis: Define el color de cada dígito de cada unidad de la memoria y tiempo a representar - Color por defecto
#######################################################################
function colorDefaultBMBT {
	for (( j=0; j<$digitosUnidad; j++)); do
		coloresPartesMemoria=("${coloresPartesMemoria[@]}" "${coloress[97]}")
	done
} #Fin de colorDefaultBMBT()

#######################################################################
# Sinopsis: Dada una unidad de 3 dígitos, se calcula el número de espacios a poner por delante para rellenar.
#######################################################################
function imprimirEspaciosEstrechos { #3 - ancho de columnas estrechas en tabla resumen de procesos en los volcados
	TamNum=$(($longCampoTablaEstrecho - $1)) #No se restan los espacios laterales izquierdo y derecho porque se pintarán por separado.
	espaciosfinal=${varhuecos:1:$TamNum}
	echo -ne "${varC[$i]}$espaciosfinal$NC"
} #Fin de imprimirEspaciosEstrechos()

function imprimirEspaciosEstrechosBN { #3 - ancho de columnas estrechas en tabla resumen de procesos en los volcados 
	TamNum=$(($longCampoTablaEstrecho - $1)) #No se restan los espacios laterales izquierdo y derecho porque se pintarán por separado. 
	espaciosfinal=${varhuecos:1:$TamNum}
	echo -ne "$espaciosfinal"
} #Fin de imprimirEspaciosEstrechosBN()

#######################################################################
# Sinopsis: Dada una unidad de 4 dígitos, se calcula el número de espacios a poner por delante para rellenar.
#######################################################################
function imprimirEspaciosAnchos { #4 - ancho de columnas anchas en tabla resumen de procesos en los volcados
	TamNum=$(("$longCampoTablaAncho" - "$1")) #No se restan los espacios laterales izquierdo y derecho porque se pintarán por separado.
	espaciosfinal=${varhuecos:1:$TamNum}
	echo -ne "${varC[$i]}$espaciosfinal$NC"
} #Fin de imprimirEspaciosAnchos()

function imprimirEspaciosAnchosBN { #4 - ancho de columnas anchas en tabla resumen de procesos en los volcados
	TamNum=$(("$longCampoTablaAncho" - "$1")) #No se restan los espacios laterales izquierdo y derecho porque se pintarán por separado. 
	espaciosfinal=${varhuecos:1:$TamNum}
	echo -ne "$espaciosfinal" 
} #Fin de imprimirEspaciosAnchosBN()

#######################################################################
# Sinopsis: Dada una unidad de 5 dígitos, se calcula el número de espacios a poner por delante para rellenar.
#######################################################################
function imprimirEspaciosMasAnchos { #5 - ancho de columnas más anchas en tabla resumen de procesos en los volcados
	TamNum=$(( $longCampoTablaMasAncho - $1 )) #No se restan los espacios laterales izquierdo y derecho porque se pintarán por separado.
	espaciosfinal=${varhuecos:1:$TamNum}
	echo -ne "${varC[$i]}$espaciosfinal$NC"
} #Fin de imprimirEspaciosMasAnchos()

function imprimirEspaciosMasAnchosBN { #5 - ancho de columnas más anchas en tabla resumen de procesos en los volcados
	TamNum=$(( $longCampoTablaMasAncho - $1 )) #No se restan los espacios laterales izquierdo y derecho porque se pintarán por separado. 
	espaciosfinal=${varhuecos:1:$TamNum}
	echo -ne "$espaciosfinal"
} #Fin de imprimirEspaciosMasAnchosBN()

#######################################################################
# Sinopsis: Dada una unidad de 17 dígitos, se calcula el número de espacios a poner por delante para rellenar.
#######################################################################
function imprimirEspaciosMuyAnchos { #17 - ancho de columnas muy anchas en tabla resumen de procesos en los volcados
	TamNum=$(( $longCampoTablaMuyAncho - $1 )) #No se restan los espacios laterales izquierdo y derecho porque se pintarán por separado.
	espaciosfinal=${varhuecos:1:$TamNum}
	echo -ne "${varC[$i]}$espaciosfinal$NC"
} #Fin de imprimirEspaciosMuyAnchos()

function imprimirEspaciosMuyAnchosBN { #17 - ancho de columnas muy anchas en tabla resumen de procesos en los volcados 
	TamNum=$(( $longCampoTablaMuyAncho - $1 )) #No se restan los espacios laterales izquierdo y derecho porque se pintarán por separado. 
	espaciosfinal=${varhuecos:1:$TamNum}
	echo -ne "$espaciosfinal"
} #Fin de imprimirEspaciosMuyAnchosBN()

#######################################################################
# Sinopsis: Dada una unidad de 9 dígitos, se calcula el número de espacios a poner por delante para rellenar.
#######################################################################
function imprimirEspaciosRangosLargos { #9 - ancho de columnas anchas en tabla de rangos
	TamNum=$(( $longCampoTablaRangosLargos - $1 )) #No se restan los espacios laterales izquierdo y derecho porque se pintarán por separado.
	espaciosfinal=${varhuecos:1:$TamNum}
	echo -ne "${varC[$i]}$espaciosfinal$NC"
} #Fin de imprimirEspaciosRangosLargos()

function imprimirEspaciosRangosLargosBN { #9 - ancho de columnas anchas en tabla de rangos 
	TamNum=$(( $longCampoTablaRangosLargos - $1 )) #No se restan los espacios laterales izquierdo y derecho porque se pintarán por separado. 
	espaciosfinal=${varhuecos:1:$TamNum}
	echo -ne "$espaciosfinal"
} #Fin de imprimirEspaciosRangosLargos()

####################################################################################
# Sinopsis: Se eliminan los archivos de última ejecución que había anteriormente creados y
# nos direcciona a la entrada de particiones y procesos
####################################################################################
function nuevaEjecucion {
#	clear
	if [[ -f $ficheroDatosAnteriorEjecucion ]]; then
		rm $ficheroDatosAnteriorEjecucion
	fi
	if [[ -f $ficherosRangosAnteriorEjecucion && ($seleccionMenuEleccionEntradaDatos -eq 4 || $seleccionMenuEleccionEntradaDatos -eq 6 || $seleccionMenuEleccionEntradaDatos -eq 7 || $seleccionMenuEleccionEntradaDatos -eq 8 || $seleccionMenuEleccionEntradaDatos -eq 9) ]]; then
		rm $ficherosRangosAnteriorEjecucion
	fi
	if [[ -f $ficheroRangosAleTotalAnteriorEjecucion && ($seleccionMenuEleccionEntradaDatos -eq 7 || $seleccionMenuEleccionEntradaDatos -eq 9) ]]; then
		rm $ficheroRangosAleTotalAnteriorEjecucion
	fi
} #Fin de nuevaEjecucion()

#######################################################################
# Sinopsis: Se calcula el tamaño máximo de la unidad para contener todos los datos que se generen sin modificar el ancho de la columna necesaria
#######################################################################
function calcularUnidad {
	sumatorio=0
	sumatorio1=0
	sumatorio2=0
	for (( i=0; i<$nprocesos; i++ )); do #Se suman los tiempos de llegada y ejecución para calcular el tamaño de la unidad de tiempo más elevada.
		sumatorio1=$(( sumatorio1 + ${llegada[$i]} + ${ejecucion[$i]} ))
	done
	sumatorio2=$mem_total #Para compatibilizar los formatos y nombres de variables de las funciones de las diferentes aplicaciones
	
	if [[ $sumatorio2 -lt $sumatorio1 ]]; then
		sumatorio=$sumatorio1
	else
		sumatorio=$sumatorio2
	fi
	espacios=$(echo -n "$sumatorio" | wc -c)
	if [[ $espacios -le 2 ]]; then #Se calcula 
		digitosUnidad=3
	else
		digitosUnidad=$espacios
		digitosUnidad=$(( $digitosUnidad + 1 ))
	fi
} #Fin de calcularUnidad()

#######################################################################
# Sinopsis: Se calcula el tamaño máximo de la unidad para contener todos los datos que se generen sin modificar el ancho de la columna necesaria
#######################################################################
function calcularUnidad_ORI {
	sumatorio=0
	for (( i=0; i<$nprocesos; i++ )); do
#		sumatorio=$(( sumatorio + ${llegada[$i]} + ${tejecucion[$i]} )) #Se debería cambiar tejecucion[] por ejecucion[] en todas sus apariciones porque son lo mismo...
		sumatorio=$(( sumatorio + ${llegada[$i]} + ${ejecucion[$i]} ))
	done
	espacios=$(echo -n "$sumatorio" | wc -c)
	if [[ $espacios -le 2 ]]; then
		digitosUnidad=3
	else
		digitosUnidad=$espacios
		digitosUnidad=$(( $digitosUnidad + 1 ))
	fi
} #Fin de calcularUnidad_ORI()

####################################################################################
# Sinopsis: Permite introducir las particiones y datos desde otro fichero (predefinido).
####################################################################################
function entradaMemoriaDatosFichero {
#	clear
	echo -e $ROJO"\nFicheros de datos a elegir en './FDatos/': "$NORMAL | tee -a $informeConColorTotal
	echo -e "\nFicheros de datos a elegir en './FDatos/': " >> $informeSinColorTotal
	files=($(ls -l ./FDatos/ | awk '{print $9}'))
	for i in "${!files[@]}"; do
		echo -e "$((i+1))) ${files[$i]}" | tee -a $informeConColorTotal
		echo -e "$((i+1))) ${files[$i]}" >> $informeSinColorTotal
	done
	echo -ne "$AMARILLO\n\nIntroduce el número correspondiente al fichero a analizar: $NORMAL" | tee -a $informeConColorTotal
	echo -ne "\n\nIntroduce el número correspondiente al fichero a analizar: " >> $informeSinColorTotal
	read -r numeroFichero
	echo -e "$numeroFichero\n\n" >> $informeConColorTotal
	echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	until [[ 0 -lt $numeroFichero && $numeroFichero -le ${#files[@]} && $numeroFichero -ne "" ]]; do
		echo -ne "Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read -r numeroFichero
		echo -e "$numeroFichero\n\n" >> $informeConColorTotal
		echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	done
	ficheroParaLectura="./FDatos/${files[$((numeroFichero-1))]}"
} #Fin de entradaMemoriaDatosFichero()

####################################################################################
# Sinopsis: Permite introducir las particiones y datos desde otro fichero (predefinido).
####################################################################################
function entradaMemoriaRangosFichero {
#	clear
	echo -e $ROJO"\nFicheros de datos a elegir en './FDatos/': "$NORMAL | tee -a $informeConColorTotal
	echo -e "\nFicheros de datos a elegir en './FDatos/': " >> $informeSinColorTotal
	files=($(ls -l ./FDatos/ | awk '{print $9}'))
	for i in "${!files[@]}"; do
		echo -e "$((i+1))) ${files[$i]}" | tee -a $informeConColorTotal
		echo -e "$((i+1))) ${files[$i]}" >> $informeSinColorTotal
	done
	echo -ne "$AMARILLO\n\nIntroduce el número correspondiente al fichero a analizar: $NORMAL" | tee -a $informeConColorTotal
	echo -ne "\n\nIntroduce el número correspondiente al fichero a analizar: " >> $informeSinColorTotal
	read -r numeroFichero
	echo -e "$numeroFichero\n\n" >> $informeConColorTotal
	echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	until [[ 0 -lt $numeroFichero && $numeroFichero -le ${#files[@]} && $numeroFichero -ne "" ]]; do
		echo -ne "Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read -r numeroFichero
		echo -e "$numeroFichero\n\n" >> $informeConColorTotal
		echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	done
	ficheroParaLectura="./FDatos/${files[$((numeroFichero-1))]}"
} #Fin de entradaMemoriaRangosFichero()

####################################################################################
# Sinopsis: Inicilizamos diferentes tablas y variables
####################################################################################
function inicializaVectoresVariables {
	# -----------------------------------------------------------------------------
	# Inicilizamos las tablas indicadoras de la MEMORIA NO CONTINUA
	# -----------------------------------------------------------------------------
	#Se crea el array para determinar qué unidades de memoria están ocupadas y se inicializan con _
	for (( ca=0; ca<(mem_total); ca++)); do
		unidMemOcupadas[$ca]="_"
	done
	#Se crea un array auxiliar para realizar la reubicación
	for (( ca=0; ca<(mem_total); ca++)); do
		unidMemOcupadasAux[$ca]="_"
	done
	#Se crea un array para guardar si un proceso está escrito o no EN EL ARRAY
	for (( ca=0; ca<(nprocesos); ca++)); do
		escrito[$ca]=0
	done
	#Se crea variables para determinar si hay que reubicar (en un primer momento no)
	#En caso de ser memoria no continua, si hay un hueco demasiado pequeño, y se va a usar como parte de la memoria a usar.
	reubicarReubicabilidad=0
	#En caso de ser memoria continua, si no hay un hueco suficientemente grande en el que quepa pero sí en la suma de todos ellos.
	reubicarContinuidad=0
	#Array que almacena el valor de en cuantos bloques se fragmenta un proceso
	for (( ca=0; ca<($nprocesos); ca++)); do
		bloques[$ca]=0
	done
	#Controla qué procesos están presentes en la banda de tiempo
	for (( ca=0; ca<(nprocesos); ca++)); do
		nomtiempo[$ca]=0 #Se van poniendo a 1 a medida que se van metiendo en las variables de las líneas de la banda de tiempos.
	done
	# -----------------------------------------------------------------------------
	# Inicilizamos las tablas indicadoras de la situación del proceso
	# -----------------------------------------------------------------------------
	for (( i=0; i<$nprocesos; i++ )); do
		pos_inicio[$i]=0
		pos_final[$i]=0
		temp_rej[$i]=0
		encola[$i]=0
		enmemoria[$i]=0
		enpausa[$i]=0
		enejecucion[$i]=0
		bloqueados[$i]=0
		terminados[$i]=0
		nollegado[$i]=0
	done
	for (( i=0; i<$nprocesos; i++)); do #Copia de todas las listas para luego ponerlas en orden
		temp_rej[$i]=${ejecucion[$i]}
		encola[$i]=0
		enmemoria[$i]=0
		enejecucion[$i]=0
		bloqueados[$i]=0
		enpausa[$i]=0
		terminados[$i]=0 #Determina qué procesos han terminado (1).
		nollegado[$i]=0
		estad[$i]=0
		estado[$i]=0
		temp_wait[$i]="-"
		temp_resp[$i]="-"
		temp_ret[$i]="-"
		colaTiempoRR[$i]=-1 #Contiene el orden de ejecución de Round-Robin (RR). Será "-" mientras no esté en cola, o cuando haya terminado, y si aún no ha terminado contendrá el número ordinal del siguiente quantum. El proceso a ejecutar será, por tanto, el que tenga el número ordinal más bajo. Y el número de quantums realizados (cambios de contexto, será el número ordinal más alto.
	done
	for (( i=0; i<$nprocesos; i++ )); do
		 tejecucion[$i]=${temp_rej[$i]}
	done
	Establecimiento_colores_proces #Establece el color de cada proceso
	blanco="\e[37m"
	mem_libre=$mem_total
	mem_aux=$mem_libre

	calcularUnidad #Determina el mayor número que podría ser representado por Tllegada y Tejecucion
	maxProcPorUnidadTiempoBT=0 # Se calcula el valor máximo del número de unidades de tiempo. Como mucho, los tiempos de llegada más los tiempos de ejecución. Ese será el número de elementos máximo del array procPorUnidadTiempoBT
	for ((j = 0; j < ${#proceso[@]}; j++)); do
		maxProcPorUnidadTiempoBT=$(($maxProcPorUnidadTiempoBT + ${llegada[$j]} + ${ejecucion[$j]}))
	done
	topeProcPorUnidadTiempoBT=$maxProcPorUnidadTiempoBT # Se pone un valor que nunca se probará (tope dinámico). Osea, el mismo que maxProcPorUnidadTiempoBT.
	indiceColaTiempoRRLibre=0 #Índice con el primer ordinal libre a repartir en Round-Robin (RR). Irá creciendo con cada puesto de quantum repartido y marca el futuro orden de ejecución.
	indiceColaTiempoRREnEjecucion=0 #Índice con el actual ordinal en ejecución para Round-Robin (RR). Irá creciendo con cada quantum ejecutado y marca el actual número ordinal de uantum en ejecución.
#	clear
} #Fin de inicializaVectoresVariables()

####################################################################################
# Sinopsis: Gestión de procesos - FCFS
####################################################################################
function gestionProcesosFCFS {
	if [[ $cpu_ocupada == "NO" ]]; then
		if [[ $realizadoAntes -eq 0 ]]; then
			indice_aux=-1
			for (( i=0; i<$nprocesos; i++ )); do  #Establecemos qué proceso es el siguiente que llega a memoria.
				if [[ ${enmemoria[$i]} -eq 1 && ${terminados[$i]} -ne 1 ]]; then
				   indice_aux=$i #El siguiente proceso que llega a memoria
					temp_aux=${temp_rej[$i]}
					break
				fi
			done
			if ! [[ "$indice_aux" -eq -1 ]]; then #Hemos encontrado el siguiente proceso en memoria
				enejecucion[$indice_aux]=1 #Marco el proceso para ejecutarse
				enpausa[$indice_aux]=0 #Quitamos el estado pausado si el proceso lo estaba anteriormente
				enmemoria[$indice_aux]=1 #Marcamos el proceso como en memoria
				cpu_ocupada=SI #La CPU está ocupada por un proceso
				avisoEntradaCPU[$indice_aux]=1 #Se activa el aviso de entrada en CPU del volcado
			fi
		fi
	fi
	if [[ $cpu_ocupada == "SI" ]]; then
		for (( i=0; i<$nprocesos; i++ )); do
			if [[ ${enejecucion[$i]} -eq 1 ]]; then
				ejecutandoinst=$i
			fi
		done
		enejecucion[$ejecutandoinst]=1 #Mantengo el proceso en ejecucion
		enpausa[$ejecutandoinst]=0 #Quitamos el estado pausado si el proceso lo estaba anteriormente
		cpu_ocupada=SI
	fi

	#ESTADO DE CADA PROCESO
	#Modificamos los valores de los arrays, restando de lo que quede<<<<<<<<<<<<<<<<
	#ESTADO DE CADA PROCESO EN EL TIEMPO ACTUAL Y HALLAMOS LAS VARIABLES. (Las cuentas se realizaran tras imprimir.)
	for (( i=0; i<$nprocesos; i++ )); do
		if [[ ${nollegado[$i]} -eq 1 ]] ; then
			estado[$i]="Fuera del Sistema"
			estad[$i]=0
		fi
		if [[ ${encola[$i]} -eq 1 && ${bloqueados[$i]} -eq 1 && ${temp_wait[$i]} == "-" && ${temp_ret[$i]} == "-" ]] ; then
			temp_wait[$i]=0 #Se inicializan a 0 para poder operar con el número
			temp_ret[$i]=0
			temp_rej[$i]=${ejecucion[$i]}
		fi
		if [[ ${encola[$i]} -eq 1 && ${bloqueados[$i]} -eq 1 ]] ; then
			estado[$i]="En espera"
			estad[$i]=1
		fi
		if [[ ${enmemoria[$i]} -eq 1 && ${temp_wait[$i]} == "-" && ${temp_ret[$i]} == "-" ]] ; then
			temp_wait[$i]=0 #Se inicializan a 0 para poder operar con el número
			temp_ret[$i]=0
			temp_rej[$i]=${ejecucion[$i]}
		fi
		if [[ ${enmemoria[$i]} -eq 1 && ${enejecucion[$i]} -eq 1 ]] ; then
			estado[$i]="En ejecucion"
			estad[$i]=3
			procPorUnidadTiempoBT[$reloj]=$i #Mete el número de orden del proceso que se mantiene en ejecución en la posición reloj de procPorUnidadTiempoBT.
		elif [[ ${enmemoria[$i]} -eq 1 && ${enpausa[$i]} -eq 1 ]] ; then #Caso imposible por ser FCFS
			estado[$i]="En pausa"
			estad[$i]=4
		elif [[ ${enmemoria[$i]} -eq 1 ]] ; then
			estado[$i]="En memoria"
			estad[$i]=2
		fi
		if [[ ${terminados[$i]} -eq 1 ]] ; then
			estado[$i]="Finalizado"
			estad[$i]=5
		fi
	done

	#Ponemos el estado del siguiente que se vaya a ejecutar (si algún proceso ha terminado) "En ejecucion"
	#SUMAR EL SEGUNDO DEL CICLO ANTES DE PONER ESTE ESTADO
	if [[ "$finalprocesos" -eq 0 ]]; then #En caso de que finalprocesos sea 0, se termina con el programa.
		parar_proceso=SI
		evento=1
	fi
	if [[ $reloj -eq 0 || $optejecucion -eq 4 ]]; then #Siempre se imprimie el volcado en T=0. y también cuando se escoja la impresión unidad de tiempo a unidad de tiempo (seleccionMenuModoTiempoEjecucionAlgormitmo = optejecucion = 4).
		evento=1
	fi
	if [[ $optejecucion -eq 5 ]]; then #Si no se quiere hacer ninguna representación intermedia en pantalla pero sí se quiere ver el resultado final y recogerlo en los ficheros de informes.
		evento=0
	fi
} #Fin de gestionProcesosFCFS()

####################################################################################
# Sinopsis: Gestión de procesos - SJF
####################################################################################
function gestionProcesosSJF {
	#ESTADO DE CADA PROCESO EN EL TIEMPO ACTUAL Y HALLAMOS LAS VARIABLES. (Las cuentas se realizarán tras lanzar el volcado.)
	for (( i=0; i<$nprocesos; i++ )); do #Se modifican los valores de los arrays.
		if [[ ${nollegado[$i]} -eq 1 ]] ; then #No ha llegado por tiempo de llegada.
			estado[$i]="Fuera del Sistema"
			estad[$i]=0
		fi
		if [[ ${encola[$i]} -eq 1 && ${temp_wait[$i]} == "-" && ${temp_ret[$i]} == "-" ]] ; then #Se encola pero no ha llegado por tiempo de llegada.
			temp_wait[$i]=0 #Se inicializan a 0 para poder operar con el número
			temp_ret[$i]=0
			temp_rej[$i]=${ejecucion[$i]}
			estado[$i]="En espera"
			estad[$i]=1
		fi
		if [[ ${enmemoria[$i]} -eq 1 && ${temp_wait[$i]} == "-" && ${temp_ret[$i]} == "-" ]] ; then #Se mete en memoria.
			temp_wait[$i]=0 #Se inicializan a 0 para poder operar con el número
			temp_ret[$i]=0
			temp_rej[$i]=${ejecucion[$i]}
		fi
	done

	if [[ $cpu_ocupada == "NO" ]]; then #Se establece el proceso con menor tiempo de ejecución de los que están en memoria.
		if [[ $realizadoAntes -eq 0 ]]; then
			indice_aux=0 #Contendrá un tiempo de ejecución de referencia (el primero encontrado) para su comparación con el de otros procesos.
			temp_aux=0
			for (( i=0; i<$nprocesos; i++ )); do  #Se busca el primer tiempo de ejecución de todos los que se encuentran en memoria.
				if [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1 && ${terminados[$i]} -ne 1 ]]; then
					if [[ ${temp_rej[$i]} -gt $temp_aux ]]; then
						indice_aux=$i #Proceso de ejecución de referencia
						temp_aux=${temp_rej[$i]} #Tiempo de ejecución de referencia
					fi
				fi
			done #Una vez encontrado el primero, se van a comparar todos los procesos hasta encontrar el de tiempo restante de ejcución más pequeño.
			min_indice_aux=-1
			min_temp_aux=$(($temp_aux + 1)) #Contendrá el menor tiempo de ejecución para su comparación con el de otros procesos.
			for (( i=0; i<$nprocesos; i++ )); do  #Se establece qué proceso tiene menor tiempo de ejecución de todos los que se encuentran en memoria.
				if [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  && ${terminados[$i]} -ne 1 ]]; then
					if [[ ${temp_rej[$i]} -lt $min_temp_aux ]]; then
						min_indice_aux=$i #Proceso de ejecución más corta hasta ahora
						min_temp_aux=${temp_rej[$i]} #Tiempo de ejecución menor hasta ahora
					fi
				fi
			done
			if [[ "$min_indice_aux" -ne -1 ]]; then #Una vez encontrado el proceso más corto, se pone en ejecución. Y si había otro en ejecución y no ha terminado, se marca como "En pausa".
				enejecucion[$min_indice_aux]=1 #Marco el proceso para ejecutarse.
				enpausa[$min_indice_aux]=0 #Quitamos el estado pausado si el proceso lo estaba anteriormente.
				cpu_ocupada=SI #La CPU está ocupada por un proceso.
				avisoEntradaCPU[$min_indice_aux]=1 #Se activa el aviso de entrada en CPU del volcado
			fi
		fi
	fi

	if [[ $cpu_ocupada == "SI" ]]; then
		for (( i=0; i<$nprocesos; i++ )); do
			if [[ ${enejecucion[$i]} -eq 1 ]]; then
				ejecutandoinst=$i
			fi
			if [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  && ${enejecucion[$i]} -eq 1 ]] ; then
				estado[$i]="En ejecucion"
				estad[$i]=3
				procPorUnidadTiempoBT[$reloj]=$i #Mete el número de orden del proceso que se mantiene en ejecución en la posición reloj de procPorUnidadTiempoBT.
			elif [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  && ${enpausa[$i]} -eq 1 ]] ; then #Caso imposible por ser SJF
				estado[$i]="En pausa"
				estad[$i]=4
			elif [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  ]] ; then
				estado[$i]="En memoria"
				estad[$i]=2
			fi
			if [[ ${terminados[$i]} -eq 1 ]] ; then
				estado[$i]="Finalizado"
				estad[$i]=5
			fi
		done
		enejecucion[$ejecutandoinst]=1 #Mantengo el proceso en ejecucion
		enpausa[$ejecutandoinst]=0 #Quitamos el estado pausado si el proceso lo estaba anteriormente
		cpu_ocupada=SI
	fi
	#Ponemos el estado del siguiente que se vaya a ejecutar (si algún proceso ha terminado) "En ejecucion"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	#SUMAR EL SEGUNDO DEL CICLO ANTES DE PONER ESTE ESTADO
	if [[ "$finalprocesos" -eq 0 ]]; then #En caso de que finalprocesos sea 0, se termina con el programa.
		parar_proceso=SI
		evento=1
	fi
	if [[ $reloj -eq 0 || $optejecucion -eq 4 ]]; then #Siempre se imprimie el volcado en T=0. y también cuando se escoja la impresión unidad de tiempo a unidad de tiempo (seleccionMenuModoTiempoEjecucionAlgormitmo = optejecucion = 4).
		evento=1
	fi
	if [[ $optejecucion -eq 5 ]]; then #Si no se quiere hacer ninguna representación intermedia en pantalla pero sí se quiere ver el resultado final y recogerlo en los ficheros de informes.
		evento=0
	fi
} #Fin de gestionProcesosSJF()

####################################################################################
# Sinopsis: Gestión de procesos - SRPT
####################################################################################
function gestionProcesosSRPT {
	#ESTADO DE CADA PROCESO EN EL TIEMPO ACTUAL Y HALLAMOS LAS VARIABLES. (Las cuentas se realizarán tras lanzar el volcado.)
	for (( i=0; i<$nprocesos; i++ )); do #Se modifican los valores de los arrays.
		if [[ ${nollegado[$i]} -eq 1 ]] ; then #No ha llegado por tiempo de llegada.
			estado[$i]="Fuera del Sistema"
			estad[$i]=0
		fi
		if [[ ${encola[$i]} -eq 1 && ${temp_wait[$i]} == "-" && ${temp_ret[$i]} == "-" ]] ; then #Se encola pero no ha llegado por tiempo de llegada.
			temp_wait[$i]=0 #Se inicializan a 0 para poder operar con el número
			temp_ret[$i]=0
			temp_rej[$i]=${ejecucion[$i]}
			estado[$i]="En espera"
			estad[$i]=1
		fi
		if [[ ${enmemoria[$i]} -eq 1 && ${temp_wait[$i]} == "-" && ${temp_ret[$i]} == "-" ]] ; then #Se mete en memoria.
			temp_wait[$i]=0 #Se inicializan a 0 para poder operar con el número
			temp_ret[$i]=0
			temp_rej[$i]=${ejecucion[$i]}
		fi
	done

	if [[ $cpu_ocupada == "SI" || $cpu_ocupada == "NO" ]]; then #Se establece el proceso con menor tiempo de ejecución de los que están en memoria.
		if [[ $realizadoAntes -eq 0 ]]; then
			indice_aux=0 #Contendrá un tiempo de ejecución de referencia (el primero encontreado) para su comparación con el de otros procesos.
			temp_aux=0
			for (( i=0; i<$nprocesos; i++ )); do  #Se busca el primer tiempo de ejecución de todos los que se encuentran en memoria.
				if [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1 && ${terminados[$i]} -ne 1 ]]; then
					if [[ ${temp_rej[$i]} -gt $temp_aux ]]; then
						indice_aux=$i #Proceso de ejecución de referencia
						temp_aux=${temp_rej[$i]} #Tiempo de ejecución de referencia
					fi
				fi
			done #Una vez encontrado el primero, se van a comparar todos los procesos hasta encontrar el de tiempo restante de ejcución más pequeño.
			min_indice_aux=-1
			min_temp_aux=$(($temp_aux + 1)) #Contendrá el menor tiempo de ejecución para su comparación con el de otros procesos.
			for (( i=0; i<$nprocesos; i++ )); do  #Se establece qué proceso tiene menor tiempo de ejecución de todos los que se encuentran en memoria.
				if [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  && ${terminados[$i]} -ne 1 ]]; then
					if [[ ${temp_rej[$i]} -lt $min_temp_aux ]]; then
						min_indice_aux=$i #Proceso de ejecución más corta hasta ahora
						min_temp_aux=${temp_rej[$i]} #Tiempo de ejecución menor hasta ahora
					fi
				fi
			done
			if [[ "$min_indice_aux" -ne -1 && $min_indice_aux -ne $anteriorProcesoEjecucion ]]; then #Una vez encontrado el proceso más corto, se pone en ejecución. Y si había otro en ejecución y no ha terminado, se marca como "En pausa".
				enejecucion[$min_indice_aux]=1 #Marco el proceso para ejecutarse.
				enpausa[$min_indice_aux]=0 #Quitamos el estado pausado si el proceso lo estaba anteriormente.
				cpu_ocupada=SI #La CPU está ocupada por un proceso.
				if [[ $anteriorProcesoEjecucion -ne -1 ]]; then #Una vez encontrado el proceso más corto, se pone en ejecución. Y si había otro en ejecución y no ha terminado, se marca como "En pausa".
					enejecucion[$anteriorProcesoEjecucion]=0 #Marcamos el proceso como no ejecutándose si lo estaba anteriormente.
					enpausa[$anteriorProcesoEjecucion]=1 #Ponemos el estado pausado si el proceso estaba anteriormente en ejecución.
					avisoPausa[$anteriorProcesoEjecucion]=1 #Se activa el aviso de entrada en CPU del volcado
				fi
				avisoEntradaCPU[$min_indice_aux]=1 #Se activa el aviso de entrada en CPU del volcado
				anteriorProcesoEjecucion=$min_indice_aux
			fi
		fi
	fi
	if [[ $cpu_ocupada == "SI" ]]; then
		for (( i=0; i<$nprocesos; i++ )); do
			if [[ ${enejecucion[$i]} -eq 1 ]]; then
				ejecutandoinst=$i
			fi
			if [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  && ${enejecucion[$i]} -eq 1 ]] ; then
				estado[$i]="En ejecucion"
				estad[$i]=3
				procPorUnidadTiempoBT[$reloj]=$i #Mete el número de orden del proceso que se mantiene en ejecución en la posición reloj de procPorUnidadTiempoBT.
			elif [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  && ${enpausa[$i]} -eq 1 ]] ; then
				estado[$i]="En pausa"
				estad[$i]=4
			elif [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  ]] ; then
				estado[$i]="En memoria"
				estad[$i]=2
			fi
			if [[ ${terminados[$i]} -eq 1 ]] ; then
				estado[$i]="Finalizado"
				estad[$i]=5
			fi
		done
		enejecucion[$ejecutandoinst]=1 #Mantengo el proceso en ejecucion
		enpausa[$ejecutandoinst]=0 #Quitamos el estado pausado si el proceso lo estaba anteriormente
		cpu_ocupada=SI
	fi

	#Ponemos el estado del siguiente que se vaya a ejecutar (si algún proceso ha terminado) "En ejecucion"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	#SUMAR EL SEGUNDO DEL CICLO ANTES DE PONER ESTE ESTADO
	if [[ "$finalprocesos" -eq 0 ]]; then #En caso de que finalprocesos sea 0, se termina con el programa.
		parar_proceso=SI
		evento=1
	fi
	if [[ $reloj -eq 0 || $optejecucion -eq 4 ]]; then #Siempre se imprimie el volcado en T=0. y también cuando se escoja la impresión unidad de tiempo a unidad de tiempo (seleccionMenuModoTiempoEjecucionAlgormitmo = optejecucion = 4).
		evento=1
	fi
	if [[ $optejecucion -eq 5 ]]; then #Si no se quiere hacer ninguna representación intermedia en pantalla pero sí se quiere ver el resultado final y recogerlo en los ficheros de informes.
		evento=0
	fi
} #Fin de gestionProcesosSRPT()

####################################################################################
# Sinopsis: Gestión de procesos - Prioridades (Mayor/Menor)
####################################################################################
function gestionProcesosPrioridades {
	#ESTADO DE CADA PROCESO EN EL TIEMPO ACTUAL Y HALLAMOS LAS VARIABLES. (Las cuentas se realizarán tras lanzar el volcado.)
	for (( i=0; i<$nprocesos; i++ )); do #Se modifican los valores de los arrays.
		if [[ ${nollegado[$i]} -eq 1 ]] ; then #No ha llegado por tiempo de llegada.
			estado[$i]="Fuera del Sistema"
			estad[$i]=0
		fi
		if [[ ${encola[$i]} -eq 1 && ${temp_wait[$i]} == "-" && ${temp_ret[$i]} == "-" ]] ; then #Se encola pero no ha llegado por tiempo de llegada.
			temp_wait[$i]=0 #Se inicializan a 0 para poder operar con el número
			temp_ret[$i]=0
			temp_rej[$i]=${ejecucion[$i]} #Aunque no entre en memoria ya tiene datos a considerar.
			temp_prio[$i]=${prioProc[$i]} #Aunque no entre en memoria ya tiene datos a considerar.
			estado[$i]="En espera"
			estad[$i]=1
		fi
		if [[ ${enmemoria[$i]} -eq 1 && ${temp_wait[$i]} == "-" && ${temp_ret[$i]} == "-" ]] ; then #Se mete en memoria.
			temp_wait[$i]=0 #Se inicializan a 0 para poder operar con el número
			temp_ret[$i]=0
			temp_rej[$i]=${ejecucion[$i]} #Cuando entre en memoria, si no se había considerado antes en cola, ya tiene datos a considerar.
			temp_prio[$i]=${prioProc[$i]} #Cuando entre en memoria, si no se había considerado antes en cola, ya tiene datos a considerar.
		fi
	done
	if [[ $realizadoAntes -eq 0 ]]; then
		cerrojo_aux=0
		indice_aux=-1 #Variable de cierre
		for (( i=0; i<$nprocesos; i++ )); do  #Se busca la mayor prioridad de todas las que se encuentran en memoria.
			if [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1 && ${terminados[$i]} -ne 1 ]]; then
				if [[ $cerrojo_aux -eq 0 ]]; then #Se inicializan las variables para determinar el mayor valor de la priridad de los procesos en memoria.
					indice_aux=$i #Se inicializa la variable con el primer proceso para la menor prioridad.
					prio_aux=${temp_prio[$i]} #Prioridad de referencia.
					cerrojo_aux=1
				fi
				if [[ ${temp_prio[$i]} -gt $prio_aux && $cerrojo_aux -eq 1 ]]; then
					indice_aux=$i #Proceso con la menor prioridad.
					prio_aux=${temp_prio[$i]} #Prioridad de referencia.
				fi
			fi
		done #Una vez encontrada la mayor prioridad, se van a comparar todos los procesos hasta encontrar el de prioridad más baja.
		max_indice_aux=$indice_aux #Prioridad mayor de los procesos en memoria.
		max_prio_aux=$prio_aux #Proceso con la mayor prioridad.
		min_indice_aux=-1 #Variable de cierre
		min_prio_aux=$(($prio_aux + 1)) #Contendrá la menor prioridad para su comparación con la de otros procesos. Se le pone un valor superior al máximo porque se busca el primero de los que tengan el menor valor.
		for (( i=0; i<$nprocesos; i++ )); do  #Se establece qué proceso tiene menor prioridad de todos los que se encuentran en memoria.
			if [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1 && ${terminados[$i]} -ne 1 ]]; then
				if [[ ${temp_prio[$i]} -lt $min_prio_aux ]]; then
					min_indice_aux=$i #Proceso de prioridad más baja hasta ahora
					min_prio_aux=${temp_prio[$i]} #Prioridad menor hasta ahora
				fi
			fi
		done
	fi
	if [[ $invertirDatoPrioridadesInversa -eq 1 ]]; then #Si es Prioridad Mayor y se invierte el rango, se calcula la Prioridad Menor, y viveversa.
		if [[ $seleccionTipoPrioridad -eq 1 ]]; then #Mayor
			seleccionTipoPrioridad_2=2
		elif [[ $seleccionTipoPrioridad -eq 2 ]]; then #Menor
			seleccionTipoPrioridad_2=1
		fi
	elif [[ $invertirDatoPrioridadesInversa -eq 0 ]]; then #Si el rango de Prioridades no se invierte, se deja sin modificar la elección Mayor/Menor.
		seleccionTipoPrioridad_2=$seleccionTipoPrioridad
	fi
	if [[ $cpu_ocupada == "SI" || $cpu_ocupada == "NO" ]]; then #Se establece el proceso con menor prioridad de los que están en memoria.
		#seleccionTipoPrioridad_2 - 1-Mayor - 2-Menor #seleccionMenuApropiatividad - 1-No apropiativo - 2-Apropiativo
		if [[ $seleccionTipoPrioridad_2 -eq 1 && $seleccionMenuApropiatividad -eq 2 ]]; then #Prioridad Mayor/Apropiativo - Se roba la CPU por ser Apropiativo.
			if [[ $max_indice_aux -ne $anteriorProcesoEjecucion ]]; then #Una vez encontrado el proceso de menor prioridad, se pone en ejecución. Y si había otro en ejecución y no ha terminado, se marca como "En pausa".
				enejecucion[$max_indice_aux]=1 #Marco el proceso para ejecutarse.
				enpausa[$max_indice_aux]=0 #Quitamos el estado pausado si el proceso lo estaba anteriormente.
				avisoPausa[$max_indice_aux]=0 #Se quita el aviso de entrada en pausa para asegurarse que sólo usa el de entrada en CPU
				cpu_ocupada=SI #La CPU está ocupada por un proceso.
				if [[ $anteriorProcesoEjecucion -ne -1 ]]; then #Una vez encontrado el proceso con más baja prioridad, se pone en ejecución. Y si había otro en ejecución y no ha terminado, se marca como "En pausa".
					enejecucion[$anteriorProcesoEjecucion]=0 #Marcamos el proceso como no ejecutándose si lo estaba anteriormente.
					enpausa[$anteriorProcesoEjecucion]=1 #Ponemos el estado pausado si el proceso estaba anteriormente en ejecución.
					avisoPausa[$anteriorProcesoEjecucion]=1 #Se activa el aviso de entrada en CPU del volcado
				fi
				avisoEntradaCPU[$max_indice_aux]=1 #Se activa el aviso de entrada en CPU del volcado
				anteriorProcesoEjecucion=$max_indice_aux
			fi
		elif [[ $seleccionTipoPrioridad_2 -eq 2 && $seleccionMenuApropiatividad -eq 2 ]]; then #Prioridad Menor/Apropiativo - Se roba la CPU por ser Apropiativo.
			if [[ $min_indice_aux -ne $anteriorProcesoEjecucion ]]; then #Una vez encontrado el proceso de menor prioridad, se pone en ejecución. Y si había otro en ejecución y no ha terminado, se marca como "En pausa".
				enejecucion[$min_indice_aux]=1 #Marco el proceso para ejecutarse.
				enpausa[$min_indice_aux]=0 #Quitamos el estado pausado si el proceso lo estaba anteriormente.
				avisoPausa[$min_indice_aux]=0 #Se quita el aviso de entrada en pausa para asegurarse que sólo usa el de entrada en CPU
				cpu_ocupada=SI #La CPU está ocupada por un proceso.
				if [[ $anteriorProcesoEjecucion -ne -1 ]]; then #Si había otro proceso en ejecución con anterioridad se avisa que se pone en pausa.
					enejecucion[$anteriorProcesoEjecucion]=0 #Marcamos el proceso como no ejecutándose si lo estaba anteriormente.
					enpausa[$anteriorProcesoEjecucion]=1 #Ponemos el estado pausado si el proceso estaba anteriormente en ejecución.
					avisoPausa[$anteriorProcesoEjecucion]=1
				fi
				avisoEntradaCPU[$min_indice_aux]=1 #Se activa el aviso de entrada en CPU del volcado
				anteriorProcesoEjecucion=$min_indice_aux
			fi
		fi
	fi

	if [[ $cpu_ocupada == "NO" ]]; then #Se establece el proceso con menor prioridad de los que están en memoria.
		#seleccionTipoPrioridad_2 - 1-Mayor - 2-Menor #seleccionMenuApropiatividad - 1-No apropiativo - 2-Apropiativo
		if [[ $seleccionTipoPrioridad_2 -eq 1 && $seleccionMenuApropiatividad -eq 1 ]]; then #1 Prioridad Mayor/No Apropiativo - No se roba la CPU por ser NO Apropiativo.
			if [[ "$max_indice_aux" -ne -1 ]]; then #Una vez encontrado el proceso más corto, se pone en ejecución. Y si había otro en ejecución y no ha terminado, se marca como "En pausa".
				enejecucion[$max_indice_aux]=1 #Marco el proceso para ejecutarse.
				enpausa[$max_indice_aux]=0 #Quitamos el estado pausado si el proceso lo estaba anteriormente.
				cpu_ocupada=SI #La CPU está ocupada por un proceso.
				avisoEntradaCPU[$max_indice_aux]=1 #Se activa el aviso de entrada en CPU del volcado
			fi
		elif [[ $seleccionTipoPrioridad_2 -eq 2 && $seleccionMenuApropiatividad -eq 1 ]]; then #2 Prioridad Menor/No Apropiativo - No se roba la CPU por ser NO Apropiativo.
			if [[ "$min_indice_aux" -ne -1 ]]; then #Una vez encontrado el proceso más corto, se pone en ejecución. Y si había otro en ejecución y no ha terminado, se marca como "En pausa".
				enejecucion[$min_indice_aux]=1 #Marco el proceso para ejecutarse.
				enpausa[$min_indice_aux]=0 #Quitamos el estado pausado si el proceso lo estaba anteriormente.
				cpu_ocupada=SI #La CPU está ocupada por un proceso.
				avisoEntradaCPU[$min_indice_aux]=1 #Se activa el aviso de entrada en CPU del volcado
			fi
		fi
	fi

	if [[ $cpu_ocupada == "SI" ]]; then #Está separado del anterior if porque la CPU podría estar ocupada por un proceso.
		for (( i=0; i<$nprocesos; i++ )); do
			if [[ ${enejecucion[$i]} -eq 1 ]]; then
				ejecutandoinst=$i
			fi
			if [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  && ${enejecucion[$i]} -eq 1 ]] ; then
				estado[$i]="En ejecucion"
				estad[$i]=3
				procPorUnidadTiempoBT[$reloj]=$i #Mete el número de orden del proceso que se mantiene en ejecución en la posición reloj de procPorUnidadTiempoBT.
			elif [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  && ${enpausa[$i]} -eq 1 ]] ; then
				estado[$i]="En pausa"
				estad[$i]=4
			elif [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  ]] ; then
				estado[$i]="En memoria"
				estad[$i]=2
			fi
			if [[ ${terminados[$i]} -eq 1 && ${terminadosAux[$i]} -ne 1 ]] ; then #Tiene esta doble condición porque una vez que pase a terminado no puede estar en otro estado.
				estado[$i]="Finalizado"
				estad[$i]=5
				procFinalizado=$i #Variable que se usa para controlar la impresión de entrada a dibujaResumenAlgPagFrecUsoRec(). Se modifica en inicializaVectoresVariables(), gestionAlgoritmoPagAlgPagFrecMFU(), gestionProcesosFCFS(), gestionProcesosSJF(), gestionProcesosSRPT() y en inicioNuevo().
			elif [[ ${terminados[$i]} -eq 1 && ${terminadosAux[$i]} -eq 1 ]] ; then
				estado[$i]="Finalizado"
				estad[$i]=5
			fi
		done
	fi
	if [[ $ejecutandoinst -ge 0 ]]; then #Si no hay proceso en ejecución se pone -1, para que pueda ser comparado.
		ResuTiempoProceso[$reloj]=$ejecutandoinst #Resumen - Proceso en ejecución en cada instante de tiempo.
	else
		ResuTiempoProceso[$reloj]=-1
	fi

	#Se pone el estado del siguiente que se vaya a ejecutar (si algún proceso ha terminado) "En ejecucion"
	#SUMAR EL SEGUNDO DEL CICLO ANTES DE PONER ESTE ESTADO
	if [[ "$finalprocesos" -eq 0 ]]; then #En caso de que finalprocesos sea 0, se termina con el programa.
		parar_proceso=SI
		evento=1
	fi
	if [[ $reloj -eq 0 || $optejecucion -eq 4 ]]; then #Siempre se imprimie el volcado en T=0. y también cuando se escoja la impresión unidad de tiempo a unidad de tiempo (seleccionMenuModoTiempoEjecucionAlgormitmo = optejecucion = 4).
		evento=1
	fi
	if [[ $optejecucion -eq 5 ]]; then #Si no se quiere hacer ninguna representación intermedia en pantalla pero sí se quiere ver el resultado final y recogerlo en los ficheros de informes.
		evento=0
	fi
} #Fin de gestionProcesosPrioridades()

####################################################################################
# Sinopsis: Gestión de procesos - Round Robin
####################################################################################
function gestionProcesosRoundRobin {
	#ESTADO DE CADA PROCESO EN EL TIEMPO ACTUAL Y HALLAMOS LAS VARIABLES. (Las cuentas se realizarán tras lanzar el volcado.)
	for (( i=0; i<$nprocesos; i++ )); do #Se modifican los valores de los arrays. Primero se trabaja con los estados y tiempos de las estadísticas.
		if [[ ${nollegado[$i]} -eq 1 ]] ; then #No ha llegado por tiempo de llegada.
			estado[$i]="Fuera del Sistema"
			estad[$i]=0
		fi
		if [[ ${encola[$i]} -eq 1 && ${temp_wait[$i]} == "-" && ${temp_ret[$i]} == "-" ]] ; then #Se cambia encola[] para que sea considerado a la hora de entrar en memoria, pero no ha entrado por falta de espacio.
			temp_wait[$i]=0 #Se inicializan a 0 para poder operar con el número
			temp_ret[$i]=0
			temp_rej[$i]=${ejecucion[$i]} #Aunque no entre en memoria ya tiene datos a considerar.
			estado[$i]="En espera"
			estad[$i]=1
		fi
		if [[ ${enmemoria[$i]} -eq 1 && ${temp_wait[$i]} == "-" && ${temp_ret[$i]} == "-" ]] ; then #Se mete en memoria y las variables pasan a numérico para poder operar.
			temp_wait[$i]=0 #Se inicializan a 0 para poder operar con el número
			temp_ret[$i]=0
			temp_rej[$i]=${ejecucion[$i]} #Cuando entre en memoria, si no se había considerado antes en cola, ya tiene datos a considerar.
		fi
	done
	for (( i=0; i<$nprocesos; i++ )); do #Se modifican los valores de los arrays, pero ahora se trabaja con el proceso que pueda haber terminado.
		if [[ ${colaTiempoRR[$i]} -eq $indiceColaTiempoRREnEjecucion && ${temp_rej[$i]} -eq 0 ]] ; then #Si termina el proceso, su referencias en la cola RR se actualiza a "-", y el contador $contadorTiempoRR a 0.
			colaTiempoRR[$i]=-1 #Si el proceso ha terminado, ya no se mete en cola de RR.
			enejecucion[$i]=0 #Se marca el proceso como no ejecutándose si lo estaba anteriormente.
			indiceColaTiempoRREnEjecucion=$(($indiceColaTiempoRREnEjecucion + 1)) #Índice con el actual ordinal en ejecución para Round-Robin (RR).
			anteriorProcesoEjecucion=$i #Se define el proceso que se ha ejecutado hasta el momento actual.
			contadorTiempoRR=0 #Contador de unidades ejecutadas del quantum de RR. Para que el proceso que se vaya a ejecutar empiece a usar su quantum desde 0.
		fi
	done
	for (( i=0; i<$nprocesos; i++ )); do #Se modifican los valores de los arrays. Y ahora se trabaja con el resto de variables para trabajar sobre los tiempos ya establecidos ya que dependen de ellos en algunos casos.
		if [[ ${colaTiempoRR[$i]} -eq $indiceColaTiempoRREnEjecucion && $contadorTiempoRR -ge $quantum ]] ; then #Si termina el quantum de un proceso, su referencias en la cola RR se actualiza al último valor del $contadorTiempoRR.
			enejecucion[$i]=0 #Se marca el proceso para no ser ejecutado ya que comenzará a ejecutarse otro proceso.
			enpausa[$i]=1 #Se marca el proceso como "en pausa" al haber terminado su quantum.
			contadorAlgPagExpulsionesForzadasProcesoAcumulado[$i]=$((${contadorAlgPagExpulsionesForzadasProcesoAcumulado[$i]} + 1)) #Número de expulsiones forzadas en Round-Robin (RR)
			anteriorProcesoEjecucion=$i
			contadorTiempoRR=0
			colaTiempoRR[$i]=$indiceColaTiempoRRLibre #Se asigna un ordinal de la cola de RR (se encola). Cuando se saca un proceso de la CPU, si no ha terminado, lo primero qeu se hace es encolarlo en la cola de RR, incluso antes de hacerlo con los procesos que acaben de llegar.
			indiceColaTiempoRRLibre=$(($indiceColaTiempoRRLibre + 1)) #Índice con el primer ordinal libre a repartir en Round-Robin (RR).
			indiceColaTiempoRREnEjecucion=$(($indiceColaTiempoRREnEjecucion + 1)) #Índice con el actual ordinal en ejecución para Round-Robin (RR).
			evento=1 #Provoca un volcado en cada final de quantum
			cpu_ocupada=NO #Se marca que la CPU no está ocupada por un proceso.
		fi
	done
	if [[ $cpu_ocupada == "SI" || $cpu_ocupada == "NO" ]]; then #En primer lugar se establece el primer proceso que haya entrado en memoria por tiempo de llegada, o por estricto orden de llegada en memoria.
		if [[ $realizadoAntes -eq 0 ]]; then
			for (( i=0; i<$nprocesos; i++ )); do  #Se busca el primer proceso de entre todos los que se encuentran en memoria.
				if [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1 && ${terminados[$i]} -ne 1 ]]; then
					if [[ ${colaTiempoRR[$i]} -eq -1 && ${temp_rej[$i]} -gt 0 ]] ; then #Si hay nuevos procesos en memoria se les encola.
						colaTiempoRR[$i]=$indiceColaTiempoRRLibre
						indiceColaTiempoRRLibre=$(($indiceColaTiempoRRLibre + 1))
					fi
				fi
			done #Una vez encolados, se determina si se sigue ejecutando el mismo que ya lo estaba en el instante anterior, o se determina cuál se ejecutará en el instante actual, si el proceso anterior o su quantum han terminado.
			for (( i=0; i<$nprocesos; i++ )); do  #Se busca el primer proceso de entre todos los que se encuentran en memoria.
				if [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1 && ${terminados[$i]} -ne 1 ]]; then
					if [[ ${colaTiempoRR[$i]} -eq $indiceColaTiempoRREnEjecucion && $contadorTiempoRR -lt $quantum && ${temp_rej[$i]} -ne 0 ]] ; then #Si es nuevo, empieza a ejecutarse. Si el proceso está marcado como en ejecución, el contador $contadorTiempoRR aumenta en una unidad.
						contadorTiempoRR=$(($contadorTiempoRR + 1))
						enejecucion[$i]=1 #Se marca el proceso para ejecutarse o se refuerza si ya lo estaba.
						enpausa[$i]=0 #Se quita el estado pausado si el proceso lo estaba anteriormente.
						cpu_ocupada=SI #Se marca que la CPU está ocupada por un proceso o se refuerza si ya lo estaba.
						avisoEntradaCPU[$i]=1 #Se activa el aviso de entrada en CPU del volcado
						avisoPausa[$i]=0 #Se inicializa para que no haya avisos de cambio a pausa hasta que no sean necesarios. No hace falta en avisos de entrada a CPU porque, siempre que haya un volcado ha habido entrada del gestor de memoria y procesos antes del volcado.
						if [[ $anteriorProcesoEjecucion -ne -1 ]]; then #Si había otro proceso en ejecución con anterioridad se avisa que se pone en pausa.
							if [[ ${estad[$anteriorProcesoEjecucion]} -ne 4 ]]; then #Si había otro proceso en ejecución con anterioridad se avisa que se pone en pausa.
								avisoPausa[$anteriorProcesoEjecucion]=1
								avisoEntradaCPU[$anteriorProcesoEjecucion]=0 #Se desactiva el aviso de entrada en CPU del volcado
							fi
						fi
					fi
				fi
			done
		fi
	fi
	if [[ $cpu_ocupada == "SI" ]]; then #Está separado del anterior if porque la CPU podría estar ocupada por un proceso.
		for (( i=0; i<$nprocesos; i++ )); do
			if [[ ${enejecucion[$i]} -eq 1 ]]; then
				ejecutandoinst=$i
			fi
			if [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  && ${enejecucion[$i]} -eq 1 ]] ; then
				estado[$i]="En ejecucion"
				estad[$i]=3
				procPorUnidadTiempoBT[$reloj]=$i #Mete el número de orden del proceso que se mantiene en ejecución en la posición reloj de procPorUnidadTiempoBT.
			elif [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  && ${enpausa[$i]} -eq 1 ]] ; then
				estado[$i]="En pausa"
				estad[$i]=4
			elif [[ ${enmemoria[$i]} -eq 1 && ${escrito[$i]} -eq 1  ]] ; then
				estado[$i]="En memoria"
				estad[$i]=2
			fi
			if [[ ${terminados[$i]} -eq 1 && ${terminadosAux[$i]} -ne 1 ]] ; then #Tiene esta doble condición porque una vez que pase a terminado no puede estar en otro estado.
				estado[$i]="Finalizado"
				estad[$i]=5
				procFinalizado=$i #Variable que se usa para controlar la impresión de entrada a dibujaResumenAlgPagFrecUsoRec(). Se modifica en inicializaVectoresVariables(), gestionAlgoritmoPagAlgPagFrecMFU(), gestionProcesosFCFS(), gestionProcesosSJF(), gestionProcesosSRPT() y en inicioNuevo().
			elif [[ ${terminados[$i]} -eq 1 && ${terminadosAux[$i]} -eq 1 ]] ; then
				estado[$i]="Finalizado"
				estad[$i]=5
			fi
		done
	fi
	if [[ $ejecutandoinst -ge 0 ]]; then #Si no hay proceso en ejecución se pone -1, para que pueda ser comparado.
		ResuTiempoProceso[$reloj]=$ejecutandoinst #Resumen - Proceso en ejecución en cada instante de tiempo.
	else
		ResuTiempoProceso[$reloj]=-1
	fi

	#Se pone el estado del siguiente que se vaya a ejecutar (si algún proceso ha terminado) "En ejecucion"
	#SUMAR EL SEGUNDO DEL CICLO ANTES DE PONER ESTE ESTADO
	if [[ "$finalprocesos" -eq 0 ]]; then #En caso de que finalprocesos sea 0, se termina con el programa.
		parar_proceso=SI
		evento=1
	fi
	if [[ $reloj -eq 0 || $optejecucion -eq 4 ]]; then #Siempre se imprimie el volcado en T=0. y también cuando se escoja la impresión unidad de tiempo a unidad de tiempo (seleccionMenuModoTiempoEjecucionAlgormitmo = optejecucion = 4).
		evento=1
	fi
	if [[ $optejecucion -eq 5 ]]; then #Si no se quiere hacer ninguna representación intermedia en pantalla pero sí se quiere ver el resultado final y recogerlo en los ficheros de informes.
		evento=0
	fi
} #Fin de gestionProcesosRoundRobin()

#######################################################################
# Sinopsis: Impresión pantalla tras la solicitud de datos/introducción desde fichero
#######################################################################
function imprimirDatosPantalla {
	if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 4 ]]; then
		echo -e "$azul Los datos introducidos al sistema son:$NC" | tee -a $informeConColorTotal #...color
		echo -e "┌───────────────┬───────────────┬───────────────┬───────────────┬───────────────┐" | tee -a $informeConColorTotal
		echo -e "│    Proceso$NC    │  T.Llegada$NC    │  T.Ejecución$NC  │    Tamaño$NC     │   Prioridad$NC   │" | tee -a $informeConColorTotal
		echo -e "└───────────────┴───────────────┴───────────────┴───────────────┴───────────────┘" | tee -a $informeConColorTotal
		for (( i=0; i<$nprocesos; i++)); do
			echo -e "${coloress[$i % 6]} \t${proceso[$i]}\t \t${llegada[$i]}\t \t${temp_rej[$i]}\t \t${memoria[$i]}\t \t${prioProc[$i]}\t  $NC" | tee -a $informeConColorTotal
		done
		echo -e "\n\nMemoria total: $mem_libre uds." | tee -a $informeConColorTotal
		echo "Tamaño a partir del cual se reubica: $variableReubicar uds." | tee -a $informeConColorTotal
		echo "---------------------------------------------" | tee -a $informeConColorTotal

		echo -e "Los datos introducidos al sistema son:" >> $informeSinColorTotal #...b/n
		echo -e "┌───────────────┬───────────────┬───────────────┬───────────────┬───────────────┐" >> $informeSinColorTotal
		echo -e "│    Proceso    │  T.Llegada    │  T.Ejecución  │    Tamaño     │   Prioridad   │" >> $informeSinColorTotal
		echo -e "└───────────────┴───────────────┴───────────────┬───────────────┴───────────────┘" >> $informeSinColorTotal
		for (( i=0; i<$nprocesos; i++)); do
			echo -e " \t${proceso[$i]}\t \t${llegada[$i]}\t \t${temp_rej[$i]}\t \t${memoria[$i]}\t \t${prioProc[$i]}\t  " >> $informeSinColorTotal
		done
		echo -e "\n\nMemoria total: $mem_libre uds." >> $informeSinColorTotal
		echo -e "Tamaño a partir del cual se reubica: $variableReubicar uds." >> $informeSinColorTotal
		echo -e  "---------------------------------------------" >> $informeSinColorTotal
		echo -e "\n$NC Pulse enter para continuar..." | tee -a $informeConColorTotal
		echo -e "\nPulse enter para continuar..." >> $informeSinColorTotal
		read enter
		echo -e $enter "\n" >> $informeConColorTotal
		echo -e $enter "\n" >> $informeSinColorTotal
	else
		echo -e "$azul Los datos introducidos al sistema son:$NC" | tee -a $informeConColorTotal #...color
		echo -e "┌───────────────┬───────────────┬───────────────┬───────────────┐" | tee -a $informeConColorTotal
		echo -e "│    Proceso$NC    │  T.Llegada$NC    │  T.Ejecución$NC  │    Tamaño$NC     │" | tee -a $informeConColorTotal
		echo -e "└───────────────┴───────────────┴───────────────┴───────────────┘" | tee -a $informeConColorTotal
		for (( i=0; i<$nprocesos; i++)); do
			echo -e "${coloress[$i % 6]} \t${proceso[$i]}\t \t${llegada[$i]}\t \t${temp_rej[$i]}\t \t${memoria[$i]}\t  $NC" | tee -a $informeConColorTotal
		done
		echo -e "\n\nMemoria total: $mem_libre uds." | tee -a $informeConColorTotal
		echo "Tamaño a partir del cual se reubica: $variableReubicar uds." | tee -a $informeConColorTotal
		echo "---------------------------------------------" | tee -a $informeConColorTotal

		echo -e "Los datos introducidos al sistema son:" >> $informeSinColorTotal #...b/n
		echo -e "┌───────────────┬───────────────┬───────────────┬───────────────┐" >> $informeSinColorTotal
		echo -e "│    Proceso    │  T.Llegada    │  T.Ejecución  │    Tamaño     │" >> $informeSinColorTotal
		echo -e "└───────────────┴───────────────┴───────────────┬───────────────┘" >> $informeSinColorTotal
		for (( i=0; i<$nprocesos; i++)); do
			echo -e " \t${proceso[$i]}\t \t${llegada[$i]}\t \t${temp_rej[$i]}\t \t${memoria[$i]}\t  " >> $informeSinColorTotal
		done
		echo -e "\n\nMemoria total: $mem_libre uds." >> $informeSinColorTotal
		echo -e "Tamaño a partir del cual se reubica: $variableReubicar uds." >> $informeSinColorTotal
		echo -e  "---------------------------------------------" >> $informeSinColorTotal
		echo -e "\n$NC Pulse enter para continuar..." | tee -a $informeConColorTotal
		echo -e "\nPulse enter para continuar..." >> $informeSinColorTotal
		read enter
		echo -e $enter "\n" >> $informeConColorTotal
		echo -e $enter "\n" >> $informeSinColorTotal
	fi
#	clear
} #Fin de imprimirDatosPantalla()

####################################################################################
# Sinopsis: Permite introducir las opciones generales de la memoria por teclado
####################################################################################
function entradaMemoriaTeclado {
	#Pedir el tamaño de memoria del sistema
	echo -ne "\n$cian Introduzca el tamaño de la memoria del sistema:  $NC" | tee -a $informeConColorTotal
	echo -ne "\n Introduzca el tamaño de la memoria del sistema:"  >> $informeSinColorTotal
	read mem
	echo $mem >> $informeConColorTotal
	echo $mem >> $informeSinColorTotal
	until [[ $mem -gt 0 ]] ; do
		echo -e "$rojo Entrada no válida, el tamaño de memoria no puede ser menor o igual a 0.$NC" | tee -a $informeConColorTotal
		echo -ne " Introduzca un$verde tamaño de memoria correcto:  $NC" | tee -a $informeConColorTotal
		echo -e " Entrada no válida, el tamaño de memoria no puede ser menor o igual a 0." >> $informeSinColorTotal
		echo -e " Introduzca un tamaño de memoria correcto:  " >> $informeSinColorTotal
		read mem
		echo $mem >> $informeConColorTotal
		echo $mem >> $informeSinColorTotal
	done
	while ! es_entero $mem ; do
		echo -e "$rojo Entrada no válida, el tamaño de memoria no puede ser menor o igual a 0.$NC" | tee -a $informeConColorTotal
		echo -ne " Introduzca un$verde tamaño de memoria correcto:  $NC" | tee -a $informeConColorTotal
		echo -e " Entrada no válida, el tamaño de memoria no puede ser menor o igual a 0." >> $informeSinColorTotal
		echo -e " Introduzca un tamaño de memoria correcto:  " >> $informeSinColorTotal
		read mem
		echo $mem >> $informeConColorTotal
		echo $mem >> $informeSinColorTotal
	done
	mem_total=$mem
	#Pedir el tamaño de la variable de reubicación $reubicabilidadNo0Si1
	reub=0 #Se inicializa para que no se considere la reubicabilidad si no está definida en la elección inicial.
	echo -ne "\n$cian Introduzca el tamaño máximo de memoria para que haya reubicacion:  $NC" | tee -a $informeConColorTotal
	echo -ne "\n Introduzca el tamaño máximo de memoria para que haya reubicacion:"  >> $informeSinColorTotal
	read reub
	echo $reub >> $informeConColorTotal
	echo $reub >> $informeSinColorTotal
	until [[ $reub -gt 0 && $reub -lt $mem ]] ; do
		echo -e "$rojo Entrada no válida, el tamaño mínimo de reubicación no puede ser 0.$NC" | tee -a $informeConColorTotal
		echo -ne " Introduzca un$verde tamaño correcto:  $NC" | tee -a $informeConColorTotal
		echo -e " Entrada no válida, el tamaño mínimo de reubicación no puede ser 0." >> $informeSinColorTotal
		echo -e " Introduzca un tamaño correcto:  " >> $informeSinColorTotal
		read reub
		echo $reub >> $informeConColorTotal
		echo $reub >> $informeSinColorTotal
	done

	while ! es_entero $reub ; do
		echo -e "$rojo Entrada no válida, el tamaño mínimo de reubicación no puede ser negativo.$NC" | tee -a $informeConColorTotal
		echo -ne " Introduzca un$verde tamaño correcto:  $NC" | tee -a $informeConColorTotal
		echo -e " Entrada no válida, el tamaño mínimo de reubicación no puede ser negativo." >> $informeSinColorTotal
		echo -e " Introduzca un tamaño correcto:  " >> $informeSinColorTotal
		read reub
		echo $reub >> $informeConColorTotal
		echo $reub >> $informeSinColorTotal
	done
	variableReubicar=$reub
	#Pedir el valor del mínimo y máximo del rango de Prioridad y el tipo de Prioridad (Mayor, Menor). Se inicializan a 0 y 100 en caso de usarse Prioridades.
	PriomInicial=0
	PrioMInicial=100
	PrioR="Mayor"
	echo -ne "\n$cian Introduzca el valor mínimo del rango de prioridades:  $NC" | tee -a $informeConColorTotal
	echo -ne "\n Introduzca el valor mínimo del rango de prioridades:"  >> $informeSinColorTotal
	read PriomInicial
	echo $PriomInicial >> $informeConColorTotal
	echo $PriomInicial >> $informeSinColorTotal
	echo -ne "\n$cian Introduzca el valor máximo del rango de prioridades:  $NC" | tee -a $informeConColorTotal
	echo -ne "\n Introduzca el valor máximo del rango de prioridades:"  >> $informeSinColorTotal
	read PrioMInicial
	echo $PrioMInicial >> $informeConColorTotal
	echo $PrioMInicial >> $informeSinColorTotal
	tratarRangoPrioridadesDirecta $PriomInicial $PrioMInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	if [[ $seleccionTipoPrioridad -eq "1" ]]; then
		PrioR="Mayor"
	elif [[ $seleccionTipoPrioridad -eq "2" ]]; then
		PrioR="Menor"
	fi
	#Pedir el valor del Quantum para Round-Robin. Se inicializa a 1 en caso de usarse RR.
	quantum=1
	echo -ne "\n$cian Introduzca el valor del Quantum de tiempo:  $NC" | tee -a $informeConColorTotal
	echo -ne "\n Introduzca el valor mínimo del Quantum de tiempo:"  >> $informeSinColorTotal
	read quantum
	echo $quantum >> $informeConColorTotal
	echo $quantum >> $informeSinColorTotal
	until [[ $quantum -gt 0 ]] ; do
		echo -e "$rojo Entrada no válida, el valor del Quantum de tiempo no puede ser menor o igual a 0.$NC" | tee -a $informeConColorTotal
		echo -ne " Introduzca un$verde tamaño correcto:  $NC" | tee -a $informeConColorTotal
		echo -e " Entrada no válida, el valor del Quantum de tiempo no puede ser menor o igual a 0." >> $informeSinColorTotal
		echo -e " Introduzca un tamaño correcto:  " >> $informeSinColorTotal
		read quantum
		echo $quantum >> $informeConColorTotal
		echo $quantum >> $informeSinColorTotal
	done
	# Salida de datos introducidos, para que el usuario pueda ver lo que esta introducciendo, y volcado de los mismos en ficheros auxiliares
	echo "MemoriaTotal $mem ">$nomFicheroDatos #Los datos de las particiones se meten en otro fichero escogido
	echo "VariableReubicar $reub ">>$nomFicheroDatos #Los datos de las particiones se meten en otro fichero escogido
	echo "RangoPrioridad $PriomInicial $PrioMInicial ">>$nomFicheroDatos #Los datos del mínimo y máximo del rango de Prioridades se meten en otro fichero escogido
	echo "TipoPrioridad $PrioR ">>$nomFicheroDatos #El tipo de Prioridad definido se mete en otro fichero escogido
	echo "Quantum $quantum ">>$nomFicheroDatos #El valor del Quantum de tiempo definido se mete en otro fichero escogido
#	clear
} #Fin de entradaMemoriaTeclado()

####################################################################################
# Sinopsis: Permite introducir los procesos por teclado.
####################################################################################
function entradaProcesosTeclado {
	p=0
	masprocesos="s"
	while [[ $masprocesos == "s" ]]; do
#	    clear
		echo -e $NORMAL"\n\n Ref Tll Tej Mem"$NORMAL | tee -a $informeConColorTotal
		echo -e "\n\n Ref Tll Tej Mem" >> $informeSinColorTotal
		for ((j = 0; j < $p; j++)); do
			echo -ne $NORMAL" ${coloress[$j % 6]}${proceso[$j]}"$NORMAL | tee -a $informeConColorTotal
			longitudLlegada=$(($longCampoTablaAncho - ${#llegada[$j]}))
			echo -ne $NORMAL"${varhuecos:1:$longitudLlegada}""${coloress[$j % 6]}${llegada[$j]}"$NORMAL | tee -a $informeConColorTotal
			longitudTiempo=$(($longCampoTablaAncho - ${#ejecucion[$j]}))
			echo -ne $NORMAL"${varhuecos:1:$longitudTiempo}""${coloress[$j % 6]}${ejecucion[$j]}"$NORMAL | tee -a $informeConColorTotal
			longitudMemoria=$(($longCampoTablaAncho - ${#memoria[$j]}))
			echo -e $NORMAL"${varhuecos:1:$longitudMemoria}""${coloress[$j % 6]}${memoria[$j]}"$NORMAL | tee -a $informeConColorTotal
			echo -ne " ${proceso[$j]}" >> $informeSinColorTotal
			echo -ne "${varhuecos:1:$longitudLlegada}""${llegada[$j]}" >> $informeSinColorTotal
			echo -ne "${varhuecos:1:$longitudTiempo}""${ejecucion[$j]}" >> $informeSinColorTotal
			echo -e "${varhuecos:1:$longitudMemoria}""${memoria[$j]}" >> $informeSinColorTotal
		done

		# Bloque para introducción del resto de datos del proceso
		echo -e $NORMAL"\nTiempo de llegada del proceso $p: "$NORMAL | tee -a $informeConColorTotal
		echo -e "\nTiempo de llegada del proceso $p: " >> $informeSinColorTotal
		read llegada[$p]
		until [ ${llegada[$p]} -ge 0 ]; do
			echo -e $NORMAL"No se pueden introducir tiempos de llegada negativos"$NORMAL | tee -a $informeConColorTotal
			echo -e "No se pueden introducir tiempos de llegada negativos" >>$informeSinColorTotal
			echo -e $NORMAL"Introduce un nuevo tiempo de llegada\n"$NORMAL | tee -a $informeConColorTotal
			echo -e "Introduce un nuevo tiempo de llegada\n" >> $informeSinColorTotal
			read llegada[$p]
		done

		echo -e $NORMAL"\nTiempo de ejecución del proceso $p: "$NORMAL | tee -a $informeConColorTotal
		echo -e "\nTiempo de ejecución del proceso $p: " >>$informeSinColorTotal
		read ejecucion[$p]
		until [ ${ejecucion[$p]} -ge 0 ]; do
			echo -e $NORMAL"No se pueden introducir tiempos de ejecución negativos"$NORMAL | tee -a $informeConColorTotal
			echo -e "No se pueden introducir tiempos de ejecución negativos" >>$informeSinColorTotal
			echo -e $NORMAL"Introduce un nuevo tiempo de ejecución\n"$NORMAL | tee -a $informeConColorTotal
			echo -e "Introduce un nuevo tiempo de ejecución\n" >>$informeSinColorTotal
			read ejecucion[$p]
			echo -e $NORMAL" Ref Tll Tej Mem"$NORMAL >>$informeConColorTotal
			echo -e " Ref Tll Tej Mem" >>$informeSinColorTotal
			echo -e ""$NORMAL
		done

		echo -e $NORMAL"\nUnidades de memoria para el proceso $p: "$NORMAL | tee -a $informeConColorTotal
		echo -e "\nUnidades de memoria para el proceso $p: " >>$informeSinColorTotal
		read memoria[$p]
		while [[ ${memoria[$p]} -le 0 || ${memoria[$p]} -gt $mem ]]; do
			echo -e $NORMAL"No se pueden introducir memoria negativa o superior a la partición máxima"$NORMAL | tee -a $informeConColorTotal
			echo -e "No se pueden introducir memoria negativa o superior a la partición máxima" >>$informeSinColorTotal
			echo -e $NORMAL"Introduce un nuevo tamaño de memoria\n"$NORMAL | tee -a $informeConColorTotal
			echo -e "Introduce un nuevo tamaño de memoria\n" >>$informeSinColorTotal
			read memoria[$p]
		done

		if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 4 ]]; then #Prioridad Mayor/Menor
			echo -e $NORMAL"\nPrioridad para el proceso $p: " | tee -a $informeConColorTotal
			echo -e "\nPrioridad para el proceso $p: " >>$informeSinColorTotal
			read prioProc[$p]
			while [[ ${prioProc[$p]} -lt $PriomInicial || ${prioProc[$p]} -gt $PrioMInicial ]]; do
				echo -e $NORMAL"No se pueden introducir una prioridad fuera del rango definido."$NORMAL | tee -a $informeConColorTotal
				echo -e "No se pueden introducir una prioridad fuera del rango definido." >>$informeSinColorTotal
				echo -e $NORMAL"Introduce una nueva prioridad del proceso\n"$NORMAL | tee -a $informeConColorTotal
				echo -e "Introduce una nueva prioridad del proceso\n" >>$informeSinColorTotal
				read prioProc[$p]
			done
		else
			prioProc[$p]=$((RANDOM % ($PrioMInicial - $PriomInicial + 1) + $PriomInicial)) #Si no se definen los valores de las prioridades por no estar ejecutando ese algoritmo, se crean unos valores de forma aleatoria entre 0 y 100 para poder ser usados en caso de utilizar ese fichero de datos para otro algoritmo.
		fi

		#Salida de datos introducidos sobre procesos para que el usuario pueda ver lo que esta introducciendo y volcado de los mismos en ficheros auxiliares
		echo "Llegada ${llegada[$p]} Ejecucion ${ejecucion[$p]} Memoria ${memoria[$p]} Prioridad ${prioProc[$p]} ">>$nomFicheroDatos #Se meten los datos de las particiones en otro fichero escogido
#	    clear

		ordenarDatosEntradaFicheros
		entradaProcesosTecladoDatosPantalla #Función para mostrar los datos
		echo -e "\n" | tee -a $informeConColorTotal $informeSinColorTotal
		echo -ne $NORMAL"\n¿Quieres más procesos? s/n " | tee -a $informeConColorTotal
		echo -ne "\n¿Quieres más procesos? s/n " >>$informeSinColorTotal
		read masprocesos
		echo -e "$masprocesos" >>$informeConColorTotal
		echo -e "$masprocesos" >>$informeSinColorTotal
		until [[ $masprocesos == "s" || $masprocesos == "n" ]]; do
			echo -ne "\nEscribe 's' o 'n', por favor: " | tee -a $informeConColorTotal
			echo -ne "\nEscribe 's' o 'n', por favor: " >>$informeSinColorTotal
			read masprocesos
			echo -e "$masprocesos" >>$informeConColorTotal
			echo -e "$masprocesos" >>$informeSinColorTotal
		done
		p=$(expr $p + 1) #incremento el contador
	done
	if [[ $preguntaDondeGuardarDatosManuales -eq 1 ]]; then #Se guardan los datos introducidos en el fichero de última ejecución
		cp $ficheroDatosDefault $ficheroDatosAnteriorEjecucion
	else
		cp $nomFicheroDatos $ficheroDatosAnteriorEjecucion
	fi
} #Fin de entradaProcesosTeclado()

####################################################################################
# Sinopsis: Permite visualizar los datos de las particiones/procesos introducidos por teclado.
####################################################################################
function entradaProcesosTecladoDatosPantalla {
		if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 4 ]]; then #Prioridad Mayor/Menor
			echo $NORMAL" Ref Tll Tej Mem Prio"  | tee -a $informeConColorTotal
			echo " Ref Tll Tej Mem Prio" >>$informeSinColorTotal
		else
			echo $NORMAL" Ref Tll Tej Mem"  | tee -a $informeConColorTotal
			echo " Ref Tll Tej Mem" >>$informeSinColorTotal
		fi
	for ((t = 0; t < ${#llegada[@]}; t++)); do
		echo -ne " ${coloress[$t % 6]}${proceso[$t]}" | tee -a $informeConColorTotal
		echo -ne " ${proceso[$t]}" >>$informeSinColorTotal
		longitudLlegada=$(($longCampoTablaAncho - ${#llegada[$t]}))
		echo -ne "${varhuecos:1:$longitudLlegada}""${coloress[$t % 6]}${llegada[$t]}" | tee -a $informeConColorTotal
		echo -ne "${varhuecos:1:$longitudLlegada}""${llegada[$t]}" >>$informeSinColorTotal
		longitudTiempo=$(($longCampoTablaAncho - ${#ejecucion[$t]}))
		echo -ne "${varhuecos:1:$longitudTiempo}""${coloress[$t % 6]}${ejecucion[$t]}" | tee -a $informeConColorTotal
		echo -ne "${varhuecos:1:$longitudTiempo}""${ejecucion[$t]}" >>$informeSinColorTotal
		longitudMemoria=$(($longCampoTablaAncho - ${#memoria[$t]}))
		echo -ne "${varhuecos:1:$longitudMemoria}""${coloress[$t % 6]}${memoria[$t]}" | tee -a $informeConColorTotal
		echo -ne "${varhuecos:1:$longitudMemoria}""${memoria[$t]}" >>$informeSinColorTotal
		if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 4 ]]; then #Prioridad Mayor/Menor
			longitudPrio=$(($longCampoTablaMasAncho - ${#prioProc[$t]}))
			echo -ne "${varhuecos:1:$longitudPrio}""${coloress[$t % 6]}${prioProc[$t]}" | tee -a $informeConColorTotal
			echo -ne "${varhuecos:1:$longitudPrio}""${prioProc[$t]}" >>$informeSinColorTotal
		fi
		echo -e "" | tee -a $informeConColorTotal $informeSinColorTotal #Salto de línea para ajustar las líneas de la tabla de procesos. No se hace en los echos de los datos para ajustar la posible existencia de las prioridades.
	done
} #Fin de entradaProcesosTecladoDatosPantalla()

#####################################################################################
# Sinopsis: Permite ordenar los datos sacados desde fichero y de entrada por teclado.
####################################################################################
function ordenarDatosEntradaFicheros {
	for ((j = 0; j < ${#llegada[@]}; j++)); do
		numeroproceso[$j]=$j #Se guarda su número de orden de introducción o lectura en un vector para la función que lo ordena
	done
	for ((j = 0; j < ${#llegada[@]}; j++)); do
		if [[ $j -ge 9 ]]; then
			proceso[$j]=$(echo P$(($j + 1)))
		else
			proceso[$j]=$(echo P0$(($j + 1)))
		fi
	done
	for (( j = $((${#llegada[@]} - 1)); j >= 0; j-- )); do
		for (( i = 0; i < $j; i++ )); do
			if [[ $((llegada[$i])) -gt $((llegada[$(($i + 1))])) ]]; then
				aux=${proceso[$(($i + 1))]}
				proceso[$(($i + 1))]=${proceso[$i]}
				proceso[$i]=$aux
				aux=${llegada[$(($i + 1))]}
				llegada[$(($i + 1))]=${llegada[$i]}
				llegada[$i]=$aux
				aux=${ejecucion[$(($i + 1))]}
				ejecucion[$(($i + 1))]=${ejecucion[$i]}
				ejecucion[$i]=$aux
				aux=${memoria[$(($i + 1))]}
				memoria[$(($i + 1))]=${memoria[$i]}
				memoria[$i]=$aux
				aux=${prioProc[$(($i + 1))]}
				prioProc[$(($i + 1))]=${prioProc[$i]}
				prioProc[$i]=$aux
				aux=${numeroproceso[$(($i + 1))]}
				numeroproceso[$(($i + 1))]=${numeroproceso[$i]}
				numeroproceso[$i]=$aux
			fi
		done
	done
} #Fin de ordenarDatosEntradaFicheros()

####################################################################################
# Sinopsis: Pregunta en qué fichero guardar los rangos para la opción 8.
####################################################################################
function entradaMemoriaRangosFichero_op_cuatro_Previo {
#	clear
	preguntaDondeGuardarRangosManuales #Resuelve los nombres de los ficheros de rangos
	preguntaDondeGuardarDatosManuales #Resuelve los nombres de los ficheros de datos
} #Fin de entradaMemoriaRangosFichero_op_cuatro_Previo()

####################################################################################
# Sinopsis: Se piden y tratan los mínimos y máximos de los rangos, calculando los valores aleatorios y los datos
# con los que se trabajará para la opción 4.
####################################################################################
function entradaMemoriaRangosFichero_op_cuatro {
	#---Llamada a funciones para rangos-------------
	datos_tamano_memoria #Se asigna la memoria aleatoriamente
	calcDatoAleatorioGeneral $MIN_RANGE_MEM $MAX_RANGE_MEM
	mem_total=$datoAleatorioGeneral
	mem=$mem_total #para compatibilidad
	datos_tamano_reubicacion #Se asigna la reubicaciónaleatoriamente
	calcDatoAleatorioGeneral $MIN_RANGE_REUB $MAX_RANGE_REUB
	reub=$datoAleatorioGeneral
	#------------------------------------------------------
	datos_prio_menor #Se asigna el mínimo del rango de prioridad aleatoriamente
	MIN_RANGE_prio_menorInicial=${prio_menor_min}
	MAX_RANGE_prio_menorInicial=${prio_menor_max}
	tratarRangoPrioridadesDirecta $MIN_RANGE_prio_menorInicial $MAX_RANGE_prio_menorInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	MIN_RANGE_prio_menor=$PriomFinal
	MAX_RANGE_prio_menor=$PrioMFinal
	calcDatoAleatorioGeneral $MIN_RANGE_prio_menor $MAX_RANGE_prio_menor
	prio_menorInicial=$datoAleatorioGeneral #*Inicial - Datos a representar
	datos_prio_mayor #Se asigna el máximo del rango de prioridad aleatoriamente
	MIN_RANGE_prio_mayorInicial=${prio_mayor_min}
	MAX_RANGE_prio_mayorInicial=${prio_mayor_max}
	tratarRangoPrioridadesDirecta $MIN_RANGE_prio_mayorInicial $MAX_RANGE_prio_mayorInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	MIN_RANGE_prio_mayor=$PriomFinal
	MAX_RANGE_prio_mayor=$PrioMFinal
	calcDatoAleatorioGeneral $MIN_RANGE_prio_mayor $MAX_RANGE_prio_mayor
	prio_mayorInicial=$datoAleatorioGeneral #*Inicial - Datos a representar
	prio_menor_min=$prio_menor_minInicial
	prio_menor_max=$prio_menor_maxInicial
	tratarRangoPrioridadesDirecta $prio_menorInicial $prio_mayorInicial #Se invierten los valores si el mayor es menor que el mayor.
	prio_menor=$PriomFinal
	prio_mayor=$PrioMFinal

	PriomInicial=$prio_menorInicial
	PrioMInicial=$prio_mayorInicial
	if [[ $seleccionTipoPrioridad -eq "1" ]]; then
		PrioR="Mayor"
	elif [[ $seleccionTipoPrioridad -eq "2" ]]; then
		PrioR="Menor"
	fi
	#------------------------------------------------------
	datos_quantum
	calcDatoAleatorioGeneral $MIN_RANGE_quantum $MAX_RANGE_quantum
	quantum=$datoAleatorioGeneral
	datos_numero_programas #Se asigna el número de procesos aleatoriamente
	calcDatoAleatorioGeneral $MIN_RANGE_NPROC $MAX_RANGE_NPROC
	n_prog=$datoAleatorioGeneral
	#------------------------------------------------------
	datos_tiempo_llegada #Se asigna el resto de datos de los procesos aleatoriamente
	datos_tiempo_ejecucion
	datos_tamano_procesos
	datos_prio_proc

	datos_memoria_tabla #Resumen final de la tabla de datos con los datos obtenidos tras introducir los rangos manualmente

#	clear
	cont_proc=0
	until [[ $cont_proc -eq $n_prog ]]; do
		entradaMemoriaRangosFichero_op_cuatro_cinco_seis_Comun #Se calculan los valores aleatorios y los datos con los que se trabajará para las opciones 4, 5 y 6.
		entradaMemoriaRangosFichero_op_cuatro_Post_1 #Guarda los datos en los ficheros que correspondan
#		clear
		p=`expr $p + 1` #Se incrementa el contador
		((cont_proc++))
	done #cierre del do del while $pro=="S"
	entradaMemoriaRangosFichero_op_cuatro_Post_2 #Copia los ficheros Default/Último
} #Fin de entradaMemoriaRangosFichero_op_cuatro()

####################################################################################
# Sinopsis: Se guardarán los datos en los ficheros que corresponda para la opción 4
####################################################################################
function entradaMemoriaRangosFichero_op_cuatro_Post_1 {
	if [[ $p -eq 1 ]]; then #Para imprimir los rangos en el fichero dependiendo si es el fichero anterior o otro
		echo -e "RangoMemoria $MIN_RANGE_MEM $MAX_RANGE_MEM " > $nomFicheroRangos
		echo -e "RangoReubicar $MIN_RANGE_REUB $MAX_RANGE_REUB " >> $nomFicheroRangos
		echo -e "RangoPrioMenor $MIN_RANGE_prio_menor $MAX_RANGE_prio_menor " >> $nomFicheroRangos
		echo -e "RangoPrioMayor $MIN_RANGE_prio_mayor $MAX_RANGE_prio_mayor " >> $nomFicheroRangos
		echo -e "RangoNumProc $MIN_RANGE_NPROC $MAX_RANGE_NPROC " >> $nomFicheroRangos
		echo -e "RangoLlegada $MIN_RANGE_llegada $MAX_RANGE_llegada " >> $nomFicheroRangos
		echo -e "RangoTEjecucion $MIN_RANGE_tiempo_ejec $MAX_RANGE_tiempo_ejec " >> $nomFicheroRangos
		echo -e "RangoPrioProc $prio_menorInicial $prio_mayorInicial " >> $nomFicheroRangos #Realmente no se usan porque calcula las prioridades desde el rango para el mínimo y el rango para el máximo.
		echo -e "RangoTamano $MIN_RANGE_tamano_proc $MAX_RANGE_tamano_proc " >> $nomFicheroRangos
		echo -ne "RangoQuantum $MIN_RANGE_quantum $MAX_RANGE_quantum " >> $nomFicheroRangos
	fi #Cierre if $p -eq 1
	if [[ $p -eq 1 ]]; then #Escribe los datos en el fichero selecionado
		echo "MemoriaTotal $mem ">$nomFicheroDatos #Los datos de las particiones se meten en otro fichero escogido
		echo "VariableReubicar $reub ">>$nomFicheroDatos #Los datos de las particiones se meten en otro fichero escogido
		echo "RangoPrioridad $prio_menorInicial $prio_mayorInicial ">>$nomFicheroDatos #Los datos del mínimo y máximo del rango de Prioridades se meten en otro fichero escogido
		echo "TipoPrioridad $PrioR ">>$nomFicheroDatos #El tipo de Prioridad definido se mete en otro fichero escogido
		echo "Quantum $quantum ">>$nomFicheroDatos #El valor del Quantum de tiempo definido se mete en otro fichero escogido
	fi
	echo "Llegada ${llegada[$p]} Ejecucion ${ejecucion[$p]} Tamano ${memoria[$p]} Prioridad ${prioProc[$p]}" >> $nomFicheroDatos
#	clear
} #Fin de entradaMemoriaRangosFichero_op_cuatro_Post_1()

####################################################################################
# Sinopsis: Se copian los ficheros que correspondan para la opción 4
####################################################################################
function entradaMemoriaRangosFichero_op_cuatro_Post_2 {
	if [[ -f "$ficheroDatosAnteriorEjecucion" ]]; then #Borra el fichero de datos ultimo y escribe los datos en el fichero
		rm $ficheroDatosAnteriorEjecucion
	fi
	if [[ -f "$ficheroRangosAnteriorEjecucion" ]]; then #Borra el fichero de datos ultimo y escribe los rangos en el fichero
		rm $ficheroRangosAnteriorEjecucion
	fi
	cp $nomFicheroDatos $ficheroDatosAnteriorEjecucion  #Copia los ficheros Default/Último
	cp $nomFicheroRangos $ficheroRangosAnteriorEjecucion  #Copia los ficheros Default/Último
} #Fin de entradaMemoriaRangosFichero_op_cuatro_Post_2()

####################################################################################
# Sinopsis: Pregunta en qué fichero guardar los rangos amplios para la opción 5.
####################################################################################
function entradaMemoriaRangosFichero_op_cinco_Previo {
#	clear
	preguntaDondeGuardarDatosManuales #Resuelve los nombres de los ficheros de datos
} #Fin de entradaMemoriaRangosFichero_op_cinco_Previo()

####################################################################################
# Sinopsis: Pregunta en qué fichero guardar los rangos amplios para la opción 6.
####################################################################################
function entradaMemoriaRangosFichero_op_seis_Previo {
#	clear
	preguntaDondeGuardarDatosManuales #Resuelve los nombres de los ficheros de datos
	echo -e "\n\nFicheros existentes:\n$NORMAL" | tee -a $informeConColorTotal
	echo -e "\n\nFicheros existentes:\n" >> $informeSinColorTotal
	files=("./FRangos"/*)
	for i in "${!files[@]}"; do
		echo -e "$((i+1))) ${files[$i]}" | tee -a $informeConColorTotal
		echo -e "$((i+1))) ${files[$i]}" >> $informeSinColorTotal
	done
	echo -ne "\n$AMARILLO\nIntroduce el número correspondiente al fichero elegido: $NORMAL" | tee -a $informeConColorTotal
	echo -ne "\n\nIntroduce el número correspondiente al fichero elegido: " >> $informeSinColorTotal
	read -r numeroFichero
	echo -e "$numeroFichero\n\n" >> $informeConColorTotal
	echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	until [[ 0 -lt $numeroFichero && $numeroFichero -le ${#files[@]} && $numeroFichero -ne "" ]]; do
		echo -ne "Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read -r numeroFichero
		echo -e "$numeroFichero\n\n" >> $informeConColorTotal
		echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	done
	ficheroParaLectura="${files[$((numeroFichero-1))]}"
#	clear
} #Fin de entradaMemoriaRangosFichero_op_seis_Previo()

####################################################################################
# Sinopsis: Se tratan los mínimos y máximos de los rangos, calculando los valores aleatorios y los datos
# con los que se trabajará para las opciones 5 y 6.
####################################################################################
function entradaMemoriaRangosFichero_op_cinco_seis {
	#-----------Llamada a funciones para rangos-------------
	MIN_RANGE_MEM=${memoria_min}
	MAX_RANGE_MEM=${memoria_max}
	calcDatoAleatorioGeneral $MIN_RANGE_MEM $MAX_RANGE_MEM
	mem_total=$datoAleatorioGeneral
	mem=$mem_total #para compatibilidad
	#------------------------------------------------------
	MIN_RANGE_REUB=${reubicacion_min}
	MAX_RANGE_REUB=${reubicacion_max}
	calcDatoAleatorioGeneral $MIN_RANGE_REUB $MAX_RANGE_REUB
	reub=$datoAleatorioGeneral
	#------------------------------------------------------
	MIN_RANGE_prio_menor=${prio_menor_min}
	MAX_RANGE_prio_menor=${prio_menor_max}
	calcDatoAleatorioGeneral $MIN_RANGE_prio_menor $MAX_RANGE_prio_menor
	prio_menorInicial=$datoAleatorioGeneral #*Inicial - Datos a representar
	MIN_RANGE_prio_mayor=${prio_mayor_min}
	MAX_RANGE_prio_mayor=${prio_mayor_max}
	calcDatoAleatorioGeneral $MIN_RANGE_prio_mayor $MAX_RANGE_prio_mayor
	prio_mayorInicial=$datoAleatorioGeneral #*Inicial - Datos a representar
	PriomInicial=$prio_menorInicial #Variables con los datos originales usadas en la cabecera de la representación de la tabla
	PrioMInicial=$prio_mayorInicial
	tratarRangoPrioridadesDirecta $prio_menorInicial $prio_mayorInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	prio_menor=$PriomFinal #Sobre este rango se calculan los datos de las prioridades de los procesos, prioridades que no deberían pedirse al usuario.
	prio_mayor=$PrioMFinal
	#------------------------------------------------------
	MIN_RANGE_quantum=${quantum_min}
	MAX_RANGE_quantum=${quantum_max}
	calcDatoAleatorioGeneral $MIN_RANGE_quantum $MAX_RANGE_quantum
	quantum=$datoAleatorioGeneral
	#------------------------------------------------------
	MIN_RANGE_NPROC=${programas_min}
	MAX_RANGE_NPROC=${programas_max}
	calcDatoAleatorioGeneral $MIN_RANGE_NPROC $MAX_RANGE_NPROC
	n_prog=$datoAleatorioGeneral
	#------------------------------------------------------
	MIN_RANGE_llegada=${llegada_min}
	MAX_RANGE_llegada=${llegada_max}
	MIN_RANGE_tiempo_ejec=${tiempo_ejec_min}
	MAX_RANGE_tiempo_ejec=${tiempo_ejec_max}
	MIN_RANGE_tamano_proc=${tamano_proc_min}
	MAX_RANGE_tamano_proc=${tamano_proc_max}
	MIN_RANGE_prio_proc=${prio_proc_min}
	MAX_RANGE_prio_proc=${prio_proc_max}
	#------------------------------------------------------

	datos_memoria_tabla #Resumen final de la tabla de datos con los datos obtenidos tras introducir los rangos desde fichero
	echo -e "\n$NC Pulse enter para continuar..." | tee -a $informeConColorTotal
	echo -e "\nPulse enter para continuar..." >> $informeSinColorTotal
	read enter
	echo -e $enter "\n" >> $informeConColorTotal
	echo -e $enter "\n" >> $informeSinColorTotal
#	clear
	cont_proc=0
	p=0
	until [[ $cont_proc -eq $n_prog ]]; do
		entradaMemoriaRangosFichero_op_cuatro_cinco_seis_Comun #Se calculan los valores aleatorios y los datos con los que se trabajará para las opciones 4, 5 y 6.
		entradaMemoriaRangosFichero_op_cinco_seis_Post_1 #Guarda los datos en los ficheros que correspondan
		p=`expr $p + 1` #Se incrementa el contador
		((cont_proc++))
	done #cierre del do del while $pro=="S"
	entradaMemoriaRangosFichero_op_cinco_seis_Post_2 #Copia los ficheros Default/Último
} #Fin de entradaMemoriaRangosFichero_op_cinco_seis()

####################################################################################
# Sinopsis: Se guardarán los datos en los ficheros que corresponda para las opciones 5 y 6
####################################################################################
function entradaMemoriaRangosFichero_op_cinco_seis_Post_1 {
	#Borra el fichero de datos ultimo y escribe los datos en el fichero
	#Escribe los datos en el fichero selecionado
	if [[ $seleccionTipoPrioridad -eq 1 ]]; then #M/m
		PrioR="Mayor"
	else
		PrioR="Menor"
	fi
	if [[ $p -eq 0 ]]; then
		echo "MemoriaTotal $mem ">$nomFicheroDatos #Los datos de las particiones se meten en otro fichero escogido
		echo "VariableReubicar $reub ">>$nomFicheroDatos #Los datos de las particiones se meten en otro fichero escogido
		echo "RangoPrioridad $PriomInicial $PrioMInicial ">>$nomFicheroDatos #Los datos del mínimo y máximo del rango de Prioridades se meten en otro fichero escogido
		echo "TipoPrioridad $PrioR ">>$nomFicheroDatos #El tipo de Prioridad definido se mete en otro fichero escogido
		echo "Quantum $quantum ">>$nomFicheroDatos #El valor del Quantum de tiempo definido se mete en otro fichero escogido
	fi
	echo "Llegada ${llegada[$p]} Ejecucion ${ejecucion[$p]} Tamano ${memoria[$p]} Prioridad ${prioProc[$p]}" >> $nomFicheroDatos
} #Fin de entradaMemoriaRangosFichero_op_cinco_seis_Post_1()

####################################################################################
# Sinopsis: Se copian los ficheros que correspondan para las opciones 5 y 6
####################################################################################
function entradaMemoriaRangosFichero_op_cinco_seis_Post_2 {
	#Borra el fichero de datos ultimo y escribe los datos en el fichero
	if [[ -f "$ficheroDatosAnteriorEjecucion" ]]; then
		rm $ficheroDatosAnteriorEjecucion
	fi
	#Borra el fichero de datos ultimo y escribe los datos en el fichero
	if [[ -f "$ficheroRangosAnteriorEjecucion" && $seleccionMenuEleccionEntradaDatos -ne 5 ]]; then
		rm $ficheroRangosAnteriorEjecucion
	fi
	cp $nomFicheroDatos $ficheroDatosAnteriorEjecucion  #Copia los ficheros Default/Último
	if [[ $seleccionMenuEleccionEntradaDatos -ne 5 ]]; then
		cp $nomFicheroRangos $ficheroRangosAnteriorEjecucion  #Copia los ficheros Default/Último
	fi
} #Fin de entradaMemoriaRangosFichero_op_cinco_seis_Post_2()

####################################################################################
# Sinopsis: Se calculan los valores aleatorios y los datos con los que se trabajará para las opciones 7, 8 y 9.
####################################################################################
function entradaMemoriaRangosFichero_op_cuatro_cinco_seis_Comun {
#	clear
	mem_total=$mem
	variableReubicar=$reub
	#----------------Empieza a introducir procesos------------
	proc=$(($p-1))
	if [[ $((p + 1)) -ge 10 ]]; then
		nombre="P$((p + 1))"
	else
		nombre="P0$((p + 1))"
	fi
	if [[ $p -ne 1 ]] ; then
		echo -ne "\n" | tee -a $informeConColorTotal $informeSinColorTotal
	fi

	proceso[$p]=$nombre; #Se añade a el vector ese nombre
	numeroproceso[$p]=$p #Se guarda su número en un vector para la función que lo ordena
	llegada_igual=$MIN_RANGE_llegada
	calcDatoAleatorioGeneral $MIN_RANGE_llegada $MAX_RANGE_llegada
	llegada[$p]=$datoAleatorioGeneral
	calcDatoAleatorioGeneral $MIN_RANGE_tiempo_ejec $MAX_RANGE_tiempo_ejec
	ejecucion[$p]=$datoAleatorioGeneral
	tiempoEjecucion[$p]=${ejecucion[$p]} #Para ser equivalente al nuevo programa
	calcDatoAleatorioGeneral $MIN_RANGE_tamano_proc $MAX_RANGE_tamano_proc
	memoria[$p]=$datoAleatorioGeneral
	proceso[$p]=$nombre; #Se añade el nombre del proceso al vector
	numeroproceso[$p]=$p #Se guarda su número en un vector para la función que lo ordena
	calcDatoAleatorioGeneral $MIN_RANGE_llegada $MAX_RANGE_llegada
	llegada[$p]=$datoAleatorioGeneral #Se añade el tiempo de llegada al vector
	calcDatoAleatorioGeneral $MIN_RANGE_tiempo_ejec $MAX_RANGE_tiempo_ejec
	ejecucion[$p]=$datoAleatorioGeneral #Se añade el tiempo de ejecución al vector
	calcDatoAleatorioGeneral $MIN_RANGE_tamano_proc $MAX_RANGE_tamano_proc
	memoria[$p]=$datoAleatorioGeneral #Se añade el tamaño de ejecución al vector
	calcDatoAleatorioGeneral $prio_menor $prio_mayor
	prioProc[$p]=$datoAleatorioGeneral #Se añade la prioridad del proceso al vector
	prio_proc=$datoAleatorioGeneral #Se crea otra variable para hacer compatible este código con otro código anterior.
} #Fin de entradaMemoriaRangosFichero_op_cuatro_cinco_seis_Comun()

####################################################################################
# Sinopsis: Pregunta en qué fichero guardar los rangos para la opción 8.
####################################################################################
function entradaMemoriaRangosFichero_op_siete_Previo {
#	clear
	preguntaDondeGuardarRangosAleTManuales #Resuelve los nombres de los ficheros de rangos amplios
	preguntaDondeGuardarRangosManuales #Resuelve los nombres de los ficheros de rangos
	preguntaDondeGuardarDatosManuales #Resuelve los nombres de los ficheros de datos
} #Fin de entradaMemoriaRangosFichero_op_siete_Previo()

####################################################################################
# Sinopsis: Pregunta en qué fichero guardar los rangos para la opción 8.
####################################################################################
function entradaMemoriaRangosFichero_op_ocho_Previo {
#	clear
	preguntaDondeGuardarRangosManuales #Resuelve los nombres de los ficheros de rangos
	preguntaDondeGuardarDatosManuales #Resuelve los nombres de los ficheros de datos
} #Fin de entradaMemoriaRangosFichero_op_ocho_Previo()

####################################################################################
# Sinopsis: Pregunta en qué fichero guardar los rangos amplios para la opción 9.
####################################################################################
function entradaMemoriaRangosFichero_op_nueve_Previo {
#	clear
	preguntaDondeGuardarRangosManuales #Resuelve los nombres de los ficheros de rangos
	preguntaDondeGuardarDatosManuales #Resuelve los nombres de los ficheros de datos
	echo -e "\n\nFicheros existentes:\n$NORMAL" | tee -a $informeConColorTotal
	echo -e "\n\nFicheros existentes:\n" >> $informeSinColorTotal
	files=("./FRangosAleT"/*)
	for i in "${!files[@]}"; do
		echo -e "$((i+1))) ${files[$i]}" | tee -a $informeConColorTotal
		echo -e "$((i+1))) ${files[$i]}" >> $informeSinColorTotal
	done
	echo -ne "\n$AMARILLO\nIntroduce el número correspondiente al fichero elegido: $NORMAL" | tee -a $informeConColorTotal
	echo -ne "\n\nIntroduce el número correspondiente al fichero elegido: " >> $informeSinColorTotal
	read -r numeroFichero
	echo -e "$numeroFichero\n\n" >> $informeConColorTotal
	echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	until [[ 0 -lt $numeroFichero && $numeroFichero -le ${#files[@]} && $numeroFichero -ne "" ]]; do
		echo -ne "Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read -r numeroFichero
		echo -e "$numeroFichero\n\n" >> $informeConColorTotal
		echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	done
	ficheroParaLectura="${files[$((numeroFichero-1))]}"
#	clear
} #Fin de entradaMemoriaRangosFichero_op_nueve_Previo()

####################################################################################
# Sinopsis: Se piden y tratan los mínimos y máximos de los rangos para las opciones 8 y 9. El cálculo de los
# datos aleatorioscon los que se trabajará se hace en entradaMemoriaRangosFichero_op_siete_ocho_nueve_Comun.
####################################################################################
function entradaMemoriaRangosFichero_op_siete_ocho_nueve {
	#Hace un cálculo inicial de mínimos, máximos y datos generales y lo muestra
	if [[ $seleccionMenuEleccionEntradaDatos -eq 7 ]]; then
		datos_tamano_memoria_amplio  #Llamada a funciones para definir las variables con los límites de los rangos amplios.
	fi
	calcDatoAleatorioGeneral $memoria_minInicial $memoria_maxInicial #calcMinTamMemoria #Mínimos
	MIN_RANGE_MEMInicial=$datoAleatorioGeneral
	calcDatoAleatorioGeneral $memoria_minInicial $memoria_maxInicial #calcMaxTamMemoria #Máximos
	MAX_RANGE_MEMInicial=$datoAleatorioGeneral
	tratarRangoPrioridadesDirecta $MIN_RANGE_MEMInicial $MAX_RANGE_MEMInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	MIN_RANGE_MEM=$PriomFinal
	MAX_RANGE_MEM=$PrioMFinal
	calcDatoAleatorioGeneral $MIN_RANGE_MEM $MAX_RANGE_MEM #Se calculan los valores que no dependen de los procesos desde los subrangos ya calculados.
	mem_total=$datoAleatorioGeneral
	mem=$mem_total #Por compatibilidad con otro código.

	if [[ $seleccionMenuEleccionEntradaDatos -eq 7 ]]; then
		datos_tamano_reubicacion_amplio
	fi
	calcDatoAleatorioGeneral $reubicacion_minInicial $reubicacion_maxInicial #calcMinReub #Mínimos
	MIN_RANGE_REUBInicial=$datoAleatorioGeneral
	calcDatoAleatorioGeneral $reubicacion_minInicial $reubicacion_maxInicial #calcMaxReub
	MAX_RANGE_REUBInicial=$datoAleatorioGeneral
	tratarRangoPrioridadesDirecta $MIN_RANGE_REUBInicial $MAX_RANGE_REUBInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	MIN_RANGE_REUB=$PriomFinal
	MAX_RANGE_REUB=$PrioMFinal
	calcDatoAleatorioGeneral $MIN_RANGE_REUB $MAX_RANGE_REUB #Se calculan los valores que no dependen de los procesos desde los subrangos ya calculados.
	reub=$datoAleatorioGeneral

	if [[ $seleccionMenuEleccionEntradaDatos -eq 7 ]]; then
		datos_prio_menor_amplio
	fi
	tratarRangoPrioridadesDirecta $prio_menor_minInicial $prio_menor_maxInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	prio_menor_min=$PriomFinal #Variables con los originales usadas para calcular subrangos y datos finales
	prio_menor_max=$PrioMFinal
	calcDatoAleatorioGeneral $prio_menor_min $prio_menor_max #calcMinPrioPro #Mínimos #Prioridades asociadas a los procesos.
	MIN_RANGE_prio_menorInicial=$datoAleatorioGeneral  #Desde este rango amplio se calculan los subrangos desde los que calcular el rango desde el que calcular los datos.
	calcDatoAleatorioGeneral $prio_menor_min $prio_menor_max #calcMaxPrioPro
	MAX_RANGE_prio_menorInicial=$datoAleatorioGeneral
	tratarRangoPrioridadesDirecta $MIN_RANGE_prio_menorInicial $MAX_RANGE_prio_menorInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	MIN_RANGE_prio_menor=$PriomFinal
	MAX_RANGE_prio_menor=$PrioMFinal
	calcDatoAleatorioGeneral $MIN_RANGE_prio_menor $MAX_RANGE_prio_menor #calcMem #Datos generales
	prio_menorInicial=$datoAleatorioGeneral #Desde este subrango se calcula el rango desde el que calcular los datos.

	if [[ $seleccionMenuEleccionEntradaDatos -eq 7 ]]; then
		datos_prio_mayor_amplio
	fi
	tratarRangoPrioridadesDirecta $prio_mayor_minInicial $prio_mayor_maxInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	prio_mayor_min=$PriomFinal
	prio_mayor_max=$PrioMFinal
	calcDatoAleatorioGeneral $prio_mayor_min $prio_mayor_max #calcMinPrioPro #Mínimos #Prioridades asociadas a los procesos.
	MIN_RANGE_prio_mayorInicial=$datoAleatorioGeneral
	calcDatoAleatorioGeneral $prio_mayor_min $prio_mayor_max #calcMaxPrioPro
	MAX_RANGE_prio_mayorInicial=$datoAleatorioGeneral
	tratarRangoPrioridadesDirecta $MIN_RANGE_prio_mayorInicial $MAX_RANGE_prio_mayorInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	MIN_RANGE_prio_mayor=$PriomFinal
	MAX_RANGE_prio_mayor=$PrioMFinal
	calcDatoAleatorioGeneral $MIN_RANGE_prio_mayor $MAX_RANGE_prio_mayor #calcMem #Datos generales
	prio_mayorInicial=$datoAleatorioGeneral

	tratarRangoPrioridadesDirecta $prio_menorInicial $prio_mayorInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	prio_menor=$PriomFinal #Desde este rango se calculan los datos.
	prio_mayor=$PrioMFinal

	PriomInicial=$prio_menorInicial #Variables con los datos originales usadas en la cabecera de la representación de la tabla
	PrioMInicial=$prio_mayorInicial

	if [[ $seleccionMenuEleccionEntradaDatos -eq 7 ]]; then
		datos_quantum_amplio
	fi
	calcDatoAleatorioGeneral $quantum_minInicial $quantum_maxInicial
	MIN_RANGE_quantumInicial=$datoAleatorioGeneral
	calcDatoAleatorioGeneral $quantum_minInicial $quantum_maxInicial
	MAX_RANGE_quantumInicial=$datoAleatorioGeneral
	tratarRangoPrioridadesDirecta $MIN_RANGE_quantumInicial $MAX_RANGE_quantumInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	MIN_RANGE_quantum=$PriomFinal
	MAX_RANGE_quantum=$PrioMFinal
	calcDatoAleatorioGeneral $MIN_RANGE_quantum $MAX_RANGE_quantum
	quantum=$datoAleatorioGeneral

	if [[ $seleccionMenuEleccionEntradaDatos -eq 7 ]]; then
		datos_numero_programas_amplio
	fi
	calcDatoAleatorioGeneral $programas_minInicial $programas_maxInicial #calcMinNumPro #Mínimos
	MIN_RANGE_NPROCInicial=$datoAleatorioGeneral
	calcDatoAleatorioGeneral $programas_minInicial $programas_maxInicial #calcMaxNumPro
	MAX_RANGE_NPROCInicial=$datoAleatorioGeneral
	tratarRangoPrioridadesDirecta $MIN_RANGE_NPROCInicial $MAX_RANGE_NPROCInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	MIN_RANGE_NPROC=$PriomFinal
	MAX_RANGE_NPROC=$PrioMFinal
	calcDatoAleatorioGeneral $MIN_RANGE_NPROC $MAX_RANGE_NPROC
	n_prog=$datoAleatorioGeneral

	if [[ $seleccionMenuEleccionEntradaDatos -eq 7 ]]; then
		datos_tiempo_llegada_amplio
	fi
	calcDatoAleatorioGeneral $llegada_minInicial $llegada_maxInicial #calcMinTiemLLegada #Mínimos
	MIN_RANGE_llegadaInicial=$datoAleatorioGeneral
	calcDatoAleatorioGeneral $llegada_minInicial $llegada_maxInicial #calcMaxTiemLLegada
	MAX_RANGE_llegadaInicial=$datoAleatorioGeneral
	tratarRangoPrioridadesDirecta $MIN_RANGE_llegadaInicial $MAX_RANGE_llegadaInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	MIN_RANGE_llegada=$PriomFinal
	MAX_RANGE_llegada=$PrioMFinal

	if [[ $seleccionMenuEleccionEntradaDatos -eq 7 ]]; then
		datos_tiempo_ejecucion_amplio
	fi
	calcDatoAleatorioGeneral $tiempo_ejec_minInicial $tiempo_ejec_maxInicial #calcMinTiemEjecucion #Mínimos
	MIN_RANGE_tiempo_ejecInicial=$datoAleatorioGeneral
	calcDatoAleatorioGeneral $tiempo_ejec_minInicial $tiempo_ejec_maxInicial #calcMaxTiemEjecucion
	MAX_RANGE_tiempo_ejecInicial=$datoAleatorioGeneral
	tratarRangoPrioridadesDirecta $MIN_RANGE_tiempo_ejecInicial $MAX_RANGE_tiempo_ejecInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	MIN_RANGE_tiempo_ejec=$PriomFinal
	MAX_RANGE_tiempo_ejec=$PrioMFinal

	if [[ $seleccionMenuEleccionEntradaDatos -eq 7 ]]; then
		datos_tamano_procesos_amplio
	fi
#	calcDatoAleatorioGeneral $tamano_proc_minInicial $tamano_maxInicial #calcMinTamPro #Mínimos
	calcDatoAleatorioGeneral $tamano_proc_minInicial $tamano_proc_maxInicial #calcMinTamPro #Mínimos
	MIN_RANGE_tamano_procInicial=$datoAleatorioGeneral
#	calcDatoAleatorioGeneral $tamano_proc_minInicial $tamano_maxInicial #calcMaxTamPro
	calcDatoAleatorioGeneral $tamano_proc_minInicial $tamano_proc_maxInicial #calcMaxTamPro
	MAX_RANGE_tamano_procInicial=$datoAleatorioGeneral
	tratarRangoPrioridadesDirecta $MIN_RANGE_tamano_procInicial $MAX_RANGE_tamano_procInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	MIN_RANGE_tamano_proc=$PriomFinal
	MAX_RANGE_tamano_proc=$PrioMFinal

	#Si los mínimos son menores de 0 o 1, dependiendo de la variable, los modifica, y recalcula los máximos y los datos, y los vuelve a mostrar, ya corregidos.
	if [[ $MIN_RANGE_MEM -lt 0 ]];then
		echo -e "$amarillo Se cambió el valor mínimo del tamaño de memoria por no ser válido"
		min=0
		max=$memoria_max
		MIN_RANGE_MEM=$((RANDOM % (max - min + 1) + min)) # Generar un número aleatorio dentro del rango
		calcMaxGeneral $MIN_RANGE_MEM $memoria_max #calcMaxTamMemoria #Máximos
		MAX_RANGE_MEM=$maxGeneral
		calcDatoAleatorioGeneral $MIN_RANGE_MEM $MAX_RANGE_MEM
		mem=$datoAleatorioGeneral
		cambios=$((cambios+1))
	fi
	if [[ $MIN_RANGE_REUB -lt 0 ]];then
		echo -e "$amarillo Se cambió el valor mínimo de la reubicación por no ser válido"
		min=0
		max=$reubicacion_max
		MIN_RANGE_REUB=$((RANDOM % (max - min + 1) + min)) # Generar un número aleatorio dentro del rango
		calcMaxGeneral $MIN_RANGE_REUB $reubicacion_max #calcMaxReub #Máximos
		MAX_RANGE_REUB=$maxGeneral
		calcDatoAleatorioGeneral $MIN_RANGE_REUB $MAX_RANGE_NPROC
		reub=$datoAleatorioGeneral
		cambios=$((cambios+1))
	fi
	if [[ $MIN_RANGE_NPROC -lt 0 ]];then
		echo -e "$amarillo Se cambió el valor mínimo del número de procesos por no ser válido"
		min=0
		max=$programas_max
		MIN_RANGE_NPROC=$((RANDOM % (max - min + 1) + min)) # Generar un número aleatorio dentro del rango
		calcMaxGeneral $MIN_RANGE_NPROC $programas_max #calcMaxNumPro #Máximos
		MAX_RANGE_NPROC=$maxGeneral
		calcDatoAleatorioGeneral $MIN_RANGE_NPROC $MAX_RANGE_MEM
		n_prog=$datoAleatorioGeneral
		cambios=$((cambios+1))
	fi
	if [[ $MIN_RANGE_llegada -lt 0 ]];then
		echo -e "$amarillo Se cambió el valor mínimo del tiempo de llegada por no ser válido"
		min=0
		max=$llegada_max
		MIN_RANGE_llegada=$((RANDOM % (max - min + 1) + min)) # Generar un número aleatorio dentro del rango
		calcMaxGeneral $MIN_RANGE_llegada $llegada_max #calcMaxTiemLLegada #Máximos
		MAX_RANGE_llegada=$maxGeneral
		cambios=$((cambios+1))
	fi
	if [[ $MIN_RANGE_tiempo_ejec -lt 0 ]];then
		echo -e "$amarillo Se cambió el valor mínimo del tiempo de ejecución por no ser válido"
		min=0
		max=$tiempo_ejec_max
		MIN_RANGE_tiempo_ejec=$((RANDOM % (max - min + 1) + min)) # Generar un número aleatorio dentro del rango
		calcMaxGeneral $MIN_RANGE_tiempo_ejec $tiempo_ejec_max #calcMaxTiemEjecucion #Máximos
		MAX_RANGE_tiempo_ejec=$maxGeneral
		cambios=$((cambios+1))
	fi
	if [[ $MIN_RANGE_tamano_proc -lt 0 ]];then
		echo -e "$amarillo Se cambió el valor mínimo del tamaño de los procesos por no ser válido"
		min=0
		max=$tamano_max
		MIN_RANGE_tamano_proc=$((RANDOM % (max - min + 1) + min)) # Generar un número aleatorio dentro del rango
		calcMaxGeneral $MIN_RANGE_tamano_proc $tamano_max #calcMaxTamPro #Máximos
		MAX_RANGE_tamano_proc=$maxGeneral
		cambios=$((cambios+1))
	fi
	if [[ $cambios != 0 ]];then

		datos_amplio_memoria_tabla

#		clear
	fi
#	clear
	cont_proc=0
	until [[ $cont_proc -eq $n_prog ]]; do
		entradaMemoriaRangosFichero_op_siete_ocho_nueve_Comun #Se calculan los valores aleatorios y los datos con los que se trabajará para las opciones 7, 8 y 9.
		entradaMemoriaRangosFichero_op_siete_ocho_nueve_Post_1 #Guarda los datos en los ficheros que correspondan
		p=`expr $p + 1` #Se incrementa el contador
		((cont_proc++))
	done #cierre del do del while $pro=="S"
	entradaMemoriaRangosFichero_op_siete_ocho_nueve_Post_2 #Copia los ficheros Default/Último
} #Fin de entradaMemoriaRangosFichero_op_siete_ocho_nueve()

####################################################################################
# Sinopsis: Se guardarán los datos en los ficheros que corresponda para las opciones 8 y 9
####################################################################################
function entradaMemoriaRangosFichero_op_siete_ocho_nueve_Post_1 {
	#Escribe los datos en el fichero de datos selecionado
	if [[ $p -eq 1 ]]; then
		if [[ -f "$ficheroDatosAnteriorEjecucion" ]]; then
			rm $nomFicheroDatos
		fi
		echo "MemoriaTotal $mem ">$nomFicheroDatos #Los datos de las particiones se meten en otro fichero escogido
		echo "VariableReubicar $reub ">>$nomFicheroDatos #Los datos de las particiones se meten en otro fichero escogido
		echo "RangoPrioridad $PriomInicial $PrioMInicial ">>$nomFicheroDatos #Los datos del mínimo y máximo del rango de Prioridades se meten en otro fichero escogido
		echo "TipoPrioridad $PrioR ">>$nomFicheroDatos #El tipo de Prioridad definido se mete en otro fichero escogido
		echo "Quantum $quantum ">>$nomFicheroDatos #El valor del Quantum de tiempo definido se mete en otro fichero escogido
	fi
	echo "Llegada ${llegada[$p]} Ejecucion ${ejecucion[$p]} Tamano ${memoria[$p]} Prioridad ${prioProc[$p]}" >> $nomFicheroDatos
	#Escribe los rangos en el fichero de rangos selecionado
	if [[ $p -eq 1 ]]; then #Escribe los rangos en el fichero de rangos selecionado (RangosAleTotalDefault.txt, o el elegido por el usuario).
		if [[ -f "$nomFicheroRangos" ]]; then
			rm $nomFicheroRangos
		fi
		echo -e "RangoMemoria $MIN_RANGE_MEM $MAX_RANGE_MEM " > $nomFicheroRangos
		echo -e "RangoPrioMenor $MIN_RANGE_prio_menor $MAX_RANGE_prio_menor " >> $nomFicheroRangos
		echo -e "RangoPrioMayor $MIN_RANGE_prio_mayor $MAX_RANGE_prio_mayor " >> $nomFicheroRangos
		echo -e "RangoNumProc $MIN_RANGE_NPROC $MAX_RANGE_NPROC " >> $nomFicheroRangos
		echo -e "RangoReubicar $MIN_RANGE_REUB $MAX_RANGE_REUB " >> $nomFicheroRangos
		echo -e "RangoLlegada $MIN_RANGE_llegada $MAX_RANGE_llegada " >> $nomFicheroRangos
		echo -e "RangoTEjecucion $MIN_RANGE_tiempo_ejec $MAX_RANGE_tiempo_ejec " >> $nomFicheroRangos
		echo -e "RangoPrioProc $prio_menor $prio_mayor " >> $nomFicheroRangos
		echo -e "RangoTamano $tamano_proc_min $tamano_proc_max " >> $nomFicheroRangos
		echo -e "RangoQuantum $MIN_RANGE_quantum $MAX_RANGE_quantum " >> $nomFicheroRangos
	fi #Cierre if $p -eq 1
	if [[ $p -eq 1 && $seleccionMenuEleccionEntradaDatos -ne 8 ]]; then  #Escribe los rangos en el fichero de rangos amplios selecionado
		if [[ -f "$nomFicheroRangosAleT" ]]; then
			rm $nomFicheroRangosAleT
		fi
		echo -e "RangoMemoria $memoria_minInicial $memoria_maxInicial " > $nomFicheroRangosAleT
		echo -e "RangoReubicar $reubicacion_minInicial $reubicacion_maxInicial " >> $nomFicheroRangosAleT
		echo -e "RangoPrioMenor $prio_menor_minInicial $prio_menor_maxInicial " >> $nomFicheroRangosAleT
		echo -e "RangoPrioMayor $prio_mayor_minInicial $prio_mayor_maxInicial " >> $nomFicheroRangosAleT
		echo -e "RangoNumProc $programas_minInicial $programas_maxInicial " >> $nomFicheroRangosAleT
		echo -e "RangoLlegada $llegada_minInicial $llegada_maxInicial " >> $nomFicheroRangosAleT
		echo -e "RangoTEjecucion $tiempo_ejec_minInicial $tiempo_ejec_maxInicial " >> $nomFicheroRangosAleT
		echo -e "RangoPrioProc $prio_proc_minInicial $prio_proc_maxInicial " >> $nomFicheroRangosAleT
		echo -e "RangoTamano $tamano_proc_minInicial $tamano_proc_maxInicial " >> $nomFicheroRangosAleT
		echo -e "RangoQuantum $quantum_minInicial $quantum_maxInicial " >> $nomFicheroRangosAleT
	fi #Cierre if $p -eq 1
} #Fin de entradaMemoriaRangosFichero_op_siete_ocho_nueve_Post_1()

####################################################################################
# Sinopsis: Se copian los ficheros que correspondan para las opciones 8 y 9
####################################################################################
function entradaMemoriaRangosFichero_op_siete_ocho_nueve_Post_2 {
	if [[ -f "$ficheroDatosAnteriorEjecucion" ]]; then #Borra el fichero de datos ultimo y escribe los datos en el fichero
		rm $ficheroDatosAnteriorEjecucion
	fi
	if [[ -f "$ficheroRangosAnteriorEjecucion" ]]; then #Borra el fichero de datos ultimo y escribe los rangos en el fichero
		rm $ficheroRangosAnteriorEjecucion
	fi
	cp $nomFicheroDatos $ficheroDatosAnteriorEjecucion  #Copia los ficheros Default/Último
	cp $nomFicheroRangos $ficheroRangosAnteriorEjecucion  #Copia los ficheros Default/Último
	if [[ $seleccionMenuEleccionEntradaDatos -ne 8 ]]; then #Actualiza el fichero de rangos amplios de última ejecución (RangosAleTotalLast.txt) como copia del fichero utilizado para los rangos amplios (RangosAleTotalDefault.txt, o el elegido por el usuario).
		if [[ -f "$ficheroRangosAleTotalAnteriorEjecucion" ]]; then #Borra el fichero de datos ultimo y escribe los rangos en el fichero
			rm $ficheroRangosAleTotalAnteriorEjecucion
		fi
		cp $nomFicheroRangosAleT $ficheroRangosAleTotalAnteriorEjecucion
	fi
} #Fin de entradaMemoriaRangosFichero_op_siete_ocho_nueve_Post_2()

####################################################################################
# Sinopsis: Se calculan los valores aleatorios y los datos con los que se trabajará para las opciones 7, 8 y 9.
####################################################################################
function entradaMemoriaRangosFichero_op_siete_ocho_nueve_Comun {
#	clear
	mem_total=$mem
	variableReubicar=$reub
	#------------------------------Empieza a introducir procesos--------------------
	if [[ $p -eq 1 ]] ; then
		if [[ -f $ficheroDatosDefault ]] ; then
			if [[ $seleccionMenuPreguntaDondeGuardarDatosManuales == "1" ]] ; then
				rm $ficheroDatosDefault
			fi
		fi
		if [[ -f $ficheroRangosDefault ]] ; then
			if [[ $seleccionMenuPreguntaDondeGuardarRangosManuales == "1" ]] ; then
				rm $ficheroRangosDefault
			fi
		fi
	fi
	proc=$(($p-1))
	if [[ $((p + 1)) -ge 10 ]]; then
		nombre="P$((p + 1))"
	else
		nombre="P0$((p + 1))"
	fi
	if [[ $p -ne 1 ]] ; then
		echo -ne "\n" | tee -a $informeConColorTotal $informeSinColorTotal
	fi
	proceso[$p]=$nombre; #Se añade a el vector ese nombre
	numeroproceso[$p]=$p #Se guarda su número en un vector para la función que lo ordena
	calcDatoAleatorioGeneral $MIN_RANGE_llegada $MAX_RANGE_llegada
	llegada[$p]=$datoAleatorioGeneral #Se añade el tamaño de ejecución al vector #Sobra uno
	calcDatoAleatorioGeneral $MIN_RANGE_tiempo_ejec $MAX_RANGE_tiempo_ejec
	ejecucion[$p]=$datoAleatorioGeneral #Se añade el tamaño de ejecución al vector #Sobra uno
	tiempoEjecucion[$p]=${ejecucion[$p]} #Para ser equivalente al nuevo programa
	calcDatoAleatorioGeneral $MIN_RANGE_tamano_proc $MAX_RANGE_tamano_proc
	memoria[$p]=$datoAleatorioGeneral #Se añade el tamaño de ejecución al vector #Sobra uno
	calcDatoAleatorioGeneral $prio_menor $prio_mayor
	prioProc[$p]=$datoAleatorioGeneral #Se añade el tamaño de ejecución al vector #Sobra uno
	prio_proc=$datoAleatorioGeneral #Se añade el tamaño de ejecución al vector
} #Fin de entradaMemoriaRangosFichero_op_siete_ocho_nueve_Comun()

####################################################################################
# Sinopsis: Calcula los datos de la tabla resumen de procesos en cada volcado
####################################################################################
function ajusteFinalTiemposEsperaEjecucionRestante { #ESTADO DE CADA PROCESO EN EL TIEMPO ACTUAL Y HALLAR LAS VARIABLES.
	for (( i=0; i<$nprocesos; i++ )); do #Modificamos los valores de los arrays, restando de lo que quede
		if [[ ${enejecucion[$i]} -eq 1 ]]; then
			temp_rej[$i]=`expr ${temp_rej[$i]} - 1`
			temp_ret[$i]=`expr ${temp_ret[$i]} + 1` #Se suman para evitar que en el último segundo de ejecución no se sume el segundo de retorno
		fi
		if [[ ${encola[$i]} -eq 1 && ${bloqueados[$i]} -eq 1 && ${estad[$i]} -ne 0 ]] ; then #estado[$i]="Bloqueado" - En espera
			temp_wait[$i]=`expr ${temp_wait[$i]} + 1`
			temp_ret[$i]=`expr ${temp_ret[$i]} + 1`
		fi
		if [[ ${enmemoria[$i]} -eq 1 && ${enejecucion[$i]} -eq 1 ]] ; then #estado[$i]="En ejecucion"
			temp_wait[$i]=`expr ${temp_wait[$i]} + 0`
		elif [[ ${enmemoria[$i]} -eq 1 && ${enpausa[$i]} -eq 1 ]] ; then #estado[$i]="En pausa" - En pausa
			temp_wait[$i]=`expr ${temp_wait[$i]} + 1`
			temp_ret[$i]=`expr ${temp_ret[$i]} + 1`
		elif [[ ${enmemoria[$i]} -eq 1 ]] ; then #estado[$i]="En memoria"
			temp_wait[$i]=`expr ${temp_wait[$i]} + 1`
			temp_ret[$i]=`expr ${temp_ret[$i]} + 1`
		fi
	done #Si ha terminado, no se hace nada. Y si no ha llegado, su tiempo de espera es "-"
	for (( i=0; i<$nprocesos; i++ )); do #Se ponen todas las posiciones del vector enejecución a 0, se establecerá qué proceso está a 1 en cada ciclo del programa.
		bloqueados[$i]=0 #Se desbloquean todos y se establecerán los procesos bloqueados en cada ciclo.
	done
	reloj=`expr $reloj + 1` # Se incrementa el reloj
} #Final de los cálculos para dibujar la banda de tiempos - ajusteFinalTiemposEsperaEjecucionRestante()

####################################################################################
# Sinopsis: Se muestran los eventos sucedidos, sobre la tabla resumen.
####################################################################################
function mostrarEventos {
#	clear
	evento=0 #Inicializo evento
	#Se muestran los datos sobre las indicaciones del evento que ha sucedido
	if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 1 ]]; then #FCFS/SJF/SRPT
		algoritmoSeleccionado="FCFS-SN-"
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 2 ]]; then
		algoritmoSeleccionado="SJF-SN-"
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 3 ]]; then
		algoritmoSeleccionado="SRPT-SN-"
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 4 ]]; then
		algoritmoSeleccionado="Prioridades-"
		if [[ $seleccionTipoPrioridad -eq 1 ]]; then #M/m
			algoritmoSeleccionado+="Mayor-"
		else
			algoritmoSeleccionado+="Menor-"
		fi
		if [[ $seleccionMenuApropiatividad -eq 1 ]]; then #M/m
			algoritmoSeleccionado+="NoApropiativo-SN-"
		else
			algoritmoSeleccionado+="Apropiativo-SN-"
		fi
		Dato2=" Prio.Mínima="$PriomInicial" Prio.Máxima="$PrioMInicial
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 5 ]]; then
		algoritmoSeleccionado="RoundRobin(RR)-SN-"
		Dato3=" Quantum="$quantum
	fi
	if [[ $continuidadNo0Si1 -eq 0 ]]; then #C/NC
		continuidadSeleccionado="NC-"
	else
		continuidadSeleccionado="C-"
	fi
	if [[ $reubicabilidadNo0Si1 -eq 0 ]]; then #R/NR
		reubicabilidadSeleccionado="NR"
	else
		reubicabilidadSeleccionado="R"
		Dato1=" Máx.Reubicación="$variableReubicar
	fi
	algoritmoContinuidadReubicabilidadSeleccionado="$algoritmoSeleccionado""$continuidadSeleccionado""$reubicabilidadSeleccionado"
	echo " $algoritmoContinuidadReubicabilidadSeleccionado" | tee -a $informeConColorTotal
	echo " $algoritmoContinuidadReubicabilidadSeleccionado" >> ./$informeSinColorTotal
	echo -e $NC" Reloj="$reloj" Mem.Total="$mem_total" Mem.Libre="$mem_libre$Dato1$Dato2$Dato3 | tee -a $informeConColorTotal
	echo -e " Reloj="$reloj" Mem.Total="$mem_total" Mem.Libre="$mem_libre$Dato1$Dato2$Dato3 >> $informeSinColorTotal
	#Se muestra el evento que ha sucedido
	for ((l=0 ;l<nprocesos; l++)); do
		if [[ ${avisosalida[$l]} -eq 1 ]]; then
			echo -e " El proceso$NC ${varC[$l]}${proceso[$l]}$NC ha salido de memoria." | tee -a $informeConColorTotal
			echo -e " El proceso ${proceso[$l]} ha salido de memoria." >> $informeSinColorTotal
			avisosalida[$l]=0 #Se borra el uno para que no se vuelva a imprimir
			avisoPausa[$l]=0 #Se borra el uno para que no se imprima, para asegurarse que si ha terminado, no salga el aviso
			avisoEntradaCPU[$l]=0 #Se borra el uno para que no se vuelva a imprimir
		fi
	done
	for ((l=0 ;l<nprocesos; l++)); do
		if [[ ${avisollegada[$l]} -eq 1 ]]; then
			echo -e " El proceso$NC ${varC[$l]}${proceso[$l]}$NC ha llegado al sistema." | tee -a $informeConColorTotal
			echo -e " El proceso ${proceso[$l]} ha llegado al sitema." >> $informeSinColorTotal
			avisollegada[$l]=0 #Se borra el uno para que no se vuelva a imprimir
			avisoPausa[$l]=0 #Se borra el uno para que no se imprima, para asegurarse que si ha entrado en CPU, no salga el aviso
		fi
	done
	for ((l=0 ;l<nprocesos; l++)); do
		if [[ ${avisoentrada[$l]} -eq 1 ]]; then
			echo -e " El proceso$NC ${varC[$l]}${proceso[$l]}$NC ha entrado en memoria. " | tee -a $informeConColorTotal
			echo -e " El proceso ${proceso[$l]} ha entrado en memoria." >> $informeSinColorTotal
			avisoentrada[$l]=0 #Se borra el uno para que no se vuelva a imprimir
			avisoPausa[$l]=0 #Se borra el uno para que no se imprima, para asegurarse que si ha entrado en CPU, no salga el aviso
		fi
	done
	for ((l=0 ;l<nprocesos; l++)); do
		if [[ ${terminados[$l]} -eq 1 ]]; then #Para evitar el error de dejar el proceso en pausa en el siguiente volcado, cuando no se dan las otras dos condiciones anteriores de estar enmemoria[] y escrito[].
			avisoPausa[$l]=0 #Se borra el uno para que no se imprima, para asegurarse que si ha entrado en CPU, no salga el aviso
		fi
		if [[ ${avisoPausa[$l]} -eq 1 ]]; then
			echo -e " El proceso$NC ${varC[$l]}${proceso[$l]}$NC ha quedado en pausa. " | tee -a $informeConColorTotal
			echo -e " El proceso ${proceso[$l]} ha quedado en pausa." >> $informeSinColorTotal
		fi
		avisoPausa[$l]=0 #Se borra el uno para que no se vuelva a imprimir
	done
	for ((l=0 ;l<nprocesos; l++)); do
		if [[ ${avisoEntradaCPU[$l]} -eq 1 ]]; then
			echo -e " El proceso$NC ${varC[$l]}${proceso[$l]}$NC ha entrado en CPU. " | tee -a $informeConColorTotal
			echo -e " El proceso ${proceso[$l]} ha entrado en CPU." >> $informeSinColorTotal
		fi
		avisoEntradaCPU[$l]=0 #Se borra el uno para que no se vuelva a imprimir
		avisoPausa[$l]=0 #Se borra el uno para que no se imprima, para asegurarse que si ha entrado en CPU, no salga el aviso
	done
} #Final de mostrar los eventos sucedidos - mostrarEventos()

####################################################################################
# Sinopsis: Prepara e imprime la tabla resumen de procesos en cada volcado
####################################################################################
function dibujarTablaDatos {
	mem_aux=$[ $mem_total -1 ]
	j=0
	k=0
	for (( i=0; i<$nprocesos; i++ )); do
		if [[ ${enmemoria[$i]} -eq 1 ]]; then
			guardados[$j]=$i #Se guardan en cada posición el número del proceso correspondiente
			coloresAux[$k]=${coloress[$i % 6]}
			j=`expr $j + 1`
		fi
		k=`expr $k + 1`
	done
	j=0
	k=0
	#CALCULAR LOS DATOS A REPRESENTAR.
	cont=0
	for (( i=0; i<$nprocesos; i++ )); do
		if [[ ${enmemoria[$i]} -eq 1 ]]; then
			enmemoriavec[$cont]=$i
			cont=$[ $cont + 1 ]
			if [[ ${guardados[0]} -eq $i ]]; then
				pos_inicio[$i]=0
				pos_final[$i]=$[ ${memoria[$i]} -1 ]
				mem_aux=`expr $mem_aux - ${memoria[$i]}`
				pos_aux=${pos_final[$i]}
			else
				pos_inicio[$i]=$pos_aux
				pos_final[$i]=`expr ${pos_inicio[$i]} + ${memoria[$i]}`
				mem_aux=`expr $mem_aux - ${memoria[$i]}`
				pos_aux=${pos_final[$i]}
			fi
		fi
		if [[ ${estad[$i]} -eq 0 ]]; then #No llegado
			inicio2[$i]="-"
			final2[$i]="-"
			temp_wait[$i]="-"
			temp_ret[$i]="-"
			temp_rej[$i]="-"
			estado[$i]="Fuera del Sistema"
		elif [[ ${estad[$i]} -eq 1 ]]; then #En espera
			inicio2[$i]="-"
			final2[$i]="-"
			estado[$i]="En espera"
		elif [[ ${estad[$i]} -eq 2 ]]; then #En memoria
			estado[$i]="En memoria"
		elif [[ ${estad[$i]} -eq 3 ]]; then #En ejecucion
			estado[$i]="En ejecución"
		elif [[ ${estad[$i]} -eq 4 ]]; then #En pausa
			estado[$i]="En pausa"
		elif [[ ${estad[$i]} -eq 5 ]]; then #Finalizado
			inicio2[$i]="-"
			final2[$i]="-"
			temp_rej[$i]="-"
			estado[$i]="Finalizado"
			enejecucion[$i]=0 #Para asegurar que el proceso ya no está en ejecución, dado que lo que representa esta función es el resumen final, y no se va a seguir procesando datos.
		fi
			varC[$i]=${coloress[$i % 6]}
	done

	#REPRESENTAR LOS DATOS
	#Se ajusta a parte el vector de memoria inicial y final NO CONTINUA para CUADRAR (he comentado lo que cuadraba lo de antes)(modificación 2020)
	#Ajuste para la memoria no continua en un auxiliar (se imprime el auxiliar)
	#Se copia los normales al auxiliar
	inicialNCaux=("${inicialNC[@]}")
	finalNCaux=("${finalNC[@]}")
	if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 4 ]]; then #Para Prioridades
		echo -e " ┌─────┬─────┬─────┬─────┬─────┬──────┬──────┬──────┬──────┬──────┬───────────────────┐" | tee -a $informeConColorTotal
		echo -e " │ Ref │ Tll │ Tej │ Mem │ Pri │ TEsp │ Tret │ Trej │ Mini │ Mfin │ Estado            │" | tee -a $informeConColorTotal
		echo -e " ├─────┼─────┼─────┼─────┼─────┼──────┼──────┼──────┼──────┼──────┼───────────────────┤" | tee -a $informeConColorTotal
		echo -e " ┌─────┬─────┬─────┬─────┬─────┬──────┬──────┬──────┬──────┬──────┬───────────────────┐"     >> $informeSinColorTotal
		echo -e " │ Ref │ Tll │ Tej │ Mem │ Pri │ TEsp │ Tret │ Trej │ Mini │ Mfin │ Estado            │"     >> $informeSinColorTotal
		echo -e " ├─────┼─────┼─────┼─────┼─────┼──────┼──────┼──────┼──────┼──────┼───────────────────┤"     >> $informeSinColorTotal
		m=0 #Se aplica el $m a memoria inicial y memoria final (los auxiliares que son los que se imprimen en el volcado)
		for (( i=0; i<$nprocesos; i++ )) ; do  #Se usa m porque i recorre los procesos y m controla las unidades usadas por cada proceso, normalmente 0 o 1, y también las unidades de los n trozos de memoria asociados a cada proceso.
			echo -e " │ ${varC[$i]}${proceso[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#llegada[$i]})${varC[$i]}${llegada[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#ejecucion[$i]})${varC[$i]}${ejecucion[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#memoria[$i]})${varC[$i]}${memoria[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#prioProc[$i]})${varC[$i]}${prioProc[$i]}$NC │"\
			"$(imprimirEspaciosAnchos ${#temp_wait[$i]})${varC[$i]}${temp_wait[$i]}$NC │"\
			"$(imprimirEspaciosAnchos ${#temp_ret[$i]})${varC[$i]}${temp_ret[$i]}$NC │"\
			"$(imprimirEspaciosAnchos ${#temp_rej[$i]})${varC[$i]}${temp_rej[$i]}$NC │"\
			"$(imprimirEspaciosAnchos ${#inicialNCaux[$m]})${varC[$i]}${inicialNCaux[$m]}$NC │"\
			"$(imprimirEspaciosAnchos ${#finalNCaux[$m]})${varC[$i]}${finalNCaux[$m]}$NC │"\
			"${varC[$i]}${estado[$i]}""$(imprimirEspaciosMuyAnchos ${#estado[$i]})$NC │" | tee -a $informeConColorTotal
			echo -e " │ ${proceso[$i]} │"\
			"$(imprimirEspaciosEstrechosBN ${#llegada[$i]})${llegada[$i]} │"\
			"$(imprimirEspaciosEstrechosBN ${#ejecucion[$i]})${ejecucion[$i]} │"\
			"$(imprimirEspaciosEstrechosBN ${#memoria[$i]})${memoria[$i]} │"\
			"$(imprimirEspaciosEstrechosBN ${#prioProc[$i]})${prioProc[$i]} │"\
			"$(imprimirEspaciosAnchosBN ${#temp_wait[$i]})${temp_wait[$i]} │"\
			"$(imprimirEspaciosAnchosBN ${#temp_ret[$i]})${temp_ret[$i]} │"\
			"$(imprimirEspaciosAnchosBN ${#temp_rej[$i]})${temp_rej[$i]} │"\
			"$(imprimirEspaciosAnchosBN ${#inicialNCaux[$m]})${inicialNCaux[$m]} │"\
			"$(imprimirEspaciosAnchosBN ${#finalNCaux[$m]})${finalNCaux[$m]} │"\
			"${estado[$i]}""$(imprimirEspaciosMuyAnchosBN ${#estado[$i]}) │" >> $informeSinColorTotal
			m=$((m+1))
			for (( b=1; b<${bloques[$i]}; b++ )) ; do
				echo -ne " │     │     │     │     │     │      │      │      │ $(imprimirEspaciosAnchos ${#inicialNCaux[$m]})${varC[$i]}${inicialNCaux[$m]}$NC │ " | tee -a $informeConColorTotal
				echo -e "$(imprimirEspaciosAnchos       ${#finalNCaux[$m]})${varC[$i]}${finalNCaux[$m]}$NC │                   │" | tee -a $informeConColorTotal
				echo -ne " │     │     │     │     │     │      │      │      │ $(imprimirEspaciosAnchosBN ${#inicialNCaux[$m]})${inicialNCaux[$m]} │ " >> $informeSinColorTotal
				echo -e "$(imprimirEspaciosAnchosBN       ${#finalNCaux[$m]})${finalNCaux[$m]} │                   │ " >> $informeSinColorTotal
				m=$((m+1))
			done
		done
		echo " └─────┴─────┴─────┴─────┴─────┴──────┴──────┴──────┴──────┴──────┴───────────────────┘" | tee -a $informeConColorTotal
		echo " └─────┴─────┴─────┴─────┴─────┴──────┴──────┴──────┴──────┴──────┴───────────────────┘">> $informeSinColorTotal
	else #Para FCFS/SJF/SRPT/Round-Robin
		echo -e " ┌─────┬─────┬─────┬─────┬──────┬──────┬──────┬──────┬──────┬───────────────────┐" | tee -a $informeConColorTotal
		echo -e " │ Ref │ Tll │ Tej │ Mem │ TEsp │ Tret │ Trej │ Mini │ Mfin │ Estado            │" | tee -a $informeConColorTotal
		echo -e " ├─────┼─────┼─────┼─────┼──────┼──────┼──────┼──────┼──────┼───────────────────┤" | tee -a $informeConColorTotal
		echo -e " ┌─────┬─────┬─────┬─────┬──────┬──────┬──────┬──────┬──────┬───────────────────┐"     >> $informeSinColorTotal
		echo -e " │ Ref │ Tll │ Tej │ Mem │ TEsp │ Tret │ Trej │ Mini │ Mfin │ Estado            │"     >> $informeSinColorTotal
		echo -e " ├─────┼─────┼─────┼─────┼──────┼──────┼──────┼──────┼──────┼───────────────────┤"     >> $informeSinColorTotal
		m=0 #Se aplica el $m a memoria inicial y memoria final (los auxiliares que son los que se imprimen en el volcado)
		for (( i=0; i<$nprocesos; i++ )) ; do  #Se usa m porque i recorre los procesos y m controla las unidades usadas por cada proceso, normalmente 0 o 1, y también las unidades de los n trozos de memoria asociados a cada proceso.
			echo -e " │ ${varC[$i]}${proceso[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#llegada[$i]})${varC[$i]}${llegada[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#ejecucion[$i]})${varC[$i]}${ejecucion[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#memoria[$i]})${varC[$i]}${memoria[$i]}$NC │"\
			"$(imprimirEspaciosAnchos ${#temp_wait[$i]})${varC[$i]}${temp_wait[$i]}$NC │"\
			"$(imprimirEspaciosAnchos ${#temp_ret[$i]})${varC[$i]}${temp_ret[$i]}$NC │"\
			"$(imprimirEspaciosAnchos ${#temp_rej[$i]})${varC[$i]}${temp_rej[$i]}$NC │"\
			"$(imprimirEspaciosAnchos ${#inicialNCaux[$m]})${varC[$i]}${inicialNCaux[$m]}$NC │"\
			"$(imprimirEspaciosAnchos ${#finalNCaux[$m]})${varC[$i]}${finalNCaux[$m]}$NC │"\
			"${varC[$i]}${estado[$i]}""$(imprimirEspaciosMuyAnchos ${#estado[$i]})$NC │" | tee -a $informeConColorTotal
			echo -e " │ ${proceso[$i]} │"\
			"$(imprimirEspaciosEstrechosBN ${#llegada[$i]})${llegada[$i]} │"\
			"$(imprimirEspaciosEstrechosBN ${#ejecucion[$i]})${ejecucion[$i]} │"\
			"$(imprimirEspaciosEstrechosBN ${#memoria[$i]})${memoria[$i]} │"\
			"$(imprimirEspaciosAnchosBN ${#temp_wait[$i]})${temp_wait[$i]} │"\
			"$(imprimirEspaciosAnchosBN ${#temp_ret[$i]})${temp_ret[$i]} │"\
			"$(imprimirEspaciosAnchosBN ${#temp_rej[$i]})${temp_rej[$i]} │"\
			"$(imprimirEspaciosAnchosBN ${#inicialNCaux[$m]})${inicialNCaux[$m]} │"\
			"$(imprimirEspaciosAnchosBN ${#finalNCaux[$m]})${finalNCaux[$m]} │"\
			"${estado[$i]}""$(imprimirEspaciosMuyAnchosBN ${#estado[$i]}) │" >> $informeSinColorTotal
			m=$((m+1))
			for (( b=1; b<${bloques[$i]}; b++ )) ; do
				echo -ne " │     │     │     │     │      │      │      │ $(imprimirEspaciosAnchos ${#inicialNCaux[$m]})${varC[$i]}${inicialNCaux[$m]}$NC │ " | tee -a $informeConColorTotal
				echo -e "$(imprimirEspaciosAnchos ${#finalNCaux[$m]})${varC[$i]}${finalNCaux[$m]}$NC │                   │" | tee -a $informeConColorTotal
				echo -ne " │     │     │     │     │      │      │      │ $(imprimirEspaciosAnchosBN ${#inicialNCaux[$m]})${inicialNCaux[$m]} │ " >> $informeSinColorTotal
				echo -e "$(imprimirEspaciosAnchosBN ${#finalNCaux[$m]})${finalNCaux[$m]} │                   │ " >> $informeSinColorTotal
				m=$((m+1))
			done
		done
		echo " └─────┴─────┴─────┴─────┴──────┴──────┴──────┴──────┴──────┴───────────────────┘" | tee -a $informeConColorTotal
		echo " └─────┴─────┴─────┴─────┴──────┴──────┴──────┴──────┴──────┴───────────────────┘">> $informeSinColorTotal
	fi
	#CALCULAR Y REPRESENTAR LOS PROMEDIOS
	dividir=0
	for (( i=0; i<nprocesos; i++ )) ; do
		if [[ ${estad[$i]} -ne 0 ]] ; then
			dividir=$((dividir+1))
		fi
	done
	promedio_espera=0.0
	promedio_respuesta=0.0
	suma_espera=0
	suma_respuesta=0

	for (( i=0; i<nprocesos; i++ )); do
		tam=${memoria[$i]};
		if [[ ${estad[$i]} -ne 0 && $tam -le $mem_total ]]; then #Si el tamaño del proceso es menor o igual que el de memoria
			suma_espera=$[$suma_espera + ${temp_wait[$i]} ]            #suma para sacar su promedio
			promedio_espera=$(echo "scale=2; $suma_espera/$dividir" | bc)  #promedio
			suma_respuesta=$[ $suma_respuesta + ${temp_ret[$i]} ]   #suma para sacar su promedio
			promedio_respuesta=$(echo "scale=2; $suma_respuesta/$dividir" | bc)  #promedio
		fi
	done
	var_uno=1
	echo -e "\tT.espera medio: $promedio_espera$NC\t      T.respuesta medio: $promedio_respuesta$NC\n" | tee -a $informeConColorTotal
	echo -e "\tT.espera medio: $promedio_espera\t       T.respuesta medio: $promedio_respuesta\n" >> ./$informeSinColorTotal

	if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 5 ]]; then
		dibujaColaRR #Se representa la cola de procesos de Round-Robin 
		echo "$DatosColaRR"
	fi
} #Final de dibujar la banda de tiempos - dibujarTablaDatos()

####################################################################################
# Sinopsis: Muestra la cola de procesos de Round-Robin (RR).
####################################################################################
function dibujaColaRR {	#colaTiempoRR		
	ejecutandoinst=-1
	DatosColaRR=" Cola de Round-Robin: "
	for (( contadorRR=0; contadorRR<${#llegada[@]} ; contadorRR++ )); do
		if [[ ${estad[$contadorRR]} -eq 3 ]]; then #Se localiza el proceso en ejecución.
			ejecutandoinst=$contadorRR
		fi
	done
	for (( contadorRRorden=$indiceColaTiempoRREnEjecucion; contadorRRorden<$indiceColaTiempoRRLibre ; contadorRRorden++ )); do
		for (( contadorRR=0; contadorRR<${#llegada[@]} ; contadorRR++ )); do
			if [[ $ejecutandoinst -ne -1 && $ejecutandoinst -ne $contadorRR ]]; then #Si hay procesos en ejecución, se puede buscar el orden de RR del resto de procesos.
				if [[ ${colaTiempoRR[$contadorRR]} -eq $contadorRRorden ]]; then
					if [[ ${estad[$contadorRR]} -eq 2 || ${estad[$contadorRR]} -eq 4 ]]; then
						DatosColaRR="$DatosColaRR${proceso[$contadorRR]} / "
					fi
				fi
			fi
		done
	done
#    clear 
} #Fin de dibujaColaRR()

####################################################################################
# Sinopsis: Sacar procesos terminados de memoria y actualizar variables de la Banda de Memoria.
####################################################################################
function calculosActualizarVariablesBandaMemoria {
	#Sucesión: sacar procesos, actualizar variables de memoria guardadoMemoria y tamanoGuardadoMemoria
	for (( po=0; po<$nprocesos; po++ )); do #Se libera espacio en memoria de los procesos recien terminados.
		if [[ ${enmemoria[$po]} == 0 && ${escrito[$po]} == 1 ]]; then
			for (( ra=0; ra<$mem_total; ra++ )); do
				if [[ ${unidMemOcupadas[$ra]} == $po ]]; then
					unidMemOcupadas[$ra]="_"
				fi
			done
			escrito[$po]=0
		fi
	done
	for (( po=0; po<$nprocesos; po++ )); do #Si los procesos ya no están en memoria se eliminan de la variable guardadoMemoria.
		if [[ ${enmemoria[$po]} -ne 1 ]]; then
			for (( i=0; i<${#guardadoMemoria[@]} ; i++ )); do
				if [[ ${guardadoMemoria[$i]} -eq $po ]]; then
					unset guardadoMemoria[$i]
					unset tamanoGuardadoMemoria[$i]
				fi
			done
		fi
	done
	guardadoMemoria=( "${guardadoMemoria[@]}" ) #Se eliminan los huecos vacíos que genera el unset
	tamanoGuardadoMemoria=( "${tamanoGuardadoMemoria[@]}" ) #Se eliminan los huecos vacíos que genera el unset
} #Fin de calculosActualizarVariablesBandaMemoria()

####################################################################################
# Sinopsis: Se realizan los cálculos necesarios para la impresión de la banda de memoria en los volcados.
####################################################################################
function calculosReubicarYMeterProcesosBandaMemoria_ORI {
	#Sucesión: Se genera una lista secuencial de procesos en guardadoMemoria y tamanoGuardadoMemoria, se comprueba si hay espacio suficiente en la memoria dependiendo de
	#la continuidad y reubicabilidad definidas, y si lo hay, se mete el proceso.
echo "00000 - 1-0-6 - evento= "$evento
	if [[ $mem_libre -gt 0 ]]; then
echo "00000 - 1-0-7 - evento= "$evento
		if [[ $reubicarReubicabilidad -eq 1 || $reubicarContinuidad -eq 1 ]]; then #Si hay que reubicar, se hace.
			for (( gm=0 ; gm<${#tamanoGuardadoMemoria[@]} ; gm++ )); do #Se reubican los procesos existentes en la memoria en el mismo orden.
echo "00000 - 1-0-8 - evento= "$evento
				ud=0 #ud contador que guarda las unidades que se van guardando (ud < total)
				ra=0
				while [[ $ud -lt ${tamanoGuardadoMemoria[$gm]} ]]; do  #Se reescriben todos los números de proceso en unidMemOcupadasAux (menor y no menor o igual, ya que se empieza en 0)
echo "00000 - 1-0-9 - evento= "$evento
					if [[ ${unidMemOcupadasAux[$ra]} == "_" ]]; then #Se marca con el proceso que ocupa la posición de memoria.
						unidMemOcupadasAux[$ra]=${guardadoMemoria[$gm]}
						ud=$((ud+1))
					fi
					escrito[${guardadoMemoria[$gm]}]=1 #Se marca que ya se ha escrito en memoria.
					ra=$((ra+1))
				done
			done
			unidMemOcupadas=("${unidMemOcupadasAux[@]}") #Se copia la memoria auxiliar a la original para que después se escriba en memoria.
			#Notificamos que se ha reubicado.
			echo -e " La memoria ha sido reubicada." $NC | tee -a $informeConColorTotal
			echo -e " La memoria ha sido reubicada." >> $informeSinColorTotal
		fi
	fi
} #Fin de calculosReubicarYMeterProcesosBandaMemoria_ORI()

####################################################################################
# Sinopsis: Se reubica la memoria.
####################################################################################
function calculosReubicarYMeterProcesosBandaMemoria {
	#Sucesión: Se genera una lista secuencial de procesos en guardadoMemoria y tamanoGuardadoMemoria, se comprueba si hay espacio suficiente en la memoria dependiendo de la continuidad y reubicabilidad definidas, y si lo hay, se mete el proceso.
	if [[ $mem_libre -gt 0 ]]; then 
		if [[ $reubicarReubicabilidad -eq 1 || $reubicarContinuidad -eq 1 ]]; then #Si hay que reubicar, se hace.
			ra=0 #Contador del número de marcos ocupados cuando está reubicando procesos
			for (( gm=0 ; gm<${#tamanoGuardadoMemoria[@]} ; gm++ )); do #Se reubican los procesos existentes en la memoria en el mismo orden.
				ud=0 #Contador con las unidades que se van guardando (ud < total)
				while [[ $ud -lt ${tamanoGuardadoMemoria[$gm]} ]]; do  #Se reescriben todos los números de proceso en unidMemOcupadasAux (menor y no menor o igual, ya que se empieza en 0) 
					unidMemOcupadasAux[$ra]=${guardadoMemoria[$gm]}  
					ud=$((ud+1))
					ra=$((ra+1))
				done
				escrito[${guardadoMemoria[$gm]}]=1 #Se marca que ya se ha escrito en memoria.
			done
			unidMemOcupadas=("${unidMemOcupadasAux[@]}") #Se copia la memoria auxiliar a la original para que se después se escriba en memoria.
			#Se notifica que se ha reubicado.
			if [[ $cierreMensajeReub -eq 1 ]]; then #Permitirá que se imprima el mensaje de reubicacón una única vez.
				echo -e " La memoria ha sido reubicada." $NC | tee -a $informeConColorTotal
				echo -e " La memoria ha sido reubicada." >> $informeSinColorTotal
				cierreMensajeReub=0 #Permitirá que se imprima el mensaje de reubicacón una única vez. Y como ya se ha imprimido, no lo permitirá de nuevo hasta que no se pase de unidad de tiempo.
			fi
		fi
	fi
} #Fin de calculosReubicarYMeterProcesosBandaMemoria()

####################################################################################
# Sinopsis: Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
####################################################################################
function tratarRangoPrioridadesDirecta {
	invertirDatoPrioridadesInversa=0 #Será 1 cuando se determine un rango de prioridades cuyo mínimo sea mayor que su máximo.
	if [[ $1 -gt $2 ]]; then
		aux=$1
		PriomFinal=$2
		PrioMFinal=$aux
		invertirDatoPrioridadesInversa=1 #Será 1 cuando se determine un rango de prioridades cuyo mínimo sea mayor que su máximo.
	else
		PriomFinal=$1
		PrioMFinal=$2
	fi
} #Fin de calculosReubicarYMeterProcesosBandaMemoria()

######################################################################
# Sinopsis: Guardar los procesos que van entrando en memoria de forma secuencial en la variable guardadoMemoria
# y sus tamaños en tamanoGuardadoMemoria
#######################################################################
function crearListaSecuencialProcesosAlEntrarMemoria {
	unset guardadoMemoria #Vaciamos el array anterior
	unset tamanoGuardadoMemoria #Vaciamos el array anterior
	for (( ra=0; ra<$mem_total; ra++ )); do #Determinará qué procesos están en memoria.
		if [[ ${unidMemOcupadas[$ra]} != "_" ]]; then
			numeroProbar=${unidMemOcupadas[$ra]}
			permiso=1
			for (( i=0; i<${#guardadoMemoria[@]} ; i++ )); do #Si el proceso ya está en memoria, no hace falta meterlo.
				if [[ ${guardadoMemoria[$i]} -eq $numeroProbar ]]; then
					permiso=0
				fi
			done
			if [[ $permiso -eq 1 ]]; then #Permiso es la variable que permite meter un proceso en memoria porque haya espacio suficiente.
				guardadoMemoria=("${guardadoMemoria[@]}" "$numeroProbar") #Guarda el número de proceso que va a meter en memoria.
				tamanoGuardadoMemoria=("${tamanoGuardadoMemoria[@]}" "${memoria[$numeroProbar]}") #Guarda el tamaño del proceso que va a meter en memoria.
				permiso=0
			fi
		fi
	done
} #Fin de crearListaSecuencialProcesosAlEntrarMemoria()

##############################################################################################################################################
##############################################################################################################################################
# Sinopsis: Funciones para el desarrollo ORIGINAL de la reubicabilidad e introducción de proecsos en memoria. NO SE USA A LA ESPERA DE VALIDAR LAS OTRAS FUNCIONES QUE LA SUSTITUYEN.
#######################################################################
# Sinopsis: Comprueba que cada hueco en memoria no es mayor que la variable definida, para decidir si se reubica.
#######################################################################
function comprobacionSiguienteProcesoParaReubicar {
	#Sucesión: Se determina qué proceso es el siguiente en entrar en memoria, y dependiendo de la continuidad y reubicabilidad definidas, se establece si hay espacio en memoria.
	noCabe0Cabe1=1 #Variable para no permitir meter procesos en memoria bajo ciertas condiciones relacionadas con la continuidad.
	encontradoHuecoMuyReducido=0
	primeraUnidadFuturoProcesoSinreubicar=-1
	raInicioProceso=-1
	reubicarReubicabilidad=0 #En caso de ser memoria no continua, si hay un hueco demasiado pequeño, y se va a usar como parte de la memoria a usar.
	reubicarContinuidad=0 #En caso de ser memoria continua, si no hay un hueco suficientemente grande en el que quepa pero sí en la suma de todos ellos.
	contadorReubicar=-1
	contadorReubicarTotal=0
	siguienteProcesoAMeter=-1
	for (( po=0; po<$nprocesos; po++ )) ; do #Metemos un proceso y comprobamos si hay que reubicar
		if [[ ${enmemoria[$po]} -eq 1 && ${escrito[$po]} -eq 0 ]]; then #Si está para entrar en memoria y no está dentro se mete, y si ya está dentro se ignora.
			siguienteProcesoAMeter=$po
			break
		fi
	done
	if [[ $siguienteProcesoAMeter -eq -1 ]]; then
		for (( po=0; po<$nprocesos; po++ )) ; do #Metemos un proceso y comprobamos si hay que reubicar
			if [[ ${encola[$po]} -eq 1 && ${enmemoria[$po]} -eq 0 && ${escrito[$po]} -eq 0 ]]; then #Si está para entrar en memoria y no está dentro se mete, y si ya está dentro se ignora.
				siguienteProcesoAMeter=$po
				break
			fi
		done
	fi
	if [[ $mem_libre -gt 0 ]]; then
		for (( ra=0; ra<$mem_total; ra++ )); do
#			if [[ ${unidMemOcupadas[$ra]} == "_" && siguienteProcesoAMeter -gt -1 ]]; then
			if [[ ${unidMemOcupadas[$ra]} == "_" && siguienteProcesoAMeter -ne -1 ]]; then
				if [[ $contadorReubicar -eq -1 ]]; then #Se designa la primera unidad sobre la que meter el proceso si entrara en memoria continua.
					contadorReubicar=0
					raInicioProceso=$ra
				fi
				contadorReubicar=$((contadorReubicar + 1))
				contadorReubicarTotal=$((contadorReubicarTotal + 1))
				if [[ $contadorReubicar -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $primeraUnidadFuturoProcesoSinreubicar -eq -1 ]]; then
					#8 - Si cabe en un único hueco en memoria continua.
					primeraUnidadFuturoProcesoSinreubicar=$raInicioProceso
					break
				fi
#			elif [[ ${unidMemOcupadas[$ra]} != "_" && siguienteProcesoAMeter -ne -1 ]]; then
			elif [[ ${unidMemOcupadas[$ra]} != "_" || $ra -eq $((mem_total - 1)) ]] && [[ siguienteProcesoAMeter -ne -1 ]]; then #Si se llega a una unidad de memoria ocupada o al final de la memoria.
if [[ $continuidadNo0Si1 -ne 1 && $reubicabilidadNo0Si1 -ne 1 ]]; then #Salvo con Continuo y Reubicable en cuyo caso, debería seguir buscando un hueco único con espacio suficiente hasta el último marco.
					if [[ $contadorReubicar -ne -1 && $contadorReubicar -le $variableReubicar && $reubicabilidadNo0Si1 -eq 1 ]]; then
						#Si encuentra un hueco demasiado pequeño mientras busca hueco suficiente y puede caber en la totalidad de los huecos, en memoria no continua.
						encontradoHuecoMuyReducido=1
					fi
fi
				contadorReubicar=-1
			fi
		done
#        if [[ $contadorReubicarTotal -lt ${memoria[$siguienteProcesoAMeter]} ]]; then #No necesario
#            #1 - 3 - 6 - 9 - No cabe - Ya se considera cuando se resta el tamaño de memoria del proceso a introducir (memoria[$siguienteProcesoAMeter]) de la memoria libre (mem_libre) y comprueba >=0 en comprobacionSiguienteProcesoParaMeterMemoria()
#            noCabe0Cabe1=0
#            reubicarContinuidad=0
#            reubicarReubicabilidad=0
#        fi
#        if [[ $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $encontradoHuecoMuyReducido -eq 0 && $contadorReubicarTotal -gt ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 0 ]]; then #No necesario
#            #2 - Lo meterá en memoria a trozos.
#            noCabe0Cabe1=1
#            reubicarContinuidad=0
#            reubicarReubicabilidad=0
#        fi
#        if [[ $contadorReubicarTotal -lt ${memoria[$siguienteProcesoAMeter]} && $encontradoHuecoMuyReducido -eq 0 && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]; then #No necesario
#            #4 -
#            noCabe0Cabe1=1
#            reubicarContinuidad=0
#            reubicarReubicabilidad=0
#        fi
#        if [[ $contadorReubicarTotal -lt ${memoria[$siguienteProcesoAMeter]} && $primeraUnidadFuturoProcesoSinreubicar -ne -1 && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0 ]]; then #No necesario
#            #7 -
#            noCabe0Cabe1=0 - No cabe - Ya se considera cuando se resta el tamaño de memoria del proceso a introducir (memoria[$siguienteProcesoAMeter]) de la memoria libre (mem_libre) y comprueba >=0 en comprobacionSiguienteProcesoParaMeterMemoria()
#            reubicarContinuidad=0
#            reubicarReubicabilidad=0
#        fi
#        if [[ $primeraUnidadFuturoProcesoSinreubicar -ne -1  && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0]]; then #No necesario
#            #8 -
#            noCabe0Cabe1=1
#            reubicarContinuidad=0
#            reubicarReubicabilidad=0
#        fi
#        if [[ $primeraUnidadFuturoProcesoSinreubicar -ne -1 && $encontradoHuecoMuyReducido -eq 0 && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 1 ]]; then #No necesario
#            #10 -
#            noCabe0Cabe1=1
#            reubicarContinuidad=0
#            reubicarReubicabilidad=0
#        fi
		if [[ $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} && $encontradoHuecoMuyReducido -eq 1 && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]; then
			reubicarReubicabilidad=1 #5 - Si encuentra un hueco demasiado pequeño mientras busca hueco suficiente y puede caber en un hueco, en memoria no continua.
		fi
		if [[ $primeraUnidadFuturoProcesoSinreubicar -gt -1 && $encontradoHuecoMuyReducido -eq 1 && $reubicabilidadNo0Si1 -eq 1 ]]; then
			reubicarReubicabilidad=0 #11 - Si encuentra un hueco demasiado pequeño mientras busca hueco suficiente y puede caber en un hueco, en memoria no continua.
		fi #No haría falta, porque se metería, pero se considera. Y en caso de encontradoHuecoMuyReducido=0 ta,bién lo metería.
		if [[ $siguienteProcesoAMeter != -1 ]]; then #
			if [[ $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 1 ]] ; then
				reubicarContinuidad=1 #12 - Si no cabe en un único hueco, pero sí en la suma de ellos, en memoria continua.
			fi
		fi
		if [[ $siguienteProcesoAMeter != -1 ]]; then #
			if [[ $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0 ]] ; then
				noCabe0Cabe1=0 #8 - Si no cabe en un único hueco, pero sí en la suma de ellos, en memoria continua.
			fi
		fi
	else
		noCabe0Cabe1=0
	fi
	#Memoria No Continua
		#Memoria No Reubicable
			#1 - Si no cabe entre todos los huecos, no lo meterá en memoria.
			#2 - OK - Si cabe entre todos los huecos, lo meterá en memoria a trozos.
		#Memoria Reubicable
			#3 - Si no cabe entre todos los huecos, no reubica, ni lo meterá en memoria.
			#4 - OK - Si cabe entre todos los huecos, y mientras busca no encuentra un hueco demasiado pequeño, no reubica y lo meterá en memoria a trozos.
			#5 - Hecho - Si cabe entre todos los huecos, y mientras busca encuentra un hueco demasiado pequeño, reubica y lo meterá en memoria.
	#Memoria Continua
		#Memoria No Reubicable
			#6 - Si no cabe entre todos los huecos, no lo meterá en memoria.
			#7 - OK - Si cabe entre todos los huecos, pero no cabe en un único hueco, no lo meterá en memoria.
			#8 - Hecho - Si cabe en un único hueco, lo meterá en memoria.
		#Memoria Reubicable
			#9 - Si no cabe entre todos los huecos, no reubica, ni lo meterá en memoria.
			#10 - OK - Si cabe en un único hueco, y mientras busca no encuentra un hueco demasiado pequeño, no reubica y lo meterá en memoria.
			#11 - Hecho - Si cabe en un único hueco, y mientras busca encuentra un hueco demasiado pequeño, NO reubica y lo meterá en memoria.
			#12 - Hecho - Si cabe entre todos los huecos, pero no en un único hueco, reubica y lo meterá en memoria.
} #Fin de comprobacionSiguienteProcesoParaReubicar()

#######################################################################
# Sinopsis: Comprueba que cada hueco en memoria es suficiente para meter un proceso en memoria.
#######################################################################
function comprobacionSiguienteProcesoParaMeterMemoria {
	if [[ $mem_libre -gt 0 && reubicarReubicabilidad -ne 1 && reubicarContinuidad -ne 1 ]]; then
		mem_libreTemp=$mem_libre
		primeraUnidadFuturoProcesoSinreubicar=-1 #No se debería definir porque es un valor arrastrado desde la comprobación en comprobacionSiguienteProcesoParaReubicar()
		#El for se resuelve con i=$po de la línea anterior a la llamada de la función.
		if [[ ${encola[$i]} -eq 1 && ${enmemoria[$i]} -eq 0 ]]; then #Si están en cola pero no en memoria (en espera)
			noCabe0Cabe1=1 #Variable para no permitir meter procesos en memoria bajo ciertas condiciones relacionadas con la continuidad.
			encontradoHuecoMuyReducido=0
			raInicioProceso=-1
			contadorMeterMemoria=-1
			contadorMeterMemoriaTotal=0
			siguienteProcesoAMeter=$i
			if [[ $((mem_libreTemp - ${memoria[$i]})) -ge 0 ]]; then
				noCabe0Cabe1=1
				for (( ra=0; ra<$mem_total; ra++ )); do
					if [[ ${unidMemOcupadas[$ra]} == "_" && siguienteProcesoAMeter -gt -1 ]]; then
						if [[ $contadorMeterMemoria -eq -1 ]]; then #Se designa la primera unidad sobre la que meter el proceso si entrara en memoria continua.
							contadorMeterMemoria=0
							raInicioProceso=$ra
						fi
						contadorMeterMemoria=$((contadorMeterMemoria + 1))
						contadorMeterMemoriaTotal=$((contadorMeterMemoriaTotal + 1))
						if [[ $contadorMeterMemoria -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $primeraUnidadFuturoProcesoSinreubicar -eq -1 ]]; then
							#8 - Si cabe en un único hueco en memoria continua.
							primeraUnidadFuturoProcesoSinreubicar=$raInicioProceso
						fi
					elif [[ ${unidMemOcupadas[$ra]} != "_" && siguienteProcesoAMeter -ne -1 ]]; then
						if [[ $contadorMeterMemoria -ne -1 && $contadorMeterMemoria -le $variableReubicar && $reubicabilidadNo0Si1 -eq 1 ]]; then
							#Si encuentra un hueco demasiado pequeño mientras busca hueco suficiente y puede caber en la totalidad de los huecos, en memoria no continua.
							encontradoHuecoMuyReducido=1
						fi
						contadorMeterMemoria=-1
					fi
				done
				if [[ $siguienteProcesoAMeter != -1 ]]; then #
					if [[ $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0 ]] ; then
						noCabe0Cabe1=0 #8 - Si no cabe en un único hueco, pero sí en la suma de ellos, en memoria continua.
					fi
					if [[ $siguienteProcesoAMeter != -1 && $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0 ]] ; then
						noCabe0Cabe1=0 #8 - Si no cabe en un único hueco, pero sí en la suma de ellos, en memoria continua.
					fi
				fi
				#Este if es fundamental para generar las excepciones sobres si se reubica o no, y sobre la unidad de memoria donde empezar a meter el proceso.
				if [[ $primeraUnidadFuturoProcesoSinreubicar -ne -1 ||
				$primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $encontradoHuecoMuyReducido -eq 1 && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ||
				$primeraUnidadFuturoProcesoSinreubicar -gt -1 && $encontradoHuecoMuyReducido -eq 1 && $reubicabilidadNo0Si1 -eq 1 ||
				$primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 1 ||
				$primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 0 ||
				$primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]; then
					if [[ $((mem_libreTemp - ${memoria[$i]})) -ge 0 ]]; then
						mem_libreTemp=`expr $mem_libreTemp - ${memoria[$i]}`
						avisoentrada[$i]=1
						evento=1
						enmemoria[$i]=1
						realizadoAntes=0
						noCabe0Cabe1=1
					else
						noCabe0Cabe1=0
					fi
				fi
			else
				noCabe0Cabe1=0
			fi
		fi
	else
		noCabe0Cabe1=0
	fi
	for (( j=$i; j<$nprocesos; j++ )); do #Bucle para bloquear los procesos
		bloqueados[$j]=1
	done
	#Memoria No Continua
		#Memoria No Reubicable
			#1 - Si no cabe entre todos los huecos, no lo meterá en memoria.
			#2 - OK - Si cabe entre todos los huecos, lo meterá en memoria a trozos.
		#Memoria Reubicable
			#3 - Si no cabe entre todos los huecos, no reubica, ni lo meterá en memoria.
			#4 - OK - Si cabe entre todos los huecos, y mientras busca no encuentra un hueco demasiado pequeño, no reubica y lo meterá en memoria a trozos.
			#5 - Hecho - Si cabe entre todos los huecos, y mientras busca encuentra un hueco demasiado pequeño, reubica y lo meterá en memoria.
	#Memoria Continua
		#Memoria No Reubicable
			#6 - Si no cabe entre todos los huecos, no lo meterá en memoria.
			#7 - OK - Si cabe entre todos los huecos, pero no cabe en un único hueco, no lo meterá en memoria.
			#8 - Hecho - Si cabe en un único hueco, lo meterá en memoria.
		#Memoria Reubicable
			#9 - Si no cabe entre todos los huecos, no reubica, ni lo meterá en memoria.
			#10 - OK - Si cabe en un único hueco, y mientras busca no encuentra un hueco demasiado pequeño, no reubica y lo meterá en memoria.
			#11 - Hecho - Si cabe en un único hueco, y mientras busca encuentra un hueco demasiado pequeño, reubica y lo meterá en memoria.
			#12 - Hecho - Si cabe entre todos los huecos, pero no en un único hueco, reubica y lo meterá en memoria.
} #Fin de comprobacionSiguienteProcesoParaMeterMemoria()

##############################################################################################################################################
##############################################################################################################################################
# Sinopsis: Funciones para el desarrollo CONDICIONADO de la reubicabilidad e introducción de proecsos en memoria
#######################################################################
# Sinopsis: Comprueba si los huecos en memoria se ajustan a la continuidad y reubicabilidad, para decidir si se reubica. 
#######################################################################
function comprobacionSiguienteProcesoParaReubicarCondicionada {
	#Sucesión: Se determina qué proceso será el siguiente en entrar en memoria, y dependiendo de la continuidad y reubicabilidad definidas, se establece si hay espacio en memoria. 
	noCabe0Cabe1=1 #Variable para no permitir meter procesos en memoria bajo ciertas condiciones relacionadas con la continuidad. 
	encontradoHuecoMuyReducidoInicial=0 #Sólo controla si el hueco que se está analizando es, hasta el momento de análisis, menor que el límite establecido.
	encontradoHuecoMuyReducido=0 #Controlará si el hueco o la suma de huecos es menor que el límite cuando se alcance el tamaño del proceso a meter.
	primeraUnidadFuturoProcesoSinreubicar=-1 #Primer marco vacío, en uno o en varios huecos
	raInicioProcesoBase=-1
	raInicioProcesoBaseContinuo=-1
	raInicioProcesoBaseNoContinuo=-1
	reubicarReubicabilidad=0 #En caso de ser memoria no continua, si hay un hueco demasiado pequeño, y se va a usar como parte de la memoria a usar.
	reubicarContinuidad=0 #En caso de ser memoria continua, si no hay un hueco suficientemente grande en el que quepa pero sí en la suma de todos ellos.
	contadorReubicar=-1 #Contiene el tamaño del hueco actual que se está localizando, mirando marco a marco.
	contadorReubicarTotal=0 #Contiene el tamaño del hueco total que se está localizando como suma de todos los huecos que se están localizando, mirando marco a marco.
	contadorReubicarHueco=0 #Contiene el tamaño del hueco que se está tratando cuando se llega al tamaño del proceso, para ver si el último marco está en un hueco pequeño.
	siguienteProcesoAMeter=-1
	for (( po=0; po<$nprocesos; po++ )) ; do #Se determina qué proceso es el siguiente a meter en la memoria. Primero se comprueba que si hay un proceso fuera del sistema que pueda entrar en memoria de forma directa.
		if [[ ${enmemoria[$po]} -eq 1 && ${escrito[$po]} -eq 0 ]]; then #Si está para entrar en memoria y no está dentro, se mete, y si ya está dentro se ignora.
			siguienteProcesoAMeter=$po
			break
		fi 
	done
	if [[ $siguienteProcesoAMeter -eq -1 ]]; then #Y si no hay un proceso fuera del sistema que pueda entrar en memoria, se comprueba que haya uno en espera.
		for (( po=0; po<$nprocesos; po++ )) ; do #Si no hay proceso enmemoria=1 se determina qué proceso es el siguiente a meter en la memoria pero desde encola().
			if [[ ${encola[$po]} -eq 1 && ${enmemoria[$po]} -eq 0 && ${escrito[$po]} -eq 0 ]]; then #Si está "En espera", para entrar en memoria y no está dentro, se mete, y si ya está dentro se ignora.
				siguienteProcesoAMeter=$po
				break
			fi 
		done
	fi 
	if [[ siguienteProcesoAMeter -gt -1 ]]; then #Si hay procesos pendientes de introducir en memoria.
		if [[ $mem_libre -ge ${memoria[$siguienteProcesoAMeter]} ]]; then #Si hay memoria libre suficiente para meter el siguiente proceso.
#			for (( ra=0; ra<$mem_num_marcos; ra++ )); do #Caso general. En caso de no encontrar un único hueco en el que quepa, revisa los huecos para intentar reubicar. Ahora no tiene que revisar toda la memoria.
			for (( ra=0; ra<$mem_total; ra++ )); do #Caso general. En caso de no encontrar un único hueco en el que quepa, revisa los huecos para intentar reubicar. Ahora no tiene que revisar toda la memoria.
#				if [[ ${unidMemOcupadas[$ra]} != "_" || $ra -eq $((mem_num_marcos)) ]]; then #Si se encuentra un marco ocupado o si se llega al final de la memoria, y había un proceso por meter, se podría marcar como hueco pequeño encontrado, y sí se reinicia el contador para la búsqueda de un hueco único suficientemente grande
				if [[ ${unidMemOcupadas[$ra]} != "_" || $ra -eq $((mem_total)) ]]; then #Si se encuentra un marco ocupado o si se llega al final de la memoria, y había un proceso por meter, se podría marcar como hueco pequeño encontrado, y sí se reinicia el contador para la búsqueda de un hueco único suficientemente grande
					if [[ $contadorReubicar -gt 0 && $contadorReubicar -le $variableReubicar ]]; then #Si encuentra un hueco demasiado pequeño mientras busca espacio libre suficiente, se marca para reubicar y se sigue buscando más huecos, hasta verificar toda la memoria, si fuera necesario.
						encontradoHuecoMuyReducidoInicial=1 #Si encuentra un hueco demasiado pequeño mientras busca un hueco suficiente y puede caber en la totalidad de los huecos, en memoria no continua.
						raInicioProcesoBaseContinuo=-1 #Marco base en caso de ser Continua. Define el primer marco libre del hueco actual hasta encontrar un hueco suficientemente grande.
						if [[ $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 1 ]]; then #Salvo con Continuo y Reubicable en cuyo caso, debería seguir buscando un hueco único con espacio suficiente hasta el último marco.
							if [[ $raInicioProcesoBaseContinuo -eq -1 ]]; then #Si encuentra un hueco demasiado pequeño mientras busca espacio libre suficiente, se marca para reubicar y se sigue buscando más huecos, hasta verificar toda la memoria, si fuera necesario.
								raInicioProcesoBaseContinuo=$raInicioProcesoBase #Marco base en caso de ser No Continua. Define el primer marco libre.
							fi
							encontradoHuecoMuyReducido=1 #Se reubica porque la memoria es Continua.
						fi
						if [[ $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]; then #Con No Continuo y Reubicable debería seguir buscando uno o varios huecos hasta encontrar espacio suficiente hasta el último marco. Si al hacerlo encuentra un hueco demasiado pequeño, no sigue buscando y lo reubica.
							if [[ $raInicioProcesoBaseNoContinuo -eq -1 ]]; then #Si encuentra un hueco demasiado pequeño mientras busca espacio libre suficiente, se marca para reubicar y se sigue buscando más huecos, hasta verificar toda la memoria, si fuera necesario.
								raInicioProcesoBaseNoContinuo=$raInicioProcesoBase #Marco base en caso de ser No Continua. Define el primer marco libre.
							fi
							encontradoHuecoMuyReducido=1 #Se reubica porque la memoria es No Continua pero hay un hueco demasiado pequeño.
							break #Si ya se ha encontrado un hueco demasiado pequeño, no sigue buscando. Reubica y continúa metiendo procesos.
						fi
					fi
						contadorReubicar=-1 #Solo se inicializa si se encuentra otro marco ocupado, pero no si se llega al final de la memoria, para que los siguientes if trabajen bien, y no se haga una reubicación que no se necesita.
				fi
				if [[ ${unidMemOcupadas[$ra]} == "_" ]]; then #Si se van encontrando marcos libres, y hay un proceso que va a entrar en la memoria.
					if [[ $contadorReubicar -eq -1 ]]; then #Se designa la primera unidad sobre la que meter el proceso si entrara en memoria continua.
						contadorReubicar=0
						raInicioProcesoBaseContinuo=-1 #Se define para que se inicialice en cada comienzo de un nuevo hueco.
						if [[ $raInicioProcesoBase -eq -1 ]]; then 
							raInicioProcesoBase=$ra #El primer marco vacío en la memoria, por si hay más huecos y recomienza la variable $raInicioProceso
						fi
						if [[ $raInicioProcesoBaseContinuo -eq -1 ]]; then #Se define para que se inicialice en cada comienzo de un nuevo hueco.
							raInicioProcesoBaseContinuo=$ra
						fi
					fi
					if [[ $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 0 ]]; then #No Continuo y No Reubicable
						#No Continuo y No Reubicable - Si cabe en varios huecos, se introduce desde el primer marco libre.
						noCabe0Cabe1=1 #Variable para no permitir meter procesos en memoria bajo ciertas condiciones relacionadas con la continuidad. 
						primeraUnidadFuturoProcesoSinreubicar=$ra               
						break
					fi
					contadorReubicar=$((contadorReubicar + 1))
					contadorReubicarTotal=$((contadorReubicarTotal + 1))
					#8 - Continuo - Si cabe en un único hueco, se mete el proceso...
					if [[ $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0 ]]; then #Continuo y No Reubicable
						#Continuo y No Reubicable - Si cabe en un único hueco, esté donde esté, se introduce.
						if [[ $contadorReubicar -ge ${memoria[$siguienteProcesoAMeter]} ]]; then #Si ya se ha encontrado algún marco vacío, y el hueco es menor que la variable de fragmentaciónm, y si se ha optado por memoria reubicable...
							primeraUnidadFuturoProcesoSinreubicar=$raInicioProcesoBaseContinuo                
							break
						fi
					fi
					if [[ $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 1 ]]; then #Continuo y Reubicable
						#Continuo y Reubicable - Si cabe en un único hueco, esté donde esté, se introduce.
						if [[ $contadorReubicar -ge ${memoria[$siguienteProcesoAMeter]} ]]; then #Si ya se ha encontrado algún marco vacío, y el hueco es menor que la variable de fragmentaciónm, y si se ha optado por memoria reubicable...
							reubicarContinuidad=0 #11 - Si cabe en un único hueco, y mientras busca encuentra un hueco demasiado pequeño, NO reubica y lo meterá en memoria.
							primeraUnidadFuturoProcesoSinreubicar=$raInicioProcesoBaseContinuo                
							encontradoHuecoMuyReducido=0 #Se refuerza que no se reubica porque la memoria es Continua y cabe en un hueco, esté donde esté.
							break
						fi
						#Continuo y Reubicable - Si cabe en más de un hueco, se reubica y se introduce. No cabe en un único hueco ya que no ha entrado en el if anterior.
#						if [[ $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} && $ra -eq $((mem_num_marcos - 1)) ]]; then #No se consideran los huecos pequeños por ser Continua y Reubicable
						if [[ $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} && $ra -eq $((mem_total - 1)) ]]; then #No se consideran los huecos pequeños por ser Continua y Reubicable
							reubicarContinuidad=1 #12 - Si no cabe en un único hueco, pero sí en la suma de ellos, en memoria continua.
							break #Si no se ha encontrado un hueco pequeño mientras se busca hueco, se sale del buble y mete el proceso.
						fi
					fi
					if [[ $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]; then #No Continuo y Reubicable
						if [[ $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} ]]; then 
							primeraUnidadFuturoProcesoSinreubicar=$raInicioProcesoBaseNoContinuo                
							#Si cabe en más de un hueco y el último hueco es demasiado pequeño, se reubica...
							if [[ $contadorReubicarTotal -lt ${memoria[$siguienteProcesoAMeter]} && $contadorReubicar -le $variableReubicar ]]; then #Inicializa variables para el siguiente for. Se reubica si el hueco demasiado pequeño no es el último hueco necesario para meter el proceso.
								encontradoHuecoMuyReducidoInicial=0 
								encontradoHuecoMuyReducido=1 
							fi
							if [[ $encontradoHuecoMuyReducidoInicial -ne 1 && $primeraUnidadFuturoProcesoSinreubicar -eq -1 ]]; then 
								#4 - Si cabe entre todos los huecos, y mientras busca no encuentra un hueco demasiado pequeño, no reubica y lo meterá en memoria a trozos.
#								if [[ $(($contadorReubicar + $(($mem_num_marcos - $ra)))) -le $variableReubicar && $contadorReubicarTotal -lt ${memoria[$siguienteProcesoAMeter]} ]]; then #Se analiza el hueco que pueda estar en los últimos marcos de la memoria
								if [[ $(($contadorReubicar + $(($mem_total - $ra)))) -le $variableReubicar && $contadorReubicarTotal -lt ${memoria[$siguienteProcesoAMeter]} ]]; then #Se analiza el hueco que pueda estar en los últimos marcos de la memoria
									#5 - Si cabe entre todos los huecos, y mientras busca encuentra un hueco demasiado pequeño que resulta ser el último hueco de la memoria, reubica y lo meterá en memoria.
									encontradoHuecoMuyReducido=1 #No continuo, Reubicable, pero igual o superior al tamaño del proceso. Pero está en varios huecos.
								fi
							fi
							break #Si el proceso cabe en uno o varios huecos, no sigue buscando.
						fi #Fin de [[ $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} ]]
					fi #Fin de [[ $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]
				fi #Fin de ${unidMemOcupadas[$ra]} == "_" ]]
			done
#			if [[ $contadorReubicarTotal -lt ${memoria[$siguienteProcesoAMeter]} ]]; then #No necesario 
#				#1 - 3 - 6 - 9 - No cabe - Ya se considera cuando se resta el tamaño de memoria del proceso a introducir (memoria[$siguienteProcesoAMeter]) de la memoria libre (mem_libre) y comprueba >=0 en comprobacionSiguienteProcesoParaMeterMemoriaCondicionada()
#				noCabe0Cabe1=0 
#				reubicarContinuidad=0
#				reubicarReubicabilidad=0
#			fi
#			if [[ $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $encontradoHuecoMuyReducido -eq 0 && $contadorReubicarTotal -gt ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 0 ]]; then #No necesario
#				#2 - Lo meterá en memoria a trozos.
#				noCabe0Cabe1=1
#				reubicarContinuidad=0
#				reubicarReubicabilidad=0
#			fi
#			if [[ $contadorReubicarTotal -lt ${memoria[$siguienteProcesoAMeter]} && $encontradoHuecoMuyReducido -eq 0 && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]; then #No necesario
#				#4 - 
#				noCabe0Cabe1=1
#				reubicarContinuidad=0
#				reubicarReubicabilidad=0
#			fi
#			if [[ $contadorReubicarTotal -lt ${memoria[$siguienteProcesoAMeter]} && $primeraUnidadFuturoProcesoSinreubicar -ne -1 && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0 ]]; then #No necesario
#				#7 - 
#				noCabe0Cabe1=0 - No cabe - Ya se considera cuando se resta el tamaño de memoria del proceso a introducir (memoria[$siguienteProcesoAMeter]) de la memoria libre (mem_libre) y comprueba >=0 en comprobacionSiguienteProcesoParaMeterMemoriaCondicionada()
#				reubicarContinuidad=0
#				reubicarReubicabilidad=0
#			fi
#			if [[ $primeraUnidadFuturoProcesoSinreubicar -ne -1  && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0]]; then #No necesario
#				#8 - 
#				noCabe0Cabe1=1
#				reubicarContinuidad=0
#				reubicarReubicabilidad=0
#			fi
#			if [[ $primeraUnidadFuturoProcesoSinreubicar -ne -1 && $encontradoHuecoMuyReducido -eq 0 && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 1 ]]; then #No necesario
#				#10 - 
#				noCabe0Cabe1=1
#				reubicarContinuidad=0
#				reubicarReubicabilidad=0
#			fi
#			if [[ $primeraUnidadFuturoProcesoSinreubicar -gt -1 && $encontradoHuecoMuyReducido -eq 1 && $reubicabilidadNo0Si1 -eq 1 ]]; then 
#				#11 - Si encuentra un hueco demasiado pequeño mientras busca hueco suficiente y puede caber en un hueco, en memoria no continua.
#				reubicarReubicabilidad=0 
#			fi #No haría falta, porque no lo metería inicialmente, sino que lo reubicaría y después lo metería.
			if [[ $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]; then #No Continuo y Reubicable
				if [[ $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} && $encontradoHuecoMuyReducido -eq 1 ]]; then 
					reubicarReubicabilidad=1 #5 - Si encuentra un hueco demasiado pequeño mientras busca hueco suficiente y puede caber en un hueco, en memoria no continua.
				fi
			fi
			if [[ $encontradoHuecoMuyReducido -eq 1 && $reubicabilidadNo0Si1 -eq 1 ]]; then 
				reubicarReubicabilidad=1 #5 - Si encuentra un hueco demasiado pequeño mientras busca hueco suficiente, en memoria no continua.
			fi #No haría falta, porque se metería, pero se considera. Y en caso de encontradoHuecoMuyReducido=0 también lo metería.
			if [[ $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0 ]]; then #Continuo y No Reubicable
				encontradoHuecoMuyReducido=0 #Aunque lo haya encontrado, no reubica.
				reubicarContinuidad=0 
				reubicarReubicabilidad=0 
				if [[ $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} ]] ; then
					noCabe0Cabe1=0 #8 - Si no cabe en un único hueco, pero sí en la suma de ellos, en memoria continua.
				fi
			fi
			if [[ $encontradoHuecoMuyReducido -eq 1 ]]; then #
				encontradoHuecoMuyReducido=0
				reubicarReubicabilidad=1
			fi
#			if [[ $mem_libre -eq $mem_num_marcos ]]; then #Evita reubicar si toda la memoria está vacía ya que se introducirá el proceso con toda seguridad.
			if [[ $mem_libre -eq $mem_total ]]; then #Evita reubicar si toda la memoria está vacía ya que se introducirá el proceso con toda seguridad.
				reubicarContinuidad=0
				reubicarReubicabilidad=0
			fi
		else
			noCabe0Cabe1=0
		fi
	fi #fin de [[ siguienteProcesoAMeter -gt -1 ]]
	#Memoria No Continua
		#Memoria No Reubicable
			#1 - Si no cabe entre todos los huecos, no lo meterá en memoria.
			#2 - OK - Si cabe entre todos los huecos, lo meterá en memoria a trozos.
		#Memoria Reubicable
			#3 - Si no cabe entre todos los huecos, no reubica, ni lo meterá en memoria.
			#4 - Hecho - Si cabe entre todos los huecos, y mientras busca no encuentra un hueco demasiado pequeño, no reubica y lo meterá en memoria a trozos.
			#5 - Hecho - Si cabe entre todos los huecos, y mientras busca encuentra un hueco demasiado pequeño, reubica y lo meterá en memoria.
	#Memoria Continua
		#Memoria No Reubicable
			#6 - Si no cabe entre todos los huecos, no lo meterá en memoria.
			#7 - OK - Si cabe entre todos los huecos, pero no cabe en un único hueco, no lo meterá en memoria.
			#8 - Hecho - Si cabe en un único hueco, lo meterá en memoria.
		#Memoria Reubicable
			#9 - Si no cabe entre todos los huecos, no reubica, ni lo meterá en memoria.
			#10 - OK - Si cabe en un único hueco, y mientras busca no encuentra un hueco demasiado pequeño, no reubica y lo meterá en memoria.
			#11 - Hecho - Si cabe en un único hueco, y mientras busca encuentra un hueco demasiado pequeño, NO reubica y lo meterá en memoria.
			#12 - Hecho - Si cabe entre todos los huecos, pero no en un único hueco, reubica y lo meterá en memoria.
} #Fin de comprobacionSiguienteProcesoParaReubicarCondicionada()

#######################################################################
# Sinopsis: Cuando se decide que ya no hay que reubicar, por haberlo reubicado o porque no hacía falta, se comprueba en qué hueco o huecos de memoria se mete un proceso y desde qué marco se comienza a meter. 
#######################################################################
function comprobacionSiguienteProcesoParaMeterMemoriaCondicionada {
	if [[ $mem_libre -gt 0 && reubicarReubicabilidad -ne 1 && reubicarContinuidad -ne 1 ]]; then
		#Podría usarse "$1" en lugar de "$compo_po" utilizand la llamada "comprobacionSiguienteProcesoParaMeterMemoriaCondicionada $compo_po". Esto puede evitarse problemas de iualdad de variables. 
		mem_libreTemp=$mem_libre 
		#El for se resuelve con i=$po de la línea anterior a la llamada de la función. 
		if [[ ${encola[$compo_po]} -eq 1 && ${enmemoria[$compo_po]} -eq 0 ]]; then #Si están en cola pero no en memoria (en espera)
			noCabe0Cabe1=1 #Variable para no permitir meter procesos en memoria bajo ciertas condiciones relacionadas con la continuidad. 
			encontradoHuecoMuyReducido=0
			raInicioProceso=-1
			contadorMeterMemoria=-1
			contadorMeterMemoriaTotal=0
			siguienteProcesoAMeter=$compo_po
			if [[ $((mem_libreTemp - ${memoria[$compo_po]})) -ge 0 ]]; then
				noCabe0Cabe1=1 #Inicialmente, se supone que el proceso cabe en memoria. Y se intenta probar que es cierto.
#				for (( ra=0; ra<$mem_num_marcos; ra++ )); do
				for (( ra=0; ra<$mem_total; ra++ )); do
					if [[ ${unidMemOcupadas[$ra]} == "_" && siguienteProcesoAMeter -gt -1 ]]; then
						if [[ $contadorMeterMemoria -eq -1 ]]; then #Se designa la primera unidad sobre la que meter el proceso si entrara en memoria continua.
							contadorMeterMemoria=0
							raInicioProceso=$ra
						fi
						contadorMeterMemoria=$((contadorMeterMemoria + 1))
						contadorMeterMemoriaTotal=$((contadorMeterMemoriaTotal + 1))
						if [[ $contadorMeterMemoria -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $primeraUnidadFuturoProcesoSinreubicar -eq -1 ]]; then 
							#8 - Si cabe en un único hueco en memoria continua.
							primeraUnidadFuturoProcesoSinreubicar=$raInicioProceso               
						fi
#					elif [[ $(($ra + 1)) -ne $mem_num_marcos || ${unidMemOcupadas[$ra]} != "_" ]] && [[ siguienteProcesoAMeter -ne -1 ]]; then
					elif [[ $(($ra + 1)) -ne $mem_total || ${unidMemOcupadas[$ra]} != "_" ]] && [[ siguienteProcesoAMeter -ne -1 ]]; then
if [[ $contadorMeterMemoriaTotal -lt ${memoria[$siguienteProcesoAMeter]} ]]; then #Si no se alcanza el tamaño del proceso, pero se alcanza un marco ocupado, se mira si es demasiado pequeño. Pero si se ha llegado al tamaño del proceso, da igual que sea demasiado pequeño, porque no se reubica.
						if [[ $contadorMeterMemoria -ne -1 && $contadorMeterMemoria -le $variableReubicar && $reubicabilidadNo0Si1 -eq 1 ]]; then 
							#Si encuentra un hueco demasiado pequeño mientras busca hueco suficiente y puede caber en la totalidad de los huecos, en memoria no continua.
							encontradoHuecoMuyReducido=1
						fi
fi
						contadorMeterMemoria=-1
					fi
				done
				if [[ $siguienteProcesoAMeter != -1 ]]; then #
					if [[ $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0 ]] ; then
						noCabe0Cabe1=0 #8 - Si no cabe en un único hueco, pero sí en la suma de ellos, en memoria continua.
					fi
					if [[ $siguienteProcesoAMeter != -1 && $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0 ]] ; then
						noCabe0Cabe1=0 #8 - Si no cabe en un único hueco, pero sí en la suma de ellos, en memoria continua.
					fi
				fi
				#Este if es fundamental para generar las excepciones sobres si se reubica o no, y sobre la unidad de memoria donde empezar a meter el proceso.
				if [[ $primeraUnidadFuturoProcesoSinreubicar -ne -1 ||
				$primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $encontradoHuecoMuyReducido -eq 1 && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ||
				$primeraUnidadFuturoProcesoSinreubicar -gt -1 && $encontradoHuecoMuyReducido -eq 1 && $reubicabilidadNo0Si1 -eq 1 ||
				$primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 1 || 
				$primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoria -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 0 || 
				$primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]; then 
					if [[ $((mem_libreTemp - ${memoria[$compo_po]})) -ge 0 ]]; then
						mem_libreTemp=`expr $mem_libreTemp - ${memoria[$compo_po]}` 
						avisoentrada[$compo_po]=1
						evento=1
						enmemoria[$compo_po]=1 
						realizadoAntes=0
						noCabe0Cabe1=1
					else 
						noCabe0Cabe1=0
					fi
				fi
			else 
				noCabe0Cabe1=0
			fi
		fi
	else 
		noCabe0Cabe1=0
	fi
	for (( j=$compo_po; j<$nprocesos; j++ )); do #Bucle para bloquear los procesos
		bloqueados[$j]=1
	done
} #Fin de comprobacionSiguienteProcesoParaMeterMemoriaCondicionada()

##############################################################################################################################################
##############################################################################################################################################
# Sinopsis: Funciones para el desarrollo PREVENTIVO de la reubicabilidad e introducción de proecsos en memoria
#######################################################################
# Sinopsis: Comprueba que cada hueco en memoria no es mayor que la variable definida, para decidir si se reubica. 
#######################################################################
function comprobacionSiguienteProcesoParaReubicarPreventiva {
	#Sucesión: Se determina qué proceso será el siguiente en entrar en memoria, y dependiendo de la continuidad y reubicabilidad definidas, se establece si hay espacio en memoria. 
	noCabe0Cabe1=1 #Variable para no permitir meter procesos en memoria bajo ciertas condiciones relacionadas con la continuidad. 
	encontradoHuecoMuyReducidoInicial=0 #Sólo controla si el hueco que se está analizando es, hasta el momento de análisis, menor que el límite establecido.
	encontradoHuecoMuyReducido=0 #Controlará si el hueco o la suma de huecos es menor que el límite cuando se alcance el tamaño del proceso a meter.
	primeraUnidadFuturoProcesoSinreubicar=-1 #Primer marco vacío, en uno o en varios huecos
	raInicioProcesoBase=-1
	reubicarReubicabilidad=0 #En caso de ser memoria no continua, si hay un hueco demasiado pequeño, y se va a usar como parte de la memoria a usar.
	reubicarContinuidad=0 #En caso de ser memoria continua, si no hay un hueco suficientemente grande en el que quepa pero sí en la suma de todos ellos.
	contadorReubicar=-1 #Contiene el tamaño del hueco actual que se está localizando, mirando marco a marco.
	contadorReubicarTotal=0 #Contiene el tamaño del hueco total que se está localizando como suma de todos los huecos que se están localizando, mirando marco a marco.
	contadorReubicarHueco=0 #Contiene el tamaño del hueco que se está tratando cuando se llega al tamaño del proceso, para ver si el último marco está en un hueco pequeño.
	siguienteProcesoAMeter=-1
	for (( po=0; po<$nprocesos; po++ )) ; do #Se determina qué proceso es el siguiente a meter en la memoria. Primero se comprueba que si hay un proceso fuera del sistema que pueda entrar en memoria de forma directa.
		if [[ ${enmemoria[$po]} -eq 1 && ${escrito[$po]} -eq 0 ]]; then #Si está para entrar en memoria y no está dentro, se mete, y si ya está dentro se ignora.
			siguienteProcesoAMeter=$po
			break
		fi 
	done
	if [[ $siguienteProcesoAMeter -eq -1 ]]; then #Y si no hay un proceso fuera del sistema que pueda entrar en memoria, se comprueba que haya uno en espera.
		for (( po=0; po<$nprocesos; po++ )) ; do #Si no hay proceso enmemoria=1 se determina qué proceso es el siguiente a meter en la memoria pero desde encola().
			if [[ ${encola[$po]} -eq 1 && ${enmemoria[$po]} -eq 0 && ${escrito[$po]} -eq 0 ]]; then #Si está "En espera", para entrar en memoria y no está dentro, se mete, y si ya está dentro se ignora.
				siguienteProcesoAMeter=$po
				break
			fi 
		done
	fi 
	if [[ siguienteProcesoAMeter -gt -1 ]]; then #Si hay procesos pendientes de introducir en memoria.
		if [[ $mem_libre -ge ${memoria[$siguienteProcesoAMeter]} ]]; then #Si hay memoria libre suficiente para meter el siguiente proceso.
#			for (( ra=0; ra<$mem_num_marcos; ra++ )); do #Caso general. En caso de no encontrar un único hueco en el que quepa, revisa los huecos para intentar reubicar. Ahora no tiene que revisar toda la memoria.
			for (( ra=0; ra<$mem_total; ra++ )); do #Caso general. En caso de no encontrar un único hueco en el que quepa, revisa los huecos para intentar reubicar. Ahora no tiene que revisar toda la memoria.
#				if [[ ${unidMemOcupadas[$ra]} != "_" || $ra -eq $((mem_num_marcos - 1)) ]]; then #Si se encuentra un marco ocupado o si se llega al final de la memoria, y había un proceso por meter, se podría marcar como hueco pequeño encontrado, y sí se reinicia el contador para la búsqueda de un hueco único suficientemente grande
				if [[ ${unidMemOcupadas[$ra]} != "_" || $ra -eq $((mem_total - 1)) ]]; then #Si se encuentra un marco ocupado o si se llega al final de la memoria, y había un proceso por meter, se podría marcar como hueco pequeño encontrado, y sí se reinicia el contador para la búsqueda de un hueco único suficientemente grande
					if [[ $contadorReubicar -gt 0 && $contadorReubicar -le $variableReubicar ]]; then #Si encuentra un hueco demasiado pequeño mientras busca espacio libre suficiente, se marca para reubicar y se sigue buscando más huecos, hasta verificar toda la memoria, si fuera necesario.
						encontradoHuecoMuyReducidoInicial=1 #Si encuentra un hueco demasiado pequeño mientras busca un hueco suficiente y puede caber en la totalidad de los huecos, en memoria no continua.
						raInicioProcesoBaseContinuo=-1 #Marco base en caso de ser Continua. Define el primer marco libre del hueco actual hasta encontrar un hueco suficientemente grande.
						if [[ $continuidadNo0Si1 -ne 1 && $reubicabilidadNo0Si1 -ne 1 ]]; then #Salvo con Continuo y Reubicable en cuyo caso, debería seguir buscando un hueco único con espacio suficiente hasta el último marco.
							if [[ $raInicioProcesoBaseNoContinuo -eq -1 ]]; then #Si encuentra un hueco demasiado pequeño mientras busca espacio libre suficiente, se marca para reubicar y se sigue buscando más huecos, hasta verificar toda la memoria, si fuera necesario.
								raInicioProcesoBaseNoContinuo=$raInicioProcesoBase #Marco base en caso de ser No Continua. Define el primer marco libre.
							fi
							encontradoHuecoMuyReducido=1 
							break #Si ya se ha encontrado un hueco demasiado pequeño, no sigue buscando. Reubica y continúa metiendo procesos.
						fi
						if [[ $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]; then #Con No Continuo y Reubicable debería seguir buscando uno o varios huecos hasta encontrar espacio suficiente hasta el último marco. Si al hacerlo encuentra un hueco demasiado pequeño, no sigue buscando y lo reubica.
							if [[ $raInicioProcesoBaseNoContinuo -eq -1 ]]; then #Si encuentra un hueco demasiado pequeño mientras busca espacio libre suficiente, se marca para reubicar y se sigue buscando más huecos, hasta verificar toda la memoria, si fuera necesario.
								raInicioProcesoBaseNoContinuo=$raInicioProcesoBase #Marco base en caso de ser No Continua. Define el primer marco libre.
							fi
							encontradoHuecoMuyReducido=1 #Se reubica porque la memoria es No Continua pero hay un hueco demasiado pequeño.
							break #Si ya se ha encontrado un hueco demasiado pequeño, no sigue buscando. Reubica y continúa metiendo procesos.
						fi
					fi
					contadorReubicar=-1 #Solo se inicializa si se encuentra otro marco ocupado, pero no si se llega al final de la memoria, para qu los siguientes if trabajen bien, y no se haga una reubicación que no se necesita.
				fi
				if [[ ${unidMemOcupadas[$ra]} == "_" ]]; then #Si se van encontrando marcos libres, y hay un proceso que va a entrar en la memoria.
					if [[ $contadorReubicar -eq -1 ]]; then #Se designa la primera unidad sobre la que meter el proceso si entrara en memoria continua.
						contadorReubicar=0
						if [[ $raInicioProcesoBase -eq -1 ]]; then 
							raInicioProcesoBase=$ra #El primer marco vacío en la memoria, por si hay más huecos y recomienza la variable $raInicioProceso
						fi
					fi
					contadorReubicar=$((contadorReubicar + 1))
					contadorReubicarTotal=$((contadorReubicarTotal + 1))
					#Continuo - Si cabe en un único hueco, se mete el proceso...
					if [[ $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0 ]]; then #Continuo y No Reubicable
						#Continuo y No Reubicable - Si cabe en un único hueco, esté donde esté, se introduce.
						if [[ $contadorReubicar -ge ${memoria[$siguienteProcesoAMeter]} ]]; then #Si ya se ha encontrado algún marco vacío, y el hueco es menor que la variable de fragmentaciónm, y si se ha optado por memoria reubicable...
							primeraUnidadFuturoProcesoSinreubicar=$raInicioProcesoBase                
							break
						fi
					fi
					if [[ $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 1 ]]; then #Continuo y Reubicable
						#Continuo y Reubicable - Si cabe en un único hueco, esté donde esté, se introduce.
						if [[ $contadorReubicar -ge ${memoria[$siguienteProcesoAMeter]} ]]; then #Si ya se ha encontrado algún marco vacío, y el hueco es menor que la variable de fragmentaciónm, y si se ha optado por memoria reubicable...
							reubicarContinuidad=0 #11 - Si cabe en un único hueco, y mientras busca encuentra un hueco demasiado pequeño, NO reubica y lo meterá en memoria.
							primeraUnidadFuturoProcesoSinreubicar=$raInicioProcesoBase                
							break
						fi
						#Continuo y Reubicable - Si cabe en más de un hueco, se reubica y se introduce.
#						if [[ $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} && $ra -eq $((mem_num_marcos - 1)) ]]; then #No se consideran los huecos pequeños por ser Continua y Reubicable
						if [[ $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} && $ra -eq $((mem_total - 1)) ]]; then #No se consideran los huecos pequeños por ser Continua y Reubicable
							reubicarContinuidad=1 #12 - Si no cabe en un único hueco, pero sí en la suma de ellos, en memoria continua.
							break #Si no se ha encontrado un hueco pequeño mientras se busca hueco, se sale del buble y mete el proceso.
						fi
					fi
					if [[ $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]; then #No Continuo y Reubicable
						if [[ $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} ]]; then 
							primeraUnidadFuturoProcesoSinreubicar=$raInicioProcesoBaseNoContinuo                
							#Si cabe en más de un hueco y el último hueco es demasiado pequeño, se reubica...
							if [[ $contadorReubicar -le $variableReubicar ]]; then #Inicializa variables para el siguiente for.
								encontradoHuecoMuyReducidoInicial=0 
								encontradoHuecoMuyReducido=1 
							fi
							if [[ $encontradoHuecoMuyReducidoInicial -ne 1 && $primeraUnidadFuturoProcesoSinreubicar -eq -1 ]]; then 
								#4 - Si cabe entre todos los huecos, y mientras busca no encuentra un hueco demasiado pequeño, no reubica y lo meterá en memoria a trozos.
#								if [[ $(($contadorReubicar + $(($mem_num_marcos - $ra)))) -le $variableReubicar ]]; then #Se analiza el hueco que pueda estar en los últimos marcos de la memoria
								if [[ $(($contadorReubicar + $(($mem_total - $ra)))) -le $variableReubicar ]]; then #Se analiza el hueco que pueda estar en los últimos marcos de la memoria
									#5 - Si cabe entre todos los huecos, y mientras busca encuentra un hueco demasiado pequeño que resulta ser el último hueco de la memoria, reubica y lo meterá en memoria.
									encontradoHuecoMuyReducido=1 #No continuo, Reubicable, pero igual o superior al tamaño del proceso. Pero está en varios huecos.
								fi
							fi
							#Se seguirá buscando el tamaño del hueco, aún después de determinar que hay hueco suficiente para el proceso, para determinar si el último hueco es más pequeño que el máximo ($variableReubicar) po si hay que reubicar.
#							if [[ $(($ra + 1)) -ne $mem_num_marcos ]]; then 
							if [[ $(($ra + 1)) -ne $mem_total ]]; then 
								contadorReubicarHueco=$contadorReubicar
#								for (( raHueco=$(($ra + 1)); raHueco<$mem_num_marcos; raHueco++ )); do #Se verifica desde el siguiente marco, dado que el marco actual ya se ha considerado como parte del espacio donde meter el proceso.
								for (( raHueco=$(($ra + 1)); raHueco<$mem_total; raHueco++ )); do #Se verifica desde el siguiente marco, dado que el marco actual ya se ha considerado como parte del espacio donde meter el proceso.
									if [[ ${unidMemOcupadas[$raHueco]} == "_" ]]; then #Si se van encontrando marcos libres, y hay un proceso que va a entrar en la memoria.
										contadorReubicarHueco=$(($contadorReubicarHueco + 1))
										if [[ $contadorReubicarHueco -gt $variableReubicar ]]; then #Se analiza el hueco que pueda estar en los últimos marcos de la memoria
											encontradoHuecoMuyReducido=0 #No continuo, Reubicable, pero igual o superior al tamaño del proceso. No encontrado último hueco demasiado pequeño.
											contadorReubicarHueco=0
											break #Si el hueco es mayor que el tamaño pequeño, ya no sigue buscando.
										fi
									else
										if [[ $contadorReubicarHueco -le $variableReubicar ]]; then 
											encontradoHuecoMuyReducido=1 #No continuo, Reubicable, pero igual o superior al tamaño del proceso. Encontrado último hueco demasiado pequeño.
											contadorReubicarHueco=0
											contadorReubicar=-1
											break
										fi 
									fi
								done
#							fi #Fin de [[ $(($ra + 1)) -ne $mem_num_marcos ]]
							fi #Fin de [[ $(($ra + 1)) -ne $mem_total ]]
							break #Si el proceso cabe en uno o varios huecos, no sigue buscando.
						fi #Fin de [[ $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} ]]
					fi #Fin de [[ $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]
				fi #Fin de ${unidMemOcupadas[$ra]} == "_" ]]
			done
			if [[ $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]; then #No Continuo y Reubicable
				if [[ $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} && $encontradoHuecoMuyReducido -eq 1 ]]; then 
					reubicarReubicabilidad=1 #5 - Si encuentra un hueco demasiado pequeño mientras busca hueco suficiente y puede caber en un hueco, en memoria no continua.
				fi
			fi
			if [[ $encontradoHuecoMuyReducido -eq 1 && $reubicabilidadNo0Si1 -eq 1 ]]; then 
				reubicarReubicabilidad=1 #5 - Si encuentra un hueco demasiado pequeño mientras busca hueco suficiente, en memoria no continua.
			fi #No haría falta, porque se metería, pero se considera. Y en caso de encontradoHuecoMuyReducido=0 también lo metería.
			if [[ $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0 ]]; then #Continuo y No Reubicable
				encontradoHuecoMuyReducido=0 #Aunque lo haya encontrado, no reubica.
				reubicarContinuidad=0 
				reubicarReubicabilidad=0 
				if [[ $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorReubicarTotal -ge ${memoria[$siguienteProcesoAMeter]} ]] ; then
					noCabe0Cabe1=0 #8 - Si no cabe en un único hueco, pero sí en la suma de ellos, en memoria continua.
				fi
			fi
			if [[ $encontradoHuecoMuyReducido -eq 1 ]]; then #
				encontradoHuecoMuyReducido=0
				reubicarReubicabilidad=1
			fi
#			if [[ $mem_libre -eq $mem_num_marcos ]]; then #Evita reubicar si toda la memoria está vacía ya que se introducirá el proceso con toda seguridad.
			if [[ $mem_libre -eq $mem_total ]]; then #Evita reubicar si toda la memoria está vacía ya que se introducirá el proceso con toda seguridad.
				reubicarContinuidad=0
				reubicarReubicabilidad=0
			fi
		else
			noCabe0Cabe1=0
		fi
	fi #fin de [[ siguienteProcesoAMeter -gt -1 ]]
} #Fin de comprobacionSiguienteProcesoParaReubicarPreventiva()

#######################################################################
# Sinopsis: Comprueba que cada hueco en memoria es suficiente para meter un proceso en memoria. 
#######################################################################
function comprobacionSiguienteProcesoParaMeterMemoriaPreventiva {
	if [[ $mem_libre -gt 0 && reubicarReubicabilidad -ne 1 && reubicarContinuidad -ne 1 ]]; then
		#Podría usarse "$1" en lugar de "$compo_po" utilizand la llamada "comprobacionSiguienteProcesoParaMeterMemoriaPreventiva $compo_po". Esto puede evitarse problemas de iualdad de variables. 
		mem_libreTemp=$mem_libre 
		primeraUnidadFuturoProcesoSinreubicar=-1 #No se debería definir porque es un valor arrastrado desde la comprobación en comprobacionSiguienteProcesoParaReubicarPreventiva()
		#El for se resuelve con i=$po de la línea anterior a la llamada de la función. 
		if [[ ${encola[$compo_po]} -eq 1 && ${enmemoria[$compo_po]} -eq 0 ]]; then #Si están en cola pero no en memoria (en espera)
			noCabe0Cabe1=1 #Variable para no permitir meter procesos en memoria bajo ciertas condiciones relacionadas con la continuidad. 
			encontradoHuecoMuyReducido=0
			raInicioProceso=-1
			contadorMeterMemoria=-1
			contadorMeterMemoriaTotal=0
			siguienteProcesoAMeter=$compo_po
			if [[ $((mem_libreTemp - ${memoria[$compo_po]})) -ge 0 ]]; then
				noCabe0Cabe1=1
#				for (( ra=0; ra<$mem_num_marcos; ra++ )); do
				for (( ra=0; ra<$mem_total; ra++ )); do
					if [[ ${unidMemOcupadas[$ra]} == "_" && siguienteProcesoAMeter -gt -1 ]]; then
						if [[ $contadorMeterMemoria -eq -1 ]]; then #Se designa la primera unidad sobre la que meter el proceso si entrara en memoria continua.
							contadorMeterMemoria=0
							raInicioProceso=$ra
						fi
						contadorMeterMemoria=$((contadorMeterMemoria + 1))
						contadorMeterMemoriaTotal=$((contadorMeterMemoriaTotal + 1))
						if [[ $contadorMeterMemoria -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $primeraUnidadFuturoProcesoSinreubicar -eq -1 ]]; then 
							#8 - Si cabe en un único hueco en memoria continua.
							primeraUnidadFuturoProcesoSinreubicar=$raInicioProceso               
						fi
					elif [[ ${unidMemOcupadas[$ra]} != "_" && siguienteProcesoAMeter -ne -1 ]]; then
						if [[ $contadorMeterMemoria -ne -1 && $contadorMeterMemoria -le $variableReubicar && $reubicabilidadNo0Si1 -eq 1 ]]; then 
							#Si encuentra un hueco demasiado pequeño mientras busca hueco suficiente y puede caber en la totalidad de los huecos, en memoria no continua.
							encontradoHuecoMuyReducido=1
						fi
						contadorMeterMemoria=-1
					fi
				done
				if [[ $siguienteProcesoAMeter != -1 ]]; then #
					if [[ $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0 ]] ; then
						noCabe0Cabe1=0 #8 - Si no cabe en un único hueco, pero sí en la suma de ellos, en memoria continua.
					fi
					if [[ $siguienteProcesoAMeter != -1 && $primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 0 ]] ; then
						noCabe0Cabe1=0 #8 - Si no cabe en un único hueco, pero sí en la suma de ellos, en memoria continua.
					fi
				fi
				#Este if es fundamental para generar las excepciones sobres si se reubica o no, y sobre la unidad de memoria donde empezar a meter el proceso.
				if [[ $primeraUnidadFuturoProcesoSinreubicar -ne -1 ||
				$primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $encontradoHuecoMuyReducido -eq 1 && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ||
				$primeraUnidadFuturoProcesoSinreubicar -gt -1 && $encontradoHuecoMuyReducido -eq 1 && $reubicabilidadNo0Si1 -eq 1 ||
				$primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 1 && $reubicabilidadNo0Si1 -eq 1 || 
				$primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 0 || 
				$primeraUnidadFuturoProcesoSinreubicar -eq -1 && $contadorMeterMemoriaTotal -ge ${memoria[$siguienteProcesoAMeter]} && $continuidadNo0Si1 -eq 0 && $reubicabilidadNo0Si1 -eq 1 ]]; then 
					if [[ $((mem_libreTemp - ${memoria[$compo_po]})) -ge 0 ]]; then
						mem_libreTemp=`expr $mem_libreTemp - ${memoria[$compo_po]}` 
						avisoentrada[$compo_po]=1
						evento=1
						enmemoria[$compo_po]=1 
						realizadoAntes=0
						noCabe0Cabe1=1
					else 
						noCabe0Cabe1=0
					fi
				fi
			else 
				noCabe0Cabe1=0
			fi
		fi
	else 
		noCabe0Cabe1=0
	fi
#	for (( j=$compo_po; j<$nprocesos; j++ )); do #Bucle para bloquear los procesos
	for (( j=$compo_po; j<$nprocesos; j++ )); do #Bucle para bloquear los procesos
		bloqueados[$j]=1
	done
} #Fin de comprobacionSiguienteProcesoParaMeterMemoriaPreventiva()
##############################################################################################################################################
##############################################################################################################################################


####################################################################################
# Sinopsis: Se realizan los cálculos necesarios para la impresión de la banda de memoria en los volcados.
####################################################################################
function meterProcesosBandaMemoria {
	if [[ $noCabe0Cabe1 -eq 1 && ${enmemoria[$po]} == 1 && ${escrito[$po]} == 0 ]]; then #Si está para entrar en memoria, y no está dentro se mete, y si ya está dentro se ignora.
		ud=0
		ra=0
		if [[ $primeraUnidadFuturoProcesoSinreubicar -ne -1 ]]; then #Esto permite la continuidad en memoria al necesitar un tramo continuo de memoria y haberlo conseguido.
			ra=$primeraUnidadFuturoProcesoSinreubicar
		fi
		while [[ $ud -lt ${memoria[($po)]} ]]; do  #Esto permite la no continuidad en memoria al no necesitar un tramo continuo de memoria.
			if [[ ${unidMemOcupadas[$ra]} == "_" ]]; then
				unidMemOcupadas[$ra]=$po
				ud=$((ud+1))
				mem_libre=$((mem_libre - 1))
			fi
			encola[$po]=0 #Este proceso ya sólo estará en memoria, ejecutandose o habrá acabado
			escrito[$po]=1 #Se marca que ya está en memoria.
			ra=$((ra+1))
		done
	fi
} #Fin de meterProcesosBandaMemoria()

####################################################################################
# Sinopsis: Se preparan las líneas para la impresión de la banda de memoria en los volcados - NO Continua y Reubicabilidad.
####################################################################################
function calculosPrepararLineasImpresionBandaMemoria {
	#Sucesión: Crear las tres líneas de la banda de memoria y se generan los bloques que componen la memoria usada por cada proceso en memoria.
	#Se calcula la línea de nombres - Línea 1
	arribaMemoriaNC="   |"
	arribaMemoriaNCb="   |"
	#Si el proceso está en la barra y no está nombrado se escribe. Si está nombrado se llena de _ para que el siguiente coincida con la línea de memoria.
	for (( ra=0; ra<$mem_total; ra++ )); do
		#Si la posición de memoria no está escrita, añades dígitos para completar los caracteres de la unidad, y la escribes.
		for (( po=0; po<$nprocesos; po++ )); do
			if [[ $ra -eq 0 && ${unidMemOcupadas[$ra]} == $po ]]; then
				arribaMemoriaNC=$arribaMemoriaNC${coloress[$po]}"${proceso[$po]}""${varhuecos:1:$(($digitosUnidad - ${#proceso[$po]}))}"$NC
				arribaMemoriaNCb=$arribaMemoriaNCb"${proceso[$po]}""${varhuecos:1:$(($digitosUnidad - ${#proceso[$po]}))}"
			fi
			if [[ $ra -ne 0 && ${unidMemOcupadas[$((ra-1))]} != $po && ${unidMemOcupadas[$ra]} == $po ]]; then #Si en una posición hay un proceso y antes algo distinto lo nombras
				arribaMemoriaNC=$arribaMemoriaNC${coloress[$po]}"${proceso[$po]}""${varhuecos:1:$(($digitosUnidad - ${#proceso[$po]}))}"$NC
				arribaMemoriaNCb=$arribaMemoriaNCb"${proceso[$po]}""${varhuecos:1:$(($digitosUnidad - ${#proceso[$po]}))}"
			elif [[ $ra -ne 0 && ${unidMemOcupadas[$((ra-1))]} == $po && ${unidMemOcupadas[$ra]} == $po ]]; then #Si es un proceso pero no es inicio pones barras bajas
				arribaMemoriaNC=$arribaMemoriaNC${coloress[$po]}"${varhuecos:1:$digitosUnidad}"$NC
				arribaMemoriaNCb=$arribaMemoriaNCb"${varhuecos:1:$digitosUnidad}"
			fi
		done
		#Si es una barra baja (blanco) se llena de _ para seguir alineando.
		if [[ ${unidMemOcupadas[$ra]} == '_' ]]; then
			arribaMemoriaNC=$arribaMemoriaNC"${varhuecos:1:$digitosUnidad}"$NC
			arribaMemoriaNCb=$arribaMemoriaNCb"${varhuecos:1:$digitosUnidad}"
		fi
	done

	#Se calcula la línea de banda - Línea 2
	unset coloresPartesMemoria #Lo vaciamos ya que cada volcado es diferente. Añadimos valores cada vez que se imprima un bloque
	barraMemoriaNC="BM |"
	barraMemoriaNCbPantalla="BM |" #Para el color se usa esta variable ya que se cuentan los caracteres por línea y no se puede hacer con las secuencias de escape. Además se hace con "█" negros cuando no están siendo usados.
	barraMemoriaNCbFichero="BM |" #Para el fichero de blanco y negro se usa esta variable ya que se cuentan los caracteres por línea y no se puede hacer con las secuencias de escape. Además se hace con "-" cuando no están siendo usados.
	coloresPartesMemoria=(" ${coloresPartesMemoria[@]}" "${coloress[97]}" "${coloress[97]}" "${coloress[97]}")
	for (( ra=0; ra<$mem_total; ra++ )); do #En $ra (recorre array) siempre va a haber o un proceso o una barra baja
		if [[ ${unidMemOcupadas[$ra]} != '_' ]] ; then #Entonces hay guardado el número del 0-x de un proceso
			barraMemoriaNC=$barraMemoriaNC${coloress[${unidMemOcupadas[$ra]}]}"${varfondos:1:$digitosUnidad}"$NC
			barraMemoriaNCbPantalla=$barraMemoriaNCbPantalla"${varfondos:1:$digitosUnidad}"
			colorunidMemOcupadas
		fi
		if [[ ${unidMemOcupadas[$ra]} == '_' ]]; then #Imprimir 3 blancos si hay una _
			barraMemoriaNC=$barraMemoriaNC" "${coloress[97]}"${varfondos:1:$digitosUnidad}"$NC
			barraMemoriaNCbPantalla=$barraMemoriaNCbPantalla"${varfondos:1:$digitosUnidad}"
			colorDefaultBMBT
		fi
	done

	#Se calcula la línea que escriba la posición de memoria - Línea 3
	abajoMemoriaNC="   |"
	abajoMemoriaNCb="   |"
	for (( ra=0; ra<$mem_total; ra++ )); do
		#Al final se escriben las unidades de comienzo de los procesos:
		#Si la posición de memoria está o no escrita, se escribe el 0 y se añaden dígitos para completar los caracteres de la unidad.
		if [[ $ra -eq 0 ]] ; then
			abajoMemoriaNC=$abajoMemoriaNC"${varhuecos:1:$(($digitosUnidad - ${#ra}))}"${coloress[$po]}"$ra"$NC
			abajoMemoriaNCb=$abajoMemoriaNCb"${varhuecos:1:$(($digitosUnidad - ${#ra}))}""$ra"
		fi
		for (( po=0; po<$nprocesos; po++ )); do
			#Si la posición de memoria no está escrita, añades dígitos para completar los caracteres de la unidad, y la escribes.
			if [[ $ra -ne 0 && ${unidMemOcupadas[$((ra-1))]} != $po  && ${unidMemOcupadas[$ra]} == $po ]] ; then
				abajoMemoriaNC=$abajoMemoriaNC"${varhuecos:1:$(($digitosUnidad - ${#ra}))}"${coloress[$po]}"$ra"$NC
				abajoMemoriaNCb=$abajoMemoriaNCb"${varhuecos:1:$(($digitosUnidad - ${#ra}))}""$ra"
			#Si la posición ya está escrita se añaden huecos para las siguientes unidades
			elif [[ $ra -ne 0 && ${unidMemOcupadas[$((ra-1))]} == $po  && ${unidMemOcupadas[$ra]} == $po ]] ; then
				abajoMemoriaNC=$abajoMemoriaNC"${varhuecos:1:$digitosUnidad}"$NC
				abajoMemoriaNCb=$abajoMemoriaNCb"${varhuecos:1:$digitosUnidad}"
			fi
		done
		#Se escribe la posición de los primeros blancos de la misma manera salvo el 0 que ya está escrito.
		#Si la posición de memoria no está escrita se escribe y se añaden dos dígitos en blanco (completar 3 caract).
		if [[ $ra -ne 0 && ${unidMemOcupadas[$((ra-1))]} != "_" && ${unidMemOcupadas[$ra]} == "_" ]] ; then
			abajoMemoriaNC=$abajoMemoriaNC"${varhuecos:1:$(($digitosUnidad - ${#ra}))}"${coloress[97]}"$ra"$NC
			abajoMemoriaNCb=$abajoMemoriaNCb"${varhuecos:1:$(($digitosUnidad - ${#ra}))}""$ra"
		#Posición ya escrita huecos SALVO en caso de que sea la posición 0 (que se escribe siempre si está vacía aunque el último hueco tenga algo).
		elif [[ $ra -ne 0 && ${unidMemOcupadas[$((ra-1))]} == "_" && ${unidMemOcupadas[$ra]} == "_" ]] ; then #Si es un proceso pero no es inicio pones barras bajas
			abajoMemoriaNC=$abajoMemoriaNC"${varhuecos:1:$digitosUnidad}"$NC
			abajoMemoriaNCb=$abajoMemoriaNCb"${varhuecos:1:$digitosUnidad}"
		fi
	done

	#Se calcula el número de bloques en los que se fragmentan los procesos.
	if [[ ${unidMemOcupadas[0]} != "_" ]] ; then #Se determina is hay un proceso en la primera unidad de memoria y qué proceso es, y se define como primer bloque.
		bloques[$((unidMemOcupadas[0]))]=1
	fi
	for (( ra=1; ra<$mem_total; ra++ )); do
		if [[ ${unidMemOcupadas[$ra]} != "_" && ${unidMemOcupadas[$ra]} != ${unidMemOcupadas[$((ra - 1))]} ]] ; then #menor
			bloques[$((unidMemOcupadas[$ra]))]=$((bloques[$((unidMemOcupadas[$ra]))] + 1))
		fi
	done
	#Se cuenta el número de datos que tienen que tener los arrays posición inicial/final. Si bloques de algo equivale a 0 o 1, se suma 1. Si no, se suma el número de bloques.
	for (( i=0; i<$nprocesos; i++ )) ; do #El array de bloques tiene el mismo número de posiciones que el de procesos.
		if [[ ${bloques[$i]} -le 1 ]]; then #Una por proceso, est´´e o no en memoria, y una más por cada bloque añadido más allá del primero
			nposiciones=$((nposiciones+1)) #Número de procesos
		else
			nposiciones=$((nposiciones+${bloques[$i]})) #Número de bloques por proceso cuando tenga bloques
		fi
	done
	for (( i=0; i<$nposiciones; i++ )); do #Se inicializan a 0 (Sin bloques)
		inicialNC[$i]=0
		finalNC[$i]=0
	done
	#Se rellena
	main=0
	mafi=0
	for (( po=0 ; po<$nprocesos; po++ )); do
		if [[ ${bloques[$po]} -eq 0 ]]; then
			inicialNC[$main]="-"
			main=$((main+1))
			finalNC[$mafi]="-"
			mafi=$((mafi+1))
		elif [[ ${bloques[$po]} -ne 0 ]]; then
			contadori=0
			contadorf=0
			while [[ $contadori -lt ${bloques[($po)]} &&  $contadorf -lt ${bloques[($po)]} ]]; do
				for (( ra=0; ra<$mem_total ; ra++ )) ; do
					if [[ $ra -eq 0  && ${unidMemOcupadas[$ra]} == $po ]] ; then #El primero es un caso especial
						inicialNC[$main]=$ra #Si el proceso entra en memoria, guarda la unidad de inicio
						main=$((main+1))
						contadori=$((contadori+1))
					fi
					if [[ $ra -ne 0  &&  ${unidMemOcupadas[$((ra - 1))]} != $po && ${unidMemOcupadas[$ra]} == $po ]] ; then
						inicialNC[$main]=$ra #Si el proceso entra en memoria, guarda la unidad de inicio
						main=$((main+1))
						contadori=$((contadori+1))
					fi
					if [[ $ra -ne 0  &&  $ra -ne $((mem_total-1)) && ${unidMemOcupadas[$ra]} == $po && ${unidMemOcupadas[$((ra + 1))]} != $po ]] ; then
						finalNC[$mafi]=$ra #Si el proceso entra en memoria, guarda la unidad de final
						mafi=$((mafi+1))
						contadorf=$((contadorf+1))
					fi
					if [[ $ra -eq $((mem_total-1)) && ${unidMemOcupadas[$ra]} == $po ]]; then #El último es un caso especial
						finalNC[$mafi]=$ra #Si el proceso entra en memoria, guarda la unidad de final aunque no haya terminado el proceso. No debería ya que hubiera tenido que empezar en el primer hueco y le habría cabido.
						mafi=$((mafi+1))
						contadorf=$((contadorf+1))
					fi
				done
			done
		fi
	done
} #Final de preparar líneas para Banda de Memoria - calculosPrepararLineasImpresionBandaMemoria()

####################################################################################
# Sinopsis: Se imprime la banda de memoria - COPIA CADA DATO CUANDO LO LOCALIZA - MUY LENTO. NO USADA.
####################################################################################
function dibujarBandaMemoriaORI { #Versión no utilizada. Funciona bien, pero sigue el modelo del anterior alumno y resulta más compleja que la versión definitiva (dibujarBandaMemoria).
	#Aquí se imprime la barra de memoria haciendo los saltos de pantalla.
	longImprimeMem=`expr length "$abajoMemoriaNCb"`
	TamTerminal=$((`tput cols`))
	colsTerminal=$((`tput cols` - 1)) #Sólo se quita un carácter que hay que dejar libre al final de la línea.
	veces=0;
	imprimeAhora=0;
	inicio=0;
	totalImprimirBandaMemoria=0
	YaImprimido=0
	tamRotuloFinal=0
	$formadamemoria
	$formadamemoriaarriba
	$formadamemoriaabajo
	$formadamemoriab
	$formadamemoriaarribab
	$formadamemoriaabajob
	until [[ $longImprimeMem -le 0 ]]; do
		if [[ $longImprimeMem -le $colsTerminal && $veces -eq 0 ]]; then
			imprimeAhora=$longImprimeMem #Caracteres que tienes que imprimir
		elif [[ $longImprimeMem -le $(($colsTerminal - 5)) && $veces -gt 0 ]]; then
			imprimeAhora=$longImprimeMem #Caracteres que tienes que imprimir
		else
			for (( i=0; i<$longImprimeMem; i++ )); do #Hay que considerar los 5 caracteres de la primera línea y que ya no estarán en el rest de líneas.
				if [[ $veces -eq 0 ]]; then
					totalImprimirBandaMemoria=$(($totalImprimirBandaMemoria+1))
					if [[ $(($(($totalImprimirBandaMemoria-5))%$digitosUnidad)) -eq 0 ]]; then #Se restan 5 por los espacios del rótulo inicial. Se buscan unidades completas por línea.
						if [[ $(($totalImprimirBandaMemoria + $digitosUnidad)) -gt $colsTerminal ]]; then
							break
						fi
					fi
					imprimeAhora=$(($totalImprimirBandaMemoria)) #Se quita un dígito para ajustar los caracteres a representar.
				else
					totalImprimirBandaMemoria=$(($totalImprimirBandaMemoria+1))
					if [[ $(($totalImprimirBandaMemoria % $digitosUnidad)) -eq 0 ]]; then
						if [[ $(( $totalImprimirBandaMemoria + $digitosUnidad + 5 )) -gt $colsTerminal ]]; then
							break
						fi
					fi
					imprimeAhora=$(($totalImprimirBandaMemoria + 1))
				fi
			done
			totalImprimirBandaMemoria=0 #Se iguala a 0 para volver a empezar a determinar el número de dígitos a imprimir.
		fi
		if [[ $veces -eq 0 ]]; then
			for ((n=0; n<$imprimeAhora; n++)); do #Como en todas, se intercala el color con un caracter y con un $NC
				let m=n
				formadamemoriaarriba=$formadamemoriaarriba"${coloresPartesMemoria[$m]}${arribaMemoriaNCb:$m:1}$NC" #Barra arriba
				formadamemoriaarribab=$formadamemoriaarribab"${arribaMemoriaNCb:$m:1}"
				formadamemoria=$formadamemoria"${coloresPartesMemoria[$m]}${barraMemoriaNCbPantalla:$m:1}$NC" #Barra medio
				formadamemoriab=$formadamemoriab"${barraMemoriaNCbFichero:$m:1}"
				formadamemoriaabajo=$formadamemoriaabajo"${coloresPartesMemoria[$m]}${abajoMemoriaNCb:$m:1}$NC" #Barra abajo
				formadamemoriaabajob=$formadamemoriaabajob"${abajoMemoriaNCb:$m:1}"
			done
		else
			for ((n=0; n<$(($imprimeAhora)); n++)); do #Como en todas, se intercala el color con un caracter y con un $NC
				m=$(($n+$YaImprimido))
				formadamemoriaarriba=$formadamemoriaarriba"${coloresPartesMemoria[$m]}${arribaMemoriaNCb:$m:1}$NC" #Barra arriba
				formadamemoriaarribab=$formadamemoriaarribab"${arribaMemoriaNCb:$m:1}"
				formadamemoria=$formadamemoria"${coloresPartesMemoria[$m]}${barraMemoriaNCbPantalla:$m:1}$NC" #Barra medio
				formadamemoriab=$formadamemoriab"${barraMemoriaNCbFichero:$m:1}"
				formadamemoriaabajo=$formadamemoriaabajo"${coloresPartesMemoria[$m]}${abajoMemoriaNCb:$m:1}$NC" #Barra abajo
				formadamemoriaabajob=$formadamemoriaabajob"${abajoMemoriaNCb:$m:1}"
			done
		fi
		tamRotuloFinaltexto="|T=$mem_total"
		tamRotuloFinal=${#tamRotuloFinaltexto}
		if [[ $veces -eq 0 ]];then
			if [[ $longImprimeMem -le $(($colsTerminal - $tamRotuloFinal)) ]];then
				echo -e "\n$formadamemoriaarriba""|" | tee -a $informeConColorTotal
				echo -e "$formadamemoria""|""M=$mem_total" | tee -a $informeConColorTotal
				echo -e "$formadamemoriaabajo""|" | tee -a $informeConColorTotal
				echo -e "\n$formadamemoriaarribab""|" >> $informeSinColorTotal
				echo -e "$formadamemoriab""|""M=$mem_total" >> $informeSinColorTotal
				echo -e "$formadamemoriaabajob""|" >> $informeSinColorTotal
			elif [[ $longImprimeMem -le $(($colsTerminal)) && $longImprimeMem -gt $(($colsTerminal - $tamRotuloFinal)) ]];then
				echo -e "\n$formadamemoriaarriba" | tee -a $informeConColorTotal
				echo -e "$formadamemoria" | tee -a $informeConColorTotal
				echo -e "$formadamemoriaabajo" | tee -a $informeConColorTotal
				echo -e "\n$formadamemoriaarribab" >> $informeSinColorTotal
				echo -e "$formadamemoriab" >> $informeSinColorTotal
				echo -e "$formadamemoriaabajob" >> $informeSinColorTotal
				echo -e "\n    ""|" | tee -a $informeConColorTotal
				echo -e "    ""|""M=$mem_total" | tee -a $informeConColorTotal
				echo -e "    ""|" | tee -a $informeConColorTotal
				echo -e "\n    ""|"  >>$informeSinColorTotal
				echo -e "    ""|""M=$mem_total"  >>$informeSinColorTotal
				echo -e "    ""|"  >>$informeSinColorTotal
			else
				echo -e "\n$formadamemoriaarriba" | tee -a $informeConColorTotal
				echo -e "$formadamemoria" | tee -a $informeConColorTotal
				echo -e "$formadamemoriaabajo" | tee -a $informeConColorTotal
				echo -e "\n$formadamemoriaarribab" >> $informeSinColorTotal
				echo -e "$formadamemoriab" >> $informeSinColorTotal
				echo -e "$formadamemoriaabajob" >> $informeSinColorTotal
			fi
			YaImprimido=$(($YaImprimido + $imprimeAhora))
		else
			if [[ $longImprimeMem -lt $(($colsTerminal - 5)) ]];then
				if [[ $(($imprimeAhora + $tamRotuloFinal)) -le $(($colsTerminal - 5)) ]];then
					echo -e "\n     ""$formadamemoriaarriba""|" | tee -a $informeConColorTotal
					echo -e "     ""$formadamemoria""|""M=$mem_total" | tee -a $informeConColorTotal
					echo -e "     ""$formadamemoriaabajo""|" | tee -a $informeConColorTotal
					echo -e "\n     ""$formadamemoriaarribab""|" >> $informeSinColorTotal
					echo -e "     ""$formadamemoriab""|""M=$mem_total" >> $informeSinColorTotal
					echo -e "     ""$formadamemoriaabajob""|" >> $informeSinColorTotal
				else
					echo -e "\n     ""$formadamemoriaarriba" | tee -a $informeConColorTotal
					echo -e "     ""$formadamemoria" | tee -a $informeConColorTotal
					echo -e "     ""$formadamemoriaabajo" | tee -a $informeConColorTotal
					echo -e "\n     ""$formadamemoriaarribab"  >>$informeSinColorTotal
					echo -e "     ""$formadamemoriab"  >>$informeSinColorTotal
					echo -e "     ""$formadamemoriaabajob"  >>$informeSinColorTotal
					echo -e "\n    ""|" | tee -a $informeConColorTotal
					echo -e "    ""|""M=$mem_total" | tee -a $informeConColorTotal
					echo -e "    ""|" | tee -a $informeConColorTotal
					echo -e "\n    ""|"  >>$informeSinColorTotal
					echo -e "    ""|""M=$mem_total"  >>$informeSinColorTotal
					echo -e "    ""|"  >>$informeSinColorTotal
				fi
			else
				echo -e "\n     ""$formadamemoriaarriba" | tee -a $informeConColorTotal
				echo -e "     ""$formadamemoria" | tee -a $informeConColorTotal
				echo -e "     ""$formadamemoriaabajo" | tee -a $informeConColorTotal
				echo -e "\n     ""$formadamemoriaarribab" >> $informeSinColorTotal
				echo -e "     ""$formadamemoriab" >> $informeSinColorTotal
				echo -e "     ""$formadamemoriaabajob" >> $informeSinColorTotal
			fi
			YaImprimido=$(($YaImprimido + $imprimeAhora))
		fi
		formadamemoria=""
		formadamemoriaarriba=""
		formadamemoriaabajo=""
		formadamemoriab=""
		formadamemoriaarribab=""
		formadamemoriaabajob=""
		((veces++))
		inicio=$((inicio+colsTerminal))
		let longImprimeMem=longImprimeMem-imprimeAhora #Determina lo que queda pendiente de imprimir
	done

	#Se vacía el auxiliar que reubica la memoria.
	for (( ca=0; ca<(mem_total); ca++)); do ##Borramos los datos de la auxiliar
		unidMemOcupadasAux[$ca]="_"
	done
	#Se vacían bloques
	for (( ca=0; ca<($nprocesos) ; ca++)); do ##Borramos los datos de la auxiliar
		 bloques[$ca]=0
	done
	#Se vacían las posiciones
	nposiciones=0
	#Se vacían posiciones iniciales y finales para borrar elementos innecesarios
	for (( i=0; i<$nposiciones; i++ )) ; do
		 inicialNCmodelo[$i]=0
	done
	for (( i=0; i<$nposiciones; i++ )) ; do
		 finalNCmodelo[$i]=0
	done
} #Final de dibujar la banda de memoria - dibujarBandaMemoria()

####################################################################################
# Sinopsis: Genera la Banda de Memoria y la muestra en pantalla/informe - GENERA LÍNEAS COMPLETAS Y LAS COPIA LÍNEA A lÍNEA EN LOS FICHEROS DE INFORMES.
####################################################################################
function dibujarBandaMemoria { #Nueva versión y más simplificada, pero tiene 100 líneas más que la versión original (dibujarBandaMemoriaORI)
	terminal2=`tput cols` #Ancho del terminal para adecuar el ancho de líneas a cada volcado
	echo ""

	# GENERACIÓN STRING DE PROCESOS (Línea 1 de la Banda de Memoria)
	nn=0 # Línea de la banda
	bandaProcesos=("    |")
	bandaProcesosColor=("$NORMAL    |")
	numCaracteres2=5
	xx=0 # Variable que indica si se ha añadido un proceso a la banda
	for ((ii=0;ii<${#unidMemOcupadas[@]};ii++)); do
		if [[ ${unidMemOcupadas[$ii]} != "_" ]]; then # El proceso se puede imprimir en memoria
			if [[ $(($numCaracteres2 + $digitosUnidad + 1)) -gt $terminal2 ]]; then # El texto no cabe en la terminal
				nn=$(($nn + 1)) # Se pasa a la siguiente línea
				bandaProcesos[$nn]="     "
				bandaProcesosColor[$nn]="     "
				numCaracteres2=5
			fi
			if [[ $ii -ne 0 && $xx -eq 1 && ${proceso[$((${unidMemOcupadas[$ii]}))]} != ${proceso[$((${unidMemOcupadas[$((ii - 1))]}))]} ]]; then # El texto no cabe en la terminal
				xx=0
			fi
			if [[ $xx -eq 0 ]]; then # Se añade el proceso a la banda
				espaciosfinal=${varhuecos:1:$(($digitosUnidad - ${#proceso[$((${unidMemOcupadas[$ii]}))]}))}
				bandaProcesos[$nn]+=`echo -e "${proceso[$((${unidMemOcupadas[$ii]}))]}""$espaciosfinal"`
				bandaProcesosColor[$nn]+=`echo -e "${coloress[${unidMemOcupadas[$ii]} % 6]}${proceso[$((${unidMemOcupadas[$ii]}))]}""$NORMAL$espaciosfinal"`
				xx=1
			else
				espaciosfinal=${varhuecos:1:$(($digitosUnidad))}
				bandaProcesos[$nn]+=`echo -e "$espaciosfinal"`
				bandaProcesosColor[$nn]+=`echo -e "$NORMAL$espaciosfinal"`
				if [[ $ii -ne 0 ]]; then
					if [[ ${unidMemOcupadas[$((ii - 1))]} !=  "_" ]]; then
						if [[ $xx -eq 1 && ${proceso[$((${unidMemOcupadas[$ii]}))]} != ${proceso[$((${unidMemOcupadas[$((ii - 1))]}))]} ]]; then
							xx=0
						fi
					fi
				fi
			fi
		else
			xx=0
			if [[ $(($numCaracteres2 + $digitosUnidad + 1)) -gt $terminal2 ]]; then # El texto no cabe en la terminal
				nn=$(($nn + 1)) # Se pasa a la siguiente línea
				bandaProcesos[$nn]="     "
				bandaProcesosColor[$nn]="     "
				numCaracteres2=5
			fi
			espaciosfinal=${varhuecos:1:$(($digitosUnidad))}
			bandaProcesos[$nn]+=`echo -e "$espaciosfinal"`
			bandaProcesosColor[$nn]+=`echo -e "$NORMAL$espaciosfinal"`
		fi
		numCaracteres2=$(($numCaracteres2 + $digitosUnidad))
	done
	# Añadir final de banda
	if [[ $(($numCaracteres2 + 5 + ${#mem_total} + 1)) -gt $terminal2 ]]; then # El texto no cabe en la terminal
		nn=$(($nn + 1)) # Se pasa a la siguiente línea
		bandaProcesos[$nn]="     "
		bandaProcesosColor[$nn]="     "
		numCaracteres2=5
	fi
	bandaProcesos[$nn]+=`echo -e "|"`
	bandaProcesosColor[$nn]+=`echo -e "$NORMAL|"`

	# GENERACIÓN STRING DE MEMORIA (Línea 2 de la Banda de Memoria)
	nn=0 # Línea de la banda
	bandaMemoria=(" BM |")
	bandaMemoriaColor=("$NORMAL BM |")
	numCaracteres2=5
	espaciosAMeter=${varfondos:1:$digitosUnidad}
	guionesAMeter=${varguiones:1:$digitosUnidad}
	asteriscosAMeter=${varasteriscos:1:$digitosUnidad}
	fondosAMeter=${varfondos:1:$digitosUnidad}
	sumaTotalMemoria=0
	xx=0 # Variable que indica si se ha añadido un proceso a la banda
	for ((ii=0;ii<${#unidMemOcupadas[@]};ii++)); do
		if [[ $(($numCaracteres2 + $digitosUnidad + 1)) -gt $terminal2 ]]; then # El texto no cabe en la terminal
			nn=$(($nn + 1)) # Se pasa a la siguiente línea
			bandaMemoria[$nn]="     "
			bandaMemoriaColor[$nn]="     "
			numCaracteres2=5
		fi
		if [[ ${unidMemOcupadas[$ii]} != "_" ]]; then # El proceso se puede imprimir en memoria
			bandaMemoria[$nn]+=`echo -e "$asteriscosAMeter"`
			bandaMemoriaColor[$nn]+=`echo -e "${coloress[${unidMemOcupadas[$ii]} % 6]}$fondosAMeter"`
			if [[ $ii -ne 0 ]]; then
				if [[ ${unidMemOcupadas[$((ii - 1))]} !=  "_" ]]; then
					if [[ $xx -eq 1 && ${proceso[$((${unidMemOcupadas[$ii]}))]} != ${proceso[$((${unidMemOcupadas[$((ii - 1))]}))]} ]]; then
						xx=0
					fi
				fi
			fi
		else
			xx=0
			bandaMemoria[$nn]+=`echo -e "$guionesAMeter"`
			bandaMemoriaColor[$nn]+=`echo -e "$NORMAL$fondosAMeter"`
		fi
		numCaracteres2=$(($numCaracteres2 + $digitosUnidad))
	done

	# Añadir final de banda
	if [[ $(($numCaracteres2 + 5 + ${#mem_total} + 1)) -gt $terminal2 ]]; then # El texto no cabe en la terminal
		nn=$(($nn + 1)) # Se pasa a la siguiente línea
		bandaMemoria[$nn]="     "
		bandaMemoriaColor[$nn]=$NORMAL"     "
		numCaracteres2=5
	fi
	bandaMemoria[$nn]+=`echo -e "|M: $mem_total"` # TODO: CAMBIAR NÚMERO DE MEMORIA
	bandaMemoriaColor[$nn]+=`echo -e "$NORMAL|M: $mem_total"` # TODO: CAMBIAR NÚMERO DE MEMORIA

	# GENERACIÓN STRING DE POSICIÓN DE MEMORIA (Línea 3 de la Banda de Memoria)
	nn=0 # Línea de la banda
	bandaPosicion=("    |")
	bandaPosicionColor=("$NORMAL    |")
	numCaracteres2=5
	xx=0 # Variable que indica si se ha añadido un proceso a la banda
	for ((ii=0;ii<${#unidMemOcupadas[@]};ii++)); do
		if [[ $(($numCaracteres2 + $digitosUnidad + 1)) -gt $terminal2 ]]; then # El texto no cabe en la terminal
			nn=$(($nn + 1)) # Se pasa a la siguiente línea
			bandaPosicion[$nn]="     "
			bandaPosicionColor[$nn]="     "
			numCaracteres2=5
		fi
		if [[ ${unidMemOcupadas[$ii]} != "_" ]]; then # El proceso se puede imprimir en memoria
			if [[ $ii -ne 0 && $xx -eq 1 && ${proceso[$((${unidMemOcupadas[$ii]}))]} != ${proceso[$((${unidMemOcupadas[$((ii - 1))]}))]} ]]; then # El texto no cabe en la terminal
				xx=0
			fi
			if [[ $xx -eq 0 ]]; then # Se añade el proceso a la banda
				espaciosfinal=${varhuecos:1:$(($digitosUnidad - ${#ii}))}
				bandaPosicion[$nn]+=`echo -e "$espaciosfinal""$ii"`
				bandaPosicionColor[$nn]+=`echo -e "$NORMAL$espaciosfinal""$ii"`
				xx=1
			else
				espaciosfinal=${varhuecos:1:$(($digitosUnidad))}
				bandaPosicion[$nn]+=`echo -e "$espaciosfinal"`
				bandaPosicionColor[$nn]+=`echo -e "$NORMAL$espaciosfinal"`
				if [[ $ii -ne 0 ]]; then
					if [[ ${unidMemOcupadas[$((ii - 1))]} !=  "_" ]]; then
						if [[ $xx -eq 1 && ${proceso[$((${unidMemOcupadas[$ii]}))]} != ${proceso[$((${unidMemOcupadas[$((ii - 1))]}))]} ]]; then
							xx=0
						fi
					fi
				fi
			fi
		else
			xx=0
			if [[ $ii -ne 0 ]]; then
				if [[ ${unidMemOcupadas[$((ii - 1))]} != "_" ]]; then
					espaciosfinal=${varhuecos:1:$(($digitosUnidad - ${#ii}))}
					bandaPosicion[$nn]+=`echo -e "$espaciosfinal""$ii"`
					bandaPosicionColor[$nn]+=`echo -e "$NORMAL$espaciosfinal""$ii"`
				else
					espaciosfinal=${varhuecos:1:$(($digitosUnidad))}
					bandaPosicion[$nn]+=`echo -e "$espaciosfinal"`
					bandaPosicionColor[$nn]+=`echo -e "$NORMAL$espaciosfinal"`
				fi
			else
				espaciosfinal=${varhuecos:1:$(($digitosUnidad - ${#ii}))}
				bandaPosicion[$nn]+=`echo -e "$espaciosfinal""$ii"`
				bandaPosicionColor[$nn]+=`echo -e "$NORMAL$espaciosfinal""$ii"`
			fi
		fi
		numCaracteres2=$(($numCaracteres2 + $digitosUnidad))
	done
	# Añadir final de banda
	if [[ $(($numCaracteres2 + 5 + ${#mem_total} + 1)) -gt $terminal2 ]]; then # El texto no cabe en la terminal
		nn=$(($nn + 1)) # Se pasa a la siguiente línea
		bandaPosicion[$nn]="     "
		bandaPosicionColor[$nn]="$NORMAL     "
		numCaracteres2=5
	fi
	bandaPosicion[$nn]+=`echo -e "|"`
	bandaPosicionColor[$nn]+=`echo -e "$NORMAL|"`

	# IMPRIMIR LAS 3 LÍNEAS DE LA BANDA DE MEMORIA (COLOR y BN a pantalla y ficheros)
	for (( jj = 0; jj < ${#bandaProcesos[@]}; jj++ )); do
		echo -e "${bandaProcesosColor[$jj]}" | tee -a $informeConColorTotal
		echo "${bandaProcesos[$jj]}" >> $informeSinColorTotal
		echo -e "${bandaMemoriaColor[$jj]}" | tee -a $informeConColorTotal
		echo -e "${bandaMemoria[$jj]}" >> $informeSinColorTotal
		echo -e "${bandaPosicionColor[$jj]}" | tee -a $informeConColorTotal
		echo -e "${bandaPosicion[$jj]}\n" >> $informeSinColorTotal
	done

	#Se vacía el auxiliar que reubica la memoria.
	for (( ca=0; ca<(mem_total); ca++)); do ##Borramos los datos de la auxiliar
		unidMemOcupadasAux[$ca]="_"
	done
	#Se vacían bloques
	for (( ca=0; ca<($nprocesos) ; ca++)); do ##Borramos los datos de la auxiliar
		 bloques[$ca]=0
	done
	#Se vacían las posiciones
	nposiciones=0
	#Se vacían posiciones iniciales y finales para borrar elementos innecesarios
	for (( i=0; i<$nposiciones; i++ )) ; do
		 inicialNCmodelo[$i]=0
	done
	for (( i=0; i<$nposiciones; i++ )) ; do
		 finalNCmodelo[$i]=0
	done
} #Fin de la nueva versión de dibujarBandaMemoria()

####################################################################################
# Sinopsis: Prepara la banda de tiempos de procesos en cada volcado - PRUEBA DE COPIAR LÍNEA A lÍNEA
####################################################################################
function calculosImpresionBandaTiempos {
	#Sucesión: Crear las tres líneas de la banda de tiempo y se generan los bloques que componen la memoria usada por cada proceso en memoria.
	#Nota: Todas las que acaben en "b" (o "baux) significa que es la versión en blanco y negro (también en la memoria).
	#Se trabaja simultaneamente con la línea en b/n, en color, y con el array coloresPartesTiempo (o memoria) que guarda el color de cada caracter del terminal.
	#dibujasNC es el array que guarda cúantas unidades quedan por dibujar de un proceso

	#A.Primero. Se trata la entrada por separado hasta que entre el primer proceso
	#En T=0 se pone el "rótulo".
	colsTerminal=$((`tput cols`-5)) #Determina el número de caracteres a inmprimir en cada línea.
	arribatiempoNC_0="    |"
	arribatiempoNCb_0="    |"
	tiempoNC_0=" BT |"
	tiempoNCb_0=" BT |"
	abajotiempoNC_0="    |"
	abajotiempoNCb_0="    |"
	tiempodibujado=0 #Unidades ya incluidas en las variables tiempoNC_0,...
	colorDefaultInicio
	#Primero se meten blancos en tiempoNC_0,... hasta la legada del primer proceso, si lo hay.
	if [[ $reloj -eq 0 && $reloj -lt ${llegada[0]} ]]; then #En el caso en que el primer proceso entre más tarde que 0, se introducen blancos iniciales en tiempoNC_0,....
		arribatiempoNC=$arribatiempoNC_0"${varhuecos:1:$(($digitosUnidad))}"$NC
		arribatiempoNCb=$arribatiempoNCb_0"${varhuecos:1:$(($digitosUnidad))}"
		tiempoNC=$tiempoNC_0"${varhuecos:1:$(($digitosUnidad))}"$NC
		tiempoNCb=$tiempoNCb_0"${varhuecos:1:$(($digitosUnidad))}"
		abajotiempoNC=$abajotiempoNC_0"${varhuecos:1:$(($digitosUnidad - 1))}0"$NC
		abajotiempoNCb=$abajotiempoNCb_0"${varhuecos:1:$(($digitosUnidad - 1))}0"
		colorDefaultBMBT
	fi
	if [[ $reloj -ne 0 && $(($reloj - $tiempodibujado)) -gt 0  ]]; then #Hasta que se alcance reloj dibujar blancos en tiempoNC_0,....
		for (( i=0 ; i<$(($reloj)) ; i++ )) ; do
			if [[ $tiempodibujado -eq 0 ]]; then
				arribatiempoNC=$arribatiempoNC_0"${varhuecos:1:$(($digitosUnidad))}""${coloress[$i]}"
				arribatiempoNCb=$arribatiempoNCb_0"${varhuecos:1:$(($digitosUnidad))}"
				tiempoNC=$tiempoNC_0"$NORMAL${varfondos:1:$(($digitosUnidad))}" #Representa los fondos con su color correspondiente
				tiempoNCb=$tiempoNCb_0"${varguiones:1:$(($digitosUnidad))}"
				abajotiempoNC=$abajotiempoNC_0"${varhuecos:1:$(($digitosUnidad - 1))}0"
				abajotiempoNCb=$abajotiempoNCb_0"${varhuecos:1:$(($digitosUnidad - 1))}0"
				tiempodibujado=$(($tiempodibujado + 1))
			else #En el caso en que el primer proceso entre más tarde que 0 (dibujar blancos iniciales de la barra todos de golpe).
				arribatiempoNC=$arribatiempoNC"${varhuecos:1:$(($digitosUnidad))}""${coloress[$i]}"
				arribatiempoNCb=$arribatiempoNCb"${varhuecos:1:$(($digitosUnidad))}"
				tiempoNC=$tiempoNC"$NC${varfondos:1:$(($digitosUnidad))}" #Representa los fondos con su color correspondiente
				tiempoNCb=$tiempoNCb"${varguiones:1:$(($digitosUnidad))}"
				abajotiempoNC=$abajotiempoNC"${varhuecos:1:$(($digitosUnidad))}"
				abajotiempoNCb=$abajotiempoNCb"${varhuecos:1:$(($digitosUnidad))}"
				tiempodibujado=$(($tiempodibujado + 1))
			fi
		done
	fi

	#B. Segundo: A partir de la representación del primer proceso, si lo hay, se dibuja el resto de procesos de forma normal, añadiendo sus nombres y unidades.
		#1.Dibujar los procesos finalizados - Si está nombrado y no se ha empezado a dibujar
		#2.Añadir el rótulo del último proceso si hace falta y se marca como nombrado (entra en ejecución pero no hay que dibujar nada).
	#1. Proceso finalizado que NO se ha acabado de dibujar. Hay que dibujar meter nombres (línea 1) y unidades (línea 3).
	if [[ $hayproanterior -eq 1 && ${estad[$proanterior]} -eq 5 && ${dibujasNC[$proanterior]} -gt 0 ]]; then #Que haya, que esté acabado (no él mismo) y que quede por dibujar:
		#Si se ha nombrado (nomtiempo()=1) y no se ha empezado a dibujar (valor en dibujasNC() como en tejecucion())
		if [[ ${nomtiempo[$proanterior]} == 1 && ${dibujasNC[$proanterior]} -eq ${tejecucion[$proanterior]} ]]; then
		#Si se ha marcado como terminado y no se ha empezado a dibujar
			contad=$((${dibujasNC[$proanterior]}-1)) #Ponemos espacios para cuadrar, tantos como unidades de la barra se dibujen, menos 1 (ese 1 es poe empezar a contar desde 0)
			for (( i=0 ; i<$contad; i++ )); do
				arribatiempoNC=$arribatiempoNC"${varhuecos:1:$(($digitosUnidad))}"$NC
				arribatiempoNCb=$arribatiempoNCb"${varhuecos:1:$(($digitosUnidad))}"
				tiempoNC=$tiempoNC${coloress[$proanterior % 6]}"${varfondos:1:$(($digitosUnidad))}"$NC #Cambiados a varfondos
				tiempoNCb=$tiempoNCb"${varguiones:1:$(($digitosUnidad))}"
				abajotiempoNC=$abajotiempoNC"${varhuecos:1:$(($digitosUnidad))}"$NC
				abajotiempoNCb=$abajotiempoNCb"${varhuecos:1:$(($digitosUnidad))}"
				colorAnterior
				tiempodibujado=$(($tiempodibujado + 1))
			done
			dibujasNC[$proanterior]=0
		fi
	fi #Fin de los procesos terminados pendientes de imprimir en la banda de tiempo
	#2.Se añade el nombre del último proceso que entra en ejecución y se marca como nombrado (entra en ejecución pero no hay que dibujar nada).
	for (( po=0; po<$nprocesos; po++)) ; do
		if ( [[ $tiempodibujado -eq $reloj && ${dibujasNC[$po]} -eq ${tejecucion[$po]} && ${estad[$po]} -eq 3 ]] ) ; then
			arribatiempoNC=$arribatiempoNC"${coloress[$po % 6]}${proceso[$po]}""${varhuecos:1:$(($digitosUnidad - ${proceso[$po]}))}"$NC
			arribatiempoNCb=$arribatiempoNCb"${proceso[$po]}""${varhuecos:1:$(($digitosUnidad - ${proceso[$po]}))}"
			tiempoNC=$tiempoNC"${varhuecos:1:$(($digitosUnidad))}"$NC #Propuesto meter varfondos
			tiempoNCb=$tiempoNCb"${varhuecos:1:$(($digitosUnidad))}"
			abajotiempoNC=$abajotiempoNC"${varhuecos:1:$(($digitosUnidad - ${#reloj}))}""$reloj"$NC
			abajotiempoNCb=$abajotiempoNCb"${varhuecos:1:$(($digitosUnidad - ${#reloj}))}""$reloj"
			tiempodibujado=$(($tiempodibujado + 1))
		fi
		nomtiempo[$po]=1 #Se marca como nombrado
	done
} #Final de los cálculos para la impresión de la banda de memoria de los volcados - calculosImpresionBandaTiempos()

####################################################################################
# Sinopsis: Imprime las tres líneas de la banda de tiempo. Permite mostrar el orden de ejecución de los
# procesos y su evolución en el tiempo.
####################################################################################
function dibujarBandaTiempos {
	local maxCaracteres=0
	maxCaracteres=$digitosUnidad # Longitud en número de dígitos de cada unidad
	if [[ $maxCaracteres -eq 2 ]]; then
		maxCaracteres=3 # El mínimo de caracteres tiene que ser 3 para que entren los nombres de
	fi
	local numCaracteresInicial=5
	local terminal=`tput cols` #Ancho del terminal para adecuar el ancho de líneas a cada volcado
	for ((s = 0; s < ${#proceso[@]}; s++)); do
		if [[ ${estado[$s]} == "En ejecución" ]]; then
			procPorUnidadTiempoBT[$reloj]=$s #En cada casilla contiene el número de orden del proceso que se ejecuta en cada instante. Sólo puede haber un proceso en cada instante.
		fi
	done

	# GENERACIÓN STRING DE LA BANDA DE TIEMPOS (Línea 1 de la Banda de Tiempos)
	local bandaProcesos=("    |")
	local bandaProcesosColor=($NORMAL"    |")
	local n=0 # Línea de la banda
	local numCaracteres=$numCaracteresInicial
	for ((k = 0; k <= $reloj; k++)); do
		if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
			n=$(($n + 1)) # Se pasa a la siguiente línea
			bandaProcesos[n]="     "
			bandaProcesosColor[n]="     "
			numCaracteres=$numCaracteresInicial
		fi
		if [[ $k -eq 0 ]]; then #Si no se mantiene el mismo proceso en ejecución se imprime el nombre del nuevo proceso
			if [[ ${procPorUnidadTiempoBT[$k]} -ge 0 ]]; then #Si hay un proceso ejecutándose...
				local p=${proceso[${procPorUnidadTiempoBT[$k]}]} #Se imprime el nombre del proceso en ejecución en ese instante definido por la posición almacenada en procPorUnidadTiempoBT
				bandaProcesosColor[n]+=`printf "${coloress[${procPorUnidadTiempoBT[$k]} % 6]}%-$(($maxCaracteres))s$NORMAL" $p` # Modificado por dar error
				bandaProcesos[n]+=`printf "%-$(($maxCaracteres))s" $p`
			elif [[ ! ${procPorUnidadTiempoBT[$k]} -ge 0 ]]; then #Si no lo hay...
				bandaProcesosColor[n]+=`printf "%-$(($maxCaracteres))s$NORMAL"`
				bandaProcesos[n]+=`printf "%-$(($maxCaracteres))s"`
			fi
		elif [[ $k -ne 0 ]]; then
			if [[ ${procPorUnidadTiempoBT[$k]} -eq ${procPorUnidadTiempoBT[$(($k - 1))]} ]]; then #Si se mantiene el mismo proceso en ejecución se imprimen espacios
				bandaProcesos[n]+=`printf "%$(($maxCaracteres))s" ""`
				bandaProcesosColor[n]+=`printf "%$(($maxCaracteres))s" ""`
			elif [[ ${procPorUnidadTiempoBT[$k]} -ne ${procPorUnidadTiempoBT[$(($k - 1))]} ]]; then #Si se mantiene el mismo proceso en ejecución se imprimen espacios
				local p=${proceso[${procPorUnidadTiempoBT[$k]}]} #Se imprime el nombre del proceso en ejecución en ese instante definido por la posición almacenada en procPorUnidadTiempoBT
				bandaProcesosColor[n]+=`printf "${coloress[${procPorUnidadTiempoBT[$k]} % 6]}%-$(($maxCaracteres))s$NORMAL" $p` # Modificado por dar error
				bandaProcesos[n]+=`printf "%-$(($maxCaracteres))s" $p`
			fi
		fi
		numCaracteres=$(($numCaracteres + $maxCaracteres))
	done
	# Añadir final de banda
	if [[ $(($numCaracteres + $numCaracteresInicial + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
		n=$(($n + 1)) # Se pasa a la siguiente línea
		bandaProcesos[n]="     "
		bandaProcesosColor[n]="     "
		numCaracteres=$numCaracteresInicial
	fi
	bandaProcesos[n]+=`printf "|    %$(($maxCaracteres))s" ""`
	bandaProcesosColor[n]+=`printf "|    %$(($maxCaracteres))s" ""`

	# GENERACIÓN STRING DE LA BANDA DE TIEMPOS (Línea 2 de la Banda de Tiempos)
	local bandaTiempo=(" BT |")
	local bandaTiempoColor=(" BT |")
	local n=0 # Línea de la banda
	local numCaracteres=$numCaracteresInicial
	for ((k = 0; k <= $reloj; k++)); do
		if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
			n=$(($n + 1)) # Se pasa a la siguiente línea
			bandaTiempo[n]="     "
			bandaTiempoColor[n]="     "
			numCaracteres=$numCaracteresInicial
		fi
		espaciosAMeter=${varhuecos:1:$maxCaracteres}
		guionesAMeter=${varguiones:1:$maxCaracteres}
		fondosAMeter=${varfondos:1:$maxCaracteres}
		if [[ $k -eq $reloj ]]; then #Si el instante considerado es igual al tiempo actual
			bandaTiempo[n]+=$espaciosAMeter
			bandaTiempoColor[n]+=$espaciosAMeter
		elif [[ $k -ne $reloj ]]; then
			if [[ ${procPorUnidadTiempoBT[$k]} -eq $topeProcPorUnidadTiempoBT ]]; then # || ${procPorUnidadTiempoBT[$k]} = 0 ]]# Si no hay proceso en ejecución asociado a ese instante. Vale 0 si no está definido porque la inicialización empieza en posición=1.
				bandaTiempo[n]+=$guionesAMeter
				if [[ $k -ne 0 ]]; then #Si no es la primera unidad de la Banda de Tiempo
					if [[ ${procPorUnidadTiempoBT[$k]} -eq ${procPorUnidadTiempoBT[$k - 1]} ]]; then #Si no cambia de proceso en ejecución respecto al instante anterior
						if [[ $numCaracteres -eq $numCaracteresInicial ]]; then #Si es el primer instante del mismo proceso de las segundas líneas respecto a la anterior se mantendría el color
							bandaTiempoColor[n]+=$NORMAL$fondosAMeter
						else
							bandaTiempoColor[n]+=$fondosAMeter
						fi
					else
						bandaTiempoColor[n]+=$NORMAL$fondosAMeter
					fi
				else
					if [[ ${procPorUnidadTiempoBT[$k]} -eq $topeProcPorUnidadTiempoBT ]]; then
						bandaTiempoColor[n]+=$NORMAL$fondosAMeter
					else
						bandaTiempoColor[n]+=${coloress[${procPorUnidadTiempoBT[$k]} % 6]}$fondosAMeter$NORMAL
					fi
				fi
			else # Si hay proceso en ejecución asociado a ese instante
				bandaTiempo[n]+=$fondosAMeter
				if [[ $k -ne 0 ]]; then #Si no es T=0
					if [[ ${procPorUnidadTiempoBT[$k]} -eq ${procPorUnidadTiempoBT[$k - 1]} ]]; then #Si no cambia de proceso respecto al instante anterior
						if [[ $numCaracteres -eq $numCaracteresInicial ]]; then #Si es el primer instante del mismo proceso de las segundas líneas respecto a la anterior se mantendría el color
							bandaTiempoColor[n]+=${coloress[${procPorUnidadTiempoBT[$k-1]} % 6]}$fondosAMeter$NORMAL
						else
							bandaTiempoColor[n]+=${coloress[${procPorUnidadTiempoBT[$k-1]} % 6]}$fondosAMeter$NORMAL
						fi
					else
						bandaTiempoColor[n]+=${coloress[${procPorUnidadTiempoBT[$k]} % 6]}$fondosAMeter$NORMAL
					fi
				else #T=0
					if [[ ${procPorUnidadTiempoBT[$k]} -ge 0 ]]; then
						bandaTiempoColor[n]+=${coloress[${procPorUnidadTiempoBT[$k]} % 6]}$fondosAMeter$NORMAL
					else
						bandaTiempoColor[n]+=$NORMAL$fondosAMeter
					fi
				fi
			fi
		fi
		numCaracteres=$(($numCaracteres + $maxCaracteres))
	done
	# Añadir final de banda
	if [[ $(($numCaracteres + $numCaracteresInicial + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
		n=$(($n + 1)) # Se pasa a la siguiente línea
		bandaTiempo[n]="     "
		bandaTiempoColor[n]="     "
		numCaracteres=$numCaracteresInicial
	fi
	bandaTiempo[n]+=`printf "|T= %-${maxCaracteres}d" $reloj`
	bandaTiempoColor[n]+=$NORMAL`printf "|T= %-${maxCaracteres}d" $reloj`

	# GENERACIÓN STRING DE LAS UNIDADES DE LOS INSTANES DE TIEMPO (Línea 3 de la Banda de Tiempos)
	local bandaInstantes=("    |")
	local bandaInstantesColor=($NORMAL"    |")
	local n=0 # Línea de la banda
	local numCaracteres=$numCaracteresInicial
	for ((k = 0; k <= $reloj; k++)); do
		if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
			n=$(($n + 1)) # Se pasa a la siguiente línea
			bandaInstantes[n]="     "
			bandaInstantesColor[n]=$NORMAL"     "
			numCaracteres=$numCaracteresInicial
		fi
		if [[ ${procPorUnidadTiempoBT[$k]} -eq ${procPorUnidadTiempoBT[$(($k - 1))]} ]]; then #Cuando se mantiene el mismo proceso en ejecución
			if [[ $k -eq 0 || $k -eq $reloj ]]; then #En T=0 o T=momento actual, aumenta el contenido de las bandas
				bandaInstantes[n]+=`printf "%${maxCaracteres}d" $k`
				bandaInstantesColor[n]+=`printf "%${maxCaracteres}d" $k`
			else #En T distinto de 0 o momento actual, también aumenta el contenido de las bandas
				bandaInstantes[n]+=`printf "%${maxCaracteres}s" ""`
				bandaInstantesColor[n]+=`printf "%${maxCaracteres}s" ""`
			fi
		else #Cuando no se mantiene el mismo proceso en ejecución
			bandaInstantes[n]+=`printf "%${maxCaracteres}d" $k`
			bandaInstantesColor[n]+=`printf "%${maxCaracteres}d" $k`
		fi
		numCaracteres=$(($numCaracteres + $maxCaracteres))
	done
	# Añadir final de banda
	if [[ $(($numCaracteres + $numCaracteresInicial + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
		n=$(($n + 1)) # Se pasa a la siguiente línea
		bandaInstantes[n]="     "
		bandaInstantesColor[n]=$NORMAL"     "
		numCaracteres=$numCaracteresInicial
	fi
	bandaInstantes[n]+=`printf "|    %$(($maxCaracteres))s" ""`
	bandaInstantesColor[n]+=`printf "|    %$(($maxCaracteres))s" ""`

	# IMPRIMIR LAS 3 LÍNEAS DE LA BANDA DE TIEMPOS (COLOR y BN a pantalla y ficheros temporales) - Se meten ahora en los temporales para que la banda de tiempo vaya tras la banda de memoria
	for (( i = 0; i < ${#bandaProcesos[@]}; i++ )); do
		echo -e "${bandaProcesos[$i]}" >> $informeSinColorTotal
		echo -e "${bandaProcesosColor[$i]}" | tee -a $informeConColorTotal
		echo -e "${bandaTiempo[$i]}" >> $informeSinColorTotal
		echo -e "${bandaTiempoColor[$i]}" | tee -a $informeConColorTotal
		echo -e "${bandaInstantes[$i]}\n" >> $informeSinColorTotal
		echo -e "${bandaInstantesColor[$i]}\n" | tee -a $informeConColorTotal
	done

	printf "\n" | tee -a $informeConColorTotal
	printf "\n" >> $informeSinColorTotal
	#########################################################
	#Se determina el modo de ejecución (Enter, sin paradas, con paradas con tiempo predefinido)
	if [[ $optejecucion = "1" ]]; then #Impresión de forma manual (pulsando enter para pasar)
		echo -e " Pulse ENTER para continuar.$NC" | tee -a $informeConColorTotal
		echo -e " Pulse ENTER para continuar." >> $informeSinColorTotal
		read continuar
		echo -e $continuar "\n" >> $informeConColorTotal
		echo -e $continuar "\n" >> $informeSinColorTotal
	fi  #Cierre de fi - optejecucion=1 (seleccionMenuModoTiempoEjecucionAlgormitmo=1)
	if [[ $optejecucion = "2" ]]; then #Impresión de forma sin parar (pasa sin esperar, de golpe)
		echo -e "───────────────────────────────────────────────────────────────────────$NC" | tee -a $informeConColorTotal
		echo -e "───────────────────────────────────────────────────────────────────────" >> $informeSinColorTotal
	fi  #Cierre de fi - optejecucion=2 (seleccionMenuModoTiempoEjecucionAlgormitmo=2)
	if [[ $optejecucion = "3" ]]; then #Impresión de forma automatica (esperando x segundo para pasar)
		echo -e " Espere para continuar...$NC\n" | tee -a $informeConColorTotal
		echo -e " Espere para continuar...\n" >> $informeSinColorTotal
		sleep $tiempoejecucion
	fi  #Cierre de fi - optejecucion=3 (seleccionMenuModoTiempoEjecucionAlgormitmo=3)
} #Fin de dibujarBandaTiempos()

####################################################################################
# Sinopsis: Muestra en pantalla/informe una tabla con el resultado final tras la ejecución
# de todos los procesos
####################################################################################
function resultadoFinalDeLaEjecucion {
	if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 4 ]]; then
		echo " Procesos introducidos (ordenados por tiempo de llegada):" | tee -a $informeConColorTotal
		echo -e " ┌─────┬─────┬─────┬─────┬─────┬──────┬──────┐" | tee -a $informeConColorTotal
		echo -e " │ Ref │ Tll │ Tej │ Mem │ Pri │ TEsp │ Tret │" | tee -a $informeConColorTotal
		echo -e " ├─────┼─────┼─────┼─────┼─────┼──────┼──────┤" | tee -a $informeConColorTotal
		echo -e " ┌─────┬─────┬─────┬─────┬─────┬──────┬──────┐" >> $informeSinColorTotal
		echo -e " │ Ref │ Tll │ Tej │ Mem │ Pri │ TEsp │ Tret │" >> $informeSinColorTotal
		echo -e " ├─────┼─────┼─────┼─────┼─────┼──────┼──────┤" >> $informeSinColorTotal
		for (( i=0; i<$nprocesos; i++ )) ; do  #Se usa m porque i recorre los procesos y m controla las unidades usadas por cada proceso, normalmente 0 o 1, y también las unidades de los n trozos de memoria asociados a cada proceso.
			echo -e " │ ${varC[$i]}${proceso[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#llegada[$i]})${varC[$i]}${llegada[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#ejecucion[$i]})${varC[$i]}${ejecucion[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#memoria[$i]})${varC[$i]}${memoria[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#prioProc[$i]})${varC[$i]}${prioProc[$i]}$NC │"\
			"$(imprimirEspaciosAnchos ${#temp_wait[$i]})${varC[$i]}${temp_wait[$i]}$NC │"\
			"$(imprimirEspaciosAnchos ${#temp_ret[$i]})${varC[$i]}${temp_ret[$i]}$NC │" | tee -a $informeConColorTotal
			echo -e " │ ${proceso[$i]} │ $(imprimirEspaciosEstrechosBN ${#llegada[$i]})${llegada[$i]} │"\
			"$(imprimirEspaciosEstrechosBN ${#ejecucion[$i]})${ejecucion[$i]} │"\
			"$(imprimirEspaciosEstrechosBN ${#memoria[$i]})${memoria[$i]} │"\
			"$(imprimirEspaciosEstrechosBN ${#prioProc[$i]})${prioProc[$i]} │"\
			"$(imprimirEspaciosAnchosBN ${#temp_wait[$i]})${temp_wait[$i]} │"\
			"$(imprimirEspaciosAnchosBN ${#temp_ret[$i]})${temp_ret[$i]} │" >> $informeSinColorTotal
		done
		echo " └─────┴─────┴─────┴─────┴─────┴──────┴──────┘" | tee -a $informeConColorTotal
		echo " └─────┴─────┴─────┴─────┴─────┴──────┴──────┘">> $informeSinColorTotal
	else
		echo " Procesos introducidos (ordenados por tiempo de llegada):" | tee -a $informeConColorTotal
		echo -e " ┌─────┬─────┬─────┬─────┬──────┬──────┐" | tee -a $informeConColorTotal
		echo -e " │ Ref │ Tll │ Tej │ Mem │ TEsp │ Tret │" | tee -a $informeConColorTotal
		echo -e " ├─────┼─────┼─────┼─────┼──────┼──────┤" | tee -a $informeConColorTotal
		echo -e " ┌─────┬─────┬─────┬─────┬──────┬──────┐" >> $informeSinColorTotal
		echo -e " │ Ref │ Tll │ Tej │ Mem │ TEsp │ Tret │" >> $informeSinColorTotal
		echo -e " ├─────┼─────┼─────┼─────┼──────┼──────┤" >> $informeSinColorTotal
		for (( i=0; i<$nprocesos; i++ )) ; do  #Se usa m porque i recorre los procesos y m controla las unidades usadas por cada proceso, normalmente 0 o 1, y también las unidades de los n trozos de memoria asociados a cada proceso.
			echo -e " │ ${varC[$i]}${proceso[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#llegada[$i]})${varC[$i]}${llegada[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#ejecucion[$i]})${varC[$i]}${ejecucion[$i]}$NC │"\
			"$(imprimirEspaciosEstrechos ${#memoria[$i]})${varC[$i]}${memoria[$i]}$NC │"\
			"$(imprimirEspaciosAnchos ${#temp_wait[$i]})${varC[$i]}${temp_wait[$i]}$NC │"\
			"$(imprimirEspaciosAnchos ${#temp_ret[$i]})${varC[$i]}${temp_ret[$i]}$NC │" | tee -a $informeConColorTotal
			echo -e " │ ${proceso[$i]} │ $(imprimirEspaciosEstrechosBN ${#llegada[$i]})${llegada[$i]} │"\
			"$(imprimirEspaciosEstrechosBN ${#ejecucion[$i]})${ejecucion[$i]} │"\
			"$(imprimirEspaciosEstrechosBN ${#memoria[$i]})${memoria[$i]} │"\
			"$(imprimirEspaciosAnchosBN ${#temp_wait[$i]})${temp_wait[$i]} │"\
			"$(imprimirEspaciosAnchosBN ${#temp_ret[$i]})${temp_ret[$i]} │" >> $informeSinColorTotal
		done
		echo " └─────┴─────┴─────┴─────┴──────┴──────┘" | tee -a $informeConColorTotal
		echo " └─────┴─────┴─────┴─────┴──────┴──────┘">> $informeSinColorTotal
	fi

	#Promedios
	dividir=0
	for (( i=0; i<nprocesos; i++ )) ; do
		if [[ ${estad[$i]} -ne 0 ]] ; then
			dividir=$((dividir+1))
		fi
	done
	suma_espera=0
	suma_respuesta=0
	for (( i=0; i<nprocesos; i++ )); do
		tam=${memoria[$i]};
		if [[ ${estad[$i]} -ne 0 && $tam -le $mem_total ]]; then #Si el tamaño del proceso es menor o igual que el de memoria
			suma_espera=$[$suma_espera + ${temp_wait[$i]} ]            #suma para sacar su promedio
			promedio_espera=$(echo "scale=2; $suma_espera/$dividir" | bc)  #promedio

			suma_respuesta=$[ $suma_respuesta + ${temp_ret[$i]} ]   #suma para sacar su promedio
			promedio_respuesta=$(echo "scale=2; $suma_respuesta/$dividir" | bc)  #promedio
		fi
	done
	echo -e "\n┌───────────────────────┬──────────────────────────┐" | tee -a $informeConColorTotal
	echo -ne "│ T.espera medio: $promedio_espera$(imprimirEspaciosMasAnchos ${#promedio_espera})$NC " | tee -a $informeConColorTotal
	echo -e "│ T.respuesta medio: $promedio_respuesta$(imprimirEspaciosMasAnchos ${#promedio_respuesta})$NC │" | tee -a $informeConColorTotal
	echo -e "└───────────────────────┴──────────────────────────┘" | tee -a $informeConColorTotal
	echo -e "\n┌───────────────────────┬──────────────────────────┐" >> $informeSinColorTotal
	echo -ne "│ T.espera medio: $promedio_espera$(imprimirEspaciosMasAnchosBN ${#promedio_espera}) " >> $informeSinColorTotal
	echo -e "│ T.respuesta medio: $promedio_respuesta$(imprimirEspaciosMasAnchosBN ${#promedio_respuesta}) │" >> $informeSinColorTotal
	echo -e "└───────────────────────┴──────────────────────────┘" >> $informeSinColorTotal
	echo -ne $ROJO"\n\n Pulsa ENTER para continuar "$NORMAL
	read enterContinuar
} #Fin de resultadoFinalDeLaEjecucion()

####################################################################################
# Sinopsis: Permite introducir las particiones y datos desde otro fichero (predefinido).
####################################################################################
function mostrarInforme {
	echo -e "\n Final del proceso, puede consultar la salida en el fichero informeBN.txt"
	echo -e "\n Pulse enter para las opciones de visualización del fichero informeBN.txt..."
	read enter
#	clear
	cecho -e "-----------------------------------------------------"  $FRED
	cecho -e "         V I S U A L I Z A C I Ó N " $FYEL
	cecho -e "-----------------------------------------------------"  $FRED
	cecho -e " 1) Leer el fichero informeBN.txt en el terminal" $FYEL
	cecho -e " 2) Leer el fichero informeBN.txt en el editor gedit" $FYEL
	cecho -e " 3) Leer el fichero informeCOLOR.txt en el terminal" $FYEL
	cecho -e " 4) Salir y terminar"  $FYEL
	cecho -e "-----------------------------------------------------\n" $FRED
	cecho -e "Introduce una opcion: " $NC
	num=0
	continuar="SI"
	while [[ $num -ne 4 && "$continuar" == "SI" ]]; do
		read num
		case $num in
			"1" )
#				clear
				cat $informeSinColorTotal
				exit 0
				;;
			"2" )
#				clear
				gedit $informeSinColorTotal
				exit 0
				;;
			"3" )
#				clear
				cat $informeConColorTotal
				exit 0
				;;
			"4" )
#				clear
				exit 0
				;;
			*)
				num=0
				cecho "Opción errónea, vuelva a introducir:" $FRED
		esac
	done
} #Fin de mostrarInforme()

####################################################################################
####################################################################################
# COMIENZO DEL PROGRAMA
####################################################################################
####################################################################################
function inicioNuevo {
	#Empieza el script
	#Inicializamos las tablas en los temporales antes de entrar en el bucle
	nprocesos=${#proceso[@]}
	inicializaVectoresVariables #Inicilizamos diferentes tablas y variables

	# Se inicilizan las variables necesarias para la nueva línea del tiempo
	dibujasNC=("${tejecucion[@]}") #Dibujas tanto como tiempo de ejecución tengan
	imprimirDatosPantalla #Volcado de datos en pantalla tras pedir datos/introducción desde fichero.

	#B U C L E   P R I N C I P A L
	reloj=0 #Tiempo transcurrido desde el inicio del programa.
	contador=1
	parar_proceso="NO" #Controla la salida del bucle cuando finalicen todos los procesos.
	cpu_ocupada="NO" #Controla si hay procesos en ejecución.
	finalprocesos=$nprocesos #Número de procesos definidos en el problema
	realizadoAntes=0

	while [[ "$parar_proceso" == "NO" ]]; do
		procPorUnidadTiempoBT[$reloj]=$topeProcPorUnidadTiempoBT #Se inicializa al máximo antes calculado para declarar que no hay proceso en ejecución en ese instante de reloj
		timepoAux=`expr $reloj + 1`

		#E N T R A R   E N   C O L A - Si el momento de entrada del proceso coincide con el reloj marcamos el proceso como en espera, en encola()
		for (( i=0; i<$nprocesos; i++ )); do #Bucle que pone en cola los procesos.
			if [[ ${llegada[$i]} == $reloj ]]; then
				encola[$i]=1
				nollegado[$i]=0
				evento=1
				avisollegada[$i]=1
			elif [[ ${llegada[$i]} -lt $reloj ]] ; then
				nollegado[$i]=0
			else
				nollegado[$i]=1
			fi
		done

		#G U A R D A R   E N    M E M O R I A - Si un proceso está encola(), intento guardarlo en memoria, si cabe. Si lo consigo, lo marco como listo enmemoria().
		for (( i=0; i<$nprocesos; i++ )); do #Comprueba si el proceso en ejecución ha finalizado, y lo saca de memoria.
			if [[ ${enejecucion[$i]} -eq 1 && ${temp_rej[$i]} -eq 0 ]]; then
				enejecucion[$i]=0
				enmemoria[$i]=0
				mem_libre=`expr $mem_libre + ${memoria[$i]}` #Se libera la memoria que ocupaba el proceso cuando termina.
				avisosalida[$i]=1
				evento=1
				cpu_ocupada=NO
				terminados[$i]=1 #Se guarda qué procesos han terminado (1) o no (0)
				pos_inicio[$i]=""
				finalprocesos=`expr $finalprocesos - 1` #Número de procesos que quedan por ejecutar.
				estad[$i]="5" #Finalizado
			fi
		done

		calculosActualizarVariablesBandaMemoria #Se actualiza la variable memoria al terminar los procesos.

		#Con esta parte se revisa la reubicabilidad, y si hay procesos se intentan cargar antes de usar los gestores de procesos, mientras que con la que hay en la reubicación, tras reubicar y producir un hueco al final de la memoria, se reintenta cargar procesos.
		#Se comprueba que haya espacio suficiente en memoria y se meten los procesos que se puedan de la cola para empezar a ejecutar los algoritmos de gestión de procesos.
		if [[ $mem_libre -gt 0 ]]; then
#############################################################
#############################################################
#Desde aquí era el orginal para resolver un problema con la reubicación
#			reubicarReubicabilidad=0 # #Determinará si se debe o no hacer la reubicación de los procesos por condiciones de reubicabilidad. En caso de ser memoria no continua, si hay un hueco demasiado pequeño, y se va a usar como parte de la memoria a usar.
#			reubicarContinuidad=0 # #Determinará si se debe o no hacer la reubicación de los procesos por condiciones de continuidad. En caso de ser memoria continua, si no hay un hueco suficientemente grande en el que quepa pero sí en la suma de todos ellos.
#			crearListaSecuencialProcesosAlEntrarMemoria #Contiene los procesos que están en memoria de forma secuencial en la variable guardadoMemoria, y sus tamaños en tamanoGuardadoMemoria.
#			comprobacionSiguienteProcesoParaReubicar #Se determina qué proceso es el siguiente en entrar en memoria, y dependiendo de la continuidad y reubicabilidad definidas, se establece si hay espacio en memoria.
#			if [[ $reubicarReubicabilidad -eq 0 && $reubicarContinuidad -eq 0 ]]; then #Si hay que reubicar antes de meter más procesos, se hace.
#				for (( po=0; po<$nprocesos; po++ )) ; do #Se meten todos los nuevos proceso que quepan y se comprueba si hay que reubicar tras cada uno de ellos.
#					i=$po #Ajusta el bucle actual a la variable interna de la función.
#					compo_po=$po #Ajusta el bucle actual a la variable interna de la función.
#					comprobacionSiguienteProcesoParaMeterMemoria
#					meterProcesosBandaMemoria
#					if [[ $noCabe0Cabe1 -eq 0 ]]; then #Sin este if+break fallaba porque podía meter otro proceso en memoria si tenía el espacio suficiente, incluso colándose a otro proceso anterior.
#						break
#					fi
#				done
#			else
#				calculosReubicarYMeterProcesosBandaMemoria #Se reubica la memoria.
#				evento=0 #Se impide un nuevo volcado en pantalla en el que no se vea avance de la aplicación.
#				timepoAux=$reloj #Se modifica restando una unidad para ajustar el reloj y variables temporales al anular un ciclo del bucle, ya que la variable timepoAux se modifica al principio del bucle principal mediante: timepoAux=`expr $reloj + 1`
#			fi
#Hasta aquí era el orginal para resolver un problema con la reubicación
#############################################################
#############################################################
#Desde aquí para resolver un problema con la reubicación
			cierreMensajeReub=1 #Permitirá que se imprima el mensaje de reubicacón una única vez.
			for (( po=0; po<$nprocesos; po++ )) ; do #Se meten todos los nuevos proceso que quepan y se comprueba si hay que reubicar tras cada uno de ellos. 
				reubicarReubicabilidad=0 #Determinará si se debe o no hacer la reubicación de los procesos por condiciones de reubicabilidad. En caso de ser memoria no continua, si hay un hueco demasiado pequeño, y se va a usar como parte de la memoria a usar.
				reubicarContinuidad=0 #Determinará si se debe o no hacer la reubicación de los procesos por condiciones de continuidad. En caso de ser memoria continua, si no hay un hueco suficientemente grande en el que quepa pero sí en la suma de todos ellos.
				crearListaSecuencialProcesosAlEntrarMemoria #En la variable guardadoMemoria contiene los procesos que están en memoria de forma secuencial. Y sus tamaños en tamanoGuardadoMemoria.
#NO BORRAR-ORI				comprobacionSiguienteProcesoParaReubicar #Se determina qué proceso es el siguiente en entrar en memoria, y dependiendo de la continuidad y reubicabilidad definidas, se establece si hay espacio en memoria, y si hay que reubicar antes de pensar en meter el proceso. #NO BORRAR-PASA DE PREVENTIVA A CONDICINADA
				comprobacionSiguienteProcesoParaReubicarCondicionada #Se determina qué proceso es el siguiente en entrar en memoria, y dependiendo de la continuidad y reubicabilidad definidas, se establece si hay espacio en memoria, y si hay que reubicar antes de pensar en meter el proceso. #NO BORRAR-PASA DE PREVENTIVA A CONDICINADA
#NO BORRAR-PASA DE CONDICINADA A PREVENTIVA 				comprobacionSiguienteProcesoParaReubicarPreventiva #Se determina qué proceso es el siguiente en entrar en memoria, y dependiendo de la continuidad y reubicabilidad definidas, se establece si hay espacio en memoria, y si hay que reubicar antes de pensar en meter el proceso. #NO BORRAR-PASA DE CONDICINADA A PREVENTIVA	
				if [[ $reubicarReubicabilidad -eq 1 || $reubicarContinuidad -eq 1 ]]; then #Si en la comprobación se determina que hay que reubicar, entra en este if y reubica.
					calculosReubicarYMeterProcesosBandaMemoria #Se reubica la memoria.
					evento=0 #Se impide un nuevo volcado en pantalla en el que no se vea avance de la aplicación.
					timepoAux=$reloj #Se modifica restando una unidad para ajustar el reloj y variables temporales al anular un ciclo del bucle, ya que la variable timepoAux se modifica al principio del bucle principal mediante: timepoAux=`expr $reloj + 1` 
					reubicarReubicabilidad=0 #Una vez reubicado se reinicializan para seguir buscando huecos y nuevas necesidades de reubicación.
					reubicarContinuidad=0
					encontradoHuecoMuyReducido=0
				fi
				if [[ $reubicarReubicabilidad -eq 0 && $reubicarContinuidad -eq 0 ]]; then #Si ya no hay que reubicar antes de meter más procesos, y hay un proceso que tenga que entrar en memoria, se mete ese proceso.
					compo_po=$po #Ajusta el bucle actual a la variable interna de la función.
#NO BORRAR-ORI					comprobacionSiguienteProcesoParaMeterMemoria
					comprobacionSiguienteProcesoParaMeterMemoriaCondicionada #NO BORRAR-PASA DE PREVENTIVA A CONDICINADA
#NO BORRAR-PASA DE CONDICINADA A PREVENTIVA					comprobacionSiguienteProcesoParaMeterMemoriaPreventiva #NO BORRAR-PASA DE CONDICINADA A PREVENTIVA	
					meterProcesosBandaMemoria
					if [[ $noCabe0Cabe1 -eq 0 ]]; then #Sin este if+break fallaba porque podía meter otro proceso en memoria si tenía el espacio suficiente, incluso colándose a otro proceso anterior.
						break
					fi
				fi
			done
		fi
#Hasta aquí para resolver un problema con la reubicación
#############################################################
#############################################################
		# P L A N I F I C A D O R   D E   P R O C E S O S
		# Si hay procesos listos en memoria(), se ejecuta el que corresponde en función del criterio de planificación que,
		# en este caso, es el que tenga una ejecución más corta de todos los procesos. Se puede expulsar a un proceso de la CPU
		# Si acaba un proceso, su tiempo de ejecución se ponemos a 0 en la lista de enejecución y se libera la memoria que estaba ocupando
		if [[ $reubicarReubicabilidad -eq 0 && $reubicarContinuidad -eq 0 ]]; then #Si hay que reubicar antes de meter más procesos, se hace.
#            procPorUnidadTiempoBT[$reloj]=$topeProcPorUnidadTiempoBT #Contiene el número de orden del proceso ejecutado en cada instante. Se inicializa en cada instante para ser modificado dentro de cualquiera de lso algoritmos posteriores.
			if [[ $alg == 1 ]]; then
				gestionProcesosFCFS #Algoritmo de gestión de procesos: FCFS
			elif [[ $alg == 2 ]]; then
				gestionProcesosSJF #Algoritmo de gestión de procesos: SJF
			elif [[ $alg == 3 ]]; then
				gestionProcesosSRPT #Algoritmo de gestión de procesos: SRPT
			elif [[ $alg == 4 ]]; then
				gestionProcesosPrioridades #Algoritmo de gestión de procesos: Prioridades
			elif [[ $alg == 5 ]]; then
				gestionProcesosRoundRobin #Algoritmo de gestión de procesos: Round Robin
			fi
		fi
		#I M P R E S I Ó N   D E   E V E N T O S
		if [[ $evento -eq 1 ]]; then #Los eventos los determinan en las funciones gestionProcesosFCFS, gestionProcesosSJF y gestionProcesosSRPT
			calculosImpresionBandaTiempos #Prepara la banda de tiempos de procesos en cada volcado
			mostrarEventos #Se muestran los eventos sucedidos, sobre la tabla resumen.
			# C Á L C U L O   D E   L A   B A N D A   D E   M E M O R I A
			# Habrá un array inicialmente relleno de "_" que se va llenando de las referencias de los procesos (memoria()). Después será usado para formar la banda de memoria.
			# $po es el índice usado para los procesos y $ra para las posiciones de la memoria al recorrer el array.
			# Hay otros arrays como el que se usa para generar los diferentes bloques que conforman cada proceso, relacionados con la reubicación (bloques()).
			calculosPrepararLineasImpresionBandaMemoria
			# D I B U J O   D E   L A   T A B L A   D E   D A T O S   Y   D E   L A S   B A N D A S (Normalmente, por eventos)
			# Los eventos suceden cuando se realiza un cambio en los estados de cualquiera de los procesos.
			# Los tiempos T.ESPERA, T.RESPUESTA y T.RESTANTE sólo se mostrarán en la tabla cuando el estado del proceso sea distinto de "No ha llegado".
			# Para ello hacemos un bucle que pase por todos los procesos que compruebe si el estado nollegado() es 0 y para cada uno de los tiempos, si se debe mostrar se guarda el tiempo, si no se mostrará un guión
			# Hay una lista de los procesos en memoria en la variable $guardados()
			dibujarTablaDatos #Prepara e imprime la tabla resumen de procesos en cada volcado
#            dibujarBandaMemoriaORI #Se imprime la banda de memoria. Versión original, más compleja, corta y con iguales resultados.
			dibujarBandaMemoria #Se imprime la banda de memoria. Nueva versión, más fácil de interpretar y adaptar, larga y con iguales resultados.
			dibujarBandaTiempos #Se imprime la banda de tiempo
		fi #Cierre de Impresión Eventos

		# Se incrementa el contador de tiempos de ejecución y de espera de los procesos y se decrementa
		# el tiempo de ejecución que tiene el proceso que se encuentra en ejecución.
		if [[ $reubicarReubicabilidad -eq 0 && $reubicarContinuidad -eq 0 ]]; then #Si hay que reubicar antes de meter más procesos, se hace.
			ajusteFinalTiemposEsperaEjecucionRestante #Prepara e imprime la tabla resumen de procesos en cada volcado - PRUEBA DE COPIAR LÍNEA A lÍNEA
		fi
	done #Fin del while con "$parar_proceso" = "NO"

#	clear
	tiempofinal=`expr $reloj - 1` #Para ajustar el tiempo final
	echo -e "\n Tiempo: $tiempofinal  " | tee -a $informeConColorTotal
	echo -e " Ejecución terminada." | tee -a $informeConColorTotal
	echo -e "-----------------------------------------------------------\n" | tee -a $informeConColorTotal
	echo -e "\n Tiempo: $tiempofinal  " >> $informeSinColorTotal
	echo -e " Ejecución terminada." >> $informeSinColorTotal
	echo -e "-----------------------------------------------------------\n" >> $informeSinColorTotal
	resultadoFinalDeLaEjecucion #Impresión de datos finales
	mostrarInforme #Elección de visualización de informes
} #Final del programa principal - inicioNuevo()

####################################################################################
####################################################################################
##############                   PROGRAMA PRINCIPAL                #################
####################################################################################
#Llamada a todas las funciones de forma secuencial
revisarArbolDirectorios #Regenera el árbol de directorios, si no se encuentra.
presentacionPantallaInforme #Carátula inicial con autores, versiones y licencias
menuInicio #Elección de ejecución o ayuda
inicioNuevo #Inicio de la ejecución del programa
