#!/bin/bash
####################################################################################
#
#   AUTORES: Jaime Sáiz de la Peña y los alumnos de la asignatura Sistemas Operativos del Grado en Ingeniería Informática (2012-2024) - Universidad de Burgos
#	TUTOR: José Manuel Saiz Diez
#
####################################################################################
# Script realizado para la simulación de un SO que utilice diferentes modelos de gestión de procesos y memoria con un total de 32 opciones diferentes.
# El algoritmo de gestión de procesos se basará en FCFS, SJF, SRPT, Prioridad Mayor y Menor (Apropiativo y No Apropiativo) y Round-Robin.
# La gestión de memoria se implementa mediante particiones fijas e iguales, y fijas y no iguales con primer, mejor y peor ajuste.

####################################################################################
# VARIABLES DE EJECUCIÓN
####################################################################################
# seleccionMenuInicio - Opciones iniciales de ayuda y ejecución
# seleccionMenuAyuda - Opciones de ayuda
# seleccionMenuDOCPDF - Opciones de elección de ficheros PDF de ayuda de los algoritmos
# seleccionMenuDOCVideo - Opciones de elección de ficheros de vídeo de ayuda de los algoritmos
# seleccionMenuAlgoritmoGestionProcesos - Opciones de elección de algoritmo d gestión de Procesos (FCFS/SJF/SRPT/Prioridades/Round-Robin)
# seleccionMenuAlgoritmoGestionFIFNIMemoria - Opciones de elección del tipo de particiones fijas
# seleccionMenuAlgoritmoGestionAjusteMemoria - Opciones de elección del tipo ajuste de elección de partición
# seleccionTipoPrioridad - Opciones del tipo de Prioridad (Mayor/Menor)
# seleccionMenuApropiatividad - Opciones del tipo de Apropiatividad (Apropiativo/No Apropiativo)
# seleccionMenuEleccionEntradaDatos - Opciones para la elección de fuente en la introducción de datos (Datos manual/Fichero de datos de última ejecución/Fichero de datos por defecto/Otro fichero de datos...
# .../Rangos manual/Fichero de rangos de última ejecución/Fichero de rangos por defecto/Otro fichero de rangos...
# .../Rangos aleatorios manual/Fichero de rangos aleatorios de última ejecución/Fichero de rangos aleatorios por defecto/Otro fichero de rangos aleatorios)
# .../Rangos aleatorios amplios manual/Fichero de rangos aleatorios amplios de última ejecución/Fichero de rangos aleatorios amplios por defecto/Otro fichero de rangos aleatorios amplios)
# seleccionMenuModoTiempoEjecucionAlgormitmo - Opciones para la elección del tipo de ejecución (Por eventos/Automatico/Completo)
# seleccionMenuPreguntaDondeGuardarDatosManuales - Opciones para la selección del fichero de datos de salida (datosDefault, Otros)
# seleccionMenuPreguntaDondeGuardarRangosManuales - Opciones para la selección del fichero de rangos de salida (rangosDefault, Otros)
# seleccionMenuPreguntaDondeGuardarRangosAleTManuales - Opciones para la selección del fichero de rangos amplios (ficheroRangosAleTotalDefault, Otros)
####################################################################################
#                                         VARIABLES
####################################################################################
# Estados de los procesos:
#	${estad[$i]}=0 - ${estado[$i]}="Fuera del Sistema"
#	${estad[$i]}=1 - ${estado[$i]}="En espera"
#	${estad[$i]}=2 - ${estado[$i]}="En memoria" 
#	${estad[$i]}=3 - ${estado[$i]}="En ejecución" 
#	${estad[$i]}=4 - ${estado[$i]}="En pausa" 
#	${estad[$i]}=5 - ${estado[$i]}="Finalizado"
####################################################################################
reloj=0 #Variable que guarda el tiempo de ejecución actual
masparticion=s #Variable bandera que determina si el usuario desea introducir mas particiones. Inicializada a s (sí)
contadorParticiones=1 #Contador para la introducción de particiones
masprocesos=s #Variable bandera que determina si el usuario desea introducir mas particiones
declare -a estad #Índices: (proceso). Número asociado a cada estado de los procesos (de 1 a 5).
declare -A estado #Índices: (proceso). Texto asociado a cada estado de los procesos (de "Fuera del Sistema" a "Finalizado").
declare -a colaTiempoRR #Contiene el orden de ejecución de Round-Robin (RR). Será "-" mientras no esté en cola, o cuando haya terminado, y si aún no ha terminado contendrá el número ordinal del siguiente quantum. El proceso a ejecutar será, por tanto, el que tenga el número ordinal más bajo. Y el número de quantums realizados (cambios de contexto, será el número ordinal más alto.
p=1 #Contador
i=1 #Contador
j=0 #Contador
k=0 #Contador
suma_espera=0 #Variable donde se acumula la suma de los tiempos de espera de todos los procesos
suma_respuesta=0 #Variable donde se acumula la suma de los tiempos de retorno de todos los procesos
aux=0 #Variable auxiliar utilizada para intercambiar valores
lineaspart=0 #Variable que almacena el número de líneas de fichero de entrada de particiones
counter=0 #Variable auxiliar utilizada como índice
nombre=0 #Variable para almacenar nombre de procesos
salida=n #Variable que indica que la ejecución de todos los procesos ha finalizado
procesosFinalizados=0 #Variable que contiene el número de procesos finalizados
enterContinuar=0 #Variable para hacer una continuar alamacenando valor en variable sin uso posterior
DIA=0 #Variable para mostrar el día de la última ejecución en informe de salida
HORA=0 #Variable para mostrar la hora de la última ejecución en informe de salida
semaforo=0 #Variable para controlar acceso o parada de un proceso
part=0 #Variable auxiliar utilizada como índice
longCampoTablaEstrecho=3 #Ancho de columnas estrechas en tabla resumen de procesos en los volcados
longCampoTablaAncho=4 #Ancho de columnas anchas en tabla resumen de procesos en los volcados
longCampoTablaMasAncho=5 #Ancho de columnas más anchas en tabla resumen de procesos en los volcados
longCampoTablaMuyAncho=17 #Ancho de columnas muy anchas en tabla resumen de procesos en los volcados
longCampoTablaRangosCortos=3 #Ancho de columnas estrechas en tabla de rangos
longCampoTablaRangosLargos=9 #Ancho de columnas anchas en tabla de rangos
poreventos=0 #Será 1 si se produce algún evento (cambio de estados), y por tanto, hay que imprimir un volcado
#Para determinar tres tipos de eventos (cambios de estado de los procesos) con lo que disparar un volcado
evento1=0 #Cuando un proceso deja de estar en ejecución (cuando pasa a pausa o finaliza)
evento2=0 #Evento de T=0

####################################################################################
# VARIABLES DE REPRESENTACIÓN DEL MAPA DE MEMORIA
####################################################################################
terminal=0 # Ancho del terminal en cada Enter de ejecución de volcados
varhuecos="                                                                                                                                                                                                                                                   "
varguiones="---------------------------------------------------------------------------------------------"
varasteriscos="******************************************************************************************"
varfondos="██████████████████████████████████████████████████████████████████████████████████████████████"
esc=$(echo -en "\033")
RESET2=$esc"[0m"
####################################################################################
# VARIABLES PARA DESTACAR TEXTO CON COLOR
####################################################################################
#NORMAL=$esc"[1;m"
NORMAL=$esc"[0;m"		#NORMAL=$esc"[1;m"
ROJO=$esc"[1;31m"
VERDE=$esc"[1;32m"
AMARILLO=$esc"[1;33m"
AZUL=$esc"[1;34m"
MORADO=$esc"[1;35m"
CYAN=$esc"[1;36m"

####################################################################################
# VARIABLES PARA DESTACAR TEXTO CON COLOR FONDO
####################################################################################
NORMAL2=$esc"[1;m"
ROJO2=$esc"[41m"
VERDE2=$esc"[42m"
AMARILLO2=$esc"[43m"
AZUL2=$esc"[44m"
MORADO2=$esc"[45m"
CYAN2=$esc"[46m"

####################################################################################
#VECTORES
####################################################################################
proceso=() #Almacena el nombre de cada proceso indicado por el usuario
llegada=() #Tiempo de llegada de los procesos
tiempo=() #Tiempo de ejecución de los procesos
memoria=() #Espacio en memoria requerido por el proceso
prioProc=() #Prioridad asignada al proceso
tiempoEsperaProceso=() #Tiempo de espera de los procesos
tiempoNEsperaProceso=() #Tiempo de espera de los procesos (0 si es negativo)
tiempoRetornoProceso=() #Tiempo de respuesta de los procesos
tiempoNRetornoProceso=() #Tiempo de respuesta de los procesos (0 si es negativo)
partConProceso=() #Número de partición ocupada por cada proceso
procesoEnParticionOcupada=() #Contiene un 1 para cada proceso que está en memoria
partEnVectorDeProceso=() #Contiene el número de partición asociada a cada proceso
particiones=() #Vector donde se almacenan las los tamaños de las particiones existentes
colores=() #Vector donde se almacenan los colores
colores2=() #Vector donde se almacenan los colores para el fondo del texto
bloqueo=() #Vector que almacena (0/1) para bloquear un reset de tiemp ejec inicial
sale=() #Vector que indica si un Px ha salido o no de memoria
porcentaje=() #Almacena el porcentaje usado de cada partición

####################################################################################
# VECTORES TEMPORALES PARA ALMACENAR ANTES DE COMPROBACIÓN PREVIA
####################################################################################
proceso2=() #Nombre del proceso
llegada2=() #Tiempo de llegada
tiempo2=() #Tiempo de ejecución
memoria2=() #Espacio en memoria
profich=() #Vector auxiliar para entrada de procesos por fichero

####################################################################################
# VECTORES DE COLORES
####################################################################################
colores[0]=$ROJO
colores[1]=$VERDE
colores[2]=$CYAN
colores[3]=$AZUL
colores[4]=$AMARILLO
colores[5]=$MORADO

####################################################################################
# VECTORES DE COLORES2
####################################################################################
colores2[0]=$ROJO2
colores2[1]=$VERDE2
colores2[2]=$CYAN2
colores2[3]=$AZUL2
colores2[4]=$AMARILLO2
colores2[5]=$MORADO2

####################################################################################
# Ficheros de salida. informeConColorTotalkk
####################################################################################
dirFLast="./FLast" #Directorio que contiene los ficheros de última ejecución (datos (DatosLast.txt), rangos (RangosLast.txt) y rangos amplios (RangosAleTotalLast)).
dirFDatos="./FDatos" #Directorio con los ficheros de datos generados por defecto (DatosDefault.txt) o por decisión del susuario.
dirFRangos="./FRangos" #Directorio con los ficheros de datos generados por defecto (RangosDefault.txt) o con el nombre por decisión del susuario.
dirFRangosAleT="./FRangosAleT" #Directorio con los ficheros de datos generados por defecto (RangosAleTotalDefault.txt) o con el nombre por decisión del susuario.
dirInformes="./Informes" #Directorio con los ficheros que contendrán todos los volcados de la ejecución del script en color (informeCOLOR.txt) y en blanco y negro (informeBN.txt).
informeSinColorTotal="./Informes/informeBN.txt" #Informe en blanco/negro de todo lo visto en pantalla durante la ejecución del script.
informeConColorTotal="./Informes/informeCOLOR.txt" #Informe a color de todo lo visto en pantalla durante la ejecución del script.

ficheroDatosAnteriorEjecucion="./FLast/DatosLast.txt" #Datos de particiones y procesos de la ejecución anterior.
ficheroDatosDefault="./FDatos/DatosDefault.txt" #Datos de particiones y procesos de la copia estándar (por defecto).

ficheroRangosAnteriorEjecucion="./FLast/RangosLast.txt" #Rangos de particiones y procesos de la ejecución anterior.
ficheroRangosDefault="./FRangos/RangosDefault.txt" #Rangos de particiones y procesos de la copia estándar (por defecto).

ficheroRangosAleTotalAnteriorEjecucion="./FLast/RangosAleTotalLast.txt" #Rangos amplios de particiones y procesos de la ejecución anterior para la extracción de subrangos.
ficheroRangosAleTotalDefault="./FRangosAleT/RangosAleTotalDefault.txt" #Rangos amplios de particiones y procesos de la copia estándar (por defecto) para la extracción de subrangos.

nomFicheroDatos="./FDatos/DatosDefault.txt" #Se inicializa la variable de fichero de datos
nomFicheroRangos="./FRangos/RangosDefault.txt" #Se inicializa la variable de fichero de rangos
nomFicheroRangosAleT="./FRangosAleT/RangosAleTotalDefault.txt" #Se inicializa la variable de fichero de rangos amplios

####################################################################################
# Comentarios sobre los elementos utilizados en el desarrollo
####################################################################################
# ${#llegada[@]} - Representa el número de procesos del problema
# maxCaracteres - Representa el número de dígitos de las unidades
# procPorUnidadTiempo - En cada casilla (instante actual - reloj) contiene el orden del proceso que se ejecuta
# en cada instante.

####################################################################################
####################################################################################
#             FUNCIONES
####################################################################################
####################################################################################
# Sinopsis: Al inicio del programa muestra la cabecera por pantalla y la envía a los
# informes de B/N y COLOR.
####################################################################################
function presentacionPantallaInforme {
#    clear
	truncate -s 0 $informeConColorTotal #Se borran los datos de los ficheros de informes
	truncate -s 0 $informeSinColorTotal
	# Salida para informe a blanco/negro y a pantalla
	echo -e "\n ########################################################################\n"\
	"#                                                                      #\n"\
	"#             LICENCIA: CREATIVE COMMONS (CC BY-NC-SA)                 #\n"\
	"#                                                                      #\n"\
	"#             BY: Atribución - Reconocimiento                          #\n"\
	"#             NC: Uso No Comercial                                     #\n"\
	"#             SA: Compartir Igual                                      #\n"\
	"#                                                                      #\n"\
	"########################################################################" >> $informeSinColorTotal #La opción >> lo crea inicialmente

	echo -e "\n ########################################################################\n"\
	"#                                                                      #\n"\
	"#     ALGORITMO DE GESTIÓN DE PROCESOS:                                #\n"\
	"#           FCFS/SJF/SRPT//PRIORIDADES(MAYOR Y MENOR)-                 #\n"\
	"#           APROPIATIVO Y NO APROPIATIVO)/ROUND-ROBIN (RR)             #\n"\
	"#                                                                      #\n"\
	"#     ALGORITMO DE GESTIÓN DE MEMORIA:                                 #\n"\
	"#           PARTICIONES FIJAS E IGUALES/                               #\n"\
	"#           PARTICIONES FIJAS NO IGUALES Y AJUSTE PRIMER/MEJOR/PEOR    #\n"\
	"#                                                                      #\n"\
	"#     Autores: Jaime Sáiz de la Peña                                   #\n"\
	"#              y los alumnos de la asignatura Sistemas Operativos      #\n"\
	"#                                                                      #\n"\
	"#              Grado en Ingeniería Informática (2012-2024)             #\n"\
	"#                         Universidad de Burgos                        #\n"\
	"#                                                                      #\n"\
	"#                     Tutor: José Manuel Sáiz Diez                     #\n"\
	"#                                                                      #\n"\
	"#                     Versión junio 2024 (V-0.1)                       #\n"\
	"#                                                                      #\n"\
	"########################################################################\n" >> $informeSinColorTotal
	DIA=$(date +"%d/%m/%Y")
	HORA=$(date +"%H:%M")
	echo -e " ÚLTIMA EJECUCIÓN: $DIA - $HORA\n" >> $informeSinColorTotal

	# Salida para informe a color
	echo -e $AMARILLO"  ########################################################################\n"\
	" #                                                                      #\n"\
	" #             LICENCIA: CREATIVE COMMONS (CC BY-NC-SA)                 #\n"\
	" #                                                                      #\n"\
	" #             BY: Atribución - Reconocimiento                          #\n"\
	" #             NC: Uso No Comercial                                     #\n"\
	" #             SA: Compartir Igual                                      #\n"\
	" #                                                                      #\n"\
	" ########################################################################\n" | tee -a $informeConColorTotal #La opción -a lo crea inicialmente en caso de no estar creado

	echo -e "  ########################################################################\n"\
	" #                                                                      #\n"\
	" #     ALGORITMO DE GESTIÓN DE PROCESOS:                                #\n"\
	" #           FCFS/SJF/SRPT//PRIORIDADES(MAYOR Y MENOR)-                 #\n"\
	" #           APROPIATIVO Y NO APROPIATIVO)/ROUND-ROBIN (RR)             #\n"\
	" #                                                                      #\n"\
	" #     ALGORITMO DE GESTIÓN DE MEMORIA:                                 #\n"\
	" #           PARTICIONES FIJAS E IGUALES/                               #\n"\
	" #           PARTICIONES FIJAS NO IGUALES Y AJUSTE PRIMER/MEJOR/PEOR    #\n"\
	" #                                                                      #\n"\
	" #     Autores: Jaime Sáiz de la Peña                                   #\n"\
	" #              y los alumnos de la asignatura Sistemas Operativos      #\n"\
	" #                                                                      #\n"\
	" #              Grado en Ingeniería Informática (2012-2024)             #\n"\
	" #                         Universidad de Burgos                        #\n"\
	" #                                                                      #\n"\
	" #                     Tutor: José Manuel Sáiz Diez                     #\n"\
	" #                                                                      #\n"\
	" #                     Versión junio 2024 (V-0.1)                       #\n"\
	" #                                                                      #\n"\
	" ########################################################################\n" | tee -a $informeConColorTotal
	DIA=$(date +"%d/%m/%Y")
	HORA=$(date +"%H:%M")
	echo -e $NORMAL" ÚLTIMA EJECUCIÓN: $DIA - $HORA\n" | tee -a $informeConColorTotal

	echo -ne $ROJO"\n Pulsa ENTER para comenzar "$NORMAL
	read enterContinuar
} #Fin de presentacionPantallaInforme()

####################################################################################
# Sinopsis: Cabecera de inicio
####################################################################################
function cabecerainicio {
	echo -e "\n$CYAN ############################################################################$NC\n"\
	"$CYAN#$NC                                                                          $CYAN#$NC\n"\
	"$CYAN#$NC$AZUL  GESTIÓN DE PROCESOS: FCFS/SJF/SRPT/Prioridad Mayor y Menor/Round-Robin$NC  $CYAN#$NC\n"\
	"$CYAN#$NC$AZUL  GESTIÓN DE MEMORIA: PARTICIONES FIJAS E IGUALES/$NC                        $CYAN#$NC\n"\
	"$CYAN#$NC$AZUL        /FIJAS Y NO IGUALES Y AJUSTE PRIMER/MEJOR/PEOR$NC                    $CYAN#$NC\n"\
	"$CYAN#$NC                                                                          $CYAN#$NC\n"\
	"$CYAN############################################################################$NC\n" | tee -a $informeConColorTotal
	echo -e "\n ##############################################################################\n"\
	"#                                                                            #\n"\
	"#   GESTIÓN DE PROCESOS: FCFS/SJF/SRPT/Prioridad Mayor y Menor/Round-Robin   #\n"\
	"#   GESTIÓN DE MEMORIA: PARTICIONES FIJAS E IGUALES/                         #\n"\
	"#         /FIJAS Y NO IGUALES Y AJUSTE PRIMER/MEJOR/PEOR                     #\n"\
	"#                                                                            #\n"\
	"##############################################################################\n" >> $informeSinColorTotal
} #Fin de cabecerainicio()

####################################################################################
# Sinopsis: Comprobar si existe el árbol de directorios utilizados en el programa
####################################################################################
function revisarArbolDirectorios { #Regenera el árbol de directorios si no se encuentra.
#    clear
	if [[ ! -d $dirFLast ]]; then
		mkdir $dirFLast
	fi
	if [[ ! -d $dirFDatos ]]; then
		mkdir $dirFDatos
	fi
	if [[ ! -d $dirFRangos ]]; then
		mkdir $dirFRangos
	fi
	if [[ ! -d $dirFRangos ]]; then
		mkdir $dirFRangos
	fi
	if [[ ! -d $dirInformes ]]; then
		mkdir $dirInformes
	fi
} #Fin de revisarArbolDirectorios()

####################################################################################
# Sinopsis: Menú inicial para mostrar el manual de usuario o ejecutar el programa
####################################################################################
function menuInicio {
#    clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ INICIO\n"$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n MENÚ INICIO\n" >> $informeSinColorTotal
	echo -ne "\n  1. Acceder al programa principal\n"\
	"\n  2. Menú de ayuda (requiere 'evince' para los ficheros PDF, o 'mplayer' para los ficheros de vídeo)\n"\
	"\n  3. Crear informe de código mediante zshelldoc\n"\
	"\n  4. Salir\n\n  --> " | tee -a $informeConColorTotal $informeSinColorTotal
	read seleccionMenuInicio
	echo -e "$seleccionMenuInicio\n\n" >> $informeConColorTotal
	echo -e "$seleccionMenuInicio\n\n" >> $informeSinColorTotal

	#Comprobación de que el número introducido por el usuario es de 1 a 4
	until [[ "0" -lt $seleccionMenuInicio && $seleccionMenuInicio -lt "5" ]];	do
		echo -ne " Error en la elección de una opción válida\n\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n\n  --> " >> $informeSinColorTotal
		read seleccionMenuInicio
		echo -e "$seleccionMenuInicio\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuInicio\n\n" >> $informeSinColorTotal
	done

	case "$seleccionMenuInicio" in
		'1')
			menuAlgoritmoGestionProcesos #Permite elegir entre FCFS, SJF, SRPT, Prioridades y Round Robin
			;;
		'2')
			menuAyuda #Permite ver los ficheros de ayuda en formato PDF y de vídeo
			;;
		'3')
			echo $0
			echo " El informe resultante es ./zsdoc/$0.adc junto con el subdirectorio ./zsdoc/data." | tee -a $informeConColorTotal
			echo " El informe resultante es ./zsdoc/$0.adc junto con el subdirectorio ./zsdoc/data." >> $informeSinColorTotal
			echo " Si el formato no es el adecuado o para estandarizar ese formato, se puede imprimir o transformar el documento a fichero pdf." | tee -a $informeConColorTotal
			echo " Si el formato no es el adecuado o para estandarizar ese formato, se puede imprimir o transformar el documento a fichero pdf." >> $informeSinColorTotal
			/home/$USER/opt/local/bin/zsd --verbose $0 #...O el directorio que se corresponda con la localización de zshelldoc, dependiendo de dónde se haya instalado
			exit 0
			;;
		'4')
			echo -e $ROJO"\nSE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0
			;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
			;;
	esac
} #Fin de menuInicio()

####################################################################################
# Sinopsis: Menú de ayuda con ficheros PDF y de vídeo
####################################################################################
function menuAyuda {
#	clear
	cabecerainicio
	echo -ne "\n MENÚ DE AYUDA\n"\
	"\n  1. Ver documentos de ayuda del en formato PDF desde el listado de problemas (requiere 'evince')\n"\
	"\n  2. Ver documentos de ayuda en formato PDF desde el listado de ficheros (requiere 'evince')\n"\
	"\n  3. Ver documentos de ayuda en formato Vídeo desde el listado de problemas (requiere 'mplayer')\n"\
	"\n  4. Ver documentos de ayuda en formato Vídeo desde el listado de ficheros (requiere 'mplayer')\n"\
	"\n  5. Salir\n\n  --> " | tee -a $informeConColorTotal $informeSinColorTotal
	read seleccionMenuInicio
	until [[ $seleccionMenuInicio > 0 && $seleccionMenuInicio < 6 ]]; do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuInicio
		echo -e "$seleccionMenuInicio\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuInicio\n\n" >> $informeSinColorTotal
	done
	case "$seleccionMenuInicio" in
		'1')
			menuDOCPDF
			;;
		'2') #Un fichero a elegir
			echo -e "\n\n Ficheros de ayuda existentes en formato PDF:\n$NORMAL" | tee -a $informeConColorTotal
			echo -e "\n\n Ficheros de ayuda existentes en formato PDF:\n" >> $informeSinColorTotal
			files=("./DOCPDF"/*)
			for i in "${!files[@]}"; do #Localiza en qué posición encuentra el dato (da la posición, pero no la variable en el array)
				echo -e "$(($i+1))) ${files[$i]}" | tee -a $informeConColorTotal
				echo -e "$(($i+1))) ${files[$i]}" >> $informeSinColorTotal
			done
			echo -ne "\n$AMARILLO\n Introduce el número correspondiente al fichero elegido: $NORMAL" | tee -a $informeConColorTotal
			echo -ne "\n\n Introduce el número correspondiente al fichero elegido: " >> $informeSinColorTotal
			read -r numeroFicheroPDF
			echo -e "$numeroFicheroPDF\n\n" >> $informeConColorTotal
			echo -e "$numeroFicheroPDF\n\n" >> $informeSinColorTotal
			until [[ 0 -lt $numeroFicheroPDF && $numeroFicheroPDF -le ${#files[@]} && $numeroFicheroPDF -ne "" ]]; do
				echo -ne " Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
				echo -ne " Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
				read -r numeroFicheroPDF
				echo -e "$numeroFicheroPDF\n\n" >> $informeConColorTotal
				echo -e "$numeroFicheroPDF\n\n" >> $informeSinColorTotal
			done
			ficheroParaLecturaPDF="${files[$((numeroFicheroPDF-1))]}"
			evince $ficheroParaLecturaPDF
			menuInicio
			;;
		'3')
			menuDOCVideo
			;;
		'4')
			echo -e "\n\n Ficheros de ayuda existentes en formato de Vídeo:\n$NORMAL" | tee -a $informeConColorTotal
			echo -e "\n\n Ficheros de ayuda existentes en formato de Vídeo:\n" >> $informeSinColorTotal
			files=("./DOCVideo"/*)
			for i in "${!files[@]}"; do #Localiza en qué posición encuentra el dato (da la posición, pero no la variable en el array)
				echo -e "$((i+1))) ${files[$i]}" | tee -a $informeConColorTotal
				echo -e "$((i+1))) ${files[$i]}" >> $informeSinColorTotal
			done
			echo -ne "\n$AMARILLO\n Introduce el número correspondiente al fichero elegido: $NORMAL" | tee -a $informeConColorTotal
			echo -ne "\n\n Introduce el número correspondiente al fichero elegido: " >> $informeSinColorTotal
			read -r numeroFicheroVideo
			echo -e "$numeroFicheroVideo\n\n" >> $informeConColorTotal
			echo -e "$numeroFicheroVideo\n\n" >> $informeSinColorTotal
			until [[ 0 -lt $numeroFicheroVideo && $numeroFicheroVideo -le ${#files[@]} && $numeroFicheroVideo -ne "" ]]; do
				echo -ne " Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
				echo -ne " Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
				read -r numeroFicheroVideo
				echo -e "$numeroFicheroVideo\n\n" >> $informeConColorTotal
				echo -e "$numeroFicheroVideo\n\n" >> $informeSinColorTotal
			done
			ficheroParaLecturaVideo="${files[$((numeroFicheroVideo-1))]}"
			mplayer $ficheroParaLecturaVideo
			menuInicio
			;;
		'5')
			echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0 ;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal ;;
	esac
} #Fin de menuAyuda()

####################################################################################
# Sinopsis: Menú de elección del Algoritmo de Gestión de Procesos; FCFS, SJF, SRPT.
####################################################################################
function menuDOCPDF {
#    clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE DOCUMENTOS DE AYUDA (Texto en formato PDF - Necesita 'evince')\n"$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DE DOCUMENTOS DE AYUDA (Texto en formato PDF - Necesita 'evince')\n" >> $informeSinColorTotal
	echo -ne "\n  0. Gestión de Procesos y Gestión de Memoria - Introducción y Herramientas"\
	"\n  1. FCFS-FI-Entrada manual de Datos"\
	"\n  2. SJF-FI-Entrada mediante Ficheros de Datos de Última Ejecución"\
	"\n  3. SRPT-FNI-PRIMER-Entrada mediante Otros Ficheros de Datos"\
	"\n  4. Prioridades-Mayor-No Apropiativo-FNI-MEJOR-Entrada manual de Rangos"\
	"\n  5. Prioridades-Menor-Apropiativo-FNI-PEOR-Entrada mediante Ficheros de Rangos de Última Ejecución"\
	"\n  6. Round-Robin(RR)-FNI-PRIMER-Entrada mediante Otros Ficheros de Rangos"\
	"\n  7. Prioridades-Mayor-Apropiativo-FNI-MEJOR-Entrada manual de Rangos Amplios"\
	"\n  8. Prioridades-Menor-Apropiativo-FNI-PEOR-Entrada mediante Ficheros de Rangos Amplios de Última Ejecución"\
	"\n  9. Round-Robin(RR)-FNI-PRIMER-Entrada mediante Otros Ficheros de Rangos Amplios"\
	"\n  10. Salir\n\n  --> " | tee -a $informeConColorTotal $informeSinColorTotal
	read seleccionMenuDOCPDF
	echo -ne "$seleccionMenuDOCPDF\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuDOCPDF\n\n" >> $informeSinColorTotal

	#Comprobación de que el número introducido por el usuario es de 1 a 4
	until [[ "0" -le $seleccionMenuDOCPDF && $seleccionMenuDOCPDF -lt "10" ]];	do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuDOCPDF
		echo -e "$seleccionMenuDOCPDF\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuDOCPDF\n\n" >> $informeSinColorTotal
	done

	if [[ $seleccionMenuDOCPDF -ge 0 && $seleccionMenuDOCPDF -le 9 ]]; then
		if [[ $seleccionMenuDOCPDF -eq 0 ]]; then evince ./DOCPDF/000-ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 1 ]]; then evince ./DOCPDF/1-001-FCFS-FI-MD.pdf
		elif [[ $seleccionMenuDOCPDF -eq 2 ]]; then evince ./DOCPDF/1-002-SJF-FI-FDUE.pdf
		elif [[ $seleccionMenuDOCPDF -eq 3 ]]; then evince ./DOCPDF/1-003-SRPT-FNI-Primer-OFD.pdf
		elif [[ $seleccionMenuDOCPDF -eq 4 ]]; then evince ./DOCPDF/1-004-Prioridades-Mayor-NoAp-FNI-Mejor-MR.pdf
		elif [[ $seleccionMenuDOCPDF -eq 5 ]]; then evince ./DOCPDF/1-005-Prioridades-Menor-Ap-FNI-Peor-FRUE.pdf
		elif [[ $seleccionMenuDOCPDF -eq 6 ]]; then evince ./DOCPDF/1-006-RR-FNI-Primer-OFR.pdf
		elif [[ $seleccionMenuDOCPDF -eq 7 ]]; then evince ./DOCPDF/1-007-Prioridades-Mayor-Ap-FNI-Mejor-MRA.pdf
		elif [[ $seleccionMenuDOCPDF -eq 8 ]]; then evince ./DOCPDF/1-008-Prioridades-Menor-Ap-FNI-Peor-FRAUE.pdf
		elif [[ $seleccionMenuDOCPDF -eq 9 ]]; then evince ./DOCPDF/1-009-RR-FNI-Primer-OFRA.pdf
		fi
		menuInicio
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 21 ]]; then
		echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
	else
		echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
		echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
	fi
} #Fin de menuDOCPDF()

####################################################################################
# Sinopsis: Menú de elección del Algoritmo de Gestión de Procesos; FCFS, SJF, SRPT.
####################################################################################
function menuDOCPDF_ORI {
#    clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE DOCUMENTOS DE AYUDA (Texto en formato PDF - Necesita 'evince')\n"$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DE DOCUMENTOS DE AYUDA (Texto en formato PDF - Necesita 'evince')\n" >> $informeSinColorTotal
	echo -ne "\n  1. FCFS-FI"\
	"\n  2. FCFS-FNI-MEJOR"\
	"\n  3. FCFS-FNI-PEOR"\
	"\n  4. FCFS-FNI-PRIMER"\
	"\n  5. SJF-FI"\
	"\n  6. SJF-FNI-MEJOR"\
	"\n  7. SJF-FNI-PEOR"\
	"\n  8. SJF-FNI-PRIMER"\
	"\n  9. SRPT-FI"\
	"\n  10. SRPT-FNI-MEJOR"\
	"\n  11. SRPT-FNI-PEOR"\
	"\n  12. SRPT-FNI-PRIMER"\
	"\n  13. PrioridadMayorMenor-FI"\
	"\n  14. PrioridadMayorMenor-FNI-MEJOR"\
	"\n  15. PrioridadMayorMenor-FNI-PEOR"\
	"\n  16. PrioridadMayorMenor-FNI-PRIMER"\
	"\n  17. Round-Robin(RR)-FI"\
	"\n  18. Round-Robin(RR)-FNI-MEJOR"\
	"\n  19. Round-Robin(RR)-FNI-PEOR"\
	"\n  20. Round-Robin(RR)-FNI-PRIMER"\
	"\n  21. Salir\n\n  --> " | tee -a $informeConColorTotal
	read seleccionMenuDOCPDF
	echo -ne "$seleccionMenuDOCPDF\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuDOCPDF\n\n" >> $informeSinColorTotal

	#Comprobación de que el número introducido por el usuario es de 1 a 4
	until [[ "0" -lt $seleccionMenuDOCPDF && $seleccionMenuDOCPDF -lt "22" ]];	do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuDOCPDF
		echo -e "$seleccionMenuDOCPDF\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuDOCPDF\n\n" >> $informeSinColorTotal
	done

	if [[ $seleccionMenuDOCPDF -ge 1 && $seleccionMenuDOCPDF -le 20 ]]; then
		if [[ $seleccionMenuDOCPDF -eq 1 ]]; then evince ./DOCPDF/001-FCFS-SJF-FI.pdf
		elif [[ $seleccionMenuDOCPDF -eq 2 ]]; then
			evince ./DOCPDF/002-FCFS-SJF-FNI-Mejor-1.pdf
			evince ./DOCPDF/002-FCFS-SJF-FNI-Mejor-2.pdf
		elif [[ $seleccionMenuDOCPDF -eq 3 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 4 ]]; then evince ./DOCPDF/004-FCFS-SJF-FNI-Primer.pdf
		elif [[ $seleccionMenuDOCPDF -eq 5 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 6 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 7 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 8 ]]; then evince ./DOCPDF/004-FCFS-SJF-FNI-Primer.pdf
		elif [[ $seleccionMenuDOCPDF -eq 9 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 10 ]]; then
			evince ./DOCVideo/010-SRPT-FNI-Mejor-1.pdf
			evince ./DOCVideo/010-SRPT-FNI-Mejor-2.pdf
		elif [[ $seleccionMenuDOCPDF -eq 11 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 12 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 13 ]]; then evince ./DOCPDF/013-PRIMayorMenor-FI.pdf
		elif [[ $seleccionMenuDOCPDF -eq 14 ]]; then evince ./DOCPDF/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCPDF -eq 15 ]]; then evince ./DOCPDF/015-PRIMayorMenor-FNI-Peor.pdf
		elif [[ $seleccionMenuDOCPDF -eq 16 ]]; then evince ./DOCPDF/016-PRIMayorMenor-FNI-Primer.pdf
		elif [[ $seleccionMenuDOCPDF -eq 17 ]]; then evince ./DOCPDF/017-RR-FI.pdf
		elif [[ $seleccionMenuDOCPDF -eq 18 ]]; then evince ./DOCPDF/018-RR-FNI-Mejor.pdf
		elif [[ $seleccionMenuDOCPDF -eq 19 ]]; then evince ./DOCPDF/019-RR-FNI-Peor.pdf
		elif [[ $seleccionMenuDOCPDF -eq 20 ]]; then evince ./DOCPDF/020-RR-FNI-Primer.pdf
		fi
		menuInicio
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 21 ]]; then
		echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
	else
		echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
		echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
	fi
} #Fin de menuDOCPDF_ORI()

####################################################################################
# Sinopsis: Menú de elección del Algoritmo de Gestión de Procesos; FCFS, SJF, SRPT.
####################################################################################
function menuDOCVideo {
#    clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE DOCUMENTOS DE AYUDA (Vídeos - Necesita 'mplayer')\n"$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DE DOCUMENTOS DE AYUDA (Vídeos - Necesita 'mplayer')\n" >> $informeSinColorTotal
	echo -ne "\n  1. FCFS-FI"\
	"\n  2. FCFS-FNI-MEJOR"\
	"\n  3. FCFS-FNI-PEOR"\
	"\n  4. FCFS-FNI-PRIMER"\
	"\n  5. SJF-FI"\
	"\n  6. SJF-FNI-MEJOR"\
	"\n  7. SJF-FNI-PEOR"\
	"\n  8. SJF-FNI-PRIMER"\
	"\n  9. SRPT-FI"\
	"\n  10. SRPT-FNI-MEJOR"\
	"\n  11. SRPT-FNI-PEOR"\
	"\n  12. SRPT-FNI-PRIMER"\
	"\n  13. PrioridadMayorMenor-FI"\
	"\n  14. PrioridadMayorMenor-FNI-MEJOR"\
	"\n  15. PrioridadMayorMenor-FNI-PEOR"\
	"\n  16. PrioridadMayorMenor-FNI-PRIMER"\
	"\n  17. Round-Robin(RR)-FI"\
	"\n  18. Round-Robin(RR)-FNI-MEJOR"\
	"\n  19. Round-Robin(RR)-FNI-PEOR"\
	"\n  20. Round-Robin(RR)-FNI-PRIMER"\
	"\n  21. Salir\n\n  --> " | tee -a $informeConColorTotal $informeSinColorTotal
	read seleccionMenuDOCVideo
	echo -ne "$seleccionMenuDOCVideo\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuDOCVideo\n\n" >> $informeSinColorTotal

	#Comprobación de que el número introducido por el usuario es de 1 a 4
	until [[ "0" -lt $seleccionMenuDOCVideo && $seleccionMenuDOCVideo -lt "22" ]];	do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuDOCVideo
		echo -e "$seleccionMenuDOCVideo\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuDOCVideo\n\n" >> $informeSinColorTotal
	done

	if [[ $seleccionMenuDOCVideo -ge 1 && $seleccionMenuDOCVideo -le 20 ]]; then
		if [[ $seleccionMenuDOCVideo -eq 1 ]]; then mplayer ./DOCVideo/001-FCFS-SJF-FI-1.mp4
		elif [[ $seleccionMenuDOCVideo -eq 2 ]]; then mplayer ./DOCVideo/002-FCFS-SJF-FNI-Mejor.mp4
		elif [[ $seleccionMenuDOCVideo -eq 3 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 4 ]]; then mplayer ./DOCVideo/004-FCFS-SJF-FNI-Primer.mp4
		elif [[ $seleccionMenuDOCVideo -eq 5 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 6 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 7 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 8 ]]; then mplayer ./DOCVideo/004-FCFS-SJF-FNI-Primer.mp4
		elif [[ $seleccionMenuDOCVideo -eq 9 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 10 ]]; then mplayer ./DOCVideo/010-SRPT-FNI-Mejor.mp4
		elif [[ $seleccionMenuDOCVideo -eq 11 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 12 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 13 ]]; then mplayer ./DOCVideo/013-PRIMayorMenor-FI.mp4
		elif [[ $seleccionMenuDOCVideo -eq 14 ]]; then evince ./DOCVideo/ManualDeUsuario.pdf
		elif [[ $seleccionMenuDOCVideo -eq 15 ]]; then mplayer ./DOCVideo/015-PRIMayorMenor-FNI-Peor.mp4
		elif [[ $seleccionMenuDOCVideo -eq 16 ]]; then mplayer ./DOCVideo/016-PRIMayorMenor-FNI-Primer.mp4
		elif [[ $seleccionMenuDOCVideo -eq 17 ]]; then mplayer ./DOCVideo/017-RR-FI-1.mp4
		elif [[ $seleccionMenuDOCVideo -eq 18 ]]; then
			mplayer ./DOCVideo/018-RR-FNI-Mejor-1.mp4
			mplayer ./DOCVideo/018-RR-FNI-Mejor-2.mp4
		elif [[ $seleccionMenuDOCVideo -eq 19 ]]; then mplayer ./DOCVideo/019-RR-FNI-Peor.mp4
		elif [[ $seleccionMenuDOCVideo -eq 20 ]]; then
			mplayer ./DOCVideo/020-RR-FNI-Primer-1.mp4
			mplayer ./DOCVideo/020-RR-FNI-Primer-2.mp4
		fi
		menuInicio
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 21 ]]; then
		echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
	else
		echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
		echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
	fi
} #Fin de menuDOCVideo()

####################################################################################
# Sinopsis: Menú de elección del Algoritmo de Gestión de Procesos; FCFS, SJF, SRPT.
####################################################################################
function menuAlgoritmoGestionProcesos {
#    clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE ALGORITMO\n"$NORMAL\
	"\n  1. FCFS\n"\
	"\n  2. SJF\n"\
	"\n  3. SRPT\n"\
	"\n  4. Prioridades\n"\
	"\n  5. Round-Robin (RR)\n"\
	"\n  6. Salir\n\n  --> " | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DE ALGORITMO\n"\
	"\n  1. FCFS\n"\
	"\n  2. SJF\n"\
	"\n  3. SRPT\n"\
	"\n  4. Prioridades\n"\
	"\n  5. Round-Robin (RR)\n"\
	"\n  6. Salir\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuAlgoritmoGestionProcesos
	echo -ne "$seleccionMenuAlgoritmoGestionProcesos\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuAlgoritmoGestionProcesos\n\n" >> $informeSinColorTotal

	#Comprobación de que el número introducido por el usuario es de 1 a 6
	until [[ "0" -lt $seleccionMenuAlgoritmoGestionProcesos && $seleccionMenuAlgoritmoGestionProcesos -lt "7" ]];	do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuAlgoritmoGestionProcesos
		echo -e "$seleccionMenuAlgoritmoGestionProcesos\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuAlgoritmoGestionProcesos\n\n" >> $informeSinColorTotal
	done

	if [[ $seleccionMenuAlgoritmoGestionProcesos -ge 1 && $seleccionMenuAlgoritmoGestionProcesos -le 5 ]]; then
		if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 4 ]]; then
			menuTipoPrioridad #Menú de elección del tipo de prioridad (Mayor/Menor).
			menuApropiatividad #Menú de elección de apropiatividad. Cuando se ejecuta con Prioridades. Se hace en menuAlgoritmoGestionProcesos()
		fi
		menuAlgoritmoGestionFIFNIMemoria
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 6 ]]; then
		echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
	else
		echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
		echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
	fi
} #Fin de menuAlgoritmoGestionProcesos()

####################################################################################
# Sinopsis: Menú de elección del Algoritmo de Gestión de memoria: Ajuste Primer, Mejor, Peor.
####################################################################################
function menuAlgoritmoGestionFIFNIMemoria {
#    clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE TIPO DE PARTICIONES FIJAS\n"$NORMAL\
	"\n  1. Particiones Fijas e Iguales"\
	"\n  2. Particiones Fijas y NO Iguales"\
	"\n  3. Salir\n\n  --> " | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DE AJUSTE\n"\
	"\n  1. Particiones Fijas e Iguales"\
	"\n  2. Particiones Fijas y NO Iguales"\
	"\n  3. Salir\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuAlgoritmoGestionFIFNIMemoria
	echo -ne "$seleccionMenuAlgoritmoGestionFIFNIMemoria\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuAlgoritmoGestionFIFNIMemoria\n\n" >> $informeSinColorTotal

	#Comprobación de que el número introducido por el usuario es de 1 a 3
	until [[ "0" -lt $seleccionMenuAlgoritmoGestionFIFNIMemoria && $seleccionMenuAlgoritmoGestionFIFNIMemoria -lt "4" ]];	do
		echo -ne "\nError en la elección de una opción válida\n\n  --> " | tee -a $informeConColorTotal
		echo -ne "Error en la elección de una opción válida\n\n  --> " >> $informeSinColorTotal
		read seleccionMenuAlgoritmoGestionFIFNIMemoria
		echo -ne "$seleccionMenuAlgoritmoGestionFIFNIMemoria\n\n" >> $informeConColorTotal
		echo -ne "$seleccionMenuAlgoritmoGestionFIFNIMemoria\n\n" >> $informeSinColorTotal
	done

	case "$seleccionMenuAlgoritmoGestionFIFNIMemoria" in
		'1')
			echo -e "\nSe debe ejecutar como Fijas y NO Iguales con el mismo tamaño de particiones, y con el ajuste Primer\n" | tee -a $informeConColorTotal
			echo -e "\nSe debe ejecutar como Fijas y NO Iguales con el mismo tamaño de particiones, y con el ajuste Primer\n" >> $informeSinColorTotal
			echo -ne $ROJO"\n\n Pulsa ENTER para continuar "$NORMAL
			read enterContinuar
			menuAlgoritmoGestionFIFNIMemoria
			;;
		'2')
			menuAlgoritmoGestionAjusteMemoria
			;;
		'3')
			echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0 ;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e "Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e "Error en la elección de una opción válida" >> $informeSinColorTotal
			;;
	esac
} #Fin de menuAlgoritmoGestionFIFNIMemoria()

####################################################################################
# Sinopsis: Menú de elección del Algoritmo de Gestión de memoria: Ajuste Primer, Mejor, Peor.
####################################################################################
function menuAlgoritmoGestionAjusteMemoria {
#    clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE AJUSTE\n"$NORMAL\
	"\n  1. Ajuste Primer"\
	"\n  2. Ajuste Mejor"\
	"\n  3. Ajuste Peor"\
	"\n  4. Salir\n\n  --> " | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DE AJUSTE\n"\
	"\n  1. Ajuste Primer"\
	"\n  2. Ajuste Mejor"\
	"\n  3. Ajuste Peor"\
	"\n  4. Salir\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuAlgoritmoGestionAjusteMemoria
	echo -ne "$seleccionMenuAlgoritmoGestionAjusteMemoria\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuAlgoritmoGestionAjusteMemoria\n\n" >> $informeSinColorTotal
	#Comprobación de que el número introducido por el usuario es de 1 a 4
	until [[ "0" -lt $seleccionMenuAlgoritmoGestionAjusteMemoria && $seleccionMenuAlgoritmoGestionAjusteMemoria -lt "5" ]];	do
		echo -ne "\n Error en la elección de una opción válida\n\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n\n  --> " >> $informeSinColorTotal
		read seleccionMenuAlgoritmoGestionAjusteMemoria
		echo -ne "$seleccionMenuAlgoritmoGestionAjusteMemoria" >> $informeConColorTotal
		echo -ne "$seleccionMenuAlgoritmoGestionAjusteMemoria" >> $informeSinColorTotal
	done
	case "$seleccionMenuAlgoritmoGestionAjusteMemoria" in
		'1')
			menuEleccionEntradaDatos
			;;
		'2')
			menuEleccionEntradaDatos
			;;
		'3')
			menuEleccionEntradaDatos
			;;
		'4')
			echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0
			;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
			;;
	esac
} #Fin de menuAlgoritmoGestionAjusteMemoria()

####################################################################################
# Sinopsis: Menú de elección de Tipo de Prioridad (Mayor/Menor). Cuando se ejecuta con Prioridades.
####################################################################################
function menuTipoPrioridad {
#	clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DEL TIPO DE PRIORIDAD"$NORMAL\
	"\n\n  1. Prioridad Mayor"\
	"\n\n  2. Prioridad Menor"\
	"\n\n  3. Salir\n\n  --> " | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DEL TIPO DE PRIORIDAD"\
	"\n\n  1. Prioridad Mayor"\
	"\n\n  2. Prioridad Menor"\
	"\n\n  3. Salir\n\n  --> " >> $informeSinColorTotal
	read seleccionTipoPrioridad
	echo -ne "$seleccionTipoPrioridad\n\n" >> $informeConColorTotal
	echo -ne "$seleccionTipoPrioridad\n\n" >> $informeSinColorTotal
	until [[ 0 -lt $seleccionTipoPrioridad && $seleccionTipoPrioridad -lt 4 ]]; do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionTipoPrioridad
		echo -e "$seleccionTipoPrioridad\n\n" >> $informeConColorTotal
		echo -e "$seleccionTipoPrioridad\n\n" >> $informeSinColorTotal
	done
} #Fin de menuApropiatividad()

####################################################################################
# Sinopsis: Menú de elección de Apropiatividad. Cuando se ejecuta con Prioridades.
####################################################################################
function menuApropiatividad {
#	clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ DE ELECCIÓN DE APROPIATIVIDAD"$NORMAL\
	"\n\n  1. No apropiativo"\
	"\n\n  2. Apropiativo"\
	"\n\n  3. Salir\n\n  --> " | tee -a $informeConColorTotal
	echo -ne "\n MENÚ DE ELECCIÓN DE APROPIATIVIDAD"\
	"\n\n  1. No apropiativo"\
	"\n\n  2. Apropiativo"\
	"\n\n  3. Salir\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuApropiatividad
	echo -ne "$seleccionMenuApropiatividad\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuApropiatividad\n\n" >> $informeSinColorTotal
	until [[ 0 -lt $seleccionMenuApropiatividad && $seleccionMenuApropiatividad -lt 4 ]]; do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuApropiatividad
		echo -e "$seleccionMenuApropiatividad\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuApropiatividad\n\n" >> $informeSinColorTotal
	done
	case "$seleccionMenuApropiatividad" in
		'1')
			apropiatividadNo0Si1=0 ;;
		'2')
			apropiatividadNo0Si1=1 ;;
		'3')
			echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0 ;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal ;;
	esac
} #Fin de menuApropiatividad()

####################################################################################
# Sinopsis: Menú de elección de opciones de entrada de datos/rangos/rangos amplios del programa:
# Manul, Última ejecución, Otros ficheros.
####################################################################################
function menuEleccionEntradaDatos {
#    clear
	cabecerainicio
	echo -ne $AMARILLO"\n MENÚ INICIO\n"$NORMAL\
	"\n  1. Introducción de datos manual\n"\
	"\n  2. Fichero de datos de última ejecución (./FLast/DatosLast.txt)\n"\
	"\n  3. Otros ficheros de datos\n"\
	"\n  4. Introducción de rangos manual (modo aleatorio)\n"\
	"\n  5. Fichero de rangos de última ejecución (./FLast/RangosLast.txt)\n"\
	"\n  6. Otros ficheros de rangos\n"\
	"\n  7. Introducción de rangos amplios manual (modo aleatorio total)\n"\
	"\n  8. Fichero de rangos amplios de última ejecución (./FLast/RangosAleTotalLast.txt)\n"\
	"\n  9. Otros ficheros de rangos amplios\n"\
	"\n  10. Salir\n\n  --> "| tee -a $informeConColorTotal
	echo -ne "\n MENÚ INICIO\n"\
	"\n  1. Introducción de datos manual\n"\
	"\n  2. Fichero de datos de última ejecución (./FLast/DatosLast.txt)\n"\
	"\n  3. Otros ficheros de datos\n"\
	"\n  4. Introducción de rangos manual (modo aleatorio)\n"\
	"\n  5. Fichero de rangos de última ejecución (./FLast/RangosLast.txt)\n"\
	"\n  6. Otros ficheros de rangos\n"\
	"\n  7. Introducción de rangos amplios manual (modo aleatorio total)\n"\
	"\n  8. Fichero de rangos amplios de última ejecución (./FLast/RangosAleTotalLast.txt)\n"\
	"\n  9. Otros ficheros de rangos amplios\n"\
	"\n  10. Salir\n\n  --> " >>$informeSinColorTotal
	read seleccionMenuEleccionEntradaDatos
	echo -ne "$seleccionMenuEleccionEntradaDatos\n\n" >> $informeConColorTotal
	echo -ne "$seleccionMenuEleccionEntradaDatos\n\n" >> $informeSinColorTotal

	#Comprobación de que el número introducido por el usuario es de 1 a 10
	until [[ "0" -lt $seleccionMenuEleccionEntradaDatos && $seleccionMenuEleccionEntradaDatos -lt "11" ]];	do
		echo -ne "\n Error en la elección de una opción válida\n\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n\n  --> " >> $informeSinColorTotal
		read seleccionMenuEleccionEntradaDatos
		echo -ne "$seleccionMenuEleccionEntradaDatos\n\n" >> $informeConColorTotal
		echo -ne "$seleccionMenuEleccionEntradaDatos\n\n" >> $informeSinColorTotal
	done
	case "$seleccionMenuEleccionEntradaDatos" in
		'1') #1. Introducción de datos manual
			nuevaEjecucion
			preguntaDondeGuardarDatosManuales
			entradaParticionesTeclado
			entradaProcesosTeclado
			menuModoTiempoEjecucionAlgormitmo
			;;
		'2') #2. Fichero de datos de última ejecución (./FLast/DatosLast.txt)
			menuModoTiempoEjecucionAlgormitmo
			leer_datos_desde_fichero $ficheroDatosAnteriorEjecucion
			;;
		'3') #3. Otros ficheros de datos
			nuevaEjecucion
			entradaMemoriaDatosFichero_op_tres
			menuModoTiempoEjecucionAlgormitmo
			;;
		'4') #4. Introducción de rangos manual (modo aleatorio)
			nuevaEjecucion
			entradaMemoriaRangosFichero_op_cuatro
			menuModoTiempoEjecucionAlgormitmo
			;;
		'5') #5. Fichero de rangos de última ejecución (./FLast/DatosRangosLast.txt)
			#nuevaEjecucion
			entradaMemoriaRangosFichero_op_cinco_Previo
			ficheroEntrada_op_cinco_seis_ocho_nueve=$ficheroRangosAnteriorEjecucion
			leer_rangos_desde_fichero
			entradaMemoriaRangosFichero_op_cinco_seis
			entradaMemoriaRangosFichero_op_cinco_Post_1
			menuModoTiempoEjecucionAlgormitmo
			;;
		'6') #6. Otros ficheros de rangos
			nuevaEjecucion
			entradaMemoriaRangosFichero_op_seis_Previo
			ficheroEntrada_op_cinco_seis_ocho_nueve=$FicheroParaLectura
			leer_rangos_desde_fichero
			entradaMemoriaRangosFichero_op_cinco_seis
			entradaMemoriaRangosFichero_op_seis_Post_1
			menuModoTiempoEjecucionAlgormitmo
			;;
		'7') #7. Introducción de rangos amplios manual (modo aleatorio total)
			nuevaEjecucion
			entradaMemoriaRangosFichero_op_siete_Previo
			entradaMemoriaRangosFichero_op_siete
			entradaMemoriaRangosFichero_op_siete_ocho_nueve
			menuModoTiempoEjecucionAlgormitmo
			;;
		'8') #8. Fichero de rangos amplios de última ejecución
			#nuevaEjecucion
			entradaMemoriaRangosFichero_op_ocho_Previo
			ficheroEntrada_op_cinco_seis_ocho_nueve=$ficheroRangosAleTotalAnteriorEjecucion
			leer_rangos_desde_fichero
			entradaMemoriaRangosFichero_op_siete_ocho_nueve
			menuModoTiempoEjecucionAlgormitmo
			;;
		'9') #9. Otros ficheros de rangos amplios
			nuevaEjecucion
			entradaMemoriaRangosFichero_op_nueve_Previo
			ficheroEntrada_op_cinco_seis_ocho_nueve=$FicheroParaLectura
			leer_rangos_desde_fichero
			entradaMemoriaRangosFichero_op_siete_ocho_nueve
			menuModoTiempoEjecucionAlgormitmo
			;;
		'10') #10. Salir
			echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0
			;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
			;;
	esac
} #Fin de menuEleccionEntradaDatos()

####################################################################################
# Sinopsis: Se decide el modo de ejecución: Por eventos, Automática, Completa, Unidad de tiempo
# a unidad de tiempo
####################################################################################
function menuModoTiempoEjecucionAlgormitmo {
#    clear
	cabecerainicio
	echo -ne $AMARILLO"\n Introduce una opción:\n$NORMAL"\
	"\n  1. Ejecución por eventos (Presionando Enter en cada evento)."\
	"\n  2. Ejecución automática (Por eventos y sin pausas)"\
	"\n  3. Ejecución completa (Con pausas de cierto número de segundos)."\
	"\n  4. Ejecución por unidad de tiempo. (Con un volcado en cada unidad de tiempo)."\
	"\n  5. Ejecución completa (Sin representación de resultados intermedios).\n\n  --> $NC" | tee -a $informeConColorTotal
	echo -ne "\n Introduce una opción:\n"\
	"\n  1. Ejecución por eventos (Presionando Enter en cada evento)."\
	"\n  2. Ejecución automática (Por eventos y sin pausas)"\
	"\n  3. Ejecución completa (Con pausas de cierto número de segundos)."\
	"\n  4. Ejecución por unidad de tiempo (Con un volcado en cada unidad de tiempo)."\
	"\n  5. Ejecución completa (Sin representación de resultados intermedios).\n\n  --> $NC" >> $informeSinColorTotal
	read seleccionMenuModoTiempoEjecucionAlgormitmo
	echo -e "$seleccionMenuModoTiempoEjecucionAlgormitmo" >> $informeConColorTotal
	echo -e "$seleccionMenuModoTiempoEjecucionAlgormitmo" >> $informeSinColorTotal

	# Comprobación de que el número introducido por el usuario esta entre 1 y 5
	until [[ "0" -lt $seleccionMenuModoTiempoEjecucionAlgormitmo && $seleccionMenuModoTiempoEjecucionAlgormitmo -lt "6" ]];	do
		echo -ne "\n Error en la elección de una opción válida\n\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n\n  --> " >> $informeSinColorTotal
		read seleccionMenuModoTiempoEjecucionAlgormitmo
		echo -e "$seleccionMenuModoTiempoEjecucionAlgormitmo\n" >> $informeConColorTotal
		echo -e "$seleccionMenuModoTiempoEjecucionAlgormitmo\n" >> $informeSinColorTotal
	done

	case $seleccionMenuModoTiempoEjecucionAlgormitmo in
		'1') #Por eventos
			optejecucion=1
			;;
		'2') #Automática. Por eventos y sin espera.
			tiempoejecucion=0
			optejecucion=2
			;;
		'3') #Completa. Por eventos y con espera.
			echo -ne " Introduce el tiempo entre actualizaciones de datos (segundos): " | tee -a $informeConColorTotal
			echo -ne " Introduce el tiempo entre actualizaciones de datos (segundos): " >> $informeSinColorTotal
			read tiempoejecucion
			until [[ "0" -le $tiempoejecucion ]];	do
				echo -ne "\n Error en la elección de una opción válida. Debe ser mayor o igual a 0.\n\n  --> " | tee -a $informeConColorTotal
				echo -ne " Error en la elección de una opción válida. Debe ser mayor o igual a 0.\n\n  --> " >> $informeSinColorTotal
				read tiempoejecucion
				echo -e "$tiempoejecucion\n" >> $informeConColorTotal
				echo -e "$tiempoejecucion\n" >> $informeSinColorTotal
			done
			optejecucion=3
			;;
		'4') #De unidad de tiempo en unidad de tiempo
			optejecucion=4
			;;
		'5') #Sólo resultados finales.
			optejecucion=5
			;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
			;;
	esac
#    clear
} #Fin de menuModoTiempoEjecucionAlgormitmo()

####################################################################################
# Sinopsis: Se eliminan los archivos de última ejecución que había anteriormente creados y
# nos direcciona a la entrada de particiones y procesos
####################################################################################
function nuevaEjecucion {
#    clear
	if [[ -f $ficheroDatosAnteriorEjecucion ]]; then
		rm $ficheroDatosAnteriorEjecucion
	fi
	if [[ -f $ficherosRangosAnteriorEjecucion && ($seleccionMenuEleccionEntradaDatos -eq 4 || $seleccionMenuEleccionEntradaDatos -eq 6 || $seleccionMenuEleccionEntradaDatos -eq 7 || $seleccionMenuEleccionEntradaDatos -eq 8 || $seleccionMenuEleccionEntradaDatos -eq 9) ]]; then
		rm $ficherosRangosAnteriorEjecucion
	fi
	if [[ -f $ficheroRangosAleTotalAnteriorEjecucion && ($seleccionMenuEleccionEntradaDatos -eq 7 || $seleccionMenuEleccionEntradaDatos -eq 9) ]]; then
		rm $ficheroRangosAleTotalAnteriorEjecucion
	fi
} #Fin de nuevaEjecucion()

####################################################################################
# Sinopsis: Se pregunta por las opciones de guardar lo datos de particiones y procesos.
# Se pregunta si se quiere guardar los datos en el fichero estándar (Default) o en otro.
# Si es en otro, pide el nombre del archivo.
####################################################################################
function preguntaDondeGuardarDatosManuales {
	cabecerainicio
	#Pregunta para los datos por teclado
	echo -ne $AMARILLO"\n ¿Dónde quiere guardar los datos resultantes?\n"$NORMAL\
	"\n  1. En el fichero estándar ($ficheroDatosDefault)"\
	"\n  2. En otro fichero\n\n  --> " | tee -a $informeConColorTotal
	echo -ne "\n ¿Dónde quiere guardar los datos resultantes?\n"\
	"\n  1. En el fichero estándar ($ficheroDatosDefault)"\
	"\n  2. En otro fichero\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuPreguntaDondeGuardarDatosManuales
	echo -e "$seleccionMenuPreguntaDondeGuardarDatosManuales\n\n" >> $informeConColorTotal
	echo -e "$seleccionMenuPreguntaDondeGuardarDatosManuales\n\n" >> $informeSinColorTotal

	# Comprobación de que el número introducido por el usuario esta entre 1 y 2
	until [[ "0" -lt $seleccionMenuPreguntaDondeGuardarDatosManuales && $seleccionMenuPreguntaDondeGuardarDatosManuales -lt "3" ]];	do
		echo -ne "\n Error en la elección de una opción válida\n\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n\n  --> " >> $informeSinColorTotal
		read seleccionMenuPreguntaDondeGuardarDatosManuales
		echo -e "$seleccionMenuPreguntaDondeGuardarDatosManuales\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuPreguntaDondeGuardarDatosManuales\n\n" >> $informeSinColorTotal
	done

	case "${seleccionMenuPreguntaDondeGuardarDatosManuales}" in
		'1') #En el fichero estándar
			truncate -s 0 $ficheroDatosDefault #Se borran los datos del fichero por defecto de la anterior ejecución
			nomFicheroDatos="$ficheroDatosDefault"
			;;
		'2') #En otro fichero
			echo -e $AMARILLO" Introduce el nombre que le quieres dar al fichero de datos (sin '.txt'):\n"$NORMAL | tee -a $informeConColorTotal
			echo -e " Introduce el nombre que le quieres dar al fichero de datos (sin '.txt'):\n" >> $informeSinColorTotal
			read seleccionNombreFicheroDatos
			nomFicheroDatos="./FDatos/""$seleccionNombreFicheroDatos.txt"
			echo -e "$seleccionNombreFicheroDatos" >> $informeConColorTotal
			echo -e "$seleccionNombreFicheroDatos" >> $informeSinColorTotal
			echo -e "$nomFicheroDatos\n\n" >> $informeConColorTotal
			echo -e "$nomFicheroDatos\n\n" >> $informeSinColorTotal
			until [[ ! -z "$seleccionNombreFicheroDatos" && ! -f "$nomFicheroDatos" ]];do
				echo -e " Ya existe un archivo con el nombre introducido, o es nulo." | tee -a $informeConColorTotal
				echo -e " Ya existe un archivo con el nombre introducido, o es nulo."  >> $informeSinColorTotal
				echo -e " Introduzca un nombre correcto: \n" | tee -a $informeConColorTotal
				echo -e " Introduzca un nombre correcto: \n" >> $informeSinColorTotal
				read seleccionNombreFicheroDatos
				nomFicheroDatos="./FDatos/""$seleccionNombreFicheroDatos.txt"
				echo -e "$seleccionNombreFicheroDatos" >> $informeConColorTotal
				echo -e "$seleccionNombreFicheroDatos" >> $informeSinColorTotal
				echo -e "$nomFicheroDatos\n" >> $informeConColorTotal
				echo -e "$nomFicheroDatos\n" >> $informeSinColorTotal
			done
			;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
			;;
	esac
#    clear
} #Fin de preguntaDondeGuardarDatosManuales()

####################################################################################
# Sinopsis: Se pregunta por las opciones de guardar lo rangos de particiones y procesos.
# Se pregunta si se quiere guardar los rangos en el fichero estándar (Default) o en otro.
# Si es en otro, pide el nombre del archivo.
####################################################################################
function preguntaDondeGuardarRangosManuales {
	cabecerainicio
	echo -ne $AMARILLO" ¿Dónde quiere guardar los rangos?\n"$NORMAL\
	"\n  1. En el fichero de rangos estándar ($ficheroRangosDefault)"\
	"\n  2. En otro fichero\n\n  --> " | tee -a  $informeConColorTotal
	echo -ne " ¿Dónde quiere guardar los rangos?\n"\
	"\n  1. En el fichero de rangos estándar ($ficheroRangosDefault)"\
	"\n  2. En otro fichero\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuPreguntaDondeGuardarRangosManuales
	echo -e "$seleccionMenuPreguntaDondeGuardarRangosManuales\n\n" >> $informeConColorTotal
	echo -e "$seleccionMenuPreguntaDondeGuardarRangosManuales\n\n" >> $informeSinColorTotal

	# Comprobación de que el número introducido por el usuario esta entre 1 y 2
	until [[ "0" -lt $seleccionMenuPreguntaDondeGuardarRangosManuales && $seleccionMenuPreguntaDondeGuardarRangosManuales -lt "3" ]];	do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuPreguntaDondeGuardarRangosManuales
		echo -e "$seleccionMenuPreguntaDondeGuardarRangosManuales\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuPreguntaDondeGuardarRangosManuales\n\n" >> $informeSinColorTotal
	done

	case "${seleccionMenuPreguntaDondeGuardarRangosManuales}" in
		'1') #En el fichero estándar
			truncate -s 0 $ficheroRangosDefault #Se borran los rangos del fichero por defecto de la anterior ejecución
			nomFicheroRangos="$ficheroRangosDefault"
			;;
		'2') #En otro fichero
			echo -e $AMARILLO" Introduce el nombre que le quieres dar al fichero de datos (sin '.txt'):\n  --> "$NORMAL | tee -a $informeConColorTotal
			echo -e " Introduce el nombre que le quieres dar al fichero de datos (sin '.txt'):\n  --> " >> $informeSinColorTotal
			read seleccionNombreFicheroRangos
			nomFicheroRangos="./FRangos/""$seleccionNombreFicheroRangos.txt"
			echo -e "$seleccionNombreFicheroRangos" >> $informeConColorTotal
			echo -e "$seleccionNombreFicheroRangos" >> $informeSinColorTotal
			echo -e "$nomFicheroRangos\n" >> $informeConColorTotal
			echo -e "$nomFicheroRangos\n" >> $informeSinColorTotal
			until [[ ! -z "$seleccionNombreFicheroRangos" && ! -f "$nomFicheroRangos" ]];do
				echo -e " Ya existe un archivo con el nombre introducido, o es nulo." | tee -a $informeConColorTotal
				echo -e " Ya existe un archivo con el nombre introducido, o es nulo."  >> $informeSinColorTotal
				echo -e " Introduzca un nombre correcto: \n" | tee -a $informeConColorTotal
				echo -e " Introduzca un nombre correcto: \n" >> $informeSinColorTotal
				read seleccionNombreFicheroRangos
				nomFicheroRangos="./FRangos/""$seleccionNombreFicheroRangos.txt"
				echo -ne "$seleccionNombreFicheroRangos" >> $informeConColorTotal
				echo -ne "$seleccionNombreFicheroRangos" >> $informeSinColorTotal
				echo -e "$nomFicheroRangos\n\n" >> $informeConColorTotal
				echo -e "$nomFicheroRangos\n\n" >> $informeSinColorTotal
			done
			;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
			;;
	esac
} #Fin de preguntaDondeGuardarRangosManuales()

####################################################################################
# Sinopsis: Se pregunta por las opciones de guardar los mínimos y máximos de los rangos amplios.
# Se pregunta si se quiere guardar los rangos en el fichero estándar (Default) o en otro.
# Si es en otro, pide el nombre del archivo.
####################################################################################
function preguntaDondeGuardarRangosAleTManuales {
	cabecerainicio
	echo -ne $AMARILLO" ¿Dónde quiere guardar los mínimos y máximos de los rangos amplios?\n"$NORMAL\
	"\n  1. En el fichero de rangos amplios estándar ($ficheroRangosAleTotalDefault)"\
	"\n  2. En otro fichero\n\n  --> " | tee -a  $informeConColorTotal
	echo -ne " ¿Dónde quiere guardar los mínimos y máximos de los rangos amplios?\n"\
	"\n  1. En el fichero de rangos amplios estándar ($ficheroRangosAleTotalDefault)"\
	"\n  2. En otro fichero\n\n  --> " >> $informeSinColorTotal
	read seleccionMenuPreguntaDondeGuardarRangosAleTManuales
	echo -e "$seleccionMenuPreguntaDondeGuardarRangosAleTManuales\n\n" >> $informeConColorTotal
	echo -e "$seleccionMenuPreguntaDondeGuardarRangosAleTManuales\n\n" >> $informeSinColorTotal

	# Comprobación de que el número introducido por el usuario esta entre 1 y 2
	until [[ "0" -lt $seleccionMenuPreguntaDondeGuardarRangosAleTManuales && $seleccionMenuPreguntaDondeGuardarRangosAleTManuales -lt "3" ]];	do
		echo -ne "\n Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne "\n Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read seleccionMenuPreguntaDondeGuardarRangosAleTManuales
		echo -e "$seleccionMenuPreguntaDondeGuardarRangosAleTManuales\n\n" >> $informeConColorTotal
		echo -e "$seleccionMenuPreguntaDondeGuardarRangosAleTManuales\n\n" >> $informeSinColorTotal
	done

	case "${seleccionMenuPreguntaDondeGuardarRangosAleTManuales}" in
		'1') #En el fichero estándar
			truncate -s 0 $ficheroRangosDefault #Se borran los rangos del fichero por defecto de la anterior ejecución
			nomFicheroRangosAleT="$ficheroRangosAleTotalDefault"
			;;
		'2') #En otro fichero
			echo -e $AMARILLO" Introduce el nombre que le quieres dar al fichero de rangos amplios (sin '.txt'):\n"$NORMAL | tee -a $informeConColorTotal
			echo -e " Introduce el nombre que le quieres dar al fichero de rangos amplios (sin '.txt'):\n" >> $informeSinColorTotal
			read seleccionNombreFicheroRangosAleT
			nomFicheroRangosAleT="./FRangosAleT/""$seleccionNombreFicheroRangosAleT.txt"
			echo -e "$seleccionNombreFicheroRangosAleT" >> $informeConColorTotal
			echo -e "$seleccionNombreFicheroRangosAleT" >> $informeSinColorTotal
			echo -e "$nomFicheroRangosAleT\n\n" >> $informeConColorTotal
			echo -e "$nomFicheroRangosAleT\n\n" >> $informeSinColorTotal
			until [[ ! -z "$seleccionNombreFicheroRangosAleT" && ! -f "$nomFicheroRangosAleT" ]];do
				echo -e " Ya existe un archivo con el nombre introducido, o es nulo." | tee -a $informeConColorTotal
				echo -e " Ya existe un archivo con el nombre introducido, o es nulo."  >> $informeSinColorTotal
				echo -e " Introduzca un nombre correcto: \n" | tee -a $informeConColorTotal
				echo -e " Introduzca un nombre correcto: \n" >> $informeSinColorTotal
				read seleccionNombreFicheroRangos
				nomFicheroRangosAleT="./FRangosAleT/""$seleccionNombreFicheroRangosAleT.txt"
				echo -e "$seleccionNombreFicheroRangosAleT" >> $informeConColorTotal
				echo -e "$seleccionNombreFicheroRangosAleT" >> $informeSinColorTotal
				echo -e "$nomFicheroRangosAleT\n" >> $informeConColorTotal
				echo -e "$nomFicheroRangosAleT\n" >> $informeSinColorTotal
			done
			;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
			echo -e " Error en la elección de una opción válida" | tee -a $informeConColorTotal
			echo -e " Error en la elección de una opción válida" >> $informeSinColorTotal
			;;
	esac
} #Fin de preguntaDondeGuardarRangosAleTManuales()

#######################################################################
# Sinopsis: Se calcula el tamaño máximo de la unidad para contener todos los datos que se generen sin modificar el ancho de la columna necesaria
#######################################################################
function calcularUnidad {
	sumatorio=0
	sumatorio1=0
	sumatorio2=0
	nprocesos=${#llegada[@]} #Por compatibilidad con otros códigos.
	for (( i=1; i<=$nprocesos; i++ )); do #Se suman los tiempos de llegada y ejecución para calcular el tamaño de la unidad de tiempo más elevada.
		sumatorio1=$(( sumatorio1 + ${llegada[$i]} + ${tiempo[$i]} ))
	done
	for (( mm=1; mm<=${#particiones[@]}; mm++ )); do #Se suman los tamaños de las diferentes particiones para calcular la memoria total, y el tamaño de la unidad de memoria más elevada.
		if [[ ${particiones[$mm]} -gt $memMax ]]; then
			sumatorio2=$(( sumatorio2 + ${particiones[$mm]} ))
		fi
	done
	
	if [[ $sumatorio2 -lt $sumatorio1 ]]; then
		sumatorio=$sumatorio1
	else
		sumatorio=$sumatorio2
	fi
	espacios=$(echo -n "$sumatorio" | wc -c)
	if [[ $espacios -le 2 ]]; then #Se calcula 
		digitosUnidad=3
	else
		digitosUnidad=$espacios
		digitosUnidad=$(( $digitosUnidad + 1 ))
	fi
} #Fin de calcularUnidad()

#####################################################################################
# Sinopsis: Permite ordenar los datos sacados desde fichero y de entrada por teclado.
####################################################################################
function ordenarDatosEntradaFicheros_cuatro_cinco_seis_siete_ocho_nueve {
	for (( j=${#llegada[@]}; j > 0; j-- )); do
		for (( i=0; i<$j; i++ )); do
			if [[ ${llegada[$i]} -gt ${llegada[$(($i + 1))]} ]]; then
				aux=${proceso[$(($i + 1))]}
				proceso[$(($i + 1))]=${proceso[$i]}
				proceso[$i]=$aux
				aux=${llegada[$(($i + 1))]}
				llegada[$(($i + 1))]=${llegada[$i]}
				llegada[$i]=$aux
				aux=${tiempo[$(($i + 1))]}
				tiempo[$(($i + 1))]=${tiempo[$i]}
				tiempo[$i]=$aux
				aux=${memoria[$(($i + 1))]}
				memoria[$(($i + 1))]=${memoria[$i]}
				memoria[$i]=$aux
				aux=${prioProc[$(($i + 1))]}
				prioProc[$(($i + 1))]=${prioProc[$i]}
				prioProc[$i]=$aux
			fi
		done
	done
} #Fin de ordenarDatosEntradaFicheros_cuatro_cinco_seis_siete_ocho_nueve()

####################################################################################
# Sinopsis: Permite introducir las particiones por teclado.
####################################################################################
function entradaParticionesTeclado {
#    clear
	echo $NORMAL" Par Mem1" | tee -a $informeConColorTotal
	echo " Par Mem1" >> $informeSinColorTotal
	while [[ "$masparticion" = "s" ]]; do
		echo -ne "\n Introduce el tamaño de la partición $contadorParticiones:  " | tee -a $informeConColorTotal
		echo -ne "\n Introduce el tamaño de la partición $contadorParticiones:  " >> $informeSinColorTotal
		read particiones[$contadorParticiones]
		echo "${particiones[$contadorParticiones]}" | tee -a $informeConColorTotal
		echo "${particiones[$contadorParticiones]}" >> $informeSinColorTotal

		until [[ ! -z "$particiones[$contadorParticiones]" && ${particiones[$contadorParticiones]} -gt 0 ]]; do
			echo $NORMAL" No se pueden introducir tamaños de partición negativos" | tee -a $informeConColorTotal
			echo -ne " No se pueden introducir tamaños de partición negativos" >> $informeSinColorTotal
			echo -ne $NORMAL" Introduce un nuevo tamaños de partición\n  --> " | tee -a $informeConColorTotal
			echo -ne " Introduce un nuevo tamaños de partición\n  --> " >> $informeSinColorTotal
			read particiones[$contadorParticiones]
			entradaParticionesTecladoDatosPantalla #Función para mostrar los datos
		done
#        clear 

		entradaParticionesTecladoDatosPantalla #Función para mostrar los datos

		echo "Particion $contadorParticiones ${particiones[$contadorParticiones]} " >>$nomFicheroDatos #Se meten los datos de las particiones en el fichero escogido
		echo -ne "\n\n ¿Quieres introducir otra partición? s/n  " | tee -a $informeConColorTotal
		echo -ne "\n\n ¿Quieres introducir otra partición? s/n  " >>$informeSinColorTotal
		read masparticion
		echo -e "$masparticion\n" >> $informeConColorTotal
		echo -e "$masparticion\n" >> $informeSinColorTotal
		until [[ $masparticion = "s" || $masparticion = "n" ]]; do
			echo -ne "\n Escribe 's' o 'n', por favor: " | tee -a $informeConColorTotal
			echo -ne "\n Escribe 's' o 'n', por favor: " >>$informeSinColorTotal
			read masparticion
			echo -e "$masparticion\n" | tee -a $informeConColorTotal
			echo -e "$masparticion\n" >> $informeSinColorTotal
		done
		let contadorParticiones=$contadorParticiones+1
	done
	mem_total=0 #Memoria total del sistema.
	for (( i=1; i<$contadorParticiones; i++ )); do #Se calcula el tamaño total de la memoria como suma de los tamaños de las particiones.
		numParticiones[$i]=$i
		mem_total=$((mem_total + ${particiones[$i]}))
	done

	echo -ne "\n Introduce el valor mínimo del rango de prioridad:  " | tee -a $informeConColorTotal
	echo -ne "\n Introduce el valor mínimo del rango de prioridad:  " >> $informeSinColorTotal
	read subrango_prioProc_procesos_minInicial
	echo "$subrango_prioProc_procesos_minInicial" | tee -a $informeConColorTotal
	echo "$subrango_prioProc_procesos_minInicial" >> $informeSinColorTotal
#        clear

	echo -ne "\n Introduce el valor máximo del rango de prioridad:  " | tee -a $informeConColorTotal
	echo -ne "\n Introduce el valor máximo del rango de prioridad:  " >> $informeSinColorTotal
	read subrango_prioProc_procesos_maxInicial
	echo "$subrango_prioProc_procesos_maxInicial" | tee -a $informeConColorTotal
	echo "$subrango_prioProc_procesos_maxInicial" >> $informeSinColorTotal

	echo "RangoPrioridad $subrango_prioProc_procesos_minInicial $subrango_prioProc_procesos_maxInicial " >>$nomFicheroDatos #Se meten los datos de las prioridades en el fichero escogido
	tratarRangoPrioridadesDirecta $subrango_prioProc_procesos_minInicial $subrango_prioProc_procesos_maxInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.

#        clear
	echo -ne "\n Introduce el valor del quantum:  " | tee -a $informeConColorTotal
	echo -ne "\n Introduce el valor del quantum:  " >> $informeSinColorTotal
	read quantum
	echo "$quantum" | tee -a $informeConColorTotal
	echo "$quantum" >> $informeSinColorTotal

	until [[ ! -z "$quantum" && $quantum -gt 0 ]]; do
		echo $NORMAL" No se pueden introducir un valor de quantum negativo" | tee -a $informeConColorTotal
		echo -ne " No se pueden introducir un valor de quantum negativo" >> $informeSinColorTotal
		echo -ne $NORMAL" Introduce un nuevo valor del quantum\n  --> " | tee -a $informeConColorTotal
		echo -ne " Introduce un nuevo valor del quantum\n  --> " >> $informeSinColorTotal
		read quantum
	done
	echo "Quantum $quantum " >>$nomFicheroDatos #Se meten los datos de las prioridades en el fichero escogido
#        clear
} #Fin de entradaParticionesTeclado()

####################################################################################
# Sinopsis: Permite visualizar los datos de las particiones/procesos introducidos por teclado.
####################################################################################
function entradaParticionesTecladoDatosPantalla {
	echo $AMARILLO" Par Mem2"$NORMAL | tee -a $informeConColorTotal
	echo " Par Mem2" >> $informeSinColorTotal
	for (( i=1; i<=${#particiones[@]}; i++ )); do
		longitudParticiones=$(($longCampoTablaAncho - ${#i}))
		echo -ne "${varhuecos:1:$longitudParticiones}""$AMARILLO$i$NORMAL" | tee -a $informeConColorTotal
		echo -ne "${varhuecos:1:$longitudParticiones}""$i" >> $informeSinColorTotal
		longitudMemoria=$(($longCampoTablaMasAncho - ${#particiones[$i]}))
		echo -e "${varhuecos:1:$longitudMemoria}""$AMARILLO${particiones[$i]}$NORMAL" | tee -a $informeConColorTotal
		echo -e "${varhuecos:1:$longitudMemoria}""${particiones[$i]}" >> $informeSinColorTotal
	done
} #Fin de entradaParticionesTecladoDatosPantalla()

####################################################################################
# Sinopsis: Permite introducir los procesos por teclado.
####################################################################################
function entradaProcesosTeclado {
	echo $NORMAL" Ref Tll Tej Mem Prio1"
	while [[ $masprocesos == "s" ]]; do # mientras que contador sea menor que cantidad de procesos
#        clear
		entradaParticionesTecladoDatosPantalla #Se muestra la tabla de memoria antes de mostrar la tabla de procesos en construcción
		for (( i=1; i<=${#proceso[@]}; i++ )); do
			echo -e $NORMAL"\n\n Ref Tll Tej Mem Prio2" | tee -a $informeConColorTotal
			echo -ne " ${colores[$i % 6]}${proceso[$i]}" | tee -a $informeConColorTotal
			longitudLlegada=$(($longCampoTablaAncho - ${#llegada[$i]}))
			echo -ne "${varhuecos:1:$longitudLlegada}""${colores[$i % 6]}${llegada[$i]}" | tee -a $informeConColorTotal
			longitudTiempo=$(($longCampoTablaAncho - ${#tiempo[$i]}))
			echo -ne "${varhuecos:1:$longitudTiempo}""${colores[$i % 6]}${tiempo[$i]}" | tee -a $informeConColorTotal
			longitudMemoria=$(($longCampoTablaAncho - ${#memoria[$i]}))
			echo -ne "${varhuecos:1:$longitudMemoria}""${colores[$i % 6]}${memoria[$i]}" | tee -a $informeConColorTotal
			longitudPrioProc=$(($longCampoTablaAncho - ${#prioProc[$i]}))
			echo -ne "${varhuecos:1:$longitudPrioProc}""${colores[$i % 6]}${prioProc[$i]}" | tee -a $informeConColorTotal
			echo -e "\n\n Ref Tll Tej Mem Prio2" >> $informeSinColorTotal
			echo -ne " ${proceso[$i]}" >> $informeSinColorTotal
			longitudLlegada=$(($longCampoTablaAncho - ${#llegada[$i]}))
			echo -ne "${varhuecos:1:$longitudLlegada}""${llegada[$i]}" >> $informeSinColorTotal
			longitudTiempo=$(($longCampoTablaAncho - ${#tiempo[$i]}))
			echo -ne "${varhuecos:1:$longitudTiempo}""${tiempo[$i]}" >> $informeSinColorTotal
			longitudMemoria=$(($longCampoTablaAncho - ${#memoria[$i]}))
			echo -ne "${varhuecos:1:$longitudMemoria}""${memoria[$i]}" >> $informeSinColorTotal
			longitudPrioProc=$(($longCampoTablaAncho - ${#prioProc[$i]}))
			echo -ne "${varhuecos:1:$longitudPrioProc}""${colores[$i % 6]}${prioProc[$i]}" >> $informeSinColorTotal
		done
		echo -e "\n" | tee -a $$informeConColorTotal
		echo -e "\n" >>$informeSinColorTotal

		#El nombre de los procesos está predefinido: P01, P02, ...
		if [[ $p -gt 9 ]]; then
			echo -ne "${colores[($i % 6)]}PROCESO P$(($p))$NORMAL" | tee -a $informeConColorTotal
			echo -n "PROCESO P$(($p))" >> $informeSinColorTotal
			proceso[$p]=$(echo P$(($p)))
		else
			echo -ne "${colores[($i % 6)]}PROCESO P0$(($p))$NORMAL" | tee -a $informeConColorTotal
			echo -ne "PROCESO P0$(($p))" >> $informeSinColorTotal
			proceso[$p]=$(echo P0$(($p)))
		fi

		# bloque para introduccion del resto de datos del proceso
		echo -ne $NORMAL"\n Tiempo de llegada del proceso $p: " | tee -a $informeConColorTotal
		echo -ne "\n Tiempo de llegada del proceso $p: " >> $informeSinColorTotal
		read llegada[$p]
		entradaProcesosTecladoDatosPantalla #Función para mostrar los datos
		until [ ${llegada[$p]} -ge 0 ]; do
			echo $NORMAL" No se pueden introducir tiempos de llegada negativos" | tee -a $informeConColorTotal
			echo " No se pueden introducir tiempos de llegada negativos" >>$informeSinColorTotal
			echo -e $NORMAL" Introduce un nuevo tiempo de llegada\n" | tee -a $informeConColorTotal
			echo -e " Introduce un nuevo tiempo de llegada\n" >> $informeSinColorTotal
			read llegada[$p]
			entradaProcesosTecladoDatosPantalla #Función para mostrar los datos
		done

		echo -ne $NORMAL"\n Tiempo de ejecución del proceso $p: " | tee -a $informeConColorTotal
		echo -ne "\n Tiempo de ejecución del proceso $p: " >>$informeSinColorTotal
		read tiempo[$p]
		entradaProcesosTecladoDatosPantalla #Función para mostrar los datos
		echo "" | tee -a $informeConColorTotal
		echo "" >> $informeSinColorTotal
		until [ ${tiempo[$p]} -ge 0 ]; do
			echo $NORMAL" No se pueden introducir tiempos de ejecución negativos" | tee -a $informeConColorTotal
			echo " No se pueden introducir tiempos de ejecución negativos" >>$informeSinColorTotal
			echo $NORMAL" Introduce un nuevo tiempo de ejecución\n" | tee -a $informeConColorTotal
			echo " Introduce un nuevo tiempo de ejecución\n" >>$informeSinColorTotal
			read tiempo[$p]
			echo $NORMAL" Ref Tll Tej Mem Prio" >>$informeConColorTotal
			echo " Ref Tll Tej Mem Prio" >>$informeSinColorTotal
			entradaProcesosTecladoDatosPantalla #Función para mostrar los datos
			echo ""$NORMAL
		done

		echo -ne $NORMAL"\n Unidades de memoria para el proceso $p: " | tee -a $informeConColorTotal
		echo -ne "\n Unidades de memoria para el proceso $p: " >>$informeSinColorTotal
		read memoria[$p]
		entradaProcesosTecladoDatosPantalla #Función para mostrar los datos
		echo "" | tee -a $informeConColorTotal
		echo "" >> $informeSinColorTotal
		#Se selecciona la partición de mayor tamaño
		memMax=0
		for (( mm = 1; mm <= ${#particiones[@]}; mm++ )); do
			if [[ ${particiones[$mm]} -gt $memMax ]]; then
				memMax=${particiones[$mm]}
				aux=$mm
			fi
		done
		while [[ ${memoria[$p]} -le 0 || ${memoria[$p]} -gt ${particiones[$aux]} ]]; do
			echo $NORMAL" No se pueden introducir memoria negativa o superior a la partición máxima" | tee -a $informeConColorTotal
			echo " No se pueden introducir memoria negativa o superior a la partición máxima" >>$informeSinColorTotal
			echo -e $NORMAL" Introduce un nuevo tamaño de memoria\n" | tee -a $informeConColorTotal
			echo -e " Introduce un nuevo tamaño de memoria\n" >>$informeSinColorTotal
			read memoria[$p]
			entradaProcesosTecladoDatosPantalla #Función para mostrar los datos
		done

		echo -ne $NORMAL"\n Prioridad para el proceso $p: " | tee -a $informeConColorTotal
		echo -ne "\n Prioridad para el proceso $p: " >>$informeSinColorTotal
		read prioProc[$p]
		entradaProcesosTecladoDatosPantalla #Función para mostrar los datos
		echo "" | tee -a $informeConColorTotal
		echo "" >> $informeSinColorTotal
		while [[ ${prioProc[$p]} -lt $rango_min_prioProc_procesos && ${prioProc[$p]} -gt $rango_max_prioProc_procesos ]]; do
			echo $NORMAL" No se pueden introducir una prioridad fuera del rango de Prioridades definido"$NORMAL | tee -a $informeConColorTotal
			echo " No se pueden introducir memoria negativa o superior a la partición máxima" >>$informeSinColorTotal
			echo -e $NORMAL" Introduce una nuevo prioridad\n" | tee -a $informeConColorTotal
			echo -e " Introduce una nuevo prioridad\n" >>$informeSinColorTotal
			read memoria[$p]
			entradaProcesosTecladoDatosPantalla #Función para mostrar los datos
		done

		# salida de datos introducidos sobre procesos para que el usuario pueda ver lo que esta introducciendo y volcado de los mismos en ficheros auxiliares
		echo ""
		echo "Llegada ${llegada[$p]} Ejecucion ${tiempo[$p]} Memoria ${memoria[$p]} Prioridad ${prioProc[$p]} " >>$nomFicheroDatos #Se meten los datos de las particiones en otro fichero escogido
#        clear

		ordenarDatosEntradaFicheros_cuatro_cinco_seis_siete_ocho_nueve
		entradaParticionesTecladoDatosPantalla #Se muestra la tabla de memoria antes de mostrar la tabla de procesos en construcción
		entradaProcesosTecladoDatosPantalla #Función para mostrar los datos
		echo -ne $NORMAL"\n ¿Quieres más procesos? s/n " | tee -a $informeConColorTotal
		echo -ne "\n ¿Quieres más procesos? s/n " >>$informeSinColorTotal
		read masprocesos
		echo "$masprocesos" >>$informeConColorTotal
		echo "$masprocesos" >>$informeSinColorTotal
		until [[ $masprocesos == "s" || $masprocesos == "n" ]]; do
			echo -ne "\n Escribe 's' o 'n', por favor: " | tee -a $informeConColorTotal
			echo -ne "\n Escribe 's' o 'n', por favor: " >>$informeSinColorTotal
			read masprocesos
			echo "$masprocesos" >>$informeConColorTotal
			echo "$masprocesos" >>$informeSinColorTotal
		done
		p=$(expr $p + 1) #incremento el contador
	done
	if [[ $preguntaDondeGuardarDatosManuales -eq 1 ]]; then #Se guardan los datos introducidos en el fichero de última ejecución
		cp $ficheroDatosDefault $ficheroDatosAnteriorEjecucion
	else
		cp $nomFicheroDatos $ficheroDatosAnteriorEjecucion
	fi
} #Fin de entradaProcesosTeclado()

####################################################################################
# Sinopsis: Permite visualizar los datos de las particiones/procesos introducidos por teclado.
####################################################################################
function entradaProcesosTecladoDatosPantalla {
		echo $NORMAL" Ref Tll Tej Mem Prio"  | tee -a $informeConColorTotal
		echo " Ref Tll Tej Mem Prio" >>$informeSinColorTotal
		for (( i=1; i<=${#proceso[@]}; i++ )); do
			echo -ne " ${colores[$i % 6]}${proceso[$i]}" | tee -a $informeConColorTotal
			echo -n " ${proceso[$i]}" >>$informeSinColorTotal
			longitudLlegada=$(($longCampoTablaAncho - ${#llegada[$i]}))
			echo -ne "${varhuecos:1:$longitudLlegada}""${colores[$i % 6]}${llegada[$i]}" | tee -a $informeConColorTotal
			echo -n "${varhuecos:1:$longitudLlegada}""${llegada[$i]}" >>$informeSinColorTotal
			longitudTiempo=$(($longCampoTablaAncho - ${#tiempo[$i]}))
			echo -ne "${varhuecos:1:$longitudTiempo}""${colores[$i % 6]}${tiempo[$i]}" | tee -a $informeConColorTotal
			echo -n "${varhuecos:1:$longitudTiempo}""${tiempo[$i]}" >>$informeSinColorTotal
			longitudMemoria=$(($longCampoTablaAncho - ${#memoria[$i]}))
			echo -ne "${varhuecos:1:$longitudMemoria}""${colores[$i % 6]}${memoria[$i]}" | tee -a $informeConColorTotal
			echo -n "${varhuecos:1:$longitudMemoria}""${memoria[$i]}" >>$informeSinColorTotal
			longitudPrioProc=$(($longCampoTablaMasAncho - ${#prioProc[$i]}))
			echo -e "${varhuecos:1:$longitudPrioProc}""${colores[$i % 6]}${prioProc[$i]}" | tee -a $informeConColorTotal
			echo "${varhuecos:1:$longitudPrioProc}""${prioProc[$i]}" >>$informeSinColorTotal
		done
} #Fin de entradaProcesosTecladoDatosPantalla()

####################################################################################
# Sinopsis: Permite utilizar los datos de particiones/procesos de la última ejecución.
####################################################################################
function leer_datos_desde_fichero {
	secuenciaContadoresParticiones=0
	secuenciaTamanosParticiones=0
	mem_total=0
	lineaspart=($(cat $1 | grep "Particion" | cut -f 1 -d " " | wc -l))
   	secuenciaContadoresParticiones=$(cat $1 | grep "Particion" | cut -f 2 -d " ")
	secuenciaTamanosParticiones=$(cat $1 | grep "Particion" | cut -f 3 -d " ") #Las líneas deben tener un espacio al final de cada línea para que tenga en cuenta el espacio final como un separador y capture el valor buscado...
	for (( i=1; i<=$lineaspart; i++ )); do #Se definen los valores de los índices de las particiones y de sus tamaños.
		numParticiones[$i]=$(echo $secuenciaContadoresParticiones | cut -f $i -d " ")
		particiones[$i]=$(echo $secuenciaTamanosParticiones | cut -f $i -d " ")
		mem_total=$(($mem_total + ${particiones[$i]}))
	done

	llegada=($(cat $1 | grep "Llegada" | cut -f 2 -d " "))
	tiempo=($(cat $1 | grep "Llegada" | cut -f 4 -d " "))
	memoria=($(cat $1 | grep "Llegada" | cut -f 6 -d " "))
	prioProc=($(cat $1 | grep "Llegada" | cut -f 8 -d " "))
	profich=($(cat $1 | grep "Llegada" | cut -f 1 -d " " | wc -l))
	subrango_prioProc_procesos_minInicial=($(cat $1 | grep "RangoPrioridad" | cut -f 2 -d " "))  #Prioridad menor
	subrango_prioProc_procesos_maxInicial=($(cat $1 | grep "RangoPrioridad" | cut -f 3 -d " "))  #Prioridad mayor
	PrioR=($(cat $1 | grep "TipoPrioridad" | cut -f 2 -d " "))  #Tipo de prioridad - Realmente no se usa porque se introduce por teclado al seleccionar el algoritmo de gestión de procesos mediante la variable de selección $seleccionTipoPrioridad.
	tratarRangoPrioridadesDirecta $subrango_prioProc_procesos_minInicial $subrango_prioProc_procesos_maxInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	quantum=($(cat $1 | grep "Quantum" | cut -f 2 -d " "))  #Quantum de Round Robin (RR)

	#Se verifica que los datos de la memoria de cada poceso son correctos. Tienen que ser menor o igual que la mayor de las particiones.
	memMax=0
	for (( mm=1; mm<=${#particiones[@]}; mm++ )); do #Se selecciona la partición de mayor tamaño
		if [[ ${particiones[$mm]} -gt $memMax ]]; then
			memMax=${particiones[$mm]}
			aux=$mm
		fi
	done
	for (( p=1; p<=$profich; p++ )); do
		if [[ ${memoria[$p]} -gt ${particiones[$aux]} ]]; then
			echo -e "\n Error" | tee -a $informeConColorTotal
			echo " La memoria tiene mayor tamaño que la partición más grande" | tee -a $informeConColorTotal
			echo -e "\n Error" >> $informeSinColorTotal
			echo " La memoria tiene mayor tamaño que la partición más grande" >> $informeSinColorTotal
			echo -ne $ROJO"\n Pulsa ENTER para continuar "$NORMAL
			read enterContinuar
		fi
	done
	for (( p=1; p<$profich + 1; p++ )); do
		if [[ $p -gt 9 ]]; then
			proceso[$p - 1]=$(echo P$(($p)))
	   else
			proceso[$p - 1]=$(echo P0$(($p)))
		fi
	done
	for (( p=$profich; p>0; p-- )); do
		llegada[$p]=${llegada[$(($p - 1))]}
		tiempo[$p]=${tiempo[$(($p - 1))]}
		memoria[$p]=${memoria[$(($p - 1))]}
		prioProc[$p]=${prioProc[$(($p - 1))]}
		proceso[$p]=${proceso[$(($p - 1))]}
	done
		unset "llegada[0]" #Se elimina el primer valor de cada array para ajustar los índices.
		unset "tiempo[0]"
		unset "memoria[0]"
		unset "prioProc[0]"
		unset "proceso[0]"

	ordenarDatosEntradaFicheros_cuatro_cinco_seis_siete_ocho_nueve #Ordena los datos por tiempo de llegada al leerlos desde los ficheros.
} #Fin de leer_datos_desde_fichero()

####################################################################################
# Sinopsis: Permite introducir las particiones y datos desde otro fichero (predefinido).
####################################################################################
function entradaMemoriaDatosFichero_op_tres {
#    clear
	mem_total=0
	echo -e $ROJO"\n Ficheros de datos a elegir en './FDatos/': "$NORMAL | tee -a $informeConColorTotal
	echo -e "\n Ficheros de datos a elegir en './FDatos/': " >> $informeSinColorTotal
	files=($(ls -l ./FDatos/ | awk '{print $9}'))
	for i in "${!files[@]}"; do
		echo -e "$((i+1))) ${files[$i]}" | tee -a $informeConColorTotal
		echo -e "$((i+1))) ${files[$i]}" >> $informeSinColorTotal
	done

	echo -ne "$AMARILLO\n\n Introduce el número correspondiente al fichero a analizar: $NORMAL" | tee -a $informeConColorTotal
	echo -ne "\n\n Introduce el número correspondiente al fichero a analizar: " >> $informeSinColorTotal
	read -r numeroFichero
	echo -e "$numeroFichero\n\n" >> $informeConColorTotal
	echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	until [[ 0 -lt $numeroFichero && $numeroFichero -le ${#files[@]} && $numeroFichero -ne "" ]]; do
		echo -ne " Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read -r numeroFichero
		echo -e "$numeroFichero\n\n" >> $informeConColorTotal
		echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	done
	FicheroParaLectura="${files[$((numeroFichero-1))]}"
	cat "./FDatos/$FicheroParaLectura" > $ficheroDatosAnteriorEjecucion
	leer_datos_desde_fichero $ficheroDatosAnteriorEjecucion #Una vez determinado el fichero, se leen los datos a utilizar.
#    clear
} #Fin de entradaMemoriaDatosFichero_op_tres()

####################################################################################
# Sinopsis: Inicializa los vectores a usar en el algoritmo.
####################################################################################
function inicializaVectores {
	for (( i=1; i<=${#particiones[@]}; i++ )); do
		particionOcupada[$i]=0
		procesoEnParticionOcupada[$i]=0
		ocupadas[$i]=0
		porcentaje[$i]=0 #Se inicializan los porcentajes de defragmentación
	done
	for (( p=1; p<=${#memoria[@]}; p++ )); do
		espera[$p]=0 #inicializo varios vectores con unos valores determinados
		entrada[$p]=0
		tiempoEsperaProceso[$p]=0
		restante[$p]=0
		tiempoRetornoProceso[$p]=0
		procesoYaHaEntrado[$p]=0
		estado[$p]="Fuera del sistema"
		estad[$p]=0
		inicioEjecucion[$p]=0
		bandera[$p]=0
		bloqueo[$p]=0
		sale[$p]=0
		partEnVectorDeProceso[$p]=-1 #La partición en la que se encuentra cada proceso se inicializa a -1.
		partConProceso[$p]=0 #Se inicializa con la partición de cada proceso a 0.
		colaTiempoRR[$p]=-1 #Contiene el orden de ejecución de Round-Robin (RR). Será "-1" mientras no esté en cola, o cuando haya terminado, y si aún no ha terminado contendrá el número ordinal del siguiente quantum. El proceso a ejecutar será, por tanto, el que tenga el número ordinal más bajo. Y el número de quantums realizados (cambios de contexto, será el número ordinal más alto.
	done
	procesoYaHaEntrado[0]=1
	anteriorProcesoEjecucion=-1 #Definirá el anterior proceso en ejecución, cuando otro proceso le deje en pausa.
	contadorTiempoRR=0 #Para que el proceso que se vaya a ejecutar empiece a usar su quantum desde 0.
	indiceColaTiempoRRLibre=0 #Índice con el primer ordinal libre a repartir en Round-Robin (RR). Irá creciendo con cada puesto de quantum repartido y marca el futuro orden de ejecución.
	indiceColaTiempoRREnEjecucion=0 #Índice con el actual ordinal en ejecución para Round-Robin (RR). Irá creciendo con cada quantum ejecutado y marca el actual número ordinal de quantum en ejecución.

	calcularUnidad #Determina el mayor número que podría ser representado por Tllegada con Tejecucion, y las unidades de memoria. 
	maxProcPorUnidadTiempo=0 # Se calcula el valor máximo del número de unidades de tiempo. Como mucho, los tiempos de llegada más los tiempos de ejecución. Ese será el número de elementos máximo del array procPorUnidadTiempo
	for (( j=1; j<=${#llegada[@]}; j++ )); do
		maxProcPorUnidadTiempo=$(expr $maxProcPorUnidadTiempo + ${tiempo[$j]} + ${llegada[$j]})
	done
	topeProcPorUnidadTiempo=$maxProcPorUnidadTiempo # Se pone un valor que nunca se probará (tope dinámico). Osea, el mismo que maxProcPorUnidadTiempo.
} #Fin de inicializaVectores()

####################################################################################
# Sinopsis: Se comprueba si el contenido de una variable genérica numeroAComprobar es entero y positivo.
####################################################################################
function comprobarNumero {
	while true; do
		if [[ $numeroAComprobar =~ ^[0-9]+$ || $numeroAComprobar =~ ^-[0-9]+$ ]]; then
			break
		else
			echo " Error en el valor. Debe ser un número entero"
			read numeroAComprobar
		fi
	done
} #Fin de comprobarNumero()

####################################################################################
# Sinopsis: Permite introducir los rangos de las particiones/procesos por teclado.
####################################################################################
function entradaMemoriaRangosFichero_op_cuatro {
#    clear
	preguntaDondeGuardarRangosManuales #Resuelve los nombres de los ficheros de rangos
	preguntaDondeGuardarDatosManuales #Resuelve los nombres de los ficheros de datos
	rango_min_cantidad_particiones="#"
	rango_max_cantidad_particiones="#"
	cantidad_particiones="0"
	rango_min_longitud_particiones="#"
	rango_max_longitud_particiones="#"
	quantum="0"
	rango_min_quantum_procesos="#"
	rango_max_quantum_procesos="#"
	procesitos="0"
	rango_min_cantidad_procesos="#"
	rango_max_cantidad_procesos="#"
	cantidad_rango_procesos="0"
	rango_min_tiempo_llegada="#"
	rango_max_tiempo_llegada="#"
	rango_min_tiempo_ejecucion="#"
	rango_max_tiempo_ejecucion="#"
	rango_min_memoria_procesos="#"
	rango_max_memoria_procesos="#"
	rango_min_prioProc_procesos="#"
	rango_max_prioProc_procesos="#"
#    clear
	mostrarPantallaEntradaProcesosRangoManual_op_cuatro
	
	echo -ne "\n Información de la particiones" | tee -a $informeConColorTotal
	echo -ne "\n Información de la particiones" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango del número de particiones: "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango del número de particiones: " >> $informeSinColorTotal
	read rango_min_cantidad_particiones
	numeroAComprobar=$rango_min_cantidad_particiones
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_cantidad_particiones=$numeroAComprobar
	echo "$rango_min_cantidad_particiones" >>$informeConColorTotal
	echo "$rango_min_cantidad_particiones" >>$informeSinColorTotal
	echo -ne $AMARILLO" Máximo del rango del número de particiones: "$NORMAL | tee -a $informeConColorTotal
	echo -ne " Máximo del rango del número de particiones: " >> $informeSinColorTotal
	read rango_max_cantidad_particiones
	numeroAComprobar=$rango_max_cantidad_particiones
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_cantidad_particiones=$numeroAComprobar
	echo "$rango_max_cantidad_particiones" >>$informeConColorTotal
	echo "$rango_max_cantidad_particiones" >>$informeSinColorTotal
	subrango_cantidad_particiones_min=$rango_min_cantidad_particiones #Se cambia de nombres para hacer el control reaprovechando la función de control de subrangos
	subrango_cantidad_particiones_max=$rango_max_cantidad_particiones
	controlRangosMaxMin # Controla que los rangos no sean invertidos
	controlRangosMinValoresNegativos # Controla que el mínimo de los rangos no sea menor que 0
	cantidad_particiones=$(shuf -i $rango_min_cantidad_particiones-$rango_max_cantidad_particiones -n 1) #Se calcula el número de particiones
#    clear
	mostrarPantallaEntradaProcesosRangoManual_op_cuatro

	echo -ne "\n Información de la particiones" | tee -a $informeConColorTotal
	echo -ne "\n Información de la particiones" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango de unidades de memoria de las particiones: "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango de unidades de memoria de las particiones: " >> $informeSinColorTotal
	read rango_min_longitud_particiones
	numeroAComprobar=$rango_min_longitud_particiones
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_longitud_particiones=$numeroAComprobar
	echo "$rango_min_longitud_particiones" >>$informeConColorTotal
	echo "$rango_min_longitud_particiones" >>$informeSinColorTotal
	echo -ne $AMARILLO"\n Máximo del rango de unidades de memoria de las particiones (Tiene que ser mayor a $rango_min_longitud_particiones): "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Máximo del rango de unidades de memoria de las particiones (Tiene que ser mayor a $rango_min_longitud_particiones): " >> $informeSinColorTotal
	read rango_max_longitud_particiones
	numeroAComprobar=$rango_max_longitud_particiones
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_longitud_particiones=$numeroAComprobar
	echo "$rango_max_longitud_particiones" >>$informeConColorTotal
	echo "$rango_max_longitud_particiones" >>$informeSinColorTotal
	subrango_longitud_particiones_min=$rango_min_longitud_particiones #Se cambia de nombres para hacer el control reaprovechando la función de control de subrangos
	subrango_longitud_particiones_max=$rango_max_longitud_particiones
	controlRangosMaxMin # Controla que los rangos no sean invertidos
	controlRangosMinValoresNegativos # Controla que el mínimo de los rangos no sea menor que 0
	for (( i=1; i<=$cantidad_particiones; i++ )); do
		numParticiones[$i]=$i
		particiones[$i]=$(shuf -i $rango_min_longitud_particiones-$rango_max_longitud_particiones -n 1)
		mem_total=$(($mem_total + ${particiones[$i]}))
	done
#    clear
	mostrarPantallaEntradaProcesosRangoManual_op_cuatro

	echo -ne "\n Información del quantum de tiempo" | tee -a $informeConColorTotal
	echo -ne "\n Información del quantum de tiempo" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango del quantum de tiempo: "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango del quantum de tiempo: " >> $informeSinColorTotal
	read rango_min_quantum_procesos
	numeroAComprobar=$rango_min_quantum_procesos
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_quantum_procesos=$numeroAComprobar
	echo "$rango_min_quantum_procesos" >>$informeConColorTotal
	echo "$rango_min_quantum_procesos" >>$informeSinColorTotal
	echo -ne $AMARILLO"\n Máximo del rango del quantum de tiempo (Podría ser mayor o menor que $rango_min_quantum_procesos): "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Máximo del rango del quantum de tiempo (Podría ser mayor o menor que $rango_min_quantum_procesos): " >> $informeSinColorTotal
	read rango_max_quantum_procesos
	numeroAComprobar=$rango_max_quantum_procesos
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_quantum_procesos=$numeroAComprobar
	echo "$rango_max_quantum_procesos" >>$informeConColorTotal
	echo "$rango_max_quantum_procesos" >>$informeSinColorTotal
	subrango_quantum_procesos_min=$rango_min_quantum_procesos #Se cambia de nombres para hacer el control reaprovechando la función de control de subrangos
	subrango_quantum_procesos_max=$rango_max_quantum_procesos
	controlRangosMaxMin # Controla que los rangos no sean invertidos
	controlRangosMinValoresNegativos # Controla que el mínimo de los rangos no sea menor que 0
	contadorParticiones=1
	quantum=$(shuf -i $rango_min_quantum_procesos-$rango_max_quantum_procesos -n 1) #Se calcula el valor del quantum de tiempo
#    clear
	mostrarPantallaEntradaProcesosRangoManual_op_cuatro

	echo -ne "\n\n Información de los procesos" | tee -a $informeConColorTotal
	echo -ne "\n\n Información de los procesos" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango del número de procesos: "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango del número de procesos: " >> $informeSinColorTotal
	read rango_min_cantidad_procesos
	numeroAComprobar=$rango_min_cantidad_procesos
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_cantidad_procesos=$numeroAComprobar
	echo "$rango_min_cantidad_procesos" >>$informeConColorTotal
	echo "$rango_min_cantidad_procesos" >>$informeSinColorTotal
	echo -ne $AMARILLO" Máximo del rango del número de procesos: "$NORMAL | tee -a $informeConColorTotal
	echo -ne " Máximo del rango del número de procesos: " >> $informeSinColorTotal
	read rango_max_cantidad_procesos
	numeroAComprobar=$rango_max_cantidad_procesos
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_cantidad_procesos=$numeroAComprobar
	echo "$rango_max_cantidad_procesos" >>$informeConColorTotal
	echo "$rango_max_cantidad_procesos" >>$informeSinColorTotal
	subrango_cantidad_procesos_min=$rango_min_cantidad_procesos #Se cambia de nombres para hacer el control reaprovechando la función de control de subrangos
	subrango_cantidad_procesos_max=$rango_max_cantidad_procesos
	controlRangosMaxMin # Controla que los rangos no sean invertidos
	controlRangosMinValoresNegativos # Controla que el mínimo de los rangos no sea menor que 0
	cantidad_rango_procesos=$(shuf -i $rango_min_cantidad_procesos-$rango_max_cantidad_procesos -n 1) #Se calcula el número de procesos
	procesitos=$cantidad_rango_procesos #Por compatibilidad con otro código.
#    clear
	mostrarPantallaEntradaProcesosRangoManual_op_cuatro

	echo -ne "\n\n Información de los procesos" | tee -a $informeConColorTotal
	echo -ne "\n\n Información de los procesos" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango del tiempo de llegada de los procesos: "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango del tiempo de llegada de los procesos: " >> $informeSinColorTotal
	read rango_min_tiempo_llegada
	numeroAComprobar=$rango_min_tiempo_llegada
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_tiempo_llegada=$numeroAComprobar
	echo "$rango_min_tiempo_llegada" >>$informeConColorTotal
	echo "$rango_min_tiempo_llegada" >>$informeSinColorTotal
	echo -ne $AMARILLO" Máximo del rango del tiempo de llegada de los procesos: "$NORMAL | tee -a $informeConColorTotal
	echo -ne " Máximo del rango del tiempo de llegada de los procesos: " >> $informeSinColorTotal
	read rango_max_tiempo_llegada
	numeroAComprobar=$rango_max_tiempo_llegada
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_tiempo_llegada=$numeroAComprobar
	echo "$rango_max_tiempo_llegada" >>$informeConColorTotal
	echo "$rango_max_tiempo_llegada" >>$informeSinColorTotal
	subrango_tiempo_llegada_min=$rango_min_tiempo_llegada #Se cambia de nombres para hacer el control reaprovechando la función de control de subrangos
	subrango_tiempo_llegada_max=$rango_max_tiempo_llegada
	controlRangosMaxMin # Controla que los rangos no sean invertidos
	controlRangosMinValoresNegativos # Controla que el mínimo de los rangos no sea menor que 0
	for (( i=1; i<=$procesitos; i++ )); do #Se calcula los tiempos de llegada de los procesos
		llegada[$i]=$(shuf -i $rango_min_tiempo_llegada-$rango_max_tiempo_llegada -n 1)
	done
#    clear
	mostrarPantallaEntradaProcesosRangoManual_op_cuatro

	echo -ne "\n\n Información de los procesos" | tee -a $informeConColorTotal
	echo -ne "\n\n Información de los procesos" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango del tiempo de ejecución de los procesos: "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango del tiempo de ejecución de los procesos: " >> $informeSinColorTotal
	read rango_min_tiempo_ejecucion
	numeroAComprobar=$rango_min_tiempo_ejecucion
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_tiempo_ejecucion=$numeroAComprobar
	echo "$rango_min_tiempo_ejecucion" >>$informeConColorTotal
	echo "$rango_min_tiempo_ejecucion" >>$informeSinColorTotal
	echo -ne $AMARILLO" Máximo del rango del tiempo de ejecución de los procesos: "$NORMAL | tee -a $informeConColorTotal
	echo -ne " Máximo del rango del tiempo de ejecución de los procesos: " >> $informeSinColorTotal
	read rango_max_tiempo_ejecucion
	numeroAComprobar=$rango_max_tiempo_ejecucion
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_tiempo_ejecucion=$numeroAComprobar
	echo "$rango_max_tiempo_ejecucion" >>$informeConColorTotal
	echo "$rango_max_tiempo_ejecucion" >>$informeSinColorTotal
	subrango_tiempo_ejecucion_min=$rango_min_tiempo_ejecucion #Se cambia de nombres para hacer el control reaprovechando la función de control de subrangos
	subrango_tiempo_ejecucion_max=$rango_max_tiempo_ejecucion
	controlRangosMaxMin # Controla que los rangos no sean invertidos
	controlRangosMinValoresNegativos # Controla que el mínimo de los rangos no sea menor que 0
	for (( i=1; i<=$procesitos; i++ )); do #Se calcula los tiempos de ejecución de los procesos
		tiempo[$i]=$(shuf -i $rango_min_tiempo_ejecucion-$rango_max_tiempo_ejecucion -n 1)
		until [ ${tiempo[$i]} -ge 1 ]; do
			tiempo[$i]=$(shuf -i $rango_min_tiempo_ejecucion-$rango_max_tiempo_ejecucion -n 1)
		done
	done
#    clear
	mostrarPantallaEntradaProcesosRangoManual_op_cuatro

	echo -ne "\n\n Información de los procesos" | tee -a $informeConColorTotal
	echo -ne "\n\n Información de los procesos">> $informeSinColorTotal
	echo -ne $AMARILLO"\n Minimo del rango de unidades de memoria de los procesos: "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Minimo del rango de unidades de memoria de los procesos: ">> $informeSinColorTotal
	read rango_min_memoria_procesos 
	numeroAComprobar=$rango_min_memoria_procesos
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_memoria_procesos=$numeroAComprobar
	echo "$rango_min_memoria_procesos" >>$informeConColorTotal
	echo "$rango_min_memoria_procesos" >>$informeSinColorTotal
	echo -ne $AMARILLO" Máximo del rango de unidades de memoria de los procesos (Tiene que ser menor a $rango_max_longitud_particiones): "$NORMAL | tee -a $informeConColorTotal
	echo -ne " Máximo del rango de unidades de memoria de los procesos (Tiene que ser menor a $rango_max_longitud_particiones): ">> $informeSinColorTotal
	read rango_max_memoria_procesos
	numeroAComprobar=$rango_max_memoria_procesos
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_memoria_procesos=$numeroAComprobar
	echo "$rango_max_memoria_procesos" >>$informeConColorTotal
	echo "$rango_max_memoria_procesos" >>$informeSinColorTotal
	subrango_memoria_proceso_min=$rango_min_memoria_procesos #Se cambia de nombres para hacer el control reaprovechando la función de control de subrangos
	subrango_memoria_proceso_max=$rango_max_memoria_procesos
	controlRangosMaxMin # Controla que los rangos no sean invertidos
	controlRangosMinValoresNegativos # Controla que el mínimo de los rangos no sea menor que 0
	cantidad_procesos_rango=$cantidad_rango_procesos
	p=1 #Se inicializa a 1 porque será la variable utilizada  para nombrar los procesos, y estos empiezan en P01.
	while [[ $masprocesos == "s" ]]; do #Se asignan nombres. Se podría haber hecho con un "for" como en las variables anteriores.
		if [[ $p -gt 9 ]]; then #Se asignan los nombres de los procesos
			#echo -ne "\n${colores[($i % 6)]}PROCESO P$(($p))$NORMAL"
			proceso[$p]=$(echo P$(($p)))
		else
			#echo -ne "\n${colores[($i % 6)]}PROCESO P0$(($p))$NORMAL"
			proceso[$p]=$(echo P0$(($p)))
		fi
		# bloque para introduccion del resto de datos del proceso
		memoria[$p]=$(shuf -i $rango_min_memoria_procesos-$rango_max_memoria_procesos -n 1) #Se calcula las memorias asignadas de los procesos
		memMax=0 #Se selecciona la partición de mayor tamaño
		for (( mm=1; mm<=${#particiones[@]}; mm++ )); do #Se calcula el tamaño más grande ya que no se puede superar.
			if [[ ${particiones[$mm]} -gt $memMax ]]; then
				memMax=${particiones[$mm]}
				aux=$mm
			fi
		done
		while [[ ${memoria[$p]} -le 0 || ${memoria[$p]} -gt $memMax ]]; do
			memoria[$p]=$(shuf -i $rango_min_memoria_procesos-$rango_max_memoria_procesos -n 1)
		done
		cantidad_rango_procesos=$(($cantidad_rango_procesos - 1)) #restar -1 a cantidad_rango_procesos
		if [[ $cantidad_rango_procesos -gt 0 ]]; then #Se comprueba si aún quedan procesos por configurar. 
			masprocesos='s'
		else
			masprocesos='n'
		fi
		p=$(expr $p + 1) #incremento el contador
	done
#    clear
	mostrarPantallaEntradaProcesosRangoManual_op_cuatro

	echo -ne "\n\n Información de los procesos" | tee -a $informeConColorTotal
	echo -ne "\n\n Información de los procesos" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango de las prioridades de los procesos: "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango de las prioridades de los procesos: " >> $informeSinColorTotal
	read subrango_prioProc_procesos_minInicial
	numeroAComprobar=$subrango_prioProc_procesos_minInicial
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	subrango_prioProc_procesos_minInicial=$numeroAComprobar
	echo "$subrango_prioProc_procesos_minInicial" >>$informeConColorTotal
	echo "$subrango_prioProc_procesos_minInicial" >>$informeSinColorTotal
	echo -ne $AMARILLO" Máximo del rango de las prioridades de los procesos: "$NORMAL | tee -a $informeConColorTotal
	echo -ne " Máximo del rango de las prioridades de los procesos: " >> $informeSinColorTotal
	read subrango_prioProc_procesos_maxInicial
	numeroAComprobar=$subrango_prioProc_procesos_maxInicial
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	subrango_prioProc_procesos_maxInicial=$numeroAComprobar
	echo "$subrango_prioProc_procesos_maxInicial" >>$informeConColorTotal
	echo "$subrango_prioProc_procesos_maxInicial" >>$informeSinColorTotal
	subrango_prioProc_procesos_min=$subrango_prioProc_procesos_minInicial #Se cambia de nombres para hacer el control reaprovechando la función de control de subrangos
	subrango_prioProc_procesos_max=$subrango_prioProc_procesos_maxInicial
	tratarRangoPrioridadesDirecta $subrango_prioProc_procesos_min $subrango_prioProc_procesos_max #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	subrango_prioProc_procesos_min=$PriomFinal #Sobre este subrango corregido se calculan los datos de las prioridades de los procesos, prioridades que no deberían pedirse al usuario.
	subrango_prioProc_procesos_max=$PrioMFinal
	for (( i=1; i<=$procesitos; i++ )); do #Se calcula los tiempos de ejecución de los procesos
		calcDatoAleatorioGeneral $subrango_prioProc_procesos_min $subrango_prioProc_procesos_max #Se calcula el mínimo amplio
		prioProc[$i]=$datoAleatorioGeneral #*Inicial - Datos a representar #Variables con los datos originales del rango amplio sin corregir, usadas en la cabecera de la representación de la tabla
	done
#    clear
	mostrarPantallaEntradaProcesosRangoManual_op_cuatro

	#Se guardan los datos calculados
	for (( i=1; i<=$cantidad_particiones; i++ )); do #Se meten los datos de particiones/procesos al fichero de datos
		echo "Particion $contadorParticiones ${particiones[$contadorParticiones]} " >>$nomFicheroDatos #Se meten los datos de las particiones en otro fichero escogido
		let contadorParticiones=$contadorParticiones+1
	done
	echo -e "RangoPrioridad $subrango_prioProc_procesos_minInicial $subrango_prioProc_procesos_maxInicial " >> $nomFicheroDatos
	PrioR="Mayor" #Valor por defecto hasta la que sea definido por el usuario.
	echo -e "TipoPrioridad $PrioR " >> $nomFicheroDatos
	quantum=$(shuf -i $rango_min_quantum_procesos-$rango_max_quantum_procesos -n 1)
	echo -e "Quantum $quantum " >> $nomFicheroDatos
	for (( i=1; i<=$procesitos; i++ )); do
		echo -ne "Llegada ${llegada[$i]} " >> $nomFicheroDatos
		echo -ne "Ejecucion ${tiempo[$i]} " >> $nomFicheroDatos
		echo -ne "Memoria ${memoria[$i]} " >> $nomFicheroDatos
		echo -e "Prioridad ${prioProc[$i]}" >> $nomFicheroDatos
	done
	ordenarDatosEntradaFicheros_cuatro_cinco_seis_siete_ocho_nueve
	#Se guardan los subrangos calculados
	echo -e "Part_minima $rango_min_cantidad_particiones \nPart_maxima $rango_max_cantidad_particiones \num_minima $rango_min_longitud_particiones \num_maxima $rango_max_longitud_particiones " > $nomFicheroRangos
	echo -e "Proc_minima $rango_min_cantidad_procesos \nProc_maxima $rango_max_cantidad_procesos \ntll_minima $rango_min_tiempo_llegada \ntll_maxima $rango_max_tiempo_llegada " >> $nomFicheroRangos
	echo -e "eje_minima $rango_min_tiempo_ejecucion \neje_maxima $rango_max_tiempo_ejecucion \nmem_minima $rango_min_memoria_procesos \nmem_maxima $rango_max_memoria_procesos " >> $nomFicheroRangos
	echo -e "prioProc_minima $subrango_prioProc_procesos_minInicial \nprioProc_maxima $subrango_prioProc_procesos_maxInicial \nquantum_minima $rango_min_quantum_procesos \nquantum_maxima $rango_max_quantum_procesos \n" >> $nomFicheroRangos
	controlRangosMaxMin # Controla que los rangos no sean invertidos
	controlRangosMinValoresNegativos # Controla que el mínimo de los rangos no sea menor que 0
	#El usuario puede verificar si se han modificado los rangos definidos de forma automática
	echo -ne $ROJO"\n\n Pulsa ENTER para continuar"$NORMAL
	read enterContinuar
	####################################################################################
	cp $nomFicheroRangos $ficheroRangosAnteriorEjecucion
	cp $nomFicheroDatos $ficheroDatosAnteriorEjecucion
#    clear
} #Fin de entradaMemoriaRangosFichero_op_cuatro()

####################################################################################
# Sinopsis: Permite mostrar cómo evolucionan los datos de las particiones/procesos calculados
# desde los rangos introducidos por teclado, para la opción cuatro.
####################################################################################
function mostrarPantallaEntradaProcesosRangoManual_op_cuatro {
	echo -ne "\n|----------------------------------------------------" | tee -a $informeConColorTotal
	echo -ne "\n|----------------------------------------------------" >> $informeSinColorTotal
	if [[ $cantidad_particiones -eq 0 ]]; then
		echo -ne "\n| Número de particiones                |[$rango_min_cantidad_particiones/$rango_max_cantidad_particiones]: " | tee -a $informeConColorTotal
		echo -ne "\n| Número de particiones                |[$rango_min_cantidad_particiones/$rango_max_cantidad_particiones]: " >> $informeSinColorTotal
	else
		echo -ne "\n| Número de particiones                |[$rango_min_cantidad_particiones/$rango_max_cantidad_particiones]: $cantidad_particiones" | tee -a $informeConColorTotal
		echo -ne "\n| Número de particiones                |[$rango_min_cantidad_particiones/$rango_max_cantidad_particiones]: $cantidad_particiones" >> $informeSinColorTotal
	fi
	echo -ne "\n| Tamaño de las particiones            |[$rango_min_longitud_particiones/$rango_max_longitud_particiones]: " | tee -a $informeConColorTotal
	echo -ne ${particiones[@]} | tee -a $informeConColorTotal
	echo -ne "\n| Tamaño de las particiones            |[$rango_min_longitud_particiones/$rango_max_longitud_particiones]: " >> $informeSinColorTotal
	echo -ne ${particiones[@]} >> $informeSinColorTotal
	if [[ $quantum -le 0 ]]; then
		echo -ne "\n| Quantum de tiempo                    |[$rango_min_quantum_procesos/$rango_max_quantum_procesos]: " | tee -a $informeConColorTotal
		echo -ne "\n| Quantum de tiempo                    |[$rango_min_quantum_procesos/$rango_max_quantum_procesos]: " >> $informeSinColorTotal
	else
		echo -ne "\n| Quantum de tiempo                    |[$rango_min_quantum_procesos/$rango_max_quantum_procesos]: $quantum" | tee -a $informeConColorTotal
		echo -ne "\n| Quantum de tiempo                    |[$rango_min_quantum_procesos/$rango_max_quantum_procesos]: $quantum" >> $informeSinColorTotal
	fi

	if [[ $procesitos -le 0 ]]; then
		echo -ne "\n| Número de procesos                   |[$rango_min_cantidad_procesos/$rango_max_cantidad_procesos]: " | tee -a $informeConColorTotal
		echo -ne "\n| Número de procesos                   |[$rango_min_cantidad_procesos/$rango_max_cantidad_procesos]: " >> $informeSinColorTotal
	else
		echo -ne "\n| Número de procesos                   |[$rango_min_cantidad_procesos/$rango_max_cantidad_procesos]: $procesitos" | tee -a $informeConColorTotal
		echo -ne "\n| Número de procesos                   |[$rango_min_cantidad_procesos/$rango_max_cantidad_procesos]: $procesitos" >> $informeSinColorTotal
	fi
	echo -ne "\n| Tiempos de llegadas de los procesos  |[$rango_min_tiempo_llegada/$rango_max_tiempo_llegada]: " | tee -a $informeConColorTotal
	echo -ne ${llegada[@]} | tee -a $informeConColorTotal
	echo -ne "\n| Tiempos de ejecución de los procesos |[$rango_min_tiempo_ejecucion/$rango_max_tiempo_ejecucion]: " | tee -a $informeConColorTotal
	echo -ne ${tiempo[@]} | tee -a $informeConColorTotal
	echo -ne "\n| Unidades de memoria de los procesos  |[$rango_min_memoria_procesos/$rango_max_memoria_procesos]: " | tee -a $informeConColorTotal
	echo -ne ${memoria[@]} | tee -a $informeConColorTotal
	echo -ne "\n| Prioridades de los procesos          |[$rango_min_prioProc_procesos/$rango_max_prioProc_procesos]: " | tee -a $informeConColorTotal
	echo -ne ${prioProc[@]} | tee -a $informeConColorTotal
	echo -ne "\n|----------------------------------------------------" | tee -a $informeConColorTotal

	echo -ne "\n| Tiempos de llegadas de los procesos  |[$rango_min_tiempo_llegada/$rango_max_tiempo_llegada]: " >> $informeSinColorTotal
	echo -ne ${llegada[@]} >> $informeSinColorTotal
	echo -ne "\n| Tiempos de ejecución de los procesos |[$rango_min_tiempo_ejecucion/$rango_max_tiempo_ejecucion]: " >> $informeSinColorTotal
	echo -ne ${tiempo[@]} >> $informeSinColorTotal
	echo -ne "\n| Unidades de memoria de los procesos  |[$rango_min_memoria_procesos/$rango_max_memoria_procesos]: " >> $informeSinColorTotal
	echo -ne ${memoria[@]} >> $informeSinColorTotal
	echo -ne "\n| Prioridades de los procesos          |[$rango_min_prioProc_procesos/$rango_max_prioProc_procesos]: " >> $informeSinColorTotal
	echo -ne ${prioProc[@]} >> $informeSinColorTotal
	echo -ne "\n|----------------------------------------------------" >> $informeSinColorTotal
} #Fin de mostrarPantallaEntradaProcesosRangoManual_op_cuatro()

####################################################################################
# Sinopsis: Permite leer los rangos desde fichero para la opción 5, 6, 8 y 9.
####################################################################################
function leer_rangos_desde_fichero {
#    clear
	#Se sacan los datos del fichero
	rango_min_cantidad_particiones=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "Part_minima" | cut -f 2 -d " "))
	rango_max_cantidad_particiones=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "Part_maxima" | cut -f 2 -d " "))
	rango_min_longitud_particiones=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "um_minima" | cut -f 2 -d " "))
	rango_max_longitud_particiones=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "um_maxima" | cut -f 2 -d " "))
	rango_min_cantidad_procesos=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "Proc_minima" | cut -f 2 -d " "))
	rango_max_cantidad_procesos=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "Proc_maxima" | cut -f 2 -d " "))
	rango_min_tiempo_llegada=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "tll_minima" | cut -f 2 -d " "))
	rango_max_tiempo_llegada=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "tll_maxima" | cut -f 2 -d " "))
	rango_min_tiempo_ejecucion=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "eje_minima" | cut -f 2 -d " "))
	rango_max_tiempo_ejecucion=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "eje_maxima" | cut -f 2 -d " "))
	rango_min_memoria_procesos=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "mem_minima" | cut -f 2 -d " "))
	rango_max_memoria_procesos=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "mem_maxima" | cut -f 2 -d " "))

	prio_menor_min=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "RangoPrioMenor_minima" | cut -f 2 -d " "))
	prio_menor_max=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "RangoPrioMenor_maxima" | cut -f 2 -d " "))
	prio_mayor_min=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "RangoPrioMayor_minima" | cut -f 2 -d " "))
	prio_mayor_max=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "RangoPrioMayor_maxima" | cut -f 2 -d " "))
	subrango_prioProc_procesos_minInicial=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "prioProc_minima" | cut -f 2 -d " "))
	subrango_prioProc_procesos_maxInicial=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "prioProc_maxima" | cut -f 2 -d " "))

	prio_menor_minInicial=$prio_menor_min #*Inicial - Datos a representar #Se invierten los rangos para calcular el mínimo, pero no para su representación, en la que se verán los datos originales *Inicial.
	prio_menor_maxInicial=$prio_menor_max #*Inicial - Datos a representar
	tratarRangoPrioridadesDirecta $prio_menor_minInicial $prio_menor_maxInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	prio_menor_min=$PriomFinal
	prio_menor_max=$PrioMFinal

	prio_mayor_minInicial=$prio_mayor_min #*Inicial - Datos a representar #Se invierten los rangos para calcular el mínimo, pero no para su representación, en la que se verán los datos originales *Inicial.
	prio_mayor_maxInicial=$prio_mayor_max #*Inicial - Datos a representar
	tratarRangoPrioridadesDirecta $prio_mayor_minInicial $prio_mayor_maxInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	prio_mayor_min=$PriomFinal
	prio_mayor_max=$PrioMFinal

	rango_min_prioProc_procesos=$PriomFinal #Por compatibilidad con código anterior
	rango_max_prioProc_procesos=$PrioMFinal
	prio_mayor_min=$rango_min_prioProc_procesos
	prio_mayor_max=$rango_max_prioProc_procesos

	rango_min_quantum_procesos=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "quantum_minima" | cut -f 2 -d " "))
	rango_max_quantum_procesos=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "quantum_maxima" | cut -f 2 -d " "))

	#Para mantener los datos originales y no los corregidos
	rango_min_cantidad_particiones_ORI=$rango_min_cantidad_particiones
	rango_max_cantidad_particiones_ORI=$rango_max_cantidad_particiones
	rango_min_longitud_particiones_ORI=$rango_min_longitud_particiones
	rango_max_longitud_particiones_ORI=$rango_max_longitud_particiones
	rango_min_cantidad_procesos_ORI=$rango_min_cantidad_procesos
	rango_max_cantidad_procesos_ORI=$rango_max_cantidad_procesos
	rango_min_tiempo_llegada_ORI=$rango_min_tiempo_llegada
	rango_max_tiempo_llegada_ORI=$rango_max_tiempo_llegada
	rango_min_tiempo_ejecucion_ORI=$rango_min_tiempo_ejecucion
	rango_max_tiempo_ejecucion_ORI=$rango_max_tiempo_ejecucion
	rango_min_memoria_procesos_ORI=$rango_min_memoria_procesos
	rango_max_memoria_procesos_ORI=$rango_max_memoria_procesos
	rango_min_prioProc_procesos_ORI=$rango_min_prioProc_procesos
	rango_max_prioProc_procesos_ORI=$rango_max_prioProc_procesos
	prio_menor_min_ORI=$prio_menor_min
	prio_menor_max_ORI=$prio_menor_max
	prio_mayor_min_ORI=$prio_mayor_min
	prio_mayor_max_ORI=$prio_mayor_max
	rango_min_quantum_procesos_ORI=$rango_min_quantum_procesos
	rango_max_quantum_procesos_ORI=$rango_max_quantum_procesos
} #Fin de leer_rangos_desde_fichero()

####################################################################################
# Sinopsis: Pregunta en qué fichero guardar los rangos amplios para la opción 5.
####################################################################################
function entradaMemoriaRangosFichero_op_cinco_Previo {
#    clear
	preguntaDondeGuardarDatosManuales #Resuelve los nombres de los ficheros de datos
} #Fin de entradaMemoriaRangosFichero_op_cinco_Previo()

####################################################################################
# Sinopsis: Permite calcular los valores sobre los que se ejecute el código desde el fichero
# por defecto (opción 5), guardarlos y ejecutarlos.
####################################################################################
function entradaMemoriaRangosFichero_op_cinco_seis {
#    clear
	mem_total=0
	cantidad_particiones="0"
	procesitos="0"
	cantidad_rango_procesos="0"
	cantidad_particiones=$(shuf -i $rango_min_cantidad_particiones-$rango_max_cantidad_particiones -n 1)
	for (( i=1; i<=$cantidad_particiones; i++ )); do
		numParticiones[$i]=$i
		particiones[$i]=$(shuf -i $rango_min_longitud_particiones-$rango_max_longitud_particiones -n 1)
		mem_total=$(($mem_total + ${particiones[$i]}))
	done

	tratarRangoPrioridadesDirecta $subrango_prioProc_procesos_minInicial $subrango_prioProc_procesos_maxInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	prio_menor=$PriomFinal #Sobre este rango se calculan los datos de las prioridades de los procesos, prioridades que no deberían pedirse al usuario.
	prio_mayor=$PrioMFinal
	rango_min_prioProc_procesos=$prio_menor
	rango_max_prioProc_procesos=$prio_mayor

	cantidad_rango_procesos=$(shuf -i $rango_min_cantidad_procesos-$rango_max_cantidad_procesos -n 1)
	procesitos=$cantidad_rango_procesos #Por compatibilidad con otro código.
	for (( i=1; i<=$procesitos; i++ )); do
		llegada[$i]=$(shuf -i $rango_min_tiempo_llegada-$rango_max_tiempo_llegada -n 1)
	done
	for (( i=1; i<=$procesitos; i++ )); do
		tiempo[$i]=$(shuf -i $rango_min_tiempo_ejecucion-$rango_max_tiempo_ejecucion -n 1)
		until [ ${tiempo[$i]} -ge 0 ]; do
			tiempo[$i]=$(shuf -i $rango_min_tiempo_ejecucion-$rango_max_tiempo_ejecucion -n 1)
		done
	done
	cantidad_procesos_rango=$cantidad_rango_procesos
	while [[ $masprocesos == "s" ]]; do # mientras que contador sea menor que cantidad de procesos
		if [[ $p -gt 9 ]]; then
			proceso[$p]=$(echo P$(($p)))
		else
			proceso[$p]=$(echo P0$(($p)))
		fi
		# bloque para introduccion del resto de datos del proceso
		memoria[$p]=$(shuf -i $rango_min_memoria_procesos-$rango_max_memoria_procesos -n 1)
		#Se selecciona la partición de mayor tamaño
		memMax=0
		for (( mm=1; mm<=${#particiones[@]}; mm++ )); do
			if [[ ${particiones[$mm]} -gt $memMax ]]; then
				memMax=${particiones[$mm]}
				aux=$mm
			fi
		done
		while [[ ${memoria[$p]} -le 0 || ${memoria[$p]} -gt ${particiones[$aux]} ]]; do
			memoria[$p]=$(shuf -i $rango_min_memoria_procesos-$rango_max_memoria_procesos -n 1)
		done
		cantidad_rango_procesos=$(($cantidad_rango_procesos - 1))
		if [[ $cantidad_rango_procesos -gt 0 ]]; then
			masprocesos='s'
		else
			masprocesos='n'
		fi
		calcDatoAleatorioGeneral $rango_min_prioProc_procesos $rango_max_prioProc_procesos
		prioProc[$p]=$datoAleatorioGeneral #*Inicial - Datos a representar
		p=$(expr $p + 1) #incremento el contador
	done

	for (( i=1; i<=$cantidad_particiones; i++ )); do
		echo -ne "Particion $i ${particiones[$i]} \n" >> $nomFicheroDatos
	done
	echo -e "RangoPrioridad $rango_min_prioProc_procesos $rango_max_prioProc_procesos " >> $nomFicheroDatos
	PrioR="Mayor" #Valor por defecto hasta la que sea definido por el usuario.
	echo -e "TipoPrioridad $PrioR " >> $nomFicheroDatos
	quantum=$(shuf -i $rango_min_quantum_procesos-$rango_max_quantum_procesos -n 1)
	echo -e "Quantum $quantum " >> $nomFicheroDatos
	for (( i=1; i<=$procesitos; i++ )); do
		echo -ne "Llegada ${llegada[$i]} " >> $nomFicheroDatos
		echo -ne "Ejecucion ${tiempo[$i]} " >> $nomFicheroDatos
		echo -ne "Memoria ${memoria[$i]} " >> $nomFicheroDatos
		echo -e "Prioridad ${prioProc[$i]} " >> $nomFicheroDatos
	done
#    clear
} #Fin de entradaMemoriaRangosFichero_op_cinco_seis()

####################################################################################
# Sinopsis: Permite calcular los valores sobre los que se ejecute el código desde el fichero
# por defecto (opción 5), guardarlos y ejecutarlos.
####################################################################################
function entradaMemoriaRangosFichero_op_cinco_Post_1 {
#    clear
	cp $nomFicheroDatos $ficheroDatosAnteriorEjecucion
	ordenarDatosEntradaFicheros_cuatro_cinco_seis_siete_ocho_nueve
#    clear
} #Fin de entradaMemoriaRangosFichero_op_cinco_Post_1()

####################################################################################
# Sinopsis: Permite elegir otro fichero de rangos reducidos para la opción 6.
####################################################################################
function entradaMemoriaRangosFichero_op_seis_Previo {
#    clear
	preguntaDondeGuardarDatosManuales #Resuelve los nombres de los ficheros de datos
	echo -e "\n\n Ficheros existentes:\n$NORMAL" | tee -a $informeConColorTotal
	echo -e "\n\n Ficheros existentes:\n" >> $informeSinColorTotal
	files=("./FRangos"/*)
	for i in "${!files[@]}"; do
		echo -e "$((i+1))) ${files[$i]}" | tee -a $informeConColorTotal
		echo -e "$((i+1))) ${files[$i]}" >> $informeSinColorTotal
	done
	echo -ne "\n$AMARILLO\n Introduce el número correspondiente al fichero elegido: $NORMAL" | tee -a $informeConColorTotal
	echo -ne "\n\n Introduce el número correspondiente al fichero elegido: " >> $informeSinColorTotal
	read -r numeroFichero
	echo -e "$numeroFichero\n\n" >> $informeConColorTotal
	echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	until [[ 0 -lt $numeroFichero && $numeroFichero -le ${#files[@]} && $numeroFichero -ne "" ]]; do
		echo -ne " Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read -r numeroFichero
		echo -e "$numeroFichero\n\n" >> $informeConColorTotal
		echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	done
	FicheroParaLectura="${files[$((numeroFichero-1))]}"
#    clear
} #Fin de entradaMemoriaRangosFichero_op_seis_Previo()

####################################################################################
# Sinopsis: Permite calcular los valores sobre los que se ejecute el código desde otros ficheros (opción 6), guardarlos y ejecutarlos.
####################################################################################
function entradaMemoriaRangosFichero_op_seis_Post_1 {
#    clear
	echo -e "Part_minima $rango_min_cantidad_particiones \nPart_maxima $rango_max_cantidad_particiones  \num_minima $rango_min_longitud_particiones \num_maxima $rango_max_longitud_particiones " > $ficheroRangosAnteriorEjecucion
	echo -e "Proc_minima $rango_min_cantidad_procesos \nProc_maxima $rango_max_cantidad_procesos \ntll_minima $rango_min_tiempo_llegada \ntll_maxima $rango_max_tiempo_llegada \neje_minima $rango_min_tiempo_ejecucion \neje_maxima $rango_max_tiempo_ejecucion \nmem_minima $rango_min_memoria_procesos \nmem_maxima $rango_max_memoria_procesos \nprioProc_minima $rango_min_prioProc_procesos \nprioProc_maxima $rango_max_prioProc_procesos " >> $ficheroRangosAnteriorEjecucion
	ordenarDatosEntradaFicheros_cuatro_cinco_seis_siete_ocho_nueve
	cp $nomFicheroDatos $ficheroDatosAnteriorEjecucion
#    clear
} #Fin de entradaMemoriaRangosFichero_op_seis_Post_1()

####################################################################################
# Sinopsis: Pregunta en qué ficheros guardar los rangos amplios, y rangos y datos calculados para la opción 7.
####################################################################################
function entradaMemoriaRangosFichero_op_siete_Previo {
#    clear
	preguntaDondeGuardarRangosAleTManuales #Resuelve los nombres de los ficheros de rangos amplios
	preguntaDondeGuardarRangosManuales #Resuelve los nombres de los ficheros de rangos
	preguntaDondeGuardarDatosManuales #Resuelve los nombres de los ficheros de datos
} #Fin de entradaMemoriaRangosFichero_op_siete()

####################################################################################
# Sinopsis: Sólo se introducen los datos, como en calcularSubRangosDatos_op_siete_ocho_nueve_Previo,
# que luego servirán para hacer los cálculos en entradaMemoriaRangosFichero_op_siete_ocho_nueve
####################################################################################
function entradaMemoriaRangosFichero_op_siete {
#    clear
	rango_min_cantidad_particiones="#"
	rango_max_cantidad_particiones="#"
	cantidad_particiones="0"
	rango_min_longitud_particiones="#"
	rango_max_longitud_particiones="#"
	procesitos="0"
	rango_min_cantidad_procesos="#"
	rango_max_cantidad_procesos="#"
	quantum="0"
	rango_min_quantum_procesos="#"
	rango_max_quantum_procesos="#"
	cantidad_rango_procesos="0"
	rango_min_tiempo_llegada="#"
	rango_max_tiempo_llegada="#"
	rango_min_tiempo_ejecucion="#"
	rango_max_tiempo_ejecucion="#"
	rango_min_memoria_procesos="#"
	rango_max_memoria_procesos="#"
	rango_min_prioProc_procesos="#"
	rango_max_prioProc_procesos="#"
#    clear
	mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve

	echo -ne "\n Información de la particiones" | tee -a $informeConColorTotal
	echo -ne "\n Información de la particiones" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango del número de particiones (Debe ser mayor que 0): "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango del número de particiones (Debe ser mayor que 0): ">> $informeSinColorTotal
	read rango_min_cantidad_particiones
	numeroAComprobar=$rango_min_cantidad_particiones
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_cantidad_particiones=$numeroAComprobar
	echo "$rango_min_cantidad_particiones" >> $informeConColorTotal
	echo "$rango_min_cantidad_particiones" >> $informeSinColorTotal
	echo -ne $AMARILLO" Máximo del rango del número de particiones (Tiene que ser mayor o igual que $rango_min_cantidad_particiones): "$NORMAL | tee -a $informeConColorTotal
	echo -ne " Máximo del rango del número de particiones (Tiene que ser mayor o igual que $rango_min_cantidad_particiones): " >> $informeSinColorTotal
	read rango_max_cantidad_particiones
	numeroAComprobar=$rango_max_cantidad_particiones
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_cantidad_particiones=$numeroAComprobar
	echo "$rango_max_cantidad_particiones" >> $informeConColorTotal
	echo "$rango_max_cantidad_particiones" >> $informeSinColorTotal
#    clear
	rango_min_cantidad_particiones_ORI=$rango_min_cantidad_particiones
	rango_max_cantidad_particiones_ORI=$rango_max_cantidad_particiones
	mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve

	echo -ne "\n Información de la particiones" | tee -a $informeConColorTotal
	echo -ne "\n Información de la particiones" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango de unidades de memoria de las particiones (Debe ser mayor que 0): "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango de unidades de memoria de las particiones (Debe ser mayor que 0): " >> $informeSinColorTotal
	read rango_min_longitud_particiones
	numeroAComprobar=$rango_min_longitud_particiones
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_longitud_particiones=$numeroAComprobar
	echo "$rango_min_longitud_particiones" >> $informeConColorTotal
	echo "$rango_min_longitud_particiones" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Máximo del rango de unidades de memoria de las particiones (Tiene que ser mayor o igual que $rango_min_longitud_particiones): "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Máximo del rango de unidades de memoria de las particiones (Tiene que ser mayor o igual que $rango_min_longitud_particiones): " >> $informeSinColorTotal
	read rango_max_longitud_particiones
	numeroAComprobar=$rango_max_longitud_particiones
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_longitud_particiones=$numeroAComprobar
	echo "$rango_max_longitud_particiones" >> $informeConColorTotal
	echo "$rango_max_longitud_particiones" >> $informeSinColorTotal
	contadorParticiones=1
#    clear
	rango_min_longitud_particiones_ORI=$rango_min_longitud_particiones
	rango_max_longitud_particiones_ORI=$rango_max_longitud_particiones
	mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve

	echo -ne "\n\n Información de las prioridades" | tee -a $informeConColorTotal
	echo -ne "\n\n Información de las prioridades" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango para calcular el mínimo del rango de prioridades de los procesos (Podría ser positivo o negativo): "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango para calcular el mínimo del rango de prioridades de los procesos (Podría ser positivo o negativo): " >> $informeSinColorTotal
	read prio_menor_min
	numeroAComprobar=$prio_menor_min
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	prio_menor_min=$numeroAComprobar
	echo "$prio_menor_min" >> $informeConColorTotal
	echo "$prio_menor_min" >> $informeSinColorTotal
	echo -ne $AMARILLO" Máximo del rango para calcular el mínimo del rango de prioridades de los procesos (Podría ser mayor o menor que $rango_max_longitud_particiones, y positivo o negativo): "$NORMAL | tee -a $informeConColorTotal
	echo -ne " Máximo del rango para calcular el mínimo del rango de prioridades de los procesos (Podría ser mayor o menor que $rango_max_longitud_particiones, y positivo o negativo): " >> $informeSinColorTotal
	read prio_menor_max
	numeroAComprobar=$prio_menor_max
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	prio_menor_max=$numeroAComprobar
	echo "$prio_menor_max" >> $informeConColorTotal
	echo "$prio_menor_max" >> $informeSinColorTotal
#    clear
	prio_menor_min_ORI=$prio_menor_min
	prio_menor_max_ORI=$prio_menor_max
	mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve

	echo -ne "\n\n Información de las prioridades" | tee -a $informeConColorTotal
	echo -ne "\n\n Información de las prioridades" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango para calcular el máximo del rango de prioridades de los procesos (Podría ser positivo o negativo): "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango para calcular el máximo del rango de prioridades de los procesos (Podría ser positivo o negativo): " >> $informeSinColorTotal
	read prio_mayor_min
	numeroAComprobar=$prio_mayor_min
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	prio_mayor_min=$numeroAComprobar
	echo "$prio_mayor_min" >> $informeConColorTotal
	echo "$prio_mayor_min" >> $informeSinColorTotal
	echo -ne $AMARILLO" Máximo del rango para calcular el máximo del rango de prioridades de los procesos (Podría ser mayor o menor que $rango_max_longitud_particiones, y positivo o negativo): "$NORMAL | tee -a $informeConColorTotal
	echo -ne " Máximo del rango para calcular el máximo del rango de prioridades de los procesos (Podría ser mayor o menor que $rango_max_longitud_particiones, y positivo o negativo): " >> $informeSinColorTotal
	read prio_mayor_max
	numeroAComprobar=$prio_mayor_max
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	prio_mayor_max=$numeroAComprobar
	echo "$prio_mayor_max" >> $informeConColorTotal
	echo "$prio_mayor_max" >> $informeSinColorTotal
#    clear
	prio_mayor_min_ORI=$prio_mayor_min
	prio_mayor_max_ORI=$prio_mayor_max
	mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve

	echo -ne "\n Información del quantum de tiempo" | tee -a $informeConColorTotal
	echo -ne "\n Información del quantum de tiempo" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango del quantum de tiempo (Debe ser mayor que 0): "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango del quantum de tiempo (Debe ser mayor que 0): " >> $informeSinColorTotal
	read rango_min_quantum_procesos
	numeroAComprobar=$rango_min_quantum_procesos
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_quantum_procesos=$numeroAComprobar
	echo "$rango_min_quantum_procesos" >>$informeConColorTotal
	echo "$rango_min_quantum_procesos" >>$informeSinColorTotal
	echo -ne $AMARILLO"\n Máximo del rango del quantum de tiempo (Tiene que ser mayor o igual que $rango_min_quantum_procesos): "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Máximo del rango del quantum de tiempo (Tiene que ser mayor o igual que $rango_min_quantum_procesos): " >> $informeSinColorTotal
	read rango_max_quantum_procesos
	numeroAComprobar=$rango_max_quantum_procesos
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_quantum_procesos=$numeroAComprobar
	echo "$rango_max_quantum_procesos" >>$informeConColorTotal
	echo "$rango_max_quantum_procesos" >>$informeSinColorTotal
#    clear
	rango_min_quantum_procesos_ORI=$rango_min_quantum_procesos
	rango_max_quantum_procesos_ORI=$rango_max_quantum_procesos
	mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve

	echo -ne "\n\n Información de los procesos" | tee -a $informeConColorTotal
	echo -ne "\n\n Información de los procesos" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango del número de procesos (Debe ser mayor que 0): "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango del número de procesos (Debe ser mayor que 0): " >> $informeSinColorTotal
	read rango_min_cantidad_procesos
	numeroAComprobar=$rango_min_cantidad_procesos
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_cantidad_procesos=$numeroAComprobar
	echo "$rango_min_cantidad_procesos" >> $informeConColorTotal
	echo "$rango_min_cantidad_procesos" >> $informeSinColorTotal
	echo -ne $AMARILLO" Máximo del rango del número de procesos (Tiene que ser mayor o igual que $rango_min_cantidad_procesos): "$NORMAL | tee -a $informeConColorTotal
	echo -ne " Máximo del rango del número de procesos (Tiene que ser mayor o igual que $rango_min_cantidad_procesos): " >> $informeSinColorTotal
	read rango_max_cantidad_procesos
	numeroAComprobar=$rango_max_cantidad_procesos
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_cantidad_procesos=$numeroAComprobar
	echo "$rango_max_cantidad_procesos" >> $informeConColorTotal
	echo "$rango_max_cantidad_procesos" >> $informeSinColorTotal
#    clear
	rango_min_cantidad_procesos_ORI=$rango_min_cantidad_procesos
	rango_max_cantidad_procesos_ORI=$rango_max_cantidad_procesos
	mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve

	echo -ne "\n\n Información de los procesos" | tee -a $informeConColorTotal
	echo -ne "\n\n Información de los procesos" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango del tiempo de llegada de los procesos (Debe ser mayor o igual que 0): "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango del tiempo de llegada de los procesos (Debe ser mayor o igual que 0): " >> $informeSinColorTotal
	read rango_min_tiempo_llegada
	numeroAComprobar=$rango_min_tiempo_llegada
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_tiempo_llegada=$numeroAComprobar
	echo "$rango_min_tiempo_llegada" >> $informeConColorTotal
	echo "$rango_min_tiempo_llegada" >> $informeSinColorTotal
	echo -ne $AMARILLO" Máximo del rango del tiempo de llegada de los procesos (Tiene que ser mayor o igual que $rango_min_tiempo_llegada): "$NORMAL | tee -a $informeConColorTotal
	echo -ne " Máximo del rango del tiempo de llegada de los procesos (Tiene que ser mayor o igual que $rango_min_tiempo_llegada): " >> $informeSinColorTotal
	read rango_max_tiempo_llegada
	numeroAComprobar=$rango_max_tiempo_llegada
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_cantidad_procesos=$numeroAComprobar
	echo "$rango_max_tiempo_llegada" >> $informeConColorTotal
	echo "$rango_max_tiempo_llegada" >> $informeSinColorTotal
#    clear
	rango_min_tiempo_llegada_ORI=$rango_min_tiempo_llegada
	rango_max_tiempo_llegada_ORI=$rango_max_tiempo_llegada
	mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve

	echo -ne "\n\n Información de los procesos" | tee -a $informeConColorTotal
	echo -ne "\n\n Información de los procesos" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Mínimo del rango del tiempo de ejecución de los procesos (Debe ser mayor que 0): "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Mínimo del rango del tiempo de ejecución de los procesos (Debe ser mayor que 0): " >> $informeSinColorTotal
	read rango_min_tiempo_ejecucion
	numeroAComprobar=$rango_min_tiempo_ejecucion
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_tiempo_ejecucion=$numeroAComprobar
	echo "$rango_min_tiempo_ejecucion" >> $informeConColorTotal
	echo "$rango_min_tiempo_ejecucion" >> $informeSinColorTotal
	echo -ne $AMARILLO" Máximo del rango del tiempo de ejecución de los procesos (Tiene que ser mayor o igual que $rango_min_tiempo_ejecucion): "$NORMAL | tee -a $informeConColorTotal
	echo -ne " Máximo del rango del tiempo de ejecución de los procesos (Tiene que ser mayor o igual que $rango_min_tiempo_ejecucion): " >> $informeSinColorTotal
	read rango_max_tiempo_ejecucion
	numeroAComprobar=$rango_max_tiempo_ejecucion
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_tiempo_ejecucion=$numeroAComprobar
	echo "$rango_max_tiempo_ejecucion" >> $informeConColorTotal
	echo "$rango_max_tiempo_ejecucion" >> $informeSinColorTotal
#    clear
	rango_min_tiempo_ejecucion_ORI=$rango_min_tiempo_ejecucion
	rango_max_tiempo_ejecucion_ORI=$rango_max_tiempo_ejecucion
	mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve

	echo -ne "\n\n Información de los procesos" | tee -a $informeConColorTotal
	echo -ne "\n\n Información de los procesos" >> $informeSinColorTotal
	echo -ne $AMARILLO"\n Minimo del rango de unidades de memoria de los procesos (Debe ser mayor que 0): "$NORMAL | tee -a $informeConColorTotal
	echo -ne "\n Minimo del rango de unidades de memoria de los procesos (Debe ser mayor que 0): " >> $informeSinColorTotal
	read rango_min_memoria_procesos
	numeroAComprobar=$rango_min_memoria_procesos
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_min_memoria_procesos=$numeroAComprobar
	echo "$rango_min_memoria_procesos" >> $informeConColorTotal
	echo "$rango_min_memoria_procesos" >> $informeSinColorTotal
	echo -ne $AMARILLO" Máximo del rango de unidades de memoria de los procesos (Tiene que ser mayor o igual que $rango_min_memoria_procesos, y menor o igual que $rango_max_longitud_particiones): "$NORMAL | tee -a $informeConColorTotal
	echo -ne " Máximo del rango de unidades de memoria de los procesos (Tiene que ser mayor o igual que $rango_min_memoria_procesos, y menor o igual que $rango_max_longitud_particiones): " >> $informeSinColorTotal
	read rango_max_memoria_procesos
	numeroAComprobar=$rango_max_memoria_procesos
	comprobarNumero #Se comprueba el valor contenido es entero, y si no lo és, se vuelve a pedir.
	rango_max_memoria_procesos=$numeroAComprobar
	echo "$rango_max_memoria_procesos" >> $informeConColorTotal
	echo "$rango_max_memoria_procesos" >> $informeSinColorTotal
#    clear
	rango_min_memoria_procesos_ORI=$rango_min_memoria_procesos
	rango_max_memoria_procesos_ORI=$rango_max_memoria_procesos
	mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve

	ordenarDatosEntradaFicheros_cuatro_cinco_seis_siete_ocho_nueve
} #Fin de entradaMemoriaRangosFichero_op_siete()

####################################################################################
# Sinopsis: Pregunta en qué ficheros guardar los rangos amplios y datos calculados para la opción 8.
####################################################################################
function entradaMemoriaRangosFichero_op_ocho_Previo {
#    clear
	preguntaDondeGuardarRangosManuales #Resuelve los nombres de los ficheros de rangos
	preguntaDondeGuardarDatosManuales #Resuelve los nombres de los ficheros de datos
} #Fin de entradaMemoriaRangosFichero_op_ocho_Previo()

####################################################################################
# Sinopsis: Permite leer los rangos reducidos desde otros ficheros para la opción 9.
####################################################################################
function entradaMemoriaRangosFichero_op_nueve_Previo {
#    clear
	preguntaDondeGuardarRangosManuales #Resuelve los nombres de los ficheros de rangos
	preguntaDondeGuardarDatosManuales #Resuelve los nombres de los ficheros de datos
	echo -e "\n\n Ficheros existentes:\n$NORMAL" | tee -a $informeConColorTotal
	echo -e "\n\n Ficheros existentes:\n" >> $informeSinColorTotal
	files=("./FRangosAleT"/*)
	for i in "${!files[@]}"; do
		echo -e "$((i+1))) ${files[$i]}" | tee -a $informeConColorTotal
		echo -e "$((i+1))) ${files[$i]}" >> $informeSinColorTotal
	done
	echo -ne "\n$AMARILLO\n Introduce el número correspondiente al fichero elegido: $NORMAL" | tee -a $informeConColorTotal
	echo -ne "\n\n Introduce el número correspondiente al fichero elegido: " >> $informeSinColorTotal
	read -r numeroFichero
	echo -e "$numeroFichero\n\n" >> $informeConColorTotal
	echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	until [[ 0 -lt $numeroFichero && $numeroFichero -le ${#files[@]} && $numeroFichero -ne "" ]]; do
		echo -ne " Error en la elección de una opción válida\n  --> " | tee -a $informeConColorTotal
		echo -ne " Error en la elección de una opción válida\n  --> " >> $informeSinColorTotal
		read -r numeroFichero
		echo -e "$numeroFichero\n\n" >> $informeConColorTotal
		echo -e "$numeroFichero\n\n" >> $informeSinColorTotal
	done
	FicheroParaLectura="${files[$((numeroFichero-1))]}"
#    clear
} #Fin de entradaMemoriaRangosFichero_op_nueve_Previo()

####################################################################################
# Sinopsis: Se controla que el mínimo sea menor que el máximo, y si no es así, lo invierte.
####################################################################################
function controlRangosMaxMin {
#    clear
	#Primero se invierten los rangos en caso de ir de mayor a menor.
	if [[ ! "$rango_max_cantidad_particiones" =~ ^#.* && ! "$rango_min_cantidad_particiones" =~ ^#.* ]]; then
		if [[ $rango_max_cantidad_particiones -lt $rango_min_cantidad_particiones ]]; then
			echo $AMARILLO" Está mal definido el rango del número de particiones, el máximo no puede ser menor que el mínimo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal definido el rango del número de particiones, el máximo no puede ser menor que el mínimo" >> $informeSinColorTotal
			aux=$rango_max_cantidad_particiones
			rango_max_cantidad_particiones=$rango_min_cantidad_particiones
			rango_min_cantidad_particiones=$aux
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_max_longitud_particiones =~ ^#.* && ! $rango_min_longitud_particiones =~ ^#.* ]]; then
		if [[ $rango_max_longitud_particiones -lt $rango_min_longitud_particiones ]]; then
			echo $AMARILLO" Está mal definido el rango del tamaño de las particiones, el máximo no puede ser menor que el mínimo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal definido el rango del tamaño de las particiones, el máximo no puede ser menor que el mínimo" >> $informeSinColorTotal
			aux=$rango_max_longitud_particiones
			rango_max_longitud_particiones=$rango_min_longitud_particiones
			rango_min_longitud_particiones=$aux
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_max_cantidad_procesos =~ ^#.* && ! $rango_min_cantidad_procesos =~ ^#.* ]]; then
		if [[ $rango_max_cantidad_procesos -lt $rango_min_cantidad_procesos ]]; then
			echo $AMARILLO" Está mal definido el rango del número de procesos, el máximo no puede ser menor que el mínimo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal definido el rango del número de procesos, el máximo no puede ser menor que el mínimo" >> $informeSinColorTotal
			aux=$rango_max_cantidad_procesos
			rango_max_cantidad_procesos=$rango_min_cantidad_procesos
			rango_min_cantidad_procesos=$aux
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_max_quantum_procesos =~ ^#.* && ! $rango_min_quantum_procesos =~ ^#.* ]]; then
		if [[ $rango_max_quantum_procesos -lt $rango_min_quantum_procesos ]]; then
			echo $AMARILLO" Está mal definido el rango del quantum, el máximo no puede ser menor que el mínimo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal definido el rango del quantum, el máximo no puede ser menor que el mínimo" >> $informeSinColorTotal
			aux=$rango_max_quantum_procesos
			rango_max_quantum_procesos=$rango_min_quantum_procesos
			rango_min_quantum_procesos=$aux
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_max_tiempo_llegada =~ ^#.* && ! $rango_min_tiempo_llegada =~ ^#.* ]]; then
		if [[ $rango_max_tiempo_llegada -lt $rango_min_tiempo_llegada ]]; then
			echo $AMARILLO" Está mal definido el rango del tiempo de llegada, el máximo no puede ser menor que el mínimo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal definido el rango del tiempo de llegada, el máximo no puede ser menor que el mínimo" >> $informeSinColorTotal
			aux=$rango_max_tiempo_llegada
			rango_max_tiempo_llegada=$rango_min_tiempo_llegada
			rango_min_tiempo_llegada=$aux
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_max_tiempo_ejecucion =~ ^#.* && ! $rango_min_tiempo_ejecucion =~ ^#.* ]]; then
		if [[ $rango_max_tiempo_ejecucion -lt $rango_min_tiempo_ejecucion ]]; then
			echo $AMARILLO" Está mal definido el rango del tiempo de ejecución, el máximo no puede ser menor que el mínimo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal definido el rango del tiempo de ejecución, el máximo no puede ser menor que el mínimo" >> $informeSinColorTotal
			aux=$rango_max_tiempo_ejecucion
			rango_max_tiempo_ejecucion=$rango_min_tiempo_ejecucion
			rango_min_tiempo_ejecucion=$aux
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_max_memoria_procesos =~ ^#.* && ! $rango_min_memoria_procesos =~ ^#.* ]]; then
		if [[ $rango_max_memoria_procesos -lt $rango_min_memoria_procesos ]]; then
			echo $AMARILLO" Está mal definido el rango de memoria por proceso, el máximo no puede ser menor que el mínimo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal definido el rango de memoria por proceso, el máximo no puede ser menor que el mínimo" >> $informeSinColorTotal
			aux=$rango_max_memoria_procesos
			rango_max_memoria_procesos=$rango_min_memoria_procesos
			rango_min_memoria_procesos=$aux
			cambionumerss=true
		fi
	fi
} #Fin de controlRangosMaxMin()

####################################################################################
# Sinopsis: Se controla que el valor mínimo no sea menor que 0 o 1, y si es así, lo pone a 0 o 1,
# dependiendo del caso.
# Por ejemplo, los tiempos de llegada pueden ser 0, pero el nùmero de particiones, no.
####################################################################################
function controlRangosMinValoresNegativos {
#    clear
	#   Se corrigen los extremos de los subrangos en caso de ser negativos
	if [[ ! $rango_min_cantidad_particiones =~ ^#.* ]]; then
		if [[ $rango_min_cantidad_particiones -lt 1 ]]; then
			echo $AMARILLO" Está mal el mínimo número de particiones, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el mínimo número de particiones, no puede ser un número negativo" >> $informeSinColorTotal
			rango_min_cantidad_particiones=1
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_max_cantidad_particiones =~ ^#.* ]]; then
		if [[ $rango_max_cantidad_particiones -lt 1 ]]; then
			echo $AMARILLO" Está mal el máximo número de particiones, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el máximo número de particiones, no puede ser un número negativo" >> $informeSinColorTotal
			rango_max_cantidad_particiones=1
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_min_longitud_particiones =~ ^#.* ]]; then
		if [[ $rango_min_longitud_particiones -lt 1 ]]; then
			echo $AMARILLO" Está mal el mínimo tamaño de las particiones, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el mínimo tamaño de las particiones, no puede ser un número negativo" >> $informeSinColorTotal
			rango_min_longitud_particiones=1
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_max_longitud_particiones =~ ^#.* ]]; then
		if [[ $rango_max_longitud_particiones -lt 1 ]]; then
			echo $AMARILLO" Está mal el máximo tamaño de las particiones, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el máximo tamaño de las particiones, no puede ser un número negativo" >> $informeSinColorTotal
			rango_max_longitud_particiones=1
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_min_cantidad_procesos =~ ^#.* ]]; then
		if [[ $rango_min_cantidad_procesos -lt 1 ]]; then
			echo $AMARILLO" Está mal el mínimo número de procesos, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el mínimo número de procesos, no puede ser un número negativo" >> $informeSinColorTotal
			rango_min_cantidad_procesos=1
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_max_cantidad_procesos =~ ^#.* ]]; then
		if [[ $rango_max_cantidad_procesos -lt 1 ]]; then
			echo $AMARILLO" Está mal el máximo número de procesos, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el máximo número de procesos, no puede ser un número negativo" >> $informeSinColorTotal
			rango_max_cantidad_procesos=1
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_min_quantum_procesos =~ ^#.* ]]; then
		if [[ $rango_min_quantum_procesos -lt 1 ]]; then
			echo $AMARILLO" Está mal el mínimo del quantum, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el mínimo del quantum, no puede ser un número negativo" >> $informeSinColorTotal
			rango_min_quantum_procesos=1
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_max_quantum_procesos =~ ^#.* ]]; then
		if [[ $rango_max_quantum_procesos -lt 1 ]]; then
			echo $AMARILLO" Está mal el máximo del quantum, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el máximo del quantum, no puede ser un número negativo" >> $informeSinColorTotal
			rango_max_quantum_procesos=1
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_min_tiempo_llegada =~ ^#.* ]]; then
		if [[ $rango_min_tiempo_llegada -lt 0 ]]; then
			echo $AMARILLO" Está mal el mínimo tiempo de llegada, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el mínimo tiempo de llegada, no puede ser un número negativo" >> $informeSinColorTotal
			rango_min_tiempo_llegada=0
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_max_tiempo_llegada =~ ^#.* ]]; then
		if [[ $rango_max_tiempo_llegada -lt 0 ]]; then
			echo $AMARILLO" Está mal el máximo tiempo de llegada, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el máximo tiempo de llegada, no puede ser un número negativo" >> $informeSinColorTotal
			rango_max_tiempo_llegada=0
			cambionumerss=true
		fi
	fi

	if [[ ! $rango_min_tiempo_ejecucion =~ ^#.* ]]; then
		if [[ $rango_min_tiempo_ejecucion -lt 1 ]]; then
			echo $AMARILLO" Está mal el mínimo tiempo de ejecución, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el mínimo tiempo de ejecución, no puede ser un número negativo" >> $informeSinColorTotal
			rango_min_tiempo_ejecucion=1
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_max_tiempo_ejecucion =~ ^#.* ]]; then
		if [[ $rango_max_tiempo_ejecucion -lt 1 ]]; then
			echo $AMARILLO" Está mal el máximo tiempo de ejecución, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el máximo tiempo de ejecución, no puede ser un número negativo" >> $informeSinColorTotal
			rango_max_tiempo_ejecucion=1
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_min_memoria_procesos =~ ^#.* ]]; then
		if [[ $rango_min_memoria_procesos -lt 1 ]]; then
			echo $AMARILLO" Está mal el mínimo de unidades de memoria, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el mínimo de unidades de memoria, no puede ser un número negativo" >> $informeSinColorTotal
			rango_min_memoria_procesos=1
			cambionumerss=true
		fi
	fi
	if [[ ! $rango_max_memoria_procesos =~ ^#.* ]]; then
		if [[ $rango_max_memoria_procesos -lt 1 ]]; then
			echo $AMARILLO" Está mal el máximo de unidades de memoria, no puede ser un número negativo"$NORMAL | tee -a $informeConColorTotal
			echo " Está mal el máximo de unidades de memoria, no puede ser un número negativo" >> $informeSinColorTotal
			rango_max_memoria_procesos=1
			cambionumerss=true
		fi
	fi
} #Fin de controlRangosMinValoresNegativos()

####################################################################################
# Sinopsis: Permite calcular subrangos desde los rangos aleatorios amplios, guardarlos, calcular los
# valores sobre los que se ejecute el código, guardarlos y ejecutarlos, para las opciones 7, 8 y 9.
####################################################################################
function entradaMemoriaRangosFichero_op_siete_ocho_nueve {
#    clear
	subrango_cantidad_particiones_min=-1
	subrango_cantidad_particiones_max=-1
	subrango_longitud_particiones_min=-1
	subrango_longitud_particiones_max=-1
	subrango_cantidad_procesos_min=-1
	subrango_cantidad_procesos_max=-1
	subrango_quantum_procesos_min=-1
	subrango_quantum_procesos_max=-1
	subrango_tiempo_llegada_min=-1
	subrango_tiempo_llegada_max=-1
	subrango_tiempo_ejecucion_min=-1
	subrango_tiempo_ejecucion_max=-1
	subrango_memoria_proceso_min=-1
	subrango_memoria_proceso_max=-1
	subrango_prioProc_procesos_min=-1
	subrango_prioProc_procesos_max=-1

	controlRangosMaxMin
	controlRangosMinValoresNegativos #Se controla que el valor mínimo no sea menor que 0 o 1, y si es así, lo pone a 0 o 1, dependiendo del caso.
	#Se calculan los valores aleatorios de mínimos y máximos de los subrangos desde los rangos amplios. Se podría hacer infinito por lo que ya se han filtrado antes. Por tanto, se podría simplificar, eliminando los while, al tener un RANDOM sobre rangos correctos.
	while [[ $subrango_cantidad_particiones_min -lt 0 ]]; do #Se genera el mínimo del subrango, y después se calcula el máximo entre el mínimo del subrango y el máximo del rango.
		subrango_cantidad_particiones_min=$((RANDOM % ($rango_max_cantidad_particiones  - $rango_min_cantidad_particiones + 1) + $rango_min_cantidad_particiones))
		subrango_cantidad_particiones_max=$((RANDOM % ($rango_max_cantidad_particiones  - $subrango_cantidad_particiones_min + 1) + $subrango_cantidad_particiones_min))
	done
	while [[ $subrango_longitud_particiones_min -lt 0 ]]; do
		subrango_longitud_particiones_min=$((RANDOM % ($rango_max_longitud_particiones  - $rango_min_longitud_particiones + 1) + $rango_min_longitud_particiones))
		subrango_longitud_particiones_max=$((RANDOM % ($rango_max_longitud_particiones  - $subrango_longitud_particiones_min + 1) + $subrango_longitud_particiones_min))
	done
	while [[ $subrango_cantidad_procesos_min -lt 0 ]]; do
		subrango_cantidad_procesos_min=$((RANDOM % ($rango_max_cantidad_procesos  - $rango_min_cantidad_procesos + 1) + $rango_min_cantidad_procesos))
		subrango_cantidad_procesos_max=$((RANDOM % ($rango_max_cantidad_procesos  - $subrango_cantidad_procesos_min + 1) + $subrango_cantidad_procesos_min))
	done
	while [[ $subrango_quantum_procesos_min -lt 0 ]]; do
		subrango_quantum_procesos_min=$((RANDOM % ($rango_max_quantum_procesos  - $rango_min_quantum_procesos + 1) + $rango_min_quantum_procesos))
		subrango_quantum_procesos_max=$((RANDOM % ($rango_max_quantum_procesos  - $subrango_quantum_procesos_min + 1) + $subrango_quantum_procesos_min))
	done
	while [[ $subrango_tiempo_llegada_min -lt 0 ]]; do
		subrango_tiempo_llegada_min=$((RANDOM % ($rango_max_tiempo_llegada  - $rango_min_tiempo_llegada + 1) + $rango_min_tiempo_llegada))
		subrango_tiempo_llegada_max=$((RANDOM % ($rango_max_tiempo_llegada  - $subrango_tiempo_llegada_min + 1) + $subrango_tiempo_llegada_min))
	done
	while [[ $subrango_tiempo_ejecucion_min -lt 0 ]]; do
		subrango_tiempo_ejecucion_min=$((RANDOM % ($rango_max_tiempo_ejecucion  - $rango_min_tiempo_ejecucion + 1) + $rango_min_tiempo_ejecucion))
		subrango_tiempo_ejecucion_max=$((RANDOM % ($rango_max_tiempo_ejecucion  - $subrango_tiempo_ejecucion_min + 1) + $subrango_tiempo_ejecucion_min))
	done
	while [[ $subrango_memoria_proceso_min -lt 0 ]]; do
		subrango_memoria_proceso_min=$((RANDOM % ($rango_max_memoria_procesos  - $rango_min_memoria_procesos + 1) + $rango_min_memoria_procesos))
		subrango_memoria_proceso_max=$((RANDOM % ($rango_max_memoria_procesos  - $subrango_memoria_proceso_min + 1) + $subrango_memoria_proceso_min))
	done

	controlRangosMaxMin #No hace falta ejecutar este control porque la forma de calcular mínimos y máximos lo impide.
	controlRangosMinValoresNegativos #Se controla que el valor mínimo no sea menor que 0 o 1, y si es así, lo pone a 0 o 1, dependiendo del caso.

	#Se calculan los datos dentro de los subrangos
	contadorParticiones=1
	cantidad_particiones=$(shuf -i $subrango_cantidad_particiones_min-$subrango_cantidad_particiones_max -n 1)
	for (( i=1; i<=$cantidad_particiones; i++ )); do
		numParticiones[$i]=$i
		particiones[$i]=$(shuf -i $subrango_longitud_particiones_min-$subrango_longitud_particiones_max -n 1)
		mem_total=$(($mem_total + ${particiones[$i]}))
	done

	#De un rango para el menor y otro rango para el mayor (rangos amplios) se sacan dos valores que se usan como subrango, del que se sacan los datos.
	tratarRangoPrioridadesDirecta $prio_menor_min $prio_menor_max #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	prio_menor_min=$PriomFinal #Rango mínimo inicial corregido
	prio_menor_max=$PrioMFinal
	calcDatoAleatorioGeneral $prio_menor_min $prio_menor_max #Se calcula el mínimo amplio
	rango_min_prioProc_procesos=$datoAleatorioGeneral #*Inicial - Datos a representar #Variables con los datos originales del rango amplio sin corregir, usadas en la cabecera de la representación de la tabla
	tratarRangoPrioridadesDirecta $prio_mayor_min $prio_mayor_max #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	prio_mayor_min=$PriomFinal #Rango máximo inicial
	prio_mayor_max=$PrioMFinal
	calcDatoAleatorioGeneral $prio_mayor_min $prio_mayor_max #Se calcula el máximo amplio
	rango_max_prioProc_procesos=$datoAleatorioGeneral #*Inicial - Datos a representar #Variables con los datos originales del rango amplio sin corregir, usadas en la cabecera de la representación de la tabla

	tratarRangoPrioridadesDirecta $rango_min_prioProc_procesos $rango_max_prioProc_procesos #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	prio_menor=$PriomFinal #Sobre este rango amplio corregido se calculan los subrangos
	prio_mayor=$PrioMFinal

	calcDatoAleatorioGeneral $prio_menor $prio_mayor #Se calcula el mínimo del subrango
	subrango_prioProc_procesos_minInicial=$datoAleatorioGeneral #Subrango sin corregir
	calcDatoAleatorioGeneral $prio_menor $prio_mayor #Se calcula el máximo del subrango
	subrango_prioProc_procesos_maxInicial=$datoAleatorioGeneral
	tratarRangoPrioridadesDirecta $subrango_prioProc_procesos_minInicial $subrango_prioProc_procesos_maxInicial #Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
	subrango_prioProc_procesos_min=$PriomFinal #Sobre este subrango corregido se calculan los datos de las prioridades de los procesos, prioridades que no deberían pedirse al usuario.
	subrango_prioProc_procesos_max=$PrioMFinal

	cantidad_rango_procesos=$(shuf -i $subrango_cantidad_procesos_min-$subrango_cantidad_procesos_max -n 1)
	procesitos=$cantidad_rango_procesos #Por compatibilidad con otro código.
	cantidad_rango_quantum=$(shuf -i $subrango_quantum_procesos_min-$subrango_quantum_procesos_max -n 1)
	quantum=$cantidad_rango_quantum
	for (( i=1; i<=$procesitos; i++ )); do
		llegada[$i]=$(shuf -i $subrango_tiempo_llegada_min-$subrango_tiempo_llegada_max -n 1)
	done
	for (( i=1; i<=$procesitos; i++ )); do
		tiempo[$i]=$(shuf -i $subrango_tiempo_ejecucion_min-$subrango_tiempo_ejecucion_max -n 1)
		until [ ${tiempo[$i]} -ge 0 ]; do
			tiempo[$i]=$(shuf -i $subrango_tiempo_ejecucion_min-$subrango_tiempo_ejecucion_max -n 1)
		done
	done
	while [[ $masprocesos == "s" ]]; do # mientras que contador sea menor que cantidad de procesos
		if [[ $p -gt 9 ]]; then
			proceso[$p]=$(echo P$(($p)))
		else
			proceso[$p]=$(echo P0$(($p)))
		fi
		#Bloque para introducción del resto de datos del proceso
		memoria[$p]=$(shuf -i $subrango_memoria_proceso_min-$subrango_memoria_proceso_max -n 1)
		#Se selecciona la partición de mayor tamaño
		memMax=0
		for (( mm=1; mm<=${#particiones[@]}; mm++ )); do
			if [[ ${particiones[$mm]} -gt $memMax ]]; then
				memMax=${particiones[$mm]}
				aux=$mm
			fi
		done

		while [[ ${memoria[$p]} -le 0 || ${memoria[$p]} -gt ${particiones[$aux]} ]]; do
			memoria[$p]=$(shuf -i 1-${particiones[$aux]} -n 1) #Se cambian los límites para que se ajusten al mayor tamaño de las particiones.
		done
		calcDatoAleatorioGeneral $subrango_prioProc_procesos_min $subrango_prioProc_procesos_max
		prioProc[$p]=$datoAleatorioGeneral #*Inicial - Datos a representar

		cantidad_rango_procesos=$(($cantidad_rango_procesos - 1))
		if [[ $cantidad_rango_procesos -gt 0 ]]; then
			masprocesos='s'
		else
			masprocesos='n'
		fi
		p=$(expr $p + 1) #incremento el contador
	done

	contadorParticiones=1
	for (( i=0; i<$cantidad_particiones; i++ )); do
		particiones_datos+=" ${particiones[$contadorParticiones]}"
		let contadorParticiones=$contadorParticiones+1
	done
	mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve
	echo -e "$ROJO\nPulsa ENTER para continuar $NORMAL"
	read -r enterContinuar

	if [[ $cambionumerss = true ]]; then
		echo $AMARILLO" Se han cambiado todos los valores que no eran posibles para la correcta ejecución"$NORMAL | tee -a $informeConColorTotal
		echo " Se han cambiado todos los valores que no eran posibles para la correcta ejecución" >> $informeSinColorTotal
	fi

	contadorParticiones=1
	for (( i=0; i<$cantidad_particiones; i++ )); do
		echo -ne "Particion $contadorParticiones ${particiones[$contadorParticiones]} \n" >> $nomFicheroDatos
		let contadorParticiones=$contadorParticiones+1
	done
	echo -e "RangoPrioridad $subrango_prioProc_procesos_minInicial $subrango_prioProc_procesos_maxInicial " >> $nomFicheroDatos
	PrioR="Mayor" #Valor por defecto hasta la que sea definido por el usuario.
	echo -e "TipoPrioridad $PrioR " >> $nomFicheroDatos
	quantum=$(shuf -i $rango_min_quantum_procesos-$rango_max_quantum_procesos -n 1)
	echo -e "Quantum $quantum " >> $nomFicheroDatos
	for (( i=1; i<=$procesitos; i++ )); do
		echo -ne "Llegada ${llegada[$i]} " >> $nomFicheroDatos
		echo -ne "Ejecucion ${tiempo[$i]} " >> $nomFicheroDatos
		echo -ne "Memoria ${memoria[$i]} " >> $nomFicheroDatos
		echo -e "Prioridad ${prioProc[$i]} " >> $nomFicheroDatos
	done
	ordenarDatosEntradaFicheros_cuatro_cinco_seis_siete_ocho_nueve
	#Se guardan los subrangos calculados sin corregir
	echo -e "Part_minima $subrango_cantidad_particiones_min \nPart_maxima $subrango_cantidad_particiones_max  \num_minima $subrango_longitud_particiones_min \num_maxima $subrango_longitud_particiones_max " > $nomFicheroRangos
	echo -e "Proc_minima $subrango_cantidad_procesos_min \nProc_maxima $subrango_cantidad_procesos_max \nquantum_minima $rango_min_quantum_procesos \nquantum_maxima $rango_max_quantum_procesos " >> $nomFicheroRangos
	echo -e "tll_minima $subrango_tiempo_llegada_min \ntll_maxima $subrango_tiempo_llegada_max \neje_minima $subrango_tiempo_ejecucion_min \neje_maxima $subrango_tiempo_ejecucion_max \nmem_minima $subrango_memoria_proceso_min \nmem_maxima $subrango_memoria_proceso_max " >> $nomFicheroRangos
	echo -e "RangoPrioMenor_minima $prio_menor_min_ORI \nRangoPrioMenor_maxima $prio_menor_max_ORI \nRangoPrioMayor_minima $prio_mayor_min_ORI \nRangoPrioMayor_maxima $prio_mayor_max_ORI " >> $nomFicheroRangos
	echo -e "prioProc_minima $subrango_prioProc_procesos_minInicial \nprioProc_maxima $subrango_prioProc_procesos_maxInicial " >> $nomFicheroRangos
	#Se guardan los valores originales y no los corregidos
	echo -e "Part_minima $rango_min_cantidad_particiones_ORI \nPart_maxima $rango_max_cantidad_particiones_ORI  \num_minima $rango_min_longitud_particiones_ORI \num_maxima $rango_max_longitud_particiones_ORI " > $nomFicheroRangosAleT
	echo -e "Proc_minima $rango_min_cantidad_procesos_ORI \nProc_maxima $rango_max_cantidad_procesos_ORI \nquantum_minima $rango_min_quantum_procesos_ORI \nquantum_maxima $rango_max_quantum_procesos_ORI " >> $nomFicheroRangosAleT
	echo -e "tll_minima $rango_min_tiempo_llegada_ORI \ntll_maxima $rango_max_tiempo_llegada_ORI \neje_minima $rango_min_tiempo_ejecucion_ORI \neje_maxima $rango_max_tiempo_ejecucion_ORI \nmem_minima $rango_min_memoria_procesos_ORI \nmem_maxima $rango_max_memoria_procesos_ORI " >> $nomFicheroRangosAleT
	echo -e "RangoPrioMenor_minima $prio_menor_min_ORI \nRangoPrioMenor_maxima $prio_menor_max_ORI \nRangoPrioMayor_minima $prio_mayor_min_ORI \nRangoPrioMayor_maxima $prio_mayor_max_ORI " >> $nomFicheroRangosAleT
	echo -e "prioProc_minima $subrango_prioProc_procesos_minInicial \nprioProc_maxima $subrango_prioProc_procesos_maxInicial " >> $nomFicheroRangosAleT

	cp $nomFicheroRangosAleT $ficheroRangosAleTotalAnteriorEjecucion
	cp $nomFicheroRangos $ficheroRangosAnteriorEjecucion
	cp $nomFicheroDatos $ficheroDatosAnteriorEjecucion
#    clear
} #Fin de entradaMemoriaRangosFichero_op_siete_ocho_nueve()

####################################################################################
# Sinopsis: Muestra una pantalla con la evolución de los rangos amplios (Ejemplo del uso de echo en sustitución de printf). COLOR.
# Esta función junto con la siguiente presentan por pantalla y a fichero los volcados de la tabla de rangos mediante echo.
# Da el mismo resultado que la siguiente función, hecha con fprint. De hecho, se ejecutan ambas y se presentan los resultados.
# Sirven de ejemplo para comparar el código con echo y con fprint.
####################################################################################
function mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve {
	echo -e "\n\n ┌────────────────────┬─────────────┬─────────────┬─────────────┐" | tee -a $informeConColorTotal
	echo -e " │                    │    AleT     │    Rangos   │    Datos    │" | tee -a $informeConColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" | tee -a $informeConColorTotal
	longitud_op_789_1_1=$(($longCampoTablaRangosCortos-${#rango_min_cantidad_particiones}))
	longitud_op_789_1_2=$(($longCampoTablaRangosCortos-${#rango_max_cantidad_particiones}))
	longitud_op_789_1_3=$(($longCampoTablaRangosCortos-${#subrango_cantidad_particiones_min}))
	longitud_op_789_1_4=$(($longCampoTablaRangosCortos-${#subrango_cantidad_particiones_max}))
	longitud_op_789_1_5=$(($longCampoTablaRangosLargos-${#cantidad_particiones}-4))
	echo -e " │NºParticiones       │" "${varhuecos:1:$longitud_op_789_1_1}" "$rango_min_cantidad_particiones" "|" "$rango_max_cantidad_particiones" "${varhuecos:1:$longitud_op_789_1_2}" "│" "${varhuecos:1:$longitud_op_789_1_3}" "$subrango_cantidad_particiones_min" "|" "$subrango_cantidad_particiones_max" "${varhuecos:1:$longitud_op_789_1_4}" "│" "${varhuecos:1:$longitud_op_789_1_5}" "$cantidad_particiones" "     │" | tee -a $informeConColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" | tee -a $informeConColorTotal

	longitud_op_789_2_1=$(($longCampoTablaRangosCortos-${#rango_min_longitud_particiones}))
	longitud_op_789_2_2=$(($longCampoTablaRangosCortos-${#rango_max_longitud_particiones}))
	longitud_op_789_2_3=$(($longCampoTablaRangosCortos-${#subrango_longitud_particiones_min}))
	longitud_op_789_2_4=$(($longCampoTablaRangosCortos-${#subrango_longitud_particiones_max}))
	longitud_op_789_2_5=$(($longCampoTablaRangosLargos-5))
	echo -e " │Tamaño Particiones  │" "${varhuecos:1:$longitud_op_789_2_1}" "$rango_min_longitud_particiones" "|" "$rango_max_longitud_particiones" "${varhuecos:1:$longitud_op_789_2_2}" "│" "${varhuecos:1:$longitud_op_789_2_3}" "$subrango_longitud_particiones_min" "|" "$subrango_longitud_particiones_max" "${varhuecos:1:$longitud_op_789_2_4}" "│" "${varhuecos:1:$longitud_op_789_2_5}" "-      │" | tee -a $informeConColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" | tee -a $informeConColorTotal

	longitud_op_789_3_1=$(($longCampoTablaRangosCortos-${#rango_min_cantidad_procesos}))
	longitud_op_789_3_2=$(($longCampoTablaRangosCortos-${#rango_max_cantidad_procesos}))
	longitud_op_789_3_3=$(($longCampoTablaRangosCortos-${#subrango_cantidad_procesos_min}))
	longitud_op_789_3_4=$(($longCampoTablaRangosCortos-${#subrango_cantidad_procesos_max}))
	longitud_op_789_3_5=$(($longCampoTablaRangosLargos-${#procesitos}-4))
	echo -e " │Número de procesos  │" "${varhuecos:1:$longitud_op_789_3_1}" "$rango_min_cantidad_procesos" "|" "$rango_max_cantidad_procesos" "${varhuecos:1:$longitud_op_789_3_2}" "|" "${varhuecos:1:$longitud_op_789_3_3}" "$subrango_cantidad_procesos_min" "|" "$subrango_cantidad_procesos_max" "${varhuecos:1:$longitud_op_789_3_4}" "|" "${varhuecos:1:$longitud_op_789_3_5}" "$procesitos" "     |" | tee -a $informeConColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" | tee -a $informeConColorTotal

	longitud_op_789_4_1=$(($longCampoTablaRangosCortos-${#rango_min_quantum_procesos}))
	longitud_op_789_4_2=$(($longCampoTablaRangosCortos-${#rango_max_quantum_procesos}))
	longitud_op_789_4_3=$(($longCampoTablaRangosCortos-${#subrango_quantum_procesos_min}))
	longitud_op_789_4_4=$(($longCampoTablaRangosCortos-${#subrango_quantum_procesos_max}))
	longitud_op_789_4_5=$(($longCampoTablaRangosLargos-${#quantum}-4))
	echo -e " │Quantum             │" "${varhuecos:1:$longitud_op_789_4_1}" "$rango_min_quantum_procesos" "|" "$rango_max_quantum_procesos" "${varhuecos:1:$longitud_op_789_4_2}" "|" "${varhuecos:1:$longitud_op_789_4_3}" "$subrango_quantum_procesos_min" "|" "$subrango_quantum_procesos_max" "${varhuecos:1:$longitud_op_789_4_4}" "|" "${varhuecos:1:$longitud_op_789_4_5}" "$quantum" "     |" | tee -a $informeConColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" | tee -a $informeConColorTotal

	longitud_op_789_5_1=$(($longCampoTablaRangosCortos-${#rango_min_tiempo_llegada}))
	longitud_op_789_5_2=$(($longCampoTablaRangosCortos-${#rango_max_tiempo_llegada}))
	longitud_op_789_5_3=$(($longCampoTablaRangosCortos-${#subrango_tiempo_llegada_min}))
	longitud_op_789_5_4=$(($longCampoTablaRangosCortos-${#subrango_tiempo_llegada_max}))
	longitud_op_789_5_5=$(($longCampoTablaRangosLargos-5))
	echo -e " │Tiempos de llegada  │" "${varhuecos:1:$longitud_op_789_5_1}" "$rango_min_tiempo_llegada" "|" "$rango_max_tiempo_llegada" "${varhuecos:1:$longitud_op_789_5_2}" "│" "${varhuecos:1:$longitud_op_789_5_3}" "$subrango_tiempo_llegada_min" "|" "$subrango_tiempo_llegada_max" "${varhuecos:1:$longitud_op_789_5_4}" "│" "${varhuecos:1:$longitud_op_789_5_5}" "-      │" | tee -a $informeConColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" | tee -a $informeConColorTotal

	longitud_op_789_6_1=$(($longCampoTablaRangosCortos-${#rango_min_tiempo_ejecucion}))
	longitud_op_789_6_2=$(($longCampoTablaRangosCortos-${#rango_max_tiempo_ejecucion}))
	longitud_op_789_6_3=$(($longCampoTablaRangosCortos-${#subrango_tiempo_ejecucion_min}))
	longitud_op_789_6_4=$(($longCampoTablaRangosCortos-${#subrango_tiempo_ejecucion_max}))
	longitud_op_789_6_5=$(($longCampoTablaRangosLargos-5))
	echo -e " │Tiempos de ejecución│" "${varhuecos:1:$longitud_op_789_6_1}" "$rango_min_tiempo_ejecucion" "|" "$rango_max_tiempo_ejecucion" "${varhuecos:1:$longitud_op_789_6_2}" "│" "${varhuecos:1:$longitud_op_789_6_3}" "$subrango_tiempo_ejecucion_min" "|" "$subrango_tiempo_ejecucion_max" "${varhuecos:1:$longitud_op_789_6_4}" "│" "${varhuecos:1:$longitud_op_789_6_5}" "-      │" | tee -a $informeConColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" | tee -a $informeConColorTotal

	longitud_op_789_7_1=$(($longCampoTablaRangosCortos-${#rango_min_memoria_procesos}))
	longitud_op_789_7_2=$(($longCampoTablaRangosCortos-${#rango_max_memoria_procesos}))
	longitud_op_789_7_3=$(($longCampoTablaRangosCortos-${#subrango_memoria_proceso_min}))
	longitud_op_789_7_4=$(($longCampoTablaRangosCortos-${#subrango_memoria_proceso_max}))
	longitud_op_789_7_5=$(($longCampoTablaRangosLargos-5))
	echo -e " │Unidades de memoria │" "${varhuecos:1:$longitud_op_789_7_1}" "$rango_min_memoria_procesos" "|" "$rango_max_memoria_procesos" "${varhuecos:1:$longitud_op_789_7_2}" "│" "${varhuecos:1:$longitud_op_789_7_3}" "$subrango_memoria_proceso_min" "|" "$subrango_memoria_proceso_max" "${varhuecos:1:$longitud_op_789_7_4}" "│" "${varhuecos:1:$longitud_op_789_7_5}" "-      │" | tee -a $informeConColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" | tee -a $informeConColorTotal

	longitud_op_789_8_1=$(($longCampoTablaRangosCortos-${#prio_menor_min}))
	longitud_op_789_8_2=$(($longCampoTablaRangosCortos-${#prio_menor_max}))
	longitud_op_789_8_3=$(($longCampoTablaRangosCortos-${#subrango_prioProc_procesos_min}))
	longitud_op_789_8_4=$(($longCampoTablaRangosCortos-${#subrango_prioProc_procesos_max}))
	longitud_op_789_8_5=$(($longCampoTablaRangosLargos-5))
	echo -e " │Mínimo Prioridades  │" "${varhuecos:1:$longitud_op_789_8_1}" "$prio_menor_min" "|" "$prio_menor_max" "${varhuecos:1:$longitud_op_789_8_2}" "│" "${varhuecos:1:$longitud_op_789_8_3}" "$subrango_prioProc_procesos_minInicial" "|" "$subrango_prioProc_procesos_maxInicial" "${varhuecos:1:$longitud_op_789_8_4}" "│" "${varhuecos:1:$longitud_op_789_8_5}" "-      │" | tee -a $informeConColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" | tee -a $informeConColorTotal

	longitud_op_789_8_1=$(($longCampoTablaRangosCortos-${#prio_mayor_min}))
	longitud_op_789_8_2=$(($longCampoTablaRangosCortos-${#prio_mayor_max}))
	longitud_op_789_8_3=$(($longCampoTablaRangosCortos-${#subrango_prioProc_procesos_min}))
	longitud_op_789_8_4=$(($longCampoTablaRangosCortos-${#subrango_prioProc_procesos_max}))
	longitud_op_789_8_5=$(($longCampoTablaRangosLargos-5))
	echo -e " │Máximo Prioridades  │" "${varhuecos:1:$longitud_op_789_8_1}" "$prio_mayor_min" "|" "$prio_mayor_max" "${varhuecos:1:$longitud_op_789_8_2}" "│" "${varhuecos:1:$longitud_op_789_8_3}" "$subrango_prioProc_procesos_minInicial" "|" "$subrango_prioProc_procesos_maxInicial" "${varhuecos:1:$longitud_op_789_8_4}" "│" "${varhuecos:1:$longitud_op_789_8_5}" "-      │" | tee -a $informeConColorTotal
	echo -e " └────────────────────┴─────────────┴─────────────┴─────────────┘\n" | tee -a $informeConColorTotal

	mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve_BN
} #Fin de mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve()

####################################################################################
# Sinopsis: Muestra una pantalla con la evolución de los rangos amplios (Ejemplo del uso de echo en sustitución de printf). BN.
####################################################################################
function mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve_BN {
	echo -e "\n ┌────────────────────┬─────────────┬─────────────┬─────────────┐" >> $informeSinColorTotal
	echo -e " │                    │    AleT     │   Rangos    │    Datos    │" >> $informeSinColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" >> $informeSinColorTotal
	echo -e " │NºParticiones       │" "${varhuecos:1:$longitud_op_789_1_1}" "$rango_min_cantidad_particiones" "|" "$rango_max_cantidad_particiones" "${varhuecos:1:$longitud_op_789_1_2}" "│" "${varhuecos:1:$longitud_op_789_1_3}" "$subrango_cantidad_particiones_min" "|" "$subrango_cantidad_particiones_max" "${varhuecos:1:$longitud_op_789_1_4}" "│" "${varhuecos:1:$longitud_op_789_1_5}" "$cantidad_particiones" "     │" >> $informeSinColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" >> $informeSinColorTotal
	echo -e " │Tamaño Particiones  │" "${varhuecos:1:$longitud_op_789_2_1}" "$rango_min_longitud_particiones" "|" "$rango_max_longitud_particiones" "${varhuecos:1:$longitud_op_789_2_2}" "│" "${varhuecos:1:$longitud_op_789_2_3}" "$subrango_longitud_particiones_min" "|" "$subrango_longitud_particiones_max" "${varhuecos:1:$longitud_op_789_2_4}" "│" "${varhuecos:1:$longitud_op_789_2_5}" "-      │" >> $informeSinColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" >> $informeSinColorTotal
	echo -e " │Número de procesos  │" "${varhuecos:1:$longitud_op_789_3_1}" "$rango_min_cantidad_procesos" "|" "$rango_max_cantidad_procesos" "${varhuecos:1:$longitud_op_789_3_2}" "|" "${varhuecos:1:$longitud_op_789_3_3}" "$subrango_cantidad_procesos_min" "|"  "$subrango_cantidad_procesos_max" "${varhuecos:1:$longitud_op_789_3_4}" "|" "${varhuecos:1:$longitud_op_789_3_5}" "$procesitos" "     |" >> $informeSinColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" >> $informeSinColorTotal
	echo -e " │Quantum             │" "${varhuecos:1:$longitud_op_789_4_1}" "$rango_min_quantum_procesos" "|" "$rango_max_quantum_procesos" "${varhuecos:1:$longitud_op_789_4_2}" "|" "${varhuecos:1:$longitud_op_789_4_3}" "$subrango_quantum_procesos_min" "|"  "$subrango_quantum_procesos_max" "${varhuecos:1:$longitud_op_789_4_4}" "|" "${varhuecos:1:$longitud_op_789_4_5}" "$quantum" "     |" >> $informeSinColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" >> $informeSinColorTotal
	echo -e " │Tiempos de llegada  │" "${varhuecos:1:$longitud_op_789_5_1}" "$rango_min_tiempo_llegada" "|" "$rango_max_tiempo_llegada" "${varhuecos:1:$longitud_op_789_5_2}" "│" "${varhuecos:1:$longitud_op_789_5_3}" "$subrango_tiempo_llegada_min" "|" "$subrango_tiempo_llegada_max" "${varhuecos:1:$longitud_op_789_5_4}" "│" "${varhuecos:1:$longitud_op_789_5_5}" "-      │" >> $informeSinColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" >> $informeSinColorTotal
	echo -e " │Tiempos de ejecución│" "${varhuecos:1:$longitud_op_789_6_1}" "$rango_min_tiempo_ejecucion" "|" "$rango_max_tiempo_ejecucion" "${varhuecos:1:$longitud_op_789_6_2}" "│" "${varhuecos:1:$longitud_op_789_6_3}" "$subrango_tiempo_ejecucion_min" "|" "$subrango_tiempo_ejecucion_max" "${varhuecos:1:$longitud_op_789_6_4}" "│" "${varhuecos:1:$longitud_op_789_6_5}" "-      │" >> $informeSinColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" >> $informeSinColorTotal
	echo -e " │Unidades de memoria │" "${varhuecos:1:$longitud_op_789_7_1}" "$rango_min_memoria_procesos" "|" "$rango_max_memoria_procesos" "${varhuecos:1:$longitud_op_789_7_2}" "│" "${varhuecos:1:$longitud_op_789_7_3}" "$subrango_memoria_proceso_min" "|" "$subrango_memoria_proceso_max" "${varhuecos:1:$longitud_op_789_7_4}" "│" "${varhuecos:1:$longitud_op_789_7_5}" "-      │" >> $informeSinColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" >> $informeSinColorTotal
	echo -e " │Mínimo Prioridades  │" "${varhuecos:1:$longitud_op_789_8_1}" "$prio_menor_min" "|" "$prio_menor_max" "${varhuecos:1:$longitud_op_789_8_2}" "│" "${varhuecos:1:$longitud_op_789_8_3}" "$subrango_prioProc_procesos_minInicial" "|" "$subrango_prioProc_procesos_maxInicial" "${varhuecos:1:$longitud_op_789_8_4}" "│" "${varhuecos:1:$longitud_op_789_8_5}" "-      │" >> $informeSinColorTotal
	echo -e " ├────────────────────┼─────────────┼─────────────┼─────────────┤" >> $informeSinColorTotal
	echo -e " │Máximo Prioridades  │" "${varhuecos:1:$longitud_op_789_8_1}" "$prio_mayor_min" "|" "$prio_mayor_max" "${varhuecos:1:$longitud_op_789_8_2}" "│" "${varhuecos:1:$longitud_op_789_8_3}" "$subrango_prioProc_procesos_minInicial" "|" "$subrango_prioProc_procesos_maxInicial" "${varhuecos:1:$longitud_op_789_8_4}" "│" "${varhuecos:1:$longitud_op_789_8_5}" "-      │" >> $informeSinColorTotal
	echo -e " └────────────────────┴─────────────┴─────────────┴─────────────┘\n" >> $informeSinColorTotal

} #Fin de mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve_BN()

####################################################################################
# Sinopsis: Muestra una por pantalla con la evolución de los rangos amplios (Ejemplo del uso de printf). NO USADA.
####################################################################################
function mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve_ORI {
	printf "\n" | tee -a $informeConColorTotal
	printf " ┌────────────────────┬─────────────┬─────────────┬────────────┐\n" | tee -a $informeConColorTotal
	printf " │                    │    AleT     │   Rangos    │   Datos    │\n" | tee -a $informeConColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" | tee -a $informeConColorTotal
	printf " │NºParticiones       │    %-*s │    %-*s  │    %-*s  │\n" 8 "$rango_min_cantidad_particiones | $rango_max_cantidad_particiones" 7 "$subrango_cantidad_particiones_min | $subrango_cantidad_particiones_max" 6 " $cantidad_particiones" | tee -a $informeConColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" | tee -a $informeConColorTotal
	printf " │Tamaño Particiones  │    %-*s │    %-*s  │   %-*s   │\n" 8 "$rango_min_longitud_particiones | $rango_max_longitud_particiones" 7 "$subrango_longitud_particiones_min | $subrango_longitud_particiones_max" 8 "  ─" | tee -a $informeConColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" | tee -a $informeConColorTotal
	printf " │Número de procesos  │    %-*s │    %-*s  │    %-*s  │\n" 8 "$rango_min_cantidad_procesos | $rango_max_cantidad_procesos" 7 "$subrango_cantidad_procesos_min | $subrango_cantidad_procesos_max" 6 " $procesitos" | tee -a $informeConColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" | tee -a $informeConColorTotal
	printf " │Quantum             │    %-*s │    %-*s  │    %-*s  │\n" 8 "$rango_min_quantum_procesos | $rango_max_quantum_procesos" 7 "$subrango_quantum_procesos_min | $subrango_quantum_procesos_max" 6 " $quantum" | tee -a $informeConColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" | tee -a $informeConColorTotal
	printf " │Tiempos de llegada  │    %-*s │    %-*s  │    %-*s  │\n" 8 "$rango_min_tiempo_llegada | $rango_max_tiempo_llegada" 7 "$subrango_tiempo_llegada_min | $subrango_tiempo_llegada_max" 8 " ─" | tee -a $informeConColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" | tee -a $informeConColorTotal
	printf " │Tiempos de ejecución│    %-*s │    %-*s  │    %-*s  │\n" 8 "$rango_min_tiempo_ejecucion | $rango_max_tiempo_ejecucion" 7 "$subrango_tiempo_ejecucion_min | $subrango_tiempo_ejecucion_max" 8 " ─" | tee -a $informeConColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" | tee -a $informeConColorTotal
	printf " │Unidades de memoria │    %-*s │    %-*s  │    %-*s  │\n" 8 "$rango_min_memoria_procesos | $rango_max_memoria_procesos" 7 "$subrango_memoria_proceso_min | $subrango_memoria_proceso_max" 8 " ─" | tee -a $informeConColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" | tee -a $informeConColorTotal
	printf " │Mínimo Prioridades  │    %-*s │    %-*s  │    %-*s  │\n" 8 "$prio_menor_min | $prio_menor_max" 7 "$subrango_prioProc_procesos_minInicial | $subrango_prioProc_procesos_maxInicial" 8 " ─" | tee -a $informeConColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" | tee -a $informeConColorTotal
	printf " │Máximo Prioridades  │    %-*s │    %-*s  │    %-*s  │\n" 8 "$prio_mayor_min | $prio_mayor_max" 7 "$subrango_prioProc_procesos_minInicial | $subrango_prioProc_procesos_maxInicial" 8 " ─" | tee -a $informeConColorTotal
	printf " └────────────────────┴─────────────┴─────────────┴────────────┘\n" | tee -a $informeConColorTotal
	printf "\n" | tee -a $informeConColorTotal
#prio_menor_min=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "RangoPrioMenor_minima" | cut -f 2 -d " "))
#prio_menor_max=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "RangoPrioMenor_maxima" | cut -f 2 -d " "))
#prio_mayor_min=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "RangoPrioMayor_minima" | cut -f 2 -d " "))
#prio_mayor_max=($(cat $ficheroEntrada_op_cinco_seis_ocho_nueve | grep "RangoPrioMayor_maxima" | cut -f 2 -d " "))

	printf "\n" >> $informeSinColorTotal
	printf " ┌────────────────────┬─────────────┬─────────────┬────────────┐\n" >> $informeSinColorTotal
	printf " │                    │    AleT     │   Rangos    │   Datos    │\n" >> $informeSinColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" >> $informeSinColorTotal
	printf " │NºParticiones       │    %-*s │    %-*s  │    %-*s  │\n" 8 "$rango_min_cantidad_particiones | $rango_max_cantidad_particiones" 7 "$subrango_cantidad_particiones_min | $subrango_cantidad_particiones_max" 6 " $cantidad_particiones" >> $informeSinColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" >> $informeSinColorTotal
	printf " │Tamaño Particiones  │    %-*s │    %-*s  │   %-*s   │\n" 8 "$rango_min_longitud_particiones | $rango_max_longitud_particiones" 7 "$subrango_longitud_particiones_min | $subrango_longitud_particiones_max" 8 "  ─" >> $informeSinColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" >> $informeSinColorTotal
	printf " │Número de procesos  │    %-*s │    %-*s  │    %-*s  │\n" 8 "$rango_min_cantidad_procesos | $rango_max_cantidad_procesos" 7 "$subrango_cantidad_procesos_min | $subrango_cantidad_procesos_max" 6 " $procesitos" >> $informeSinColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" >> $informeSinColorTotal
	printf " │Quantum             │    %-*s │    %-*s  │    %-*s  │\n" 8 "$rango_min_quantum_procesos | $rango_max_quantum_procesos" 7 "$subrango_quantum_procesos_min | $subrango_quantum_procesos_max" 6 " $quantum" >> $informeSinColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" >> $informeSinColorTotal
	printf " │Tiempos de llegada  │    %-*s │    %-*s  │    %-*s  │\n" 8 "$rango_min_tiempo_llegada | $rango_max_tiempo_llegada" 7 "$subrango_tiempo_llegada_min | $subrango_tiempo_llegada_max" 8 " ─" >> $informeSinColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" >> $informeSinColorTotal
	printf " │Tiempos de ejecución│    %-*s │    %-*s  │    %-*s  │\n" 8 "$rango_min_tiempo_ejecucion | $rango_max_tiempo_ejecucion" 7 "$subrango_tiempo_ejecucion_min | $subrango_tiempo_ejecucion_max" 8 " ─" >> $informeSinColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" >> $informeSinColorTotal
	printf " │Unidades de memoria │    %-*s │    %-*s  │    %-*s  │\n" 8 "$rango_min_memoria_procesos | $rango_max_memoria_procesos" 7 "$subrango_memoria_proceso_min | $subrango_memoria_proceso_max" 8 " ─" >> $informeSinColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" >> $informeSinColorTotal
	printf " │Mínimo Prioridades  │    %-*s │    %-*s  │    %-*s  │\n" 8 "$prio_menor_min | $prio_menor_max" 7 "$subrango_prioProc_procesos_minInicial | $subrango_prioProc_procesos_maxInicial" 8 " ─" >> $informeSinColorTotal
	printf " ├────────────────────┼─────────────┼─────────────┼────────────┤\n" >> $informeSinColorTotal
	printf " │Máximo Prioridades  │    %-*s │    %-*s  │    %-*s  │\n" 8 "$prio_mayor_min | $prio_mayor_max" 7 "$subrango_prioProc_procesos_minInicial | $subrango_prioProc_procesos_maxInicial" 8 " ─" >> $informeSinColorTotal
	printf " └────────────────────┴─────────────┴─────────────┴────────────┘\n" >> $informeSinColorTotal
	printf "\n" >> $informeSinColorTotal
} #Fin de mostrarPantallaEntradaProcesosRangoManual_op_siete_ocho_nueve_ORI()

####################################################################################
####################################################################################
######################                                                ##############
######################                  ALGORITMO FCFS                ##############
######################                                                ##############
####################################################################################
function algoritmoFCFS_AjustePrimerMejorPeor {
#    clear
	if [[ $reloj -eq 0 ]]; then
		evento2=1
	else
		evento2=0
	fi
	semaforo=0 #Valdrá 0 cuando, al haber terminado un proceso, haya otros procesos esperando en memoria o fuera del sistema. Y valdrá 1 mientras haya un proceso en ejecución y, por tanto la variable bandera() tendría algún valor a 1.
	nprocesos=${#llegada[@]} #Por compatibilidad con otros códigos.
	while [[ $salida != "s" ]]; do
		procesoNoEntraEnParticion=0 #Si vale 1 es porque hay un proceso que no entra en memoria. El resto, aún estando en espera, no lo intenta.

		#Control de Particiones y Estados de los Procesos
		procPorUnidadTiempo[$reloj]=$topeProcPorUnidadTiempo #Se inicializa al máximo antes calculado para declarar que no hay proceso en ejecución en ese instante de reloj
		for (( i=1; i<=${#llegada[@]}; i++ )); do
			if [[ ${sale[$i]} -ne 1 && ${procesoEnParticionOcupada[$i]} -ne 1 && $procesoNoEntraEnParticion -eq 0 ]]; then #Si el proceso no ha salido, no ocupa ninguna partición y proceso anterior ha entrado ya
				if [[ ${llegada[$i]} -le $reloj ]]; then
					procesoNoEntraEnParticion=1 #Se pone a 1 y se busca una partición. Si no la encuentra, no sigue buscando con el resto de procesos.
					for (( j=1; j<=${#particiones[@]}; j++ )); do
						if [[ ${memoria[$i]} -le ${particiones[$j]} && ${particionOcupada[$j]} -eq 0 ]]; then #Si el tamaño en memoria del proceso es menor que alguna partición y ésta no está ocupada, se mete el proceso en esa partición
							procesoNoEntraEnParticion=0 #Si encuentra una partición libre en la que quepa ese proceso, modifica las variables correspondientes y sigue con el siguiente proceso en espera, si lo hay.
							procesoEnParticionOcupada[$i]=1 #El proceso $i está en una partición ocupada
							partEnVectorDeProceso[$i]=$ct #Sólo se usa en pruebas. Ahora, para nada.
							procesoYaHaEntrado[$i]=1 #El proceso $i ha entrado en memoria
							entrada[$i]=$reloj
							if [[ ${estad[$i]} -ne 2 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
								poreventos=1
								avisoentrada[$i]=1
							fi
							estado[$i]="En memoria"
							estad[$i]=2
							let restante[$i]=${tiempo[$i]}

							#Primer/Mejor/Peor (Primer por defecto) #
							diff_mem=0
							if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 2 ]]; then #FCFS+Mejor - Se busca la partición más grande como límite, para buscar después la Mejor de las particiones, o la que corresponda. Así se evita tener que poner un número fijo.
								for (( part=${#particiones[@]}; part>=1; part-- )); do
									if [[ $diff_mem -lt ${particiones[$part]} ]]; then
										diff_mem=${particiones[$part]}
									fi
								done
							fi
							diff=$j
							for (( dm=1; dm<=${#particiones[@]}; dm++ )); do
								if [[ ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then #si la posicion esta vacia y el tamaño de la posicion es mayor o igual a la memoria actual
									auxMem=$(expr ${particiones[$dm]} - ${memoria[$i]}) # Resta entre el tamaño de la partición y el valor de la memoria correspondiente.
								fi
								#Esta parte es para que vaya con Mejor
								if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 2 ]]; then #FCFS+Mejor
									if [[ $auxMem -lt $diff_mem && ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then
										diff_mem=$auxMem #Diferencia entre tamaño de partición y tamaño de proceso más pequeña
										diff=$dm #Número de la partición más pequeña
									fi
								fi
								#Hasta aquí es para que vaya con Mejor
								#Esto es para que vaya con Peor
								if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 3 ]]; then #FCFS+Peor
									if [[ $auxMem -gt $diff_mem && ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then
										diff_mem=$auxMem #Diferencia entre tamaño de partición y tamaño de proceso más grande
										diff=$dm  #Número de la partición más grande
									fi
								fi
								#Hasta aquí es para que vaya con Peor
							done
							ocupadas[$diff]=$i # asigno a diff del array ocupadas el valor de i
							partConProceso[$i]=$diff # asigno el valor diff al indice i del array partConProceso
							particionOcupada[$diff]=1 #La partición $j está ocupada. Asigno el valor 1 al indice diff del array particionOcupada
							j=$(expr ${#particiones[@]} + 1) #Se asigna a j la longitud del array particiones +1
						fi
					done
				fi
			fi

			# 1)Se ajustan los estados
			if [[ ${tiempoEsperaProceso[$i]} -lt 0 && ${llegada[$i]} -ge $reloj && ${sale[$i]} -eq 0 ]]; then
				estado[$i]="Fuera del sistema"
				estad[$i]=0
			else
				if [[ ${procesoEnParticionOcupada[$i]} -ne 1 && ${llegada[$i]} -le $reloj && ${estad[$i]} -ne 5 && ${sale[$i]} -eq 0 ]]; then
					if [[ ${estad[$i]} -ne 1 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
						poreventos=1
						avisollegada[$i]=1
					fi
					estado[$i]="En espera"
					estad[$i]=1
				fi
			fi
			# 2)Se ajustan tiempos de retorno según el estado en el que nos encontramos
			if [[ ${estad[$i]} -ne 5 ]]; then
				let tiempoRetornoProceso[$i]=$reloj-${llegada[$i]}
				if [[ ${tiempoRetornoProceso[$i]} -lt 0 ]]; then
					tiempoRetornoProceso[$i]=0
				fi
			fi
			# 3)Si se está en ejecución/no ejecución: se ajusta el tiempo de Espera
			if [[ ${bandera[$i]} -eq 0 && ${sale[$i]} -eq 0 ]]; then
				if [[ ${estad[$i]} -ne 4 ]]; then
					let tiempoEsperaProceso[$i]=${tiempoRetornoProceso[$i]}
				else
					let tiempoEsperaProceso[$i]=${tiempoEsperaProceso[$i]}+1
				fi
			else
				if [[ ${bandera[$i]} -eq 1 && ${sale[$i]} -eq 0 && ${bloqueo[$i]} -eq 0 ]]; then
					let tiempoEsperaProceso[$i]=${tiempoRetornoProceso[$i]}-$reloj+${inicioEjecucion[$i]}

				fi
			fi
			# 4)Se ajusta el tiempo restante de ejecución decrementando para el estado "En ejecución"
			procPorUnidadTiempo[$reloj]=0 #Mete 0 mientras no haya número de orden del proceso que se mantiene en ejecución en la posición reloj.
			if [[ ${estad[$i]} -eq 3 && ${sale[$i]} -eq 0 ]]; then
				let restante[$i]=${restante[$i]}-1
				procPorUnidadTiempo[$reloj]=$i #Mete el número de orden del proceso que se mantiene en ejecución en la posición reloj de procPorUnidadTiempo.
			fi

			#En caso de que sea el primer proceso
			if [[ $i -eq 1 && ${sale[$i]} -eq 0 && ${bloqueo[$i]} -eq 0 ]]; then
				if [[ $reloj -lt ${llegada[$i]} ]]; then
					estado[$i]="Fuera del sistema"
					estad[$i]=0
					if [[ $reloj -eq 0 ]]; then
						evento2=1
					else
						evento2=0
					fi
				else
					if [[ ${estad[$i]} -ne 3 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
						poreventos=1
						avisoEntradaCPU[$i]=1 #Se activa el aviso de entrada en CPU del volcado
					fi
					estado[$i]="En ejecución"
					estad[$i]=3
					inicioEjecucion[$i]=$reloj
					bandera[$i]=1
					bloqueo[$i]=1
					procPorUnidadTiempo[$reloj]=$i #Mete el número de orden del proceso que entra en ejecución en la posición reloj de procPorUnidadTiempo.
					let restante[$i]=${tiempo[$i]}
				fi
			else #Si no es el primer proceso
				for (( ct=1; ct<=${#particiones[@]}; ct++ )); do
					if [[ ${particionOcupada[$ct]} -eq 0 && ${llegada[$i]} -le $reloj && ${memoria[$i]} -le ${particiones[$ct]} && ${procesoEnParticionOcupada[$i]} -eq 0 && ${sale[$i]} -eq 0 && $procesoNoEntraEnParticion -eq 0 ]]; then
						particionOcupada[$ct]=1 #La partición $j está ocupada
						procesoEnParticionOcupada[$i]=1 #El proceso $i está en una partición ocupada
						procesoYaHaEntrado[$i]=1 #El proceso $i ha entrado en memoria
						ocupadas[$ct]=$i
						entrada[$i]=$reloj
						partConProceso[$i]=$ct
						partEnVectorDeProceso[$i]=$ct #Sólo se usa en pruebas. Ahora, para nada.
						if [[ ${estad[$i]} -ne 2 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
							poreventos=1
							avisoentrada[$i]=1
						fi
						estado[$i]="En memoria"
						estad[$i]=2
						let restante[$i]=${tiempo[$i]}+1
					fi
				done
			fi
			#Si el tiempo restante de un proceso es 0, finaliza
			if [[ ${restante[$i]} -le 0 && ${procesoEnParticionOcupada[$i]} -eq 1 && ${sale[$i]} -eq 0 ]]; then
				if [[ ${estad[$i]} -ne 5 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
					poreventos=1
					avisosalida[$i]=1
				fi
				estado[$i]="Finalizado"
				estad[$i]=5
				procesoEnParticionOcupada[$i]=0 #El proceso $i está en una partición ocupada
				particionOcupada[${partConProceso[$i]}]=0
				bandera[$i]=0
				ocupadas[${partConProceso[$i]}]=0
				partConProceso[$i]=0
				sale[$i]=1
				((procesosFinalizados++))
				semaforo=0
			fi
			#Se comprueba si hay algún Px en ejecución, y en caso contrario se lanza el siguiente.
			for (( counter=1; counter<=${#llegada[@]}; counter++ )); do
				if [[ ${bandera[$counter]} -eq 1 ]]; then #Con bandera[] a 1 se define que ese proceso está en ejecución (semaforo=1).
					semaforo=1
				fi
			done
			if [[ $semaforo -eq 0 ]]; then
				for (( h=1; h<=${#llegada[@]}; h++ )); do
					if [[ ${estad[$h]} -eq 2 || ${estad[$h]} -eq 4 ]]; then
						if [[ ${estad[$h]} -ne 3 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
							poreventos=1
							avisoEntradaCPU[$h]=1 #Se activa el aviso de entrada en CPU del volcado
						fi
						estado[$h]="En ejecución"
						estad[$h]=3
						inicioEjecucion[$h]=$reloj
						bandera[$h]=1
						h=$(expr ${#llegada[@]} + 1)
					fi
				done
			fi
			#Salida
			if [[ $procesosFinalizados -ge ${#memoria[@]} ]]; then
				salida=s
			fi
			#Recalculo de tiempos en función de la espera y la respuesta de un Px
			for (( k=1; k<=${#tiempoEsperaProceso[@]}; k++ )); do
				if [[ ${tiempoEsperaProceso[$k]} -lt 0 ]]; then
					tiempoNEsperaProceso[$k]=0
				else
					tiempoNEsperaProceso[$k]=${tiempoEsperaProceso[$k]}
				fi
			done
			for (( k=1; k<=${#tiempoRetornoProceso[@]}; k++ )); do
				if [[ ${tiempoRetornoProceso[$k]} -lt 0 ]]; then
					tiempoNRetornoProceso[$k]=0
				else
					tiempoNRetornoProceso[$k]=${tiempoRetornoProceso[$k]}
				fi
			done
		done

		# 6)Impresión por cada ciclo de iteraciones, sólo cuando haya algún cambio de estado.
		imprimirTablaResumenProcesosEnVolcados
		let reloj=$reloj+1
	done #Final del 'while' - Final de la Impresión por cada ciclo de iteraciones
} #Fin de algoritmoFCFS_AjustePrimerMejorPeor()

####################################################################################
####################################################################################
#################                 ALGORITMO SJF                 ####################
####################################################################################
function algoritmoSJF_AjustePrimerMejorPeor {
#    clear
	if [[ $reloj -eq 0 ]]; then
		evento2=1
	else
		evento2=0
	fi
	semaforo=0 # Valdrá 0 cuando, al haber terminado un proceso, haya otros procesos esperando en memoria o fuera del sistema. Y valdrá 1 mientras haya un proceso en ejecución y, por tanto la variable bandera() tendría algún valor a 1.
	nprocesos=${#llegada[@]} #Por compatibilidad con otros códigos.
	while [[ $salida != "s" ]]; do
		procesoNoEntraEnParticion=0 #Si vale 1 es porque hay un proceso que no entra en memoria. El resto, aún estando en espera, no lo intenta.

		#Control de Particiones y Estados de los Procesos
		procPorUnidadTiempo[$reloj]=$topeProcPorUnidadTiempo #Se inicializa al máximo antes calculado para declarar que no hay proceso en ejecución en ese instante de reloj
		for (( i=1; i<=${#llegada[@]}; i++ )); do
			#Primero, habrá que meter en memoria los procesos de la lista que hayan llegado por tiempo de llegada, por FIFO
			#Ahora se ajustan los parámetros puesto que T es exacto y se va a parametrizar el momento actual
			# 1)Se ajustan los estados
			if [[ ${tiempoEsperaProceso[$i]} -lt 0 && ${llegada[$i]} -ge $reloj && ${sale[$i]} -eq 0 ]]; then
				estado[$i]="Fuera del sistema"
				estad[$i]=0
			else
				if [[ ${procesoEnParticionOcupada[$i]} -ne 1 && ${llegada[$i]} -le $reloj && ${estad[$i]} -ne 5 && ${sale[$i]} -eq 0 ]]; then
					if [[ ${estad[$i]} -ne 1 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
						poreventos=1
						avisollegada[$i]=1
					fi
					estado[$i]="En espera"
					estad[$i]=1
				fi
			fi
			# 2)Se ajustan tiempos de retorno según el estado en el que nos encontramos
			if [[ ${estad[$i]} -ne 5 ]]; then
				let tiempoRetornoProceso[$i]=$reloj-${llegada[$i]}
				if [[ ${tiempoRetornoProceso[$i]} -lt 0 ]]; then
					tiempoRetornoProceso[$i]=0
				fi
			fi
			# 3)Si se está en ejecución/no ejecución: se ajusta el tiempo de Espera
			if [[ ${bandera[$i]} -eq 0 && ${sale[$i]} -eq 0 ]]; then
				if [[ ${estad[$i]} -ne 4 ]]; then
					let tiempoEsperaProceso[$i]=${tiempoRetornoProceso[$i]}
				else
					let tiempoEsperaProceso[$i]=${tiempoEsperaProceso[$i]}+1
				fi
			else
				if [[ ${bandera[$i]} -eq 1 && ${sale[$i]} -eq 0 && ${bloqueo[$i]} -eq 0 ]]; then
					let tiempoEsperaProceso[$i]=${tiempoRetornoProceso[$i]}-$reloj+${inicioEjecucion[$i]}

				fi
			fi
			# 4)Se ajusta el tiempo restante de ejecución decrementando para el estado "En ejecución"
			procPorUnidadTiempo[$reloj]=0 #Mete 0 mientras no haya número de orden del proceso que se mantiene en ejecución en la posición reloj.
			if [[ ${estad[$i]} -eq 3 && ${sale[$i]} -eq 0 ]]; then
				let restante[$i]=${restante[$i]}-1
				procPorUnidadTiempo[$reloj]=$i #Mete el número de orden del proceso que se mantiene en ejecución en la posición reloj de procPorUnidadTiempo.
			fi

			# Después, se determina si hay un proceso que va a terminar en este instante de tiempo en caso de que se esté ejecutando. Por tanto, si el tiempo restante de un proceso es 0, finaliza
			if [[ ${restante[$i]} -eq 0 && ${procesoEnParticionOcupada[$i]} -eq 1 && ${sale[$i]} -eq 0 ]]; then
				if [[ ${estad[$i]} -ne 5 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
					poreventos=1
					avisosalida[$i]=1
				fi
				estado[$i]="Finalizado"
				estad[$i]=5
				procesoEnParticionOcupada[$i]=0 #El proceso $i ya no está en una partición ocupada
				particionOcupada[${partConProceso[$i]}]=0
				bandera[$i]=0 #Con 0 se define que ese proceso ya no está en ejecución.
				ocupadas[${partConProceso[$i]}]=0
				partConProceso[$i]=0
				sale[$i]=1
				((procesosFinalizados++)) #Contiene el número de procesos terminados
				semaforo=0
			fi

			#Ahora se meten los procesos en memoria, si ha lugar.
			if [[ ${sale[$i]} -ne 1 && ${procesoEnParticionOcupada[$i]} -ne 1 && ${procesoYaHaEntrado[$i]} -ne 1 && $procesoNoEntraEnParticion -eq 0 ]]; then #Si el proceso no ha salido, no ocupa ninguna partición y proceso anterior ha entrado ya
				if [[ ${llegada[$i]} -le $reloj ]]; then
					procesoNoEntraEnParticion=1 #Se pone a 1 y se busca una partición. Si no la encuentra, no sigue buscando con el resto de procesos.
					for (( j=1; j<=${#particiones[@]}; j++ )); do
						if [[ ${memoria[$i]} -le ${particiones[$j]} && ${particionOcupada[$j]} -eq 0 ]]; then #Si el tamaño en memoria del proceso es menor que alguna partición y ésta no está ocupada, se mete el proceso en esa partición
							procesoNoEntraEnParticion=0 #Si encuentra una partición libre en la que quepa ese proceso, modifica las variables correspondientes y sigue con el siguiente proceso en espera, si lo hay.
							procesoEnParticionOcupada[$i]=1 # El proceso $i está en una partición ocupada
							procesoYaHaEntrado[$i]=1 # El proceso $i ha entrado en memoria
							entrada[$i]=$reloj
							if [[ ${estad[$i]} -ne 2 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
								poreventos=1
								avisoentrada[$i]=1
							fi
							estado[$i]="En memoria"
							estad[$i]=2
							let restante[$i]=${tiempo[$i]}

						   #Primer/Mejor/Peor (Primer por defecto) #
							diff_mem=0
							if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 2 ]]; then #SJF+Mejor - Se busca la partición más grande como límite, para buscar después la Mejor de las particiones, o la que corresponda. Así se evita tener que poner un número fijo.
								for (( part=${#particiones[@]}; part>=1; part-- )); do
									if [[ $diff_mem -lt ${particiones[$part]} ]]; then
										diff_mem=${particiones[$part]}
									fi
								done
							fi
							diff=$j
							for (( dm=1; dm<=${#particiones[@]}; dm++ )); do
								if [[ ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then #Si la posición esta vacia y el tamaño de la posición es mayor o igual a la memoria actual
									auxMem=$(expr ${particiones[$dm]} - ${memoria[$i]}) #Resta entre el tamaño de la partición y el valor de la memoria correspondiente.
								fi
								#Esto es para que vaya con Mejor
								if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 2 ]]; then #SJF+Mejor
									if [[ $auxMem -lt $diff_mem && ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then
										diff_mem=$auxMem #Diferencia entre tamaño de partición y tamaño de proceso más pequeña
										diff=$dm #Número de la partición más pequeña
									fi
								fi
								#Hasta aquí es para que vaya con Mejor
								#Esto es para que vaya con Peor
								if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 3 ]]; then #SJF+Peor
									if [[ $auxMem -gt $diff_mem && ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then
										diff_mem=$auxMem #Diferencia entre tamaño de partición y tamaño de proceso más grande
										diff=$dm  #Número de la partición más grande
									fi
								fi
								#Hasta aquí es para que vaya con Peor
							done
							ocupadas[$diff]=$i # asigno a diff del array ocupadas el valor de i
							partConProceso[$i]=$diff # asigno el valor diff al indice i del array partConProceso
							particionOcupada[$diff]=1 #La partición $j está ocupada. Asigno el valor 1 al indice diff del array particionOcupada
							j=$(expr ${#particiones[@]} + 1) # asigno a j la longitud del array particiones +1
						fi
					done
				fi
			fi
		done
			#Y una vez en memoria, se establece cuál es el proceso que seguirá ejecutándose o comenzará a hacerlo. Para ello, se comprueba si hay algún Px en ejecución, y en caso contrario se lanza uno.
		for (( i=1; i<=${#llegada[@]}; i++ )); do
			for (( counter=1; counter<=${#llegada[@]}; counter++ )); do
				if [[ ${bandera[$counter]} -eq 1 ]]; then #Con bandera[] a 1 se define que ese proceso está en ejecución (semaforo=1).
					semaforo=1
				fi
			done
			#Se calcula el menor tiempo de ejecución de los procesos en memoria
			tiempo_menor=-1
			x=1
			e=1
			for (( x=1; x<=${#llegada[@]}; x++ )); do
				if [[ ${estad[$x]} -eq 2 && ${sale[$x]} -eq 0 ]]; then
					if [[ $tiempo_menor -eq -1 ]]; then
						let "tiempo_menor=${tiempo[$x]} + 1"
					fi
					if [[ ${tiempo[$x]} -lt $tiempo_menor ]]; then
						let "tiempo_menor=${tiempo[$x]}"
						let "e = $x"
					fi
				fi
			done
			if [[ $semaforo -eq 0 && ${estad[$i]} -eq 2 && $e == $i ]]; then
				poreventos=1
				avisoEntradaCPU[$i]=1 #Se activa el aviso de entrada en CPU del volcado
				estado[$e]="En ejecución"
				estad[$e]=3
				inicioEjecucion[$e]=$reloj
				bandera[$e]=1
				procPorUnidadTiempo[$reloj]=$i #Mete el número de orden del proceso que entra en ejecución en la posición reloj de procPorUnidadTiempo.
			fi
			#Salida
			if [[ $procesosFinalizados -ge ${#memoria[@]} ]]; then
				salida=s
			fi
			#Recalculo de tiempos en función de la espera y la respuesta de un Px
			for (( k=1; k<=${#tiempoEsperaProceso[@]}; k++ )); do
				if [[ ${tiempoEsperaProceso[$k]} -lt 0 ]]; then
					tiempoNEsperaProceso[$k]=0
				else
					tiempoNEsperaProceso[$k]=${tiempoEsperaProceso[$k]}
				fi
			done
			for (( k=1; k<=${#tiempoRetornoProceso[@]}; k++ )); do
				if [[ ${tiempoRetornoProceso[$k]} -lt 0 ]]; then
					tiempoNRetornoProceso[$k]=0
				else
					tiempoNRetornoProceso[$k]=${tiempoRetornoProceso[$k]}
				fi
			done
		done

		# 6)Impresión por cada ciclo de iteraciones, sólo cuando haya algún cambio de estado.
		imprimirTablaResumenProcesosEnVolcados
		let reloj=$reloj+1
	done #Final del 'while' - Final de la Impresión por cada ciclo de iteraciones
} #Fin de algoritmoSJF_AjustePrimerMejorPeor()

####################################################################################
####################################################################################
##################                                                     #############
##################                  ALGORITMO SRPT                     #############
##################                                                     #############
####################################################################################
function algoritmoSRPT_AjustePrimerMejorPeor {
#    clear
	if [[ $reloj -eq 0 ]]; then
		evento2=1
	else
		evento2=0
	fi
	semaforo=0 # Valdrá 0 cuando, al haber terminado un proceso, haya otros procesos esperando en memoria o fuera del sistema. Y valdrá 1 mientras haya un proceso en ejecución y, por tanto la variable bandera() tendría algún valor a 1.
	nprocesos=${#llegada[@]} #Por compatibilidad con otros códigos.
	while [[ $salida != "s" ]]; do
		procesoNoEntraEnParticion=0 #Si vale 1 es porque hay un proceso que no entra en memoria. El resto, aún estando en espera, no lo intenta.

		#Control de Particiones y Estados de los Procesos
		procPorUnidadTiempo[$reloj]=$topeProcPorUnidadTiempo #Se inicializa al máximo antes calculado para declarar que no hay proceso en ejecución en ese instante de reloj
		for (( i=1; i<=${#llegada[@]}; i++ )); do
			#Primero, habrá que meter en memoria los procesos de la lista que hayan llegado por tiempo de llegada, por FIFO
			#Ahora se ajustan los parámetros puesto que T es exacto y se va a parametrizar el momento actual
			# 1)Se ajustan los estados
			if [[ ${tiempoEsperaProceso[$i]} -lt 0 && ${llegada[$i]} -ge $reloj && ${sale[$i]} -eq 0 ]]; then
				estado[$i]="Fuera del sistema"
				estad[$i]=0
			else
				if [[ ${procesoEnParticionOcupada[$i]} -ne 1 && ${llegada[$i]} -le $reloj && ${estad[$i]} -ne 5 && ${sale[$i]} -eq 0 ]]; then
					if [[ ${estad[$i]} -ne 1 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
						poreventos=1
						avisollegada[$i]=1
					fi
					estado[$i]="En espera"
					estad[$i]=1
				fi
			fi
			# 2)Se ajustan tiempos de retorno según el estado en el que nos encontramos
			if [[ ${estad[$i]} -ne 5 ]]; then
				let tiempoRetornoProceso[$i]=$reloj-${llegada[$i]}
				if [[ ${tiempoRetornoProceso[$i]} -lt 0 ]]; then
					tiempoRetornoProceso[$i]=0
				fi
			fi
			# 3)Se ajustan el tiempo restante de ejecución decrementando para el estado "En ejecución"
			if [[ ${estad[$i]} -eq 3 && ${sale[$i]} -eq 0 ]]; then
				let restante[$i]=${restante[$i]}-1
				procPorUnidadTiempo[$reloj]=$i #Mete el número de orden del proceso que se mantiene en ejecución en la posición reloj de procPorUnidadTiempo.
			fi
			# 4)Si se está en ejecución/no ejecución: se ajusta el tiempo de Espera
			if [[ ${bandera[$i]} -eq 0 && ${sale[$i]} -eq 0 ]]; then
				if [[ ${estad[$i]} -ne 4 ]]; then
					let tiempoEsperaProceso[$i]=${tiempoRetornoProceso[$i]}
				else
					let tiempoEsperaProceso[$i]=${tiempoEsperaProceso[$i]}+1
				fi
			else
				if [[ ${bandera[$i]} -eq 1 && ${sale[$i]} -eq 0 && ${bloqueo[$i]} -eq 0 ]]; then
					let resto=${tiempo[$i]}-${restante[$i]}
					let tiempoEsperaProceso[$i]=${tiempoRetornoProceso[$i]}-$resto
				fi
			fi

			#Después, se determina si hay un proceso que va a terminar en este instante de tiempo en caso de que se esté ejecutando. Por tanto, si el tiempo restante de un proceso es 0, finaliza
			if [[ ${restante[$i]} -le 0 && ${procesoEnParticionOcupada[$i]} -eq 1 && ${sale[$i]} -eq 0 ]]; then
				if [[ ${estad[$i]} -ne 5 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
					poreventos=1
					avisosalida[$i]=1
				fi
				estado[$i]="Finalizado"
				estad[$i]=5
				procesoEnParticionOcupada[$i]=0 #El proceso $i ya no está en una partición ocupada
				particionOcupada[${partConProceso[$i]}]=0
				bandera[$i]=0 #Con 0 se define que ese proceso ya no está en ejecución.
				ocupadas[${partConProceso[$i]}]=0
				partConProceso[$i]=0
				sale[$i]=1
				((procesosFinalizados++)) #Contiene el número de procesos terminados
				semaforo=0
			fi

			#Ahora se meten los procesos en memoria, si ha lugar.
			if [[ ${sale[$i]} -ne 1 && ${procesoEnParticionOcupada[$i]} -ne 1 && ${procesoYaHaEntrado[$i]} -ne 1 && $procesoNoEntraEnParticion -eq 0 ]]; then #Si el proceso no ha salido, no ocupa ninguna partición y proceso anterior ha entrado ya
				if [[ ${llegada[$i]} -le $reloj ]]; then
					procesoNoEntraEnParticion=1 #Se pone a 1 y se busca una partición. Si no la encuentra, no sigue buscando con el resto de procesos.
					for (( j=1; j<=${#particiones[@]}; j++ )); do
						if [[ ${memoria[$i]} -le ${particiones[$j]} && ${particionOcupada[$j]} -eq 0 ]]; then #Si el tamaño en memoria del proceso es menor que alguna partición y ésta no está ocupada, se mete el proceso en esa partición
							procesoNoEntraEnParticion=0 #Si encuentra una partición libre en la que quepa ese proceso, modifica las variables correspondientes y sigue con el siguiente proceso en espera, si lo hay.
							procesoEnParticionOcupada[$i]=1 #El proceso $i está en una partición ocupada
							procesoYaHaEntrado[$i]=1 #El proceso $i ha entrado en memoria
							entrada[$i]=$reloj
							if [[ ${estad[$i]} -ne 2 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
								poreventos=1
								avisoentrada[$i]=1
							fi
							estado[$i]="En memoria"
							estad[$i]=2
							let restante[$i]=${tiempo[$i]}

							#   Primer/Mejor/Peor (Primer por defecto) #
							diff_mem=0
							if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 2 ]]; then #SRPT+Mejor - Se busca la partición más grande como límite, para buscar después la Mejor de las particiones, o la que corresponda. Así se evita tener que poner un número fijo.
								for (( part=${#particiones[@]}; part>=1; part-- )); do
									if [[ "$diff_mem" -lt "${particiones[$part]}" ]]; then
										diff_mem=${particiones[$part]}
									fi
								done
							fi
							diff=$j
							for (( dm=1; dm<=${#particiones[@]}; dm++ )); do
								if [[ ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then #Si la posición esta vacia y el tamaño de la posición es mayor o igual a la memoria actual
									auxMem=$(expr ${particiones[$dm]} - ${memoria[$i]}) #Resta entre el tamaño de la partición y el valor de la memoria correspondiente.
								fi

								#Esto es para que vaya con Mejor
								if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 2 ]]; then #SRPT+Mejor
									if [[ $auxMem -lt $diff_mem && ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then
										diff_mem=$auxMem #Diferencia entre tamaño de partición y tamaño de proceso más pequeña
										diff=$dm #Número de la partición más pequeña
									fi
								fi
								#Hasta aquí es para que vaya con Mejor
								#Esto es para que vaya con Peor
								if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 3 ]]; then #SRPT+Peor
									if [[ $auxMem -gt $diff_mem && ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then
										diff_mem=$auxMem #Diferencia entre tamaño de partición y tamaño de proceso más grande
										diff=$dm  #Número de la partición más grande
									fi
								fi
								#Hasta aquí es para que vaya con Peor
							done
							ocupadas[$diff]=$i # asigno a diff del array ocupadas el valor de i
							partConProceso[$i]=$diff # asigno el valor diff al indice i del array partConProceso
							particionOcupada[$diff]=1 #La partición $j está ocupada. Asigno el valor 1 al indice diff del array particionOcupada
							j=$(expr ${#particiones[@]} + 1) # asigno a j la longitud del array particiones +1
						fi
					done
				fi
			fi
		done

		#Y una vez en memoria, se establece cuál es el proceso que seguirá ejecutándose o comenzará a hacerlo. Para ello, se comprueba si hay algún Px en ejecución, y en caso contrario se lanza uno.
		for (( i=1; i<=${#llegada[@]}; i++ )); do
			for ((counter = 1; counter <= ${#llegada[@]}; counter++)); do
				if [[ ${bandera[$counter]} -eq 1 ]]; then #Con bandera[] a 1 se define que ese proceso está en ejecución (semaforo=1).
					semaforo=1
				fi
			done
			#Se calcula el menor tiempo de ejecución de los procesos en memoria o en pausa
			tiempo_menor=-1
			x=1
			e=1
			for (( x=1; x<=${#llegada[@]}; x++ )); do
				if [[ (${estad[$x]} -eq 2 || ${estad[$x]} -eq 4) && ${sale[$x]} -eq 0 ]]; then #A diferencia de SJF y FCFS, se añade la condición de En Pausa
					if [[ $tiempo_menor -eq -1 ]]; then
						let "tiempo_menor=${tiempo[$x]} + 1"
					fi
					if [[ ${restante[$x]} -lt $tiempo_menor ]]; then
						let "tiempo_menor=${restante[$x]}"
						let "e = $x"
					fi
				fi
			done
			if [[ $semaforo -eq 0 && (${estad[$i]} -eq 2 || ${estad[$i]} -eq 4) && $e == $i ]]; then #A diferencia de SJF y FCFS, se añade la condición de En Pausa
				poreventos=1
				avisoEntradaCPU[$e]=1 #Se activa el aviso de entrada en CPU del volcado
				estado[$e]="En ejecución"
				estad[$e]=3
				inicioEjecucion[$e]=$reloj
				bandera[$e]=1
				procPorUnidadTiempo[$reloj]=$i #Mete el número de orden del proceso que entra en ejecución en la posición reloj de procPorUnidadTiempo.
			fi
			#Salida
			if [[ $procesosFinalizados -ge ${#memoria[@]} ]]; then
				salida=s
			fi
			#Recalculo de tiempos en función de la espera y la respuesta de un Px
			for (( k=1; k<=${#tiempoEsperaProceso[@]}; k++ )); do
				if [[ ${tiempoEsperaProceso[$k]} -lt 0 ]]; then
					tiempoNEsperaProceso[$k]=0
				else
					tiempoNEsperaProceso[$k]=${tiempoEsperaProceso[$k]}
				fi
			done
			for (( k=1; k<=${#tiempoRetornoProceso[@]}; k++ )); do
				if [[ ${tiempoRetornoProceso[$k]} -lt 0 ]]; then
					tiempoNRetornoProceso[$k]=0
				else
					tiempoNRetornoProceso[$k]=${tiempoRetornoProceso[$k]}
				fi
			done
		done

		####################################################################################
		#DIFERENTE - SRPT Expropiación ante un Px que tiene menor tiempo de ejecución que el que esta ejecutandose
		f=0
		for (( e=1; e<=${#llegada[@]}; e++ )); do #ESTO ES DIFERENTE A FSFS Y SJF
			if [[ ${estad[$e]} -eq 2 || ${estad[$e]} -eq 4 && $semaforo -eq 0 && ${sale[$e]} -eq 0 ]]; then
				tiempo_menor=-1
				x=0
				f=0
				for (( x=1; x<=${#llegada[@]}; x++ )); do
					if [[ (${estad[$x]} -eq 2 || ${estad[$x]} -eq 4) && ${sale[$x]} -eq 0 ]]; then
						if [[ $tiempo_menor -eq -1 ]]; then
							let "tiempo_menor=${tiempo[$x]} + 1"
						fi
						if [[ ${restante[$x]} -lt $tiempo_menor ]]; then
							let "tiempo_menor=${restante[$x]}"
							let "f = $x"
						fi
					fi
				done

				for (( m=1; m<=${#particiones[@]}; m++ )); do
					if [[ ${restante[${ocupadas[$m]}]} -gt ${restante[$f]} && ${estad[${ocupadas[$m]}]} -eq 3 ]]; then
						if [[ ${estad[$m]} -ne 4 ]]; then
							poreventos=1
							avisoPausa[$m]=1
						fi
						estado[${ocupadas[$m]}]="En pausa"
						estad[${ocupadas[$m]}]=4
						bandera[${ocupadas[$m]}]=0
						inicioEjecucion[$f]=$reloj

						if [[ ${estad[$f]} -ne 3 ]]; then
							poreventos=1
							avisoEntradaCPU[$f]=1 #Se activa el aviso de entrada en CPU del volcado
						fi
						estado[$f]="En ejecución"
						estad[$f]=3
						bandera[$f]=1
					fi
				done
			fi
		done
		# DIFERENTE
		####################################################################################
		# 6)Impresión por cada ciclo de iteraciones, sólo cuando haya algún cambio de estado.
		imprimirTablaResumenProcesosEnVolcados
		let reloj=$reloj+1
	done #Final del 'while' - Final de la Impresión por cada ciclo de iteraciones
} #Fin de algoritmoSRPT_AjustePrimerMejorPeor()

####################################################################################
####################################################################################
##################                                                     #############
##################         ALGORITMO Prioridades (Mayor/Menor)         #############
##################                                                     #############
####################################################################################
function algoritmoPrioridades_AjustePrimerMejorPeor {
	if [[ $reloj -eq 0 ]]; then #Se lanzan los volcados, por lo menos, cuando T=0.
		evento2=1
	else
		evento2=0
	fi
	semaforo=0 # Valdrá 0 cuando, al haber terminado un proceso, o antes de que se empiece a ejecutar el primer proceso, haya otros procesos esperando en memoria o fuera del sistema. Y valdrá 1 mientras haya un proceso en ejecución y, por tanto la variable bandera() tendría algún valor a 1.
	nprocesos=${#llegada[@]} #Por compatibilidad con otros códigos.
	while [[ $salida != "s" ]]; do
		procesoNoEntraEnParticion=0 #Si vale 1 es porque hay un proceso que no entra en memoria. El resto de procesos de la lista, aún estando en espera, no lo intenta.
		#Control de Particiones y Estados de los Procesos
		procPorUnidadTiempo[$reloj]=$topeProcPorUnidadTiempo #Se inicializa al máximo antes calculado para declarar que no hay proceso en ejecución en ese instante de reloj
		for (( i=1; i<=${#llegada[@]}; i++ )); do
			#Primero, habrá que meter en memoria los procesos de la lista que hayan llegado por tiempo de llegada, por FIFO
			#Ahora se ajustan los parámetros puesto que T es exacto y se va a parametrizar el momento actual
			# 1)Se ajustan los estados
			if [[ ${tiempoEsperaProceso[$i]} -lt 0 && ${llegada[$i]} -ge $reloj && ${sale[$i]} -eq 0 ]]; then
				estado[$i]="Fuera del sistema"
				estad[$i]=0
			else
				if [[ ${procesoEnParticionOcupada[$i]} -ne 1 && ${llegada[$i]} -le $reloj && ${estad[$i]} -ne 5 && ${sale[$i]} -eq 0 ]]; then
					if [[ ${estad[$i]} -ne 1 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
						poreventos=1
						avisollegada[$i]=1
					fi
					estado[$i]="En espera"
					estad[$i]=1
				fi
			fi
			# 2)Se ajustan tiempos de retorno según el estado en el que nos encontramos
			if [[ ${estad[$i]} -ne 5 && ${sale[$i]} -eq 0 ]]; then
				let tiempoRetornoProceso[$i]=$reloj-${llegada[$i]}
				if [[ ${tiempoRetornoProceso[$i]} -lt 0 ]]; then
					tiempoRetornoProceso[$i]=0
				fi
			fi
			# 3)Se ajustan el tiempo restante de ejecución decrementando para el estado "En ejecución"
			procPorUnidadTiempo[$reloj]=0 #Mete 0 mientras no haya número de orden del proceso que se mantiene en ejecución en la posición reloj.
			if [[ ${estad[$i]} -eq 3 && ${sale[$i]} -eq 0 ]]; then
				let restante[$i]=${restante[$i]}-1
				procPorUnidadTiempo[$reloj]=$i #Mete el número de orden del proceso que se mantiene en ejecución en la posición reloj de procPorUnidadTiempo.
			fi
			# 4)Si se están en ejecución/no ejecución: se ajusta el tiempo de Espera
			if [[ ${bandera[$i]} -eq 0 && ${sale[$i]} -eq 0 ]]; then
				if [[ ${estad[$i]} -ne 4 ]]; then
					let tiempoEsperaProceso[$i]=${tiempoRetornoProceso[$i]}
				else
					let tiempoEsperaProceso[$i]=${tiempoEsperaProceso[$i]}+1
				fi
			else
				if [[ ${bandera[$i]} -eq 1 && ${sale[$i]} -eq 0 && ${bloqueo[$i]} -eq 0 ]]; then
					let resto=${tiempo[$i]}-${restante[$i]}
					let tiempoEsperaProceso[$i]=${tiempoRetornoProceso[$i]}-$resto
				fi
			fi
			# 5)Después, se determina si hay un proceso que va a terminar en este instante de tiempo en caso de que se esté ejecutando. Por tanto, si el tiempo restante de un proceso es 0, finaliza
			if [[ ${restante[$i]} -le 0 && ${procesoEnParticionOcupada[$i]} -eq 1 && ${sale[$i]} -eq 0 && ${estad[$i]} -ne 5 ]]; then
				if [[ ${estad[$i]} -ne 5 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
					poreventos=1
					avisosalida[$i]=1
				fi
				estado[$i]="Finalizado"
				estad[$i]=5
				procesoEnParticionOcupada[$i]=0 #El proceso $i ya no está en una partición ocupada
				particionOcupada[${partConProceso[$i]}]=0
				bandera[$i]=0 #Con 0 se define que ese proceso ya no está en ejecución.
				ocupadas[${partConProceso[$i]}]=0
				partConProceso[$i]=0
				sale[$i]=1
				((procesosFinalizados++)) #Contiene el número de procesos terminados
				semaforo=0 #No hay ningún proceso en ejecución
			fi

			#Ahora se meten procesos en memoria, si ha lugar.
			if [[ ${sale[$i]} -ne 1 && ${procesoEnParticionOcupada[$i]} -ne 1 && ${procesoYaHaEntrado[$i]} -ne 1 && $procesoNoEntraEnParticion -eq 0 ]]; then #Si el proceso no ha salido, no ocupa ninguna partición y proceso anterior ha entrado ya
				if [[ ${llegada[$i]} -le $reloj ]]; then
					procesoNoEntraEnParticion=1 #Se pone a 1 y se busca una partición. Si no la encuentra, no sigue buscando con el resto de procesos.
					for (( j=1; j<=${#particiones[@]}; j++ )); do
						if [[ ${memoria[$i]} -le ${particiones[$j]} && ${particionOcupada[$j]} -eq 0 && ${estad[$i]} -ne 5 ]]; then #Si el tamaño en memoria del proceso es menor que alguna partición y ésta no está ocupada, se mete el proceso en esa partición
							procesoNoEntraEnParticion=0 #Si encuentra una partición libre en la que quepa ese proceso, modifica las variables correspondientes y sigue con el siguiente proceso en espera, si lo hay.
							procesoEnParticionOcupada[$i]=1 #El proceso $i está en una partición ocupada
							procesoYaHaEntrado[$i]=1 #El proceso $i ha entrado en memoria
							entrada[$i]=$reloj
							if [[ ${estad[$i]} -ne 2 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
								poreventos=1
								avisoentrada[$i]=1
							fi
							estado[$i]="En memoria"
							estad[$i]=2
							let restante[$i]=${tiempo[$i]}

						   #Primer/Mejor/Peor (Primer por defecto) #
							diff_mem=0
							if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 2 ]]; then #Prioridades+Mejor - Se busca la partición más grande como límite, para buscar después la Mejor de las particiones, o la que corresponda. Así se evita tener que poner un número fijo.
								for (( part=${#particiones[@]}; part>=1; part-- )); do
									if [[ $diff_mem -lt ${particiones[$part]} ]]; then
										diff_mem=${particiones[$part]}
									fi
								done
							fi
							diff=$j
							for (( dm=1; dm<=${#particiones[@]}; dm++ )); do
								if [[ ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then #Si la posición esta vacia y el tamaño de la posición es mayor o igual a la memoria actual
									auxMem=$(expr ${particiones[$dm]} - ${memoria[$i]}) #Resta entre el tamaño de la partición y el valor de la memoria correspondiente.
								fi

								#Esto es para que vaya con Mejor
								if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 2 ]]; then #Prioridades+Mejor
									if [[ $auxMem -lt $diff_mem && ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then
										diff_mem=$auxMem #Diferencia entre tamaño de partición y tamaño de proceso más pequeña
										diff=$dm #Número de la partición más pequeña
									fi
								fi
								#Hasta aquí es para que vaya con Mejor
								#Esto es para que vaya con Peor
								if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 3 ]]; then #Prioridades+Peor
									if [[ $auxMem -gt $diff_mem && ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then
										diff_mem=$auxMem #Diferencia entre tamaño de partición y tamaño de proceso más grande
										diff=$dm  #Número de la partición más grande
									fi
								fi
								#Hasta aquí es para que vaya con Peor
							done
							ocupadas[$diff]=$i # asigno a diff del array ocupadas el valor de i
							partConProceso[$i]=$diff # asigno el valor diff al indice i del array partConProceso
							particionOcupada[$diff]=1 #La partición $j está ocupada. Asigno el valor 1 al indice diff del array particionOcupada
							j=$(expr ${#particiones[@]} + 1) # asigno a j la longitud del array particiones +1
						fi
					done
				fi
			fi
		done

		####################################################################################
		# DIFERENTE - Algoritmo Prioridades - Se determina la mayor y menor prioridad de los procesos en memoria
		cerrojo_aux=0
		e1=-1
		e2=-1
		max_indice_aux=-1 #Proceso en memoria con la mayor prioridad.
		max_prio_aux=-1 #Mayor prioridad de los procesos en memoria.
		for (( i=1; i<=$nprocesos; i++ )); do #Se busca el primer dato no nulo y se sale del bucle.
			if [[ ${procesoEnParticionOcupada[$i]} -eq 1 && ${sale[$i]} -eq 0 ]]; then
				break
			fi
		done
		for (( i=1; i<=$nprocesos; i++ )); do  #Se busca la mayor prioridad de todas las que se encuentran en memoria.
			if [[ ${procesoEnParticionOcupada[$i]} -eq 1  && ${sale[$i]} -eq 0 ]]; then
				if [[ $cerrojo_aux -eq 0 ]]; then #Se inicializan las variables para determinar el mayor valor de la priridad de los procesos en memoria.
					max_indice_aux=$i #Se inicializa la variable con el primer proceso para la mayor prioridad.
					max_prio_aux=${prioProc[$i]} #Mayor prioridad de los procesos en memoria.
					cerrojo_aux=1
				e1=$i #Se busca el primer dato no nulo
				e2=$i
				fi
				if [[ ${prioProc[$i]} -gt $max_prio_aux && $cerrojo_aux -eq 1 ]]; then
					max_indice_aux=$i #Proceso en memoria con la mayor prioridad.
					max_prio_aux=${prioProc[$i]} #Mayor prioridad de los procesos en memoria.
					e1=$i
				fi
			fi
		done #Una vez encontrada la mayor prioridad, se van a comparar todos los procesos hasta encontrar el de prioridad más baja.
		min_indice_aux=$max_indice_aux #Proceso en memoria con la menor prioridad.
		min_prio_aux=$max_prio_aux #Contendrá la menor prioridad para su comparación con la de otros procesos. Se le pone un valor superior al máximo porque, inicialmente, se busca el primero de los que tengan el menor valor.
		for (( i=1; i<=$nprocesos; i++ )); do  #Se establece qué proceso tiene menor prioridad de todos los que se encuentran en memoria.
			if [[ ${procesoEnParticionOcupada[$i]} -eq 1  && ${sale[$i]} -eq 0  ]]; then
				if [[ ${prioProc[$i]} -lt $min_prio_aux ]]; then
					min_indice_aux=$i #Proceso de prioridad más baja hasta ahora
					min_prio_aux=${prioProc[$i]} #Prioridad menor hasta ahora
					e2=$i
				fi
			fi
		done
		# DIFERENTE
		####################################################################################
		# DIFERENTE - Algoritmo Prioridades - Se determina el sentido del rango para invertir la elección del tipo de prioridad en caso de que el rango sea inverso.
		if [[ $invertirDatoPrioridadesInversa -eq 1 ]]; then #Si es Prioridad Mayor y se invierte el rango, se calcula la Prioridad Menor, y viveversa.
			if [[ $seleccionTipoPrioridad -eq 1 ]]; then #Mayor
				seleccionTipoPrioridad_2=2
			elif [[ $seleccionTipoPrioridad -eq 2 ]]; then #Menor
				seleccionTipoPrioridad_2=1
			fi
		elif [[ $invertirDatoPrioridadesInversa -eq 0 ]]; then #Si el rango de Prioridades no se invierte, se deja sin modificar la elección Mayor/Menor.
			seleccionTipoPrioridad_2=$seleccionTipoPrioridad
		fi

		for (( i=1; i<=${#llegada[@]}; i++ )); do
			for (( counter=1; counter<=${#llegada[@]}; counter++ )); do
				if [[ ${bandera[$counter]} -eq 1 ]]; then #Con bandera[] a 1 se define que ese proceso está en en ejecución (semaforo=1).
					semaforo=1 #Valdrá 1 mientras haya un proceso en ejecución.
				fi
			done
			if [[ (${estad[$i]} -eq 2 || ${estad[$i]} -eq 4) && ($e1 == $i || $e2 == $i) ]]; then #A diferencia de SJF y FCFS, se añade la condición de En Pausa
			#APROPIATIVO
				if [[ $seleccionMenuApropiatividad -eq 2 ]]; then #APROPIATIVO
					#seleccionTipoPrioridad_2 - 1-Mayor - 2-Menor #seleccionMenuApropiatividad - 1-No apropiativo - 2-Apropiativo
					if [[ $seleccionTipoPrioridad_2 -eq 1 ]]; then #Prioridad Mayor/Apropiativo - Se roba la CPU por ser Apropiativo.
						if [[ $max_indice_aux -ne $anteriorProcesoEjecucion ]]; then #Una vez encontrado el proceso de mayor prioridad, se pone en ejecución. Y si había otro en ejecución y no ha terminado, se marca como "En pausa".
							poreventos=1
#							avisoEntradaCPU[$i]=1 #Se activa el aviso de entrada en CPU del volcado
							if [[ ${restante[$anteriorProcesoEjecucion]} -gt 0 && $anteriorProcesoEjecucion -ne -1 ]]; then
								estado[$anteriorProcesoEjecucion]="En pausa" #Marco el proceso para ejecutarse.
								estad[$anteriorProcesoEjecucion]=4 #Marco el proceso para ejecutarse.
								avisoPausa[$anteriorProcesoEjecucion]=1
							elif [[ ${restante[$anteriorProcesoEjecucion]} -le 0 && $anteriorProcesoEjecucion -ne -1 ]]; then
								estado[$anteriorProcesoEjecucion]="Finalizado" #Marco el proceso para ejecutarse.
								estad[$anteriorProcesoEjecucion]=5 #Marco el proceso para ejecutarse.
								avisosalida[$anteriorProcesoEjecucion]=1
							fi
							estado[$e1]="En ejecución" #Marco el proceso para ejecutarse.
							estad[$e1]=3
							inicioEjecucion[$e1]=$reloj
							bandera[$e1]=1 #Marco el proceso para ejecutarse.
							procPorUnidadTiempo[$reloj]=$i #Mete el número de orden del proceso que entra en ejecución en la posición reloj de procPorUnidadTiempo.
							anteriorProcesoEjecucion=$e1
							avisoEntradaCPU[$max_indice_aux]=1 #Se activa el aviso de entrada en CPU del volcado
						fi
					elif [[ $seleccionTipoPrioridad_2 -eq 2 ]]; then #Prioridad Menor/Apropiativo - Se roba la CPU por ser Apropiativo.
						if [[ $min_indice_aux -ne $anteriorProcesoEjecucion ]]; then #Una vez encontrado el proceso de menor prioridad, se pone en ejecución. Y si había otro en ejecución y no ha terminado, se marca como "En pausa".
							poreventos=1
#							avisoEntradaCPU[$i]=1 #Se activa el aviso de entrada en CPU del volcado
							if [[ ${restante[$anteriorProcesoEjecucion]} -gt 0 && $anteriorProcesoEjecucion -ne -1 ]]; then
								estado[$anteriorProcesoEjecucion]="En pausa" #Marco el proceso para ejecutarse.
								estad[$anteriorProcesoEjecucion]=4 #Marco el proceso para ejecutarse.
								avisoPausa[$anteriorProcesoEjecucion]=1
							elif [[ ${restante[$anteriorProcesoEjecucion]} -le 0 && $anteriorProcesoEjecucion -ne -1 ]]; then
								estado[$anteriorProcesoEjecucion]="Finalizado" #Marco el proceso para ejecutarse.
								estad[$anteriorProcesoEjecucion]=5 #Marco el proceso para ejecutarse.
								avisosalida[$anteriorProcesoEjecucion]=1
							fi
							estado[$e2]="En ejecución" #Marco el proceso para ejecutarse.
							estad[$e2]=3
							inicioEjecucion[$e2]=$reloj
							bandera[$e2]=1 #Marco el proceso para ejecutarse.
							procPorUnidadTiempo[$reloj]=$i #Mete el número de orden del proceso que entra en ejecución en la posición reloj de procPorUnidadTiempo.
							anteriorProcesoEjecucion=$e2
							avisoEntradaCPU[$min_indice_aux]=1 #Se activa el aviso de entrada en CPU del volcado
						fi
					fi
				fi
			#NO APROPIATIVO
			fi
			if [[ $semaforo -eq 0 && ${estad[$i]} -eq 2 && ($e1 == $i || $e2 == $i) ]]; then #A diferencia de SJF y FCFS, se añade la condición de En Pausa
				poreventos=1
				avisoEntradaCPU[$i]=1 #Se activa el aviso de entrada en CPU del volcado
				if [[ $seleccionMenuApropiatividad -eq 1 ]]; then #NO APROPIATIVO
					#seleccionTipoPrioridad_2 - 1-Mayor - 2-Menor #seleccionMenuApropiatividad - 1-No apropiativo - 2-Apropiativo
					if [[ $seleccionTipoPrioridad_2 -eq 1 ]]; then #1 Prioridad Mayor/No Apropiativo - No se roba la CPU por ser NO Apropiativo.
						if [[ "$max_indice_aux" -ne -1 ]]; then #Una vez encontrado el proceso más corto, se pone en ejecución. Y si había otro en ejecución y no ha terminado, se marca como "En pausa".
							estado[$e1]="En ejecución" #Marco el proceso para ejecutarse.
							estad[$e1]=3 #Marco el proceso para ejecutarse.
							inicioEjecucion[$e1]=$reloj
							bandera[$e1]=1 #Marco el proceso para ejecutarse.
							procPorUnidadTiempo[$reloj]=$i #Mete el número de orden del proceso que entra en ejecución en la posición reloj de procPorUnidadTiempo.
							anteriorProcesoEjecucion=$e1
						fi
					elif [[ $seleccionTipoPrioridad_2 -eq 2 ]]; then #2 Prioridad Menor/No Apropiativo - No se roba la CPU por ser NO Apropiativo.
						if [[ "$min_indice_aux" -ne -1 ]]; then #Una vez encontrado el proceso más corto, se pone en ejecución. Y si había otro en ejecución y no ha terminado, se marca como "En pausa".
							estado[$e2]="En ejecución"
							estad[$e2]=3
							inicioEjecucion[$e2]=$reloj
							bandera[$e2]=1
							procPorUnidadTiempo[$reloj]=$i #Mete el número de orden del proceso que entra en ejecución en la posición reloj de procPorUnidadTiempo.
							anteriorProcesoEjecucion=$e2
						fi
					fi
				fi
			fi
			#Salida
			if [[ $procesosFinalizados -ge ${#memoria[@]} ]]; then
				salida=s
			fi
			#Recalculo de tiempos en función de la espera y la respuesta de un Px
			for (( k=1; k<=${#tiempoEsperaProceso[@]}; k++ )); do
				if [[ ${tiempoEsperaProceso[$k]} -lt 0 ]]; then
					tiempoNEsperaProceso[$k]=0
				else
					tiempoNEsperaProceso[$k]=${tiempoEsperaProceso[$k]}
				fi
			done
			for (( k=1; k<=${#tiempoRetornoProceso[@]}; k++ )); do
				if [[ ${tiempoRetornoProceso[$k]} -lt 0 ]]; then
					tiempoNRetornoProceso[$k]=0
				else
					tiempoNRetornoProceso[$k]=${tiempoRetornoProceso[$k]}
				fi
			done
		done
		# DIFERENTE
		####################################################################################
		# 6)Impresión por cada ciclo de iteraciones, sólo cuando haya algún cambio de estado.
		imprimirTablaResumenProcesosEnVolcados
		let reloj=$reloj+1
	done
} #Fin de algoritmoPrioridades_AjustePrimerMejorPeor()

####################################################################################
####################################################################################
##################                                                     #############
##################             ALGORITMO Round-Robin (RR)              #############
##################                                                     #############
####################################################################################
function algoritmoRoundRobin_AjustePrimerMejorPeor {
	if [[ $reloj -eq 0 ]]; then #Se lanzan los volcados, por lo menos, cuando T=0.
		evento2=1
	else
		evento2=0
	fi
	semaforo=0 #Valdrá 0 cuando, al haber terminado un proceso, haya otros procesos esperando en memoria o fuera del sistema. Y valdrá 1 mientras haya un proceso en ejecución y, por tanto la variable bandera() tendría algún valor a 1.
	nprocesos=${#llegada[@]} #Por compatibilidad con otros códigos.
	while [[ $salida != "s" ]]; do #Controla si aún quedan procesos pendientes de ejecutar.
		#Habrá que meter en memoria los procesos de la lista que hayan llegado por tiempo de llegada, por FIFO.
		procesoNoEntraEnParticion=0 #Si vale 1 es porque hay un proceso que no entra en memoria. El resto de procesos de la lista, aún estando en espera, no lo intenta.
		#Control de Particiones y Estados de los Procesos
		procPorUnidadTiempo[$reloj]=$topeProcPorUnidadTiempo #Se inicializa al máximo antes calculado para declarar que no hay proceso en ejecución en ese instante de reloj
		#Primero se ajustan los parámetros puesto que T es exacto y se va a parametrizar el momento actual.
		for (( i=1; i<=${#llegada[@]}; i++ )); do
			# 1)Se ajustan los estados
			if [[ ${tiempoEsperaProceso[$i]} -lt 0 && ${llegada[$i]} -ge $reloj && ${sale[$i]} -eq 0 ]]; then
				estado[$i]="Fuera del sistema"
				estad[$i]=0
			else
				if [[ ${procesoEnParticionOcupada[$i]} -ne 1 && ${llegada[$i]} -le $reloj && ${estad[$i]} -ne 5 && ${sale[$i]} -eq 0 ]]; then
					if [[ ${estad[$i]} -ne 1 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
						poreventos=1
						avisollegada[$i]=1
					fi
					estado[$i]="En espera"
					estad[$i]=1
				fi
			fi
			# 2)Se ajustan tiempos de retorno según el estado en el que se encuentren
			if [[ ${estad[$i]} -ne 0 && ${estad[$i]} -ne 5 && ${sale[$i]} -eq 0 ]]; then
				tiempoRetornoProceso[$i]=$(($reloj - ${llegada[$i]}))
				if [[ ${tiempoRetornoProceso[$i]} -lt 0 ]]; then
					tiempoRetornoProceso[$i]=0
				fi
			fi
			# 3)Se ajustan el tiempo restante de ejecución decrementando para el estado "En ejecución"
			procPorUnidadTiempo[$reloj]=0 #Mete 0 mientras no haya número de orden del proceso que se mantiene en ejecución en la posición reloj.
			if [[ ${estad[$i]} -eq 3 && ${sale[$i]} -eq 0 ]]; then
				restante[$i]=$((${restante[$i]} - 1))
				procPorUnidadTiempo[$reloj]=$i #Mete el número de orden del proceso que se mantiene en ejecución en la posición reloj de procPorUnidadTiempo.
			fi
			# 4)Si se están en ejecución/no ejecución: se ajusta el tiempo de Espera
			if [[ ${bandera[$i]} -eq 0 && ${sale[$i]} -eq 0 ]]; then  #Con bandera[] a 1 se define que ese proceso está en ejecución (semaforo=1).
				if [[ ${estad[$i]} -ne 4 ]]; then
					tiempoEsperaProceso[$i]=${tiempoRetornoProceso[$i]}
				else
					tiempoEsperaProceso[$i]=$((${tiempoEsperaProceso[$i]} + 1))
				fi
			else
				if [[ ${bandera[$i]} -eq 1 && ${sale[$i]} -eq 0 && ${bloqueo[$i]} -eq 0 ]]; then
					resto=$((${tiempo[$i]} - ${restante[$i]}))
					tiempoEsperaProceso[$i]=$((${tiempoRetornoProceso[$i]} - $resto))
				fi
			fi
		done

		####################################################################################
		# DIFERENTE - Algoritmo Round-Robin
		#Se mira si ha terminado el proceso en ejecución, ya que si deja espacio se podrá meter algún otro proceso y se determina el proceso a ejecutar.
		for (( i=1; i<=$nprocesos; i++ )); do  #Se busca el primer proceso de entre todos los que se encuentran en memoria.
			if [[ ${colaTiempoRR[$i]} -eq $indiceColaTiempoRREnEjecucion && ${restante[$i]} -le 0 && ${procesoEnParticionOcupada[$i]} -eq 1 && ${sale[$i]} -eq 0 ]]; then
				if [[ ${estad[$i]} -ne 5 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
					evento1=1
					poreventos=1
					avisosalida[$i]=1
				fi
				estado[$i]="Finalizado"
				estad[$i]=5
				colaTiempoRR[$i]=-1 #Contiene el orden de ejecución de Round-Robin (RR). Será "-1" mientras no esté en cola, o cuando haya terminado, y si aún no ha terminado contendrá el número ordinal del siguiente quantum. El proceso a ejecutar será, por tanto, el que tenga el número ordinal más bajo. Y el número de quantums realizados (cambios de contexto, será el número ordinal más alto.
				indiceColaTiempoRREnEjecucion=$(($indiceColaTiempoRREnEjecucion + 1)) #Índice con el actual ordinal en ejecución para Round-Robin (RR).
				contadorTiempoRR=0 #Contador de uso del quantum. Para que el proceso que se vaya a ejecutar empiece a usar su quantum desde 0.
				procesoEnParticionOcupada[$i]=0 #El proceso $i ya no está en una partición ocupada
				particionOcupada[${partConProceso[$i]}]=0 #La partición se marca como libre.
				bandera[$i]=0 #Con 0 se define que ese proceso ya no está en ejecución.
				ocupadas[${partConProceso[$i]}]=0
				partConProceso[$i]=0
				sale[$i]=1
				((procesosFinalizados++)) #Contiene el número de procesos terminados
				semaforo=0
			fi
		done
		#Se mira si el proceso en ejecución ha terminado su quantum, pero el proceso aún no ha terminado, ya que se encolará antes que los nuevos procesos que entren en memoria.
		for (( i=1; i<=$nprocesos; i++ )); do  #Se busca el primer proceso de entre todos los que se encuentran en memoria.
			if [[ ${colaTiempoRR[$i]} -eq $indiceColaTiempoRREnEjecucion && $contadorTiempoRR -ge $quantum ]] ; then #Si es nuevo, empieza a ejecutarse. Si el proceso está marcado como en ejecución, el contador $contadorTiempoRR aumenta en una unidad.
				if [[ ${estad[$i]} -ne 4 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
					evento1=1 #Provoca un volcado en cada final de quantum
					poreventos=1
					avisoPausa[$i]=1
				fi
				estado[$i]="En pausa" #Se marca el proceso como "en pausa" para no ser ejecutado ya que comenzará a ejecutarse otro proceso.
				estad[$i]=4
				bandera[$i]=0 #Proceso que no está en ejecución
				contadorTiempoRR=0 #Contador de uso del quantum. Para que el proceso que se vaya a ejecutar empiece a usar su quantum desde 0.
				colaTiempoRR[$i]=$indiceColaTiempoRRLibre #Se le reencola con un nuevo índice, en último lugar.
				indiceColaTiempoRRLibre=$(($indiceColaTiempoRRLibre + 1)) #Índice con el primer ordinal libre a repartir en Round-Robin (RR).
				indiceColaTiempoRREnEjecucion=$(($indiceColaTiempoRREnEjecucion + 1)) #Índice con el actual ordinal en ejecución para Round-Robin (RR).
			fi
		done
		# DIFERENTE
		####################################################################################3

		for (( i=1; i<=${#llegada[@]}; i++ )); do
			# 5)Ahora se meten procesos en memoria, si ha lugar.
			if [[ ${sale[$i]} -ne 1 && ${procesoEnParticionOcupada[$i]} -ne 1 && ${procesoYaHaEntrado[$i]} -ne 1 && $procesoNoEntraEnParticion -eq 0 ]]; then #Si el proceso no ha salido, no ocupa ninguna partición y proceso anterior ha entrado ya
				if [[ ${llegada[$i]} -le $reloj ]]; then
					procesoNoEntraEnParticion=1 #Se pone a 1 y se busca una partición. Si no la encuentra, no sigue buscando con el resto de procesos.
					for (( j=1; j<=${#particiones[@]}; j++ )); do
						if [[ ${memoria[$i]} -le ${particiones[$j]} && ${particionOcupada[$j]} -eq 0 && ${estad[$i]} -ne 5 ]]; then #Si el tamaño en memoria del proceso es menor que alguna partición y ésta no está ocupada, se mete el proceso en esa partición
							procesoNoEntraEnParticion=0 #Si encuentra una partición libre en la que quepa ese proceso, modifica las variables correspondientes y sigue con el siguiente proceso en espera, si lo hay.
							procesoEnParticionOcupada[$i]=1 #El proceso $i está en una partición ocupada
							procesoYaHaEntrado[$i]=1 #El proceso $i ha entrado en memoria
							entrada[$i]=$reloj
							if [[ ${estad[$i]} -ne 2 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
								poreventos=1
								avisoentrada[$i]=1
							fi
							estado[$i]="En memoria"
							estad[$i]=2
							let restante[$i]=${tiempo[$i]}

							# Primer/Mejor/Peor (Primer por defecto) #
							diff_mem=0
							if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 2 ]]; then #Prioridades+Mejor - Se busca la partición más grande como límite, para buscar después la Mejor de las particiones, o la que corresponda. Así se evita tener que poner un número fijo.
								for (( part=${#particiones[@]}; part>=1; part-- )); do
									if [[ $diff_mem -lt ${particiones[$part]} ]]; then
										diff_mem=${particiones[$part]}
									fi
								done
							fi
							diff=$j
							for (( dm=1; dm<=${#particiones[@]}; dm++ )); do
								if [[ ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then #Si la posición esta vacia y el tamaño de la posición es mayor o igual a la memoria actual
									auxMem=$(expr ${particiones[$dm]} - ${memoria[$i]}) #Resta entre el tamaño de la partición y el valor de la memoria correspondiente.
								fi

								#Esto es para que vaya con Mejor
								if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 2 ]]; then #Prioridades+Mejor
									if [[ $auxMem -lt $diff_mem && ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then
										diff_mem=$auxMem #Diferencia entre tamaño de partición y tamaño de proceso más pequeña
										diff=$dm #Número de la partición más pequeña
									fi
								fi
								#Hasta aquí es para que vaya con Mejor
								#Esto es para que vaya con Peor
								if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 3 ]]; then #Prioridades+Peor
									if [[ $auxMem -gt $diff_mem && ${particionOcupada[$dm]} -eq 0 && ${particiones[$dm]} -ge ${memoria[$i]} ]]; then
										diff_mem=$auxMem #Diferencia entre tamaño de partición y tamaño de proceso más grande
										diff=$dm  #Número de la partición más grande
									fi
								fi
								#Hasta aquí es para que vaya con Peor
							done
							ocupadas[$diff]=$i # asigno a diff del array ocupadas el valor de i
							partConProceso[$i]=$diff # asigno el valor diff al indice i del array partConProceso
							particionOcupada[$diff]=1 #La partición $j está ocupada. Asigno el valor 1 al indice diff del array particionOcupada
							j=$(expr ${#particiones[@]} + 1) # asigno a j la longitud del array particiones +1
						fi
					done
				fi
			fi
		done

		####################################################################################
		# DIFERENTE - Algoritmo Round-Robin - Se determina ... la cola de ejecución
		#Se encolan procesos que acaban de entrar en memoria.
		for (( i=1; i<=$nprocesos; i++ )); do  #Se buscan nuevos procesos no encolados de entre todos los que se encuentran en memoria.
			if [[ ${estad[$i]} -eq 2 && ${restante[$i]} -gt 0 ]]; then
				if [[ ${colaTiempoRR[$i]} -eq -1 ]] ; then #Si hay nuevos procesos en memoria se les encola y se les asigna una possición ($indiceColaTiempoRRLibre).
					colaTiempoRR[$i]=$indiceColaTiempoRRLibre
					indiceColaTiempoRRLibre=$(($indiceColaTiempoRRLibre + 1))
				fi
			fi
		done
		#Una vez encolados, se determina si se sigue ejecutando el mismo que ya lo estaba en el instante anterior, o se determina cuál se ejecutará en el instante actual, si el proceso anterior o su quantum han terminado.
		for (( i=1; i<=$nprocesos; i++ )); do  #Se busca el primer proceso de la cola de entre todos los que se encuentran en memoria.
			if ([[ ${estad[$i]} -eq 2 || ${estad[$i]} -eq 3 || ${estad[$i]} -eq 4 ]]) && [[ ${restante[$i]} -gt 0 ]]; then
				if [[ ${colaTiempoRR[$i]} -eq $indiceColaTiempoRREnEjecucion && $contadorTiempoRR -lt $quantum ]] ; then #Si es nuevo, empieza a ejecutarse. Si el proceso está marcado como en ejecución, el contador $contadorTiempoRR aumenta en una unidad.
					contadorTiempoRR=$(($contadorTiempoRR + 1))
					if [[ ${estad[$i]} -ne 3 ]]; then # Sólo se cambia la variable "poreventos" si se ha producido una modificación en el Estado del proceso.
						if [[ $anteriorProcesoEjecucion -ne $i ]]; then #Si estaba el mismo proceso en ejecución con anterioridad no se avisaa.
							poreventos=1
							avisoEntradaCPU[$i]=1 #Se activa el aviso de entrada en CPU del volcado
						fi
					fi
					estado[$i]="En ejecución" #Se marca el proceso para ejecutarse o se refuerza si ya lo estaba.
					estad[$i]=3 #Se marca el proceso para ejecutarse o se refuerza si ya lo estaba.
					bandera[$i]=1 #Proceso que está en ejecución
					anteriorProcesoEjecucion=Si
				fi
			fi
 		done
		#Se comprueba si hay algún Px en ejecución, y en caso contrario se lanza el siguiente.
		for (( counter=1; counter<=${#llegada[@]}; counter++ )); do
			if [[ ${bandera[$counter]} -eq 1 ]]; then #Con bandera[] a 1 se define que ese proceso está en ejecución (semaforo=1).
				semaforo=1
			fi
		done
		#Salida
		if [[ $procesosFinalizados -ge ${#memoria[@]} ]]; then
			salida=s
		fi
		#Recalculo de tiempos en función de la espera y la respuesta de un Px
		for (( k=1; k<=${#tiempoEsperaProceso[@]}; k++ )); do
			if [[ ${tiempoEsperaProceso[$k]} -lt 0 ]]; then
				tiempoNEsperaProceso[$k]=0
			else
				tiempoNEsperaProceso[$k]=${tiempoEsperaProceso[$k]}
			fi
		done
		for (( k=1; k<=${#tiempoRetornoProceso[@]}; k++ )); do
			if [[ ${tiempoRetornoProceso[$k]} -lt 0 ]]; then
				tiempoNRetornoProceso[$k]=0
			else
				tiempoNRetornoProceso[$k]=${tiempoRetornoProceso[$k]}
			fi
		done
		# DIFERENTE
		####################################################################################3

		# 6)Impresión por cada ciclo de iteraciones, sólo cuando haya algún cambio de estado.
		imprimirTablaResumenProcesosEnVolcados
		let reloj=$reloj+1
	done
} #Fin de algoritmoRoundRobin_AjustePrimerMejorPeor()

####################################################################################
# Sinopsis: Determina si el rango es de menor a mayor y si no lo es, lo modifica para convertir el problema con las prioridades invertidas, porque el código sólo resuelve ese caso.
####################################################################################
function tratarRangoPrioridadesDirecta {
	invertirDatoPrioridadesInversa=0 #Será 1 cuando se determine un rango de prioridades cuyo mínimo sea mayor que su máximo.
	if [[ $1 -gt $2 ]]; then
		aux=$1
		PriomFinal=$2
		PrioMFinal=$aux
		invertirDatoPrioridadesInversa=1 #Será 1 cuando se determine un rango de prioridades cuyo mínimo sea mayor que su máximo.
	else
		PriomFinal=$1
		PrioMFinal=$2
	fi
} #Fin de tratarRangoPrioridadesDirecta()

#######################################################################
# Sinopsis: Dato del tamaño de la memoria total, calculado de forma aleatoria desde su subrango
#######################################################################
function calcDatoAleatorioGeneral {
	#Llamada: calcDatoAleatorioGeneral $MIN_RANGE_MEM $MAX_RANGE_MEM #Asignación: mem=$datoAleatorioGeneral
	min=$1 #min=$MIN_RANGE_MEM
	max=$2 #max=$MAX_RANGE_MEM
	datoAleatorioGeneral=$((RANDOM % ($max - $min + 1) + $min)) #mem=$((RANDOM % ($max - $min + 1) + $min)) # Generar un número aleatorio dentro del rango
}

####################################################################################
# Sinopsis: Se muestran los eventos sucedidos, sobre la tabla resumen.
####################################################################################
function mostrarEventos {
#	clear
	Dato2=""
	Dato3=""
	Dato4=""
	evento1=0 #Inicializo evento
	#Se muestran los datos sobre las indicaciones del evento que ha sucedido
	if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 1 ]]; then #FCFS/SJF/SRPT
		algoritmoSeleccionado=" FCFS-"
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 2 ]]; then
		algoritmoSeleccionado=" SJF-"
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 3 ]]; then
		algoritmoSeleccionado=" SRPT-"
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 4 ]]; then
		algoritmoSeleccionado=" Prioridades-"
		if [[ $seleccionTipoPrioridad -eq 1 ]]; then #M/m
			algoritmoSeleccionado+="Mayor-"
		else
			algoritmoSeleccionado+="Menor-"
		fi
		if [[ $seleccionMenuApropiatividad -eq 1 ]]; then #M/m
			algoritmoSeleccionado+="NoApropiativo-"
		else
			algoritmoSeleccionado+="Apropiativo-"
		fi
		Dato2=" Prio.Mínima="$subrango_prioProc_procesos_minInicial" Prio.Máxima="$subrango_prioProc_procesos_maxInicial
	elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 5 ]]; then
		algoritmoSeleccionado=" RoundRobin(RR)-"
		Dato3=" Quantum="$quantum
	fi
	if [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 1 ]]; then
		titleMemoria="FNI-Primer Ajuste"
	elif [[ $seleccionMenuAlgoritmoGestionAjusteMemoria -eq 2 ]]; then
		titleMemoria="FNI-Mejor Ajuste"
	else
		titleMemoria="FNI-Peor Ajuste"
	fi
	Dato4=" Tamaño de las particiones (de la Part. 1 a la "${#particiones[@]}"):"
	for (( z=1; z<=${#particiones[@]}; z++ )); do
		Dato4+=" ${particiones[$z]} "
	done
	algoritmoContinuidadReubicabilidadSeleccionado="\n$algoritmoSeleccionado""$titleMemoria"
	echo -ne "$algoritmoContinuidadReubicabilidadSeleccionado" | tee -a $informeConColorTotal
	echo -ne "$algoritmoContinuidadReubicabilidadSeleccionado" >> ./$informeSinColorTotal
	echo -e "\n Reloj=$reloj Mem.Total=$mem_total$Dato4" | tee -a $informeConColorTotal
	echo -e "\n Reloj=$reloj Mem.Total=$mem_total$Dato4" >> $informeSinColorTotal
	echo -e "$Dato2$Dato3" | tee -a $informeConColorTotal
	echo -e "$Dato2$Dato3" >> $informeSinColorTotal
	#Se muestra el evento que ha sucedido
	for (( l=1; l<=$nprocesos; l++ )); do
		if [[ ${avisosalida[$l]} -eq 1 ]]; then
			echo -e " El proceso$NC ${varC[$l]}${proceso[$l]}$NC ha salido de memoria." | tee -a $informeConColorTotal
			echo -e " El proceso ${proceso[$l]} ha salido de memoria." >> $informeSinColorTotal
			avisosalida[$l]=0 #Se borra el uno para que no se vuelva a imprimir 
			avisoPausa[$l]=0 #Se borra el uno para que no se imprima, para asegurarse que si ha entrado en CPU, no salga el aviso
			avisoEntradaCPU[$l]=0 #Se borra el uno para que no se vuelva a imprimir
		fi
	done
	for (( l=1; l<=$nprocesos; l++ )); do
		if [[ ${avisollegada[$l]} -eq 1 ]]; then
			echo -e " El proceso$NC ${varC[$l]}${proceso[$l]}$NC ha llegado al sistema." | tee -a $informeConColorTotal
			echo -e " El proceso ${proceso[$l]} ha llegado al sitema." >> $informeSinColorTotal
			avisollegada[$l]=0 #Se borra el uno para que no se vuelva a imprimir 
			avisoPausa[$l]=0 #Se borra el uno para que no se imprima, para asegurarse que si ha entrado en CPU, no salga el aviso
		fi
	done
	for (( l=1; l<=$nprocesos; l++ )); do
		if [[ ${avisoentrada[$l]} -eq 1 ]]; then
			echo -e " El proceso$NC ${varC[$l]}${proceso[$l]}$NC ha entrado en memoria. " | tee -a $informeConColorTotal
			echo -e " El proceso ${proceso[$l]} ha entrado en memoria." >> $informeSinColorTotal
			avisoentrada[$l]=0 #Se borra el uno para que no se vuelva a imprimir 
			avisoPausa[$l]=0 #Se borra el uno para que no se imprima, para asegurarse que si ha entrado en CPU, no salga el aviso
		fi
	done
	for (( l=1; l<=$nprocesos; l++ )); do
		if [[ ${avisoPausa[$l]} -eq 1 ]]; then
			echo -e " El proceso$NC ${varC[$l]}${proceso[$l]}$NC ha quedado en pausa. " | tee -a $informeConColorTotal
			echo -e " El proceso ${proceso[$l]} ha quedado en pausa." >> $informeSinColorTotal
			avisoPausa[$l]=0 #Se borra el uno para que no se vuelva a imprimir
		fi
	done
	for (( l=1; l<=$nprocesos; l++ )); do
		if [[ ${avisoEntradaCPU[$l]} -eq 1 ]]; then
			echo -e " El proceso$NC ${varC[$l]}${proceso[$l]}$NC ha entrado en CPU. " | tee -a $informeConColorTotal
			echo -e " El proceso ${proceso[$l]} ha entrado en CPU." >> $informeSinColorTotal
			avisoEntradaCPU[$l]=0 #Se borra el uno para que no se vuelva a imprimir 
		fi
	done
} #Fin de mostrarEventos()

####################################################################################
# Sinopsis: Prepara e imprime la tabla resumen de procesos en cada volcado
####################################################################################
function imprimirTablaResumenProcesosEnVolcados {
	for (( i=1; i<=${#particiones[@]}; i++ )); do # Se calculan los porcentajes de uso de las particiones //Se podría calcular cuando se mete un proceso en una partición  y se haría una única. Pero este cálculo habría que meterlo en los tres algoritmos de gestión de procesos y para los trs algoritmos de eleción de modelo de ejecución de gestión de memoria.
		for (( j=1; j<=${#partConProceso[@]}; j++ )); do
			if [[ $i -eq ${partConProceso[$j]} && (${estad[$j]} -eq 2 || ${estad[$j]} -eq 3 || ${estad[$j]} -eq 4) ]]; then # El proceso se puede imprimir en memoria
				# Se añade el porcentaje de la partición a la banda
				porcentaje[$i]=`expr ${memoria[$j]} \* 100 / ${particiones[$i]}` #Se calcula el porcentaje de fragmentación de la partición
			fi
		done
	done

	if [[ $poreventos -eq 0 && $optejecucion -ne 5 && $reloj -gt 0 ]]; then
		procPorUnidadTiempo[$reloj]=${procPorUnidadTiempo[$reloj - 1]}
	fi
	if [[ $reloj -eq 0 && $optejecucion -ne 5 ]]; then
		imprimirTablaResumenProcesosEnVolcadosEjecucion
		calcularPromediosEsperaRespuesta
		representacionParticionesEnTabla
		representacionLineaTemporal
		poreventos=0
	fi
	if [[ (($poreventos -eq 1) && (($optejecucion -ge 1) && ($optejecucion -le 3))) && $reloj -ne 0 ]]; then
		if [[ $optejecucion -eq 2 || $optejecucion -eq 3 ]]; then
			sleep $tiempoejecucion
		elif [[ $optejecucion -eq 1 ]]; then
			echo -ne $ROJO"\n\n Pulsa ENTER para continuar "$NORMAL #Para esperar un return tras parar en cada volcado
			read enterContinuar
		fi
		imprimirTablaResumenProcesosEnVolcadosEjecucion
		calcularPromediosEsperaRespuesta
		representacionParticionesEnTabla
		representacionLineaTemporal
		poreventos=0
	fi
	if [[ $optejecucion -eq 4 && $reloj -ne 0 ]]; then
		imprimirTablaResumenProcesosEnVolcadosEjecucion
		calcularPromediosEsperaRespuesta
		representacionParticionesEnTabla
		representacionLineaTemporal
		poreventos=0
	fi
	if [[ $optejecucion -eq 5 ]]; then
		calcularPromediosEsperaRespuesta
	fi
} #Fin de imprimirTablaResumenProcesosEnVolcados()

####################################################################################
# Sinopsis: Prepara e imprime la tabla resumen de procesos en cada volcado - GENERA LÍNEAS COMPLETAS Y LAS COPIA LÍNEA A lÍNEA EN LOS FICHEROS DE INFORMES.
####################################################################################
function imprimirTablaResumenProcesosEnVolcadosEjecucion {
	mostrarEventos #Muestra el tipo de algoritmo en la cabecera de los volcados del resumen de la tabla de procesos.
	if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 4 ]]; then
		echo -ne "\n Ref Tll Tej Mem Prio Tesp Tret Trej Part %Uso Estado" | tee -a $informeSinColorTotal
		echo -ne $NORMAL
		echo -ne "\n Ref Tll Tej Mem Prio Tesp Tret Trej Part %Uso Estado" >> $informeConColorTotal
	else
		echo -ne "\n Ref Tll Tej Mem Tesp Tret Trej Part %Uso Estado" | tee -a $informeSinColorTotal
		echo -ne $NORMAL
		echo -ne "\n Ref Tll Tej Mem Tesp Tret Trej Part %Uso Estado" >> $informeConColorTotal
	fi
	for (( i=1; i<=${#llegada[@]}; i++ )); do
		#Salidas por pantalla y salidas a informe
		restante[$i]=$((${tiempo[$i]} + ${tiempoNEsperaProceso[$i]} - ${tiempoNRetornoProceso[$i]}))
		varColor="\n ${colores[$i % 6]}${proceso[$i]} "
		varBN="\n ${proceso[$i]} "
		longitudLlegada=$(($longCampoTablaEstrecho - ${#llegada[$i]}))
		varColor+="${varhuecos:1:$longitudLlegada}""${colores[$i % 6]}${llegada[$i]} "
		varBN+="${varhuecos:1:$longitudLlegada}""${llegada[$i]} "
		longitudTiempo=$(($longCampoTablaEstrecho - ${#tiempo[$i]}))
		varColor+="${varhuecos:1:$longitudTiempo}""${colores[$i % 6]}${tiempo[$i]} "
		varBN+="${varhuecos:1:$longitudTiempo}""${tiempo[$i]} "
		longitudMemoria=$(($longCampoTablaEstrecho - ${#memoria[$i]}))
		varColor+="${varhuecos:1:$longitudMemoria}""${colores[$i % 6]}${memoria[$i]} "
		varBN+="${varhuecos:1:$longitudMemoria}""${memoria[$i]} "
		if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 4 ]]; then
			longitudPrioProc=$(($longCampoTablaAncho - ${#prioProc[$i]}))
			varColor+="${varhuecos:1:$longitudPrioProc}""${colores[$i % 6]}${prioProc[$i]} "
			varBN+="${varhuecos:1:$longitudPrioProc}""${prioProc[$i]} "
		fi
		if [[ "${estad[$i]}" -eq 0 ]]; then
			varColor+="   ${colores[$i % 6]}- "
			varBN+="   - "
		else
			longitudTiempoNEsperaProceso=$((longCampoTablaAncho - ${#tiempoNEsperaProceso[$i]}))
			varColor+="${varhuecos:1:$longitudTiempoNEsperaProceso}""${colores[$i % 6]}${tiempoNEsperaProceso[$i]} "
			varBN+="${varhuecos:1:$longitudTiempoNEsperaProceso}""${tiempoNEsperaProceso[$i]} "
		fi
		if [[ "${estad[$i]}" -eq 0 ]]; then
			varColor+="   ${colores[$i % 6]}- "
			varBN+="   - "
		else
			longitudTiempoNRespuProceso=$((longCampoTablaAncho - ${#tiempoNRetornoProceso[$i]}))
			varColor+="${varhuecos:1:$longitudTiempoNRespuProceso}""${colores[$i % 6]}${tiempoNRetornoProceso[$i]} "
			varBN+="${varhuecos:1:$longitudTiempoNRespuProceso}""${tiempoNRetornoProceso[$i]} "
		fi
		if [[ "${estad[$i]}" -eq 0 ]]; then
			varColor+="   ${colores[$i % 6]}- "
			varBN+="   - "
		else
			longitudRestante=$((longCampoTablaAncho - ${#restante[$i]}))
			varColor+="${varhuecos:1:$longitudRestante}""${colores[$i % 6]}${restante[$i]} "
			varBN+="${varhuecos:1:$longitudRestante}""${restante[$i]} "
		fi
		if [[ ("${estad[$i]}" -eq 0 || "${estad[$i]}" -eq 5 || "${estad[$i]}" -eq 1) ]]; then
			varColor+="   - "
			varBN+="   - "
		else
			longitudPartConProceso=$((longCampoTablaAncho - ${#partConProceso[$i]}))
			varColor+="${varhuecos:1:$longitudPartConProceso}""${partConProceso[$i]} "
			varBN+="${varhuecos:1:$longitudPartConProceso}""${partConProceso[$i]} "
		fi
		if [[ ("${estad[$i]}" -eq 0 || "${estad[$i]}" -eq 5 || "${estad[$i]}" -eq 1) ]]; then
			varColor+="   - "
			varBN+="   - "
		else
			longitudPorcentaje=$((longCampoTablaAncho - ${#porcentaje[${partConProceso[$i]}]}))
			varColor+="${varhuecos:1:$longitudPorcentaje}""${porcentaje[${partConProceso[$i]}]} "
			varBN+="${varhuecos:1:$longitudPorcentaje}""${porcentaje[${partConProceso[$i]}]} "
		fi
		varColor+="${estado[$i]} "
		varBN+="${estado[$i]} "
		echo -ne "${varColor}" | tee -a $informeConColorTotal
		echo -ne "${varBN}" >> $informeSinColorTotal
	done # Fin del for
} #Fin de imprimirTablaResumenProcesosEnVolcadosEjecucion()

####################################################################################
# Sinopsis: Prepara e imprime la tabla resumen de procesos en cada volcado - COPIA CADA DATO CUANDO LO LOCALIZA - MUY LENTO. NO USADA.
####################################################################################
function imprimirTablaResumenProcesosEnVolcadosEjecucion_ORI {
	echo "" >>$informeConColorTotal
	echo "" >>$informeSinColorTotal
	echo -e $AMARILLO$title$NORMAL
	echo -e $title >$informeSinColorTotal
	echo $AMARILLO$title$NORMAL >$informeConColorTotal
	echo -ne " T: $reloj\tTamaño de las particiones:" | tee -a $informeConColorTotal
	echo -ne " T: $reloj\tTamaño de las particiones:" >>$informeSinColorTotal
	for (( z=1; z<=$contadorParticiones; z++ )); do
		echo -en " ${particiones[$z]} " | tee -a $informeConColorTotal
		echo -en " ${particiones[$z]} " >>$informeSinColorTotal
	done
	echo "" | tee -a $informeSinColorTotal
	echo "" >>$informeConColorTotal
	echo -e " Ref Tll Tej Mem Prio Tesp Tret Trej Part %Uso Estado" | tee -a $informeSinColorTotal
	echo -ne $NORMAL
	#Cabecera par informe a color
	echo -e " Ref Tll Tej Mem Tesp Tret Trej Part %Uso Estado" >>$informeConColorTotal
	for (( i=1; i<=${#llegada[@]}; i++ )); do
		#Salidas por pantalla y salidas a informe
		restante[$i]=$((${tiempo[$i]} + ${tiempoNEsperaProceso[$i]} - ${tiempoNRetornoProceso[$i]}))
		echo -ne " ${colores[$i % 6]}${proceso[$i]} "
		echo -ne " ${proceso[$i]} " >>$informeSinColorTotal
		echo -ne " ${colores[$i % 6]}${proceso[$i]} " >>$informeConColorTotal
		longitudLlegada=$(($longCampoTablaEstrecho - ${#llegada[$i]}))
		echo -ne "${varhuecos:1:$longitudLlegada}""${colores[$i % 6]}${llegada[$i]} " | tee -a $informeConColorTotal
		echo -ne "${varhuecos:1:$longitudLlegada}""${llegada[$i]} " >>$informeSinColorTotal
		longitudTiempo=$(($longCampoTablaEstrecho - ${#tiempo[$i]}))
		echo -ne "${varhuecos:1:$longitudTiempo}""${colores[$i % 6]}${tiempo[$i]} " | tee -a $informeConColorTotal
		echo -ne "${varhuecos:1:$longitudTiempo}""${tiempo[$i]} " >>$informeSinColorTotal
		longitudMemoria=$(($longCampoTablaEstrecho - ${#memoria[$i]}))
		echo -ne "${varhuecos:1:$longitudMemoria}""${colores[$i % 6]}${memoria[$i]} " | tee -a $informeConColorTotal
		echo -ne "${varhuecos:1:$longitudMemoria}""${memoria[$i]} " >>$informeSinColorTotal
		longitudPrioProc=$(($longCampoTablaEstrecho - ${#prioProc[$i]}))
		echo -ne "${varhuecos:1:$longitudPrioProc}""${colores[$i % 6]}${prioProc[$i]} " | tee -a $informeConColorTotal
		echo -ne "${varhuecos:1:$longitudPrioProc}""${prioProc[$i]} " >>$informeSinColorTotal
		if [[ "${estad[$i]}" -eq 0 ]]; then
			echo -ne "   ${colores[$i % 6]}- " | tee -a $informeConColorTotal
			echo -ne "   - " >>$informeSinColorTotal
		else
			longitudTiempoNEsperaProceso=$((longCampoTablaAncho - ${#tiempoNEsperaProceso[$i]}))
			echo -ne "${varhuecos:1:$longitudTiempoNEsperaProceso}""${colores[$i % 6]}${tiempoNEsperaProceso[$i]} " | tee -a $informeConColorTotal
			echo -ne "${varhuecos:1:$longitudTiempoNEsperaProceso}""${tiempoNEsperaProceso[$i]} " >>$informeSinColorTotal
		fi
		if [[ "${estad[$i]}" -eq 0 ]]; then
				echo -ne "   ${colores[$i % 6]}- " | tee -a $informeConColorTotal
				echo -ne "   - " >>$informeSinColorTotal
		else
				longitudTiempoNRespuProceso=$((longCampoTablaAncho - ${#tiempoNRetornoProceso[$i]}))
			echo -ne "${varhuecos:1:$longitudTiempoNRespuProceso}""${colores[$i % 6]}${tiempoNRetornoProceso[$i]} " | tee -a $informeConColorTotal
			echo -ne "${varhuecos:1:$longitudTiempoNRespuProceso}""${tiempoNRetornoProceso[$i]} " >>$informeSinColorTotal
		fi
		if [[ "${estad[$i]}" -eq 0 ]]; then
			echo -ne "   ${colores[$i % 6]}- " | tee -a $informeConColorTotal
			echo -ne "   - " >>$informeSinColorTotal
		else
			longitudRestante=$((longCampoTablaAncho - ${#restante[$i]}))
			echo -ne "${varhuecos:1:$longitudRestante}""${colores[$i % 6]}${restante[$i]} " | tee -a $informeConColorTotal
			echo -ne "${varhuecos:1:$longitudRestante}""${restante[$i]} " >>$informeSinColorTotal
		fi
		if [[ ("${estad[$i]}" -eq 0 || "${estad[$i]}" -eq 5 || "${estad[$i]}" -eq 1) ]]; then
			echo -ne "   - " | tee -a $informeConColorTotal
			echo -ne "   - " >>$informeSinColorTotal
		else
			longitudPartConProceso=$((longCampoTablaAncho - ${#partConProceso[$i]}))
			echo -ne "${varhuecos:1:$longitudPartConProceso}""${partConProceso[$i]} " | tee -a $informeConColorTotal
			echo -ne "${varhuecos:1:$longitudPartConProceso}""${partConProceso[$i]} " >>$informeSinColorTotal
		fi
		if [[ ("${estad[$i]}" -eq 0 || "${estad[$i]}" -eq 5 || "${estad[$i]}" -eq 1) ]]; then
			echo -ne "   - " | tee -a $informeConColorTotal
			echo -ne "   - " >>$informeSinColorTotal
		else
			longitudPorcentaje=$((longCampoTablaAncho - ${#porcentaje[$i]}))
			echo -ne "${varhuecos:1:$longitudPorcentaje}""${porcentaje[$i]} " | tee -a $informeConColorTotal
			echo -ne "${varhuecos:1:$longitudPorcentaje}""${porcentaje[$i]} " >>$informeSinColorTotal
		fi
		echo -e "${estado[$i]} " | tee -a $informeConColorTotal
		echo -e "${estado[$i]} " >>$informeSinColorTotal
	done 
} #Fin de imprimirTablaResumenProcesosEnVolcadosEjecucion_ORI()

####################################################################################
# Sinopsis: Genera la Banda de Memoria y la muestra en pantalla/informe
####################################################################################
function representacionParticionesEnTabla {
	local maxCaracteres=0
#	maxCaracteres=$(($digitosUnidad + 1)) # Longitud en número de dígitos de cada unidad
	maxCaracteres=$digitosUnidad # Longitud en número de dígitos de cada unidad. Ya se aumentó en la función de cálculo del tamaño de la unidad (calcularUnidad())
	if [[ $maxCaracteres -eq 2 ]]; then
		maxCaracteres=3 # El mínimo de caracteres tiene que ser 3 para que entren los nombres de los procesos (P01,...)
	fi
	local terminal=`tput cols` #Ancho del terminal para adecuar el ancho de líneas a cada volcado
	echo ""

# GENERACIÓN STRING DE PARTICIONES (Línea 1 de la Banda de Memoria)
	local bandaParticiones=("     ")
	local bandaParticionesColor=("     ")
	local n=0 # Línea de la banda
	local numCaracteres=5

	for (( i=1; i<=${#particiones[@]}; i++ )); do
		local maxSize=$((${particiones[$i]} * $maxCaracteres)) # Tamaño caracteres de la partición
		local nombre=`printf "%-${maxSize}s" "Part.$i"`
		if [[ ${#nombre} -gt $maxSize ]]; then # Nombre demasiado grande
			nombre=`printf "%-${maxSize}s" "P$i"`
		fi
		for (( j=0; j<$maxSize; j += $maxCaracteres )); do
			if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
				n=$(($n + 1)) # Se pasa a la siguiente línea
				bandaParticiones[n]="     "
				bandaParticionesColor[n]=$NORMAL"     "
				numCaracteres=5
			fi
			# Se añade el nombre de la partición a la banda
			bandaParticiones[n]+=${nombre:$j:$maxCaracteres}
			bandaParticionesColor[n]+=${nombre:$j:$maxCaracteres}
			numCaracteres=$(($numCaracteres + $maxCaracteres))
		done

		# AÑADIR SEPARADOR DE PARTICIONES
		if [[ $i -lt ${#particiones[@]} ]]; then
			if [[ $(($numCaracteres + 1 + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
				n=$(($n + 1)) # Se pasa a la siguiente línea
				bandaParticiones[n]="     "
				bandaParticionesColor[n]=$NORMAL"     "
				numCaracteres=5
			fi
			bandaParticiones[n]+=" "
			bandaParticionesColor[n]+=" "
			numCaracteres=$(($numCaracteres + 1))
		fi
	done
	if [[ $(($numCaracteres + 5 + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
		n=$(($n + 1)) # Se pasa a la siguiente línea
		bandaParticiones[n]="     "
		bandaParticionesColor[n]=$NORMAL"     "
		numCaracteres=5
	fi
	bandaParticiones[n]+=`printf "    %$(($maxCaracteres))s" ""`
	bandaParticionesColor[n]+=`printf "    %$(($maxCaracteres))s" ""`

# GENERACIÓN STRING DE DEFRAGMENTACIONES (Línea 2 de la Banda de Memoria)
	local bandaDefragmentacionParticiones=("     ")
	local bandaDefragmentacionParticionesColor=("     ")
	local n=0 # Línea de la banda
	local numCaracteres=5

	for (( i=1; i<=${#particiones[@]}; i++ )); do
		x=0 # Variable que indica si se ha añadido un proceso a la banda
		falloDeDefragmentacion=0 #Variable para resolver un fallo en la representación de la defragmentación cuando se ocupa el 100% , las unidades son de 3 dígitos y la partición tiene más de 1 unidad, ya que la línea de porcentajes se descompensa.
		for (( j=1; j<=${#partConProceso[@]}; j++ )); do
			if [[ $i -eq ${partConProceso[$j]} && (${estad[$j]} -eq 2 || ${estad[$j]} -eq 3 || ${estad[$j]} -eq 4) ]]; then # El proceso se puede imprimir en memoria
				if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
					n=$(($n + 1)) # Se pasa a la siguiente línea
					bandaDefragmentacionParticiones[n]="     "
					bandaDefragmentacionParticionesColor[n]="     "
					numCaracteres=5
				fi
				# Se añade el porcentaje de la partición a la banda
				longitudPorcentaje=$(($maxCaracteres - ${#porcentaje[$i]} -1)) #Longitud de la variable para calcular los espacios a introducir antes de la unidad de la Banda de Tiempo

				if [[ ${porcentaje[$i]} -eq 100 && ${particiones[$i]} -eq 1 && $maxCaracteres -eq 3 ]]; then #Si el porcentaje es 100%, la partición sólo tiene una unidad y es de tamaño 3, se reduce el tamaño del texto del porcentaje. Se quitaría "&& ${particiones[$i]} -eq 1" hasta recalcular el resto convenientemente.
					bandaDefragmentacionParticionesColor[n]+="${colores[$j % 6]}${porcentaje[$i]}""${varhuecos:1:$longitudPorcentaje + 1}"$NORMAL
					bandaDefragmentacionParticiones[n]+="${porcentaje[$i]}""${varhuecos:1:$longitudPorcentaje + 1}"
				elif [[ ${porcentaje[$i]} -eq 100 && ${particiones[$i]} -gt 1 && $maxCaracteres -eq 3 ]]; then # El porcentaje ocupa una unidad más un dígito de la siguiente.la variable longitudPorcentaje valdría -1 y no se calculan bien los espacios a añadir.
					falloDeDefragmentacion=1

					bandaDefragmentacionParticionesColor[n]+="${colores[$j % 6]}${porcentaje[$i]}%"$NORMAL
					bandaDefragmentacionParticiones[n]+="${porcentaje[$i]}%"
				else
					bandaDefragmentacionParticionesColor[n]+="${colores[$j % 6]}${porcentaje[$i]}%""${varhuecos:1:$longitudPorcentaje}"$NORMAL
					bandaDefragmentacionParticiones[n]+="${porcentaje[$i]}%""${varhuecos:1:$longitudPorcentaje}"
				fi
				numCaracteres=$(($numCaracteres + $maxCaracteres))
				# Se añade los espacios correspondientes al proceso
				for (( k=0; k<$((${particiones[$i]} - 1)); k++ )); do
					if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
						n=$(($n + 1)) # Se pasa a la siguiente línea
						bandaDefragmentacionParticiones[n]="     "
						bandaDefragmentacionParticionesColor[n]="     "
						numCaracteres=5
					fi
					if [[ $falloDeDefragmentacion -eq 0  ]]; then
						bandaDefragmentacionParticiones[n]+="${varhuecos:1:$maxCaracteres}"
						bandaDefragmentacionParticionesColor[n]+="${varhuecos:1:$maxCaracteres}"
						numCaracteres=$(($numCaracteres + $maxCaracteres))
					else #Ajusta el carácter de más que tenía en la unidad anterior. No falla al saltar de línea porque se cuenta con un último carácter en el borde derecho de la pantalla.
						bandaDefragmentacionParticiones[n]+="${varhuecos:1:$maxCaracteres-1}"
						bandaDefragmentacionParticionesColor[n]+="${varhuecos:1:$maxCaracteres-1}"
						numCaracteres=$(($numCaracteres + $maxCaracteres))
						falloDeDefragmentacion=0
					fi
				done
				x=1
				break
			fi
		done
		if [[ $x -eq 0 ]]; then # No hay proceso en la partición
			for (( k=0; k<${particiones[$i]}; k++ )); do
				if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
					n=$(($n + 1)) # Se pasa a la siguiente línea
					bandaDefragmentacionParticiones[n]="     "
					bandaDefragmentacionParticionesColor[n]="     "
					numCaracteres=5
				fi
				bandaDefragmentacionParticiones[n]+="${varhuecos:1:$maxCaracteres}"
				bandaDefragmentacionParticionesColor[n]+="${varhuecos:1:$maxCaracteres}"
				numCaracteres=$(($numCaracteres + $maxCaracteres))
			done
		fi

		# AÑADIR SEPARADOR DE FRAGMENTACIONES
		if [[ $i -lt ${#particiones[@]} ]]; then
			if [[ $(($numCaracteres + 1 + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
				n=$(($n + 1)) # Se pasa a la siguiente línea
				bandaDefragmentacionParticiones[n]="     "
				bandaDefragmentacionParticionesColor[n]=$NORMAL"     "
				numCaracteres=5
			fi
			bandaDefragmentacionParticiones[n]+=" "
			bandaDefragmentacionParticionesColor[n]+=" "
			numCaracteres=$(($numCaracteres + 1))
		fi
	done
	if [[ $(($numCaracteres + 5 + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
		n=$(($n + 1)) # Se pasa a la siguiente línea
		bandaDefragmentacionParticiones[n]="     "
		bandaDefragmentacionParticionesColor[n]=$NORMAL"     "
		numCaracteres=5
	fi
	bandaDefragmentacionParticiones[n]+=`printf "    %$(($maxCaracteres))s" ""`
	bandaDefragmentacionParticionesColor[n]+=`printf "    %$(($maxCaracteres))s" ""`

	# GENERACIÓN STRING DE PROCESOS (Línea 3 de la Banda de Memoria)
	local bandaProcesos=("    |")
	local bandaProcesosColor=("    |")
	local n=0 # Línea de la banda
	local numCaracteres=5
	for (( i=1; i<=${#particiones[@]}; i++ )); do
		local x=0 # Variable que indica si se ha añadido un proceso a la banda
		for (( j=1; j<=${#partConProceso[@]}; j++ )); do
			if [[ $i -eq ${partConProceso[$j]} && (${estad[$j]} -eq 2 || ${estad[$j]} -eq 3 || ${estad[$j]} -eq 4) ]]; then # El proceso se puede imprimir en memoria
				if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
					n=$(($n + 1)) # Se pasa a la siguiente línea
					bandaProcesos[n]="     "
					bandaProcesosColor[n]="     "
					numCaracteres=5
				fi
				# Se añade el proceso a la banda
				bandaProcesos[n]+=`printf "%-${maxCaracteres}s" ${proceso[$j]}`
				bandaProcesosColor[n]+=`printf "${colores[$j % 6]}%-${maxCaracteres}s$NORMAL" ${proceso[$j]}`
				numCaracteres=$(($numCaracteres + $maxCaracteres))
				# Se añade los espacios correspondientes al proceso
				for (( k=0; k<$((${particiones[$i]} - 1)); k++ )); do
					if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
						n=$(($n + 1)) # Se pasa a la siguiente línea
						bandaProcesos[n]="     "
						bandaProcesosColor[n]="     "
						numCaracteres=5
					fi
					bandaProcesos[n]+=`printf "%$(($maxCaracteres))s" ""`
					bandaProcesosColor[n]+=`printf "%$(($maxCaracteres))s" ""`
					numCaracteres=$(($numCaracteres + $maxCaracteres))
				done
				x=1
				break
			fi
		done
		if [[ $x -eq 0 ]]; then # No hay proceso en la partición
			for (( k=0; k<${particiones[$i]}; k++ )); do
				if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
					n=$(($n + 1)) # Se pasa a la siguiente línea
					bandaProcesos[n]="     "
					bandaProcesosColor[n]="     "
					numCaracteres=5
				fi
				bandaProcesos[n]+=`printf "%$(($maxCaracteres))s" ""`
				bandaProcesosColor[n]+=`printf "%$(($maxCaracteres))s" ""`
				numCaracteres=$(($numCaracteres + $maxCaracteres))
			done
		fi

		# AÑADIR SEPARADOR DE PARTICIONES
		if [[ $i -lt ${#particiones[@]} ]]; then
			if [[ $(($numCaracteres + 1 + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
				n=$(($n + 1)) # Se pasa a la siguiente línea
				bandaProcesos[n]="     "
				bandaProcesosColor[n]="     "
				numCaracteres=5
			fi
			bandaProcesos[n]+=" "
			bandaProcesosColor[n]+=" "
			numCaracteres=$(($numCaracteres + 1))
		fi
	done
	# Añadir final de banda
	if [[ $(($numCaracteres + 5 + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
		n=$(($n + 1)) # Se pasa a la siguiente línea
		bandaProcesos[n]="     "
		bandaProcesosColor[n]="     "
		numCaracteres=5
	fi
	bandaProcesos[n]+=`printf "|    %$(($maxCaracteres))s" ""`
	bandaProcesosColor[n]+=`printf "|    %$(($maxCaracteres))s" ""`

	# GENERACIÓN STRING DE MEMORIA (Línea 4 de la Banda de Memoria)
	local bandaMemoria=(" BM |")
	local bandaMemoriaColor=(" BM |")
	local n=0 # Línea de la banda
	local numCaracteres=5
	espaciosAMeter=${varhuecos:1:$maxCaracteres}
	guionesAMeter=${varguiones:1:$maxCaracteres}
	asteriscosAMeter=${varasteriscos:1:$maxCaracteres}
	fondosAMeter=${varfondos:1:$maxCaracteres}
	sumaTotalMemoria=0
	for (( i=1; i<=${#particiones[@]}; i++ )); do #Se recorren todas las particiones para calcular su total
	   sumaTotalMemoria=$(($sumaTotalMemoria + ${particiones[$i]}))
	done
	for (( i=1; i<=${#particiones[@]}; i++ )); do #Se recorren todas las particiones
		local x=0 # Variable que indica si se ha añadido un proceso a la banda

		for (( j=1; j<=${#partConProceso[@]}; j++ )); do #Se recorren todos los procesos con número de partición asignada
			if [[ $i -eq ${partConProceso[$j]} && (${estad[$j]} -eq 2 || ${estad[$j]} -eq 3 || ${estad[$j]} -eq 4) ]]; then # El proceso se encuentra en alguna partición
				for (( k = 0; k < ${particiones[$i]}; k++ )); do #Se recorren las unidades de la partición con proceso
					if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
						n=$(($n + 1)) # Se pasa a la siguiente línea y se inicializan las variables
						bandaMemoria[n]="     "
						bandaMemoriaColor[n]="     "
						numCaracteres=5
					fi
					if [[ $k -lt ${memoria[$j]} ]]; then #Se concatenan el número de dígitos de cada unidad de esa partición
						bandaMemoria[n]+=$fondosAMeter
						bandaMemoriaColor[n]+=${colores[$j % 6]}$fondosAMeter
					else
						bandaMemoria[n]+=$guionesAMeter
						bandaMemoriaColor[n]+=$NORMAL$fondosAMeter
					fi
					numCaracteres=$(($numCaracteres + $maxCaracteres))
					done
					x=1 #Vale 1 cuando hay un proceso en la partición
					break
				fi
		done
		if [[ $x -eq 0 ]]; then # No hay proceso en la partición
			for (( j=0; j<${particiones[$i]}; j++ )); do
				if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
					n=$(($n + 1)) # Se pasa a la siguiente línea
					bandaMemoria[n]="     "
					bandaMemoriaColor[n]="     "
					numCaracteres=5
				fi
				bandaMemoria[n]+=$asteriscosAMeter
				bandaMemoriaColor[n]+=$NORMAL$fondosAMeter
				numCaracteres=$(($numCaracteres + $maxCaracteres))
			done
		fi

		# AÑADIR SEPARADOR DE PARTICIONES
		if [[ $i -lt ${#particiones[@]} ]]; then
			if [[ $(($numCaracteres + 1 + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
				n=$(($n + 1)) # Se pasa a la siguiente línea
				bandaMemoria[n]="     "
				bandaMemoriaColor[n]=$NORMAL"     "
				numCaracteres=5
			fi
			bandaMemoria[n]+="|"
			bandaMemoriaColor[n]+=$NORMAL"|"
			numCaracteres=$(($numCaracteres + 1))
		fi
	done
	# Añadir final de banda
	if [[ $(($numCaracteres + 5 + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
		n=$(($n + 1)) # Se pasa a la siguiente línea
		bandaMemoria[n]="     "
		bandaMemoriaColor[n]=$NORMAL"     "
		numCaracteres=5
	fi
	bandaMemoria[n]+=`printf "| M: %-$(($maxCaracteres))d" $sumaTotalMemoria` # TODO: CAMBIAR NÚMERO DE MEMORIA
	bandaMemoriaColor[n]+=`printf $NORMAL"| M: %-$(($maxCaracteres))d" $sumaTotalMemoria` # TODO: CAMBIAR NÚMERO DE MEMORIA

	# GENERACIÓN STRING DE POSICIÓN DE MEMORIA (Línea 5 de la Banda de Memoria)
	local bandaPosicion=("    |")
	local bandaPosicionColor=($NORMAL"    |")
	local n=0 # Línea de la banda
	local numCaracteres=5
	local x=0 # Variable que indica el número de procesos que se han añadido a la banda
	for (( i=1; i<=${#particiones[@]}; i++ )); do
		if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
			n=$(($n + 1)) # Se pasa a la siguiente línea
			bandaPosicion[n]="     "
			bandaPosicionColor[n]=$NORMAL"     "
			numCaracteres=5
		fi
		bandaPosicion[n]+=`printf "%${maxCaracteres}d" $x`
		bandaPosicionColor[n]+=`printf "%${maxCaracteres}d" $x`
		numCaracteres=$(($numCaracteres + $maxCaracteres))
		local ultimaPosicion=-1 # Permite añadir donde se termina el proceso dentro de la memoria
		for (( j=1; j<=${#partConProceso[@]}; j++ )); do
			if [[ $i -eq ${partConProceso[$j]} && (${estad[$j]} -eq 2 || ${estad[$j]} -eq 3 || ${estad[$j]} -eq 4) ]]; then # El proceso se puede imprimir en memoria
				ultimaPosicion=${memoria[$j]}
			fi
		done
		for (( k=0; k<$((${particiones[$i]} - 1)); k++ )); do
			if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
				n=$(($n + 1)) # Se pasa a la siguiente línea
				bandaPosicion[n]="     "
				bandaPosicionColor[n]=$NORMAL"     "
				numCaracteres=5
			fi
			if [[ $(($ultimaPosicion - 1)) -eq $k ]]; then
				bandaPosicion[n]+=`printf "%$(($maxCaracteres))d" $(($ultimaPosicion + $x))`
				bandaPosicionColor[n]+=`printf "%$(($maxCaracteres))d" $(($ultimaPosicion + $x))`
			else
				bandaPosicion[n]+=`printf "%$(($maxCaracteres))s" ""`
				bandaPosicionColor[n]+=`printf "%$(($maxCaracteres))s" ""`
			fi
			numCaracteres=$(($numCaracteres + $maxCaracteres))
		done

		# AÑADIR SEPARADOR DE PARTICIONES
		if [[ $i -lt ${#particiones[@]} ]]; then
			if [[ $(($numCaracteres + 1 + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
				n=$(($n + 1)) # Se pasa a la siguiente línea
				bandaPosicion[n]="     "
				bandaPosicionColor[n]=$NORMAL"     "
				numCaracteres=5
			fi
			bandaPosicion[n]+=" "
			bandaPosicionColor[n]+=" "
			numCaracteres=$(($numCaracteres + 1))
		fi
		x=$(($x + ${particiones[$i]}))
	done
	# Añadir final de banda
	if [[ $(($numCaracteres + 5 + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
		n=$(($n + 1)) # Se pasa a la siguiente línea
		bandaPosicion[n]="     "
		bandaPosicionColor[n]=$NORMAL"     "
		numCaracteres=5
	fi
	bandaPosicion[n]+=`printf "|    %$(($maxCaracteres))s" ""`
	bandaPosicionColor[n]+=`printf "|    %$(($maxCaracteres))s" ""`

	# IMPRIMIR LAS 5 LÍNEAS DE LA BANDA DE MEMORIA (COLOR y BN a pantalla y ficheros temporales)
	for (( i=0; i<${#bandaProcesos[@]}; i++ )); do
		echo -e "${bandaParticionesColor[$i]}" | tee -a $informeConColorTotal
		echo "${bandaParticiones[$i]}" >> $informeSinColorTotal
		echo -e "${bandaDefragmentacionParticionesColor[$i]}" | tee -a $informeConColorTotal
		echo "${bandaDefragmentacionParticiones[$i]}" >> $informeSinColorTotal
		echo -e "${bandaProcesosColor[$i]}" | tee -a $informeConColorTotal
		echo "${bandaProcesos[$i]}" >> $informeSinColorTotal
		echo -e "${bandaMemoriaColor[$i]}" | tee -a $informeConColorTotal
		echo "${bandaMemoria[$i]}" >> $informeSinColorTotal
		echo -e "${bandaPosicionColor[$i]}" | tee -a $informeConColorTotal
		echo "${bandaPosicion[$i]}" >> $informeSinColorTotal
	done
} #Fin de representacionParticionesEnTabla()

####################################################################################
# Sinopsis: Genera la Banda de Memoria y la muestra en pantalla/informe. Permite mostrar el orden de
# ejecución de los procesos y su evolución en el tiempo.
####################################################################################
function representacionLineaTemporal {
	local maxCaracteres=0
#	maxCaracteres=$(($digitosUnidad + 1)) # Longitud en número de dígitos de cada unidad
	maxCaracteres=$digitosUnidad # Longitud en número de dígitos de cada unidad. Ya se aumentó en la función de cálculo del tamaño de la unidad (calcularUnidad())
	if [[ $maxCaracteres -eq 2 ]]; then
		maxCaracteres=3 # El mínimo de caracteres tiene que ser 3 para que entren los nombres de
	fi
	local terminal=`tput cols` #Ancho del terminal para adecuar el ancho de líneas a cada volcado
	echo ""
	for (( s=0; s<=${#llegada[@]}; s++ )); do
		if [[ ${estad[$s]} -eq 3 ]]; then
			procPorUnidadTiempo[$reloj]=$s #En cada casilla contiene el número de orden del proceso que se ejecuta en cada instante. Sólo puede haber un proceso en cada instante.
		fi
	done
	echo ""

	# GENERACIÓN STRING DE LA BANDA DE TIEMPOS (Línea 1 de la Banda de Tiempos)
	local bandaProcesos=("    |")
	local bandaProcesosColor=($NORMAL"    |")
	local n=0 # Línea de la banda
	local numCaracteres=5
	fondosAMeter=${varfondos:1:$maxCaracteres}
	for (( k=0; k<=$reloj; k++ )); do
		if [[ $k -ne 0 ]]; then #Si no es T=0
			if [[ ${procPorUnidadTiempo[$k]} = ${procPorUnidadTiempo[$(($k - 1))]} ]]; then #Si se mantiene el mismo proceso en ejecución se imprimen espacios
				evento1=0
				if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
					n=$(($n + 1)) # Se pasa a la siguiente línea
					bandaProcesos[n]="     "
					bandaProcesosColor[n]="     "
					numCaracteres=5
				fi
				bandaProcesos[n]+=`printf "%$(($maxCaracteres))s" ""`
				bandaProcesosColor[n]+=`printf "%$(($maxCaracteres))s" ""`
				numCaracteres=$(($numCaracteres + $maxCaracteres))

			else #Si no se mantiene el mismo proceso en ejecución se imprime el nombre del nuevo proceso
				local p=${proceso[${procPorUnidadTiempo[$k]}]} #Se imprime el nombre del proceso en ejecución en ese instante definido por la posición almacenada en procPorUnidadTiempo
				evento1=1
				if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
					n=$(($n + 1)) # Se pasa a la siguiente línea
					bandaProcesos[n]="     "
					bandaProcesosColor[n]="     "
					numCaracteres=5
				fi
				bandaProcesos[n]+=`printf "%-$(($maxCaracteres))s" $p`
				if [[ $k -ne 0 ]]; then
					 bandaProcesosColor[n]+=`printf "${colores[${procPorUnidadTiempo[$k]} % 6]}%-$(($maxCaracteres))s$NORMAL" $p` # Modificado por dar error
				else
					bandaProcesosColor[n]+=`printf "%-$(($maxCaracteres))s$NORMAL" $p`
				fi
				numCaracteres=$(($numCaracteres + $maxCaracteres))
			fi
		else
			if [[ ${procPorUnidadTiempo[$k]} -eq 0 ]]; then
				bandaProcesos[n]+=`printf "%$(($maxCaracteres))s" ""`
				bandaProcesosColor[n]+=`printf "%$(($maxCaracteres))s" ""`
			else
				local p=${proceso[${procPorUnidadTiempo[$k]}]} #Se imprime el nombre del proceso en ejecución en ese instante definido por la posición almacenada en procPorUnidadTiempo
				evento1=1
				bandaProcesos[n]+=`printf "%-$(($maxCaracteres))s" $p`
				bandaProcesosColor[n]+=`printf "${colores[${procPorUnidadTiempo[$k]} % 6]}%-$(($maxCaracteres))s$NORMAL" $p` # Modificado por dar error
			fi
			numCaracteres=$(($numCaracteres + $maxCaracteres))
		fi
	done
	# Añadir final de banda
	if [[ $(($numCaracteres + 5 + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
		n=$(($n + 1)) # Se pasa a la siguiente línea
		bandaProcesos[n]="     "
		bandaProcesosColor[n]="     "
		numCaracteres=5
	fi
	bandaProcesos[n]+=`printf "|    %$(($maxCaracteres))s" ""`
	bandaProcesosColor[n]+=`printf "|    %$(($maxCaracteres))s" ""`

	# GENERACIÓN STRING DE LA BANDA DE TIEMPOS (Línea 2 de la Banda de Tiempos)
	local bandaTiempo=(" BT |")
	local bandaTiempoColor=(" BT |")
	local n=0 # Línea de la banda
	local numCaracteres=5
	for (( k=0; k<=$reloj; k++ )); do
		if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
			n=$(($n + 1)) # Se pasa a la siguiente línea
			bandaTiempo[n]="     "
			bandaTiempoColor[n]="     "
			numCaracteres=5
		fi

		espaciosAMeter=${varhuecos:1:$maxCaracteres}
		guionesAMeter=${varguiones:1:$maxCaracteres}
		fondosAMeter=${varfondos:1:$maxCaracteres}
		if [[ $k -eq $reloj ]]; then #Si el instante considerado es igual al tiempo actual
			bandaTiempo[n]+=$espaciosAMeter
			bandaTiempoColor[n]+=$espaciosAMeter
		else
			if [[ ${procPorUnidadTiempo[$k]} = $topeProcPorUnidadTiempo || ${procPorUnidadTiempo[$k]} = 0 ]]; then # Si no hay proceso en ejecución asociado a ese instante. Vale 0 si no está definido porque la inicialización empieza en posición=1.
					bandaTiempo[n]+=$guionesAMeter
				if [[ $k -ne 0 ]]; then #Si no es la primera unidad de la Banda de Tiempo
					if [[ ${procPorUnidadTiempo[$k]} -eq ${procPorUnidadTiempo[$k - 1]} ]]; then #Si no cambia de proceso en ejecución respecto al instante anterior
						if [[ $numCaracteres -eq 5 ]]; then #Si es el primer instante del mismo proceso de las segundas líneas respecto a la anterior se mantendría el color
							bandaTiempoColor[n]+=$NORMAL$fondosAMeter
						else
							bandaTiempoColor[n]+=$fondosAMeter
						fi
					else
						bandaTiempoColor[n]+=$NORMAL$fondosAMeter
					fi
				else
					if [[ ${procPorUnidadTiempo[$k]} -eq 0 ]]; then
						bandaTiempoColor[n]+=$NORMAL$fondosAMeter
					else
						bandaTiempoColor[n]+=$NORMAL$fondosAMeter
					fi
				fi
			else # Si hay proceso en ejecución asociado a ese instante
				bandaTiempo[n]+=$fondosAMeter
				if [[ $k -ne 0 ]]; then #Si no es T=0
					if [[ ${procPorUnidadTiempo[$k]} -eq ${procPorUnidadTiempo[$k - 1]} ]]; then #Si no cambia de proceso respecto al instante anterior
						if [[ $numCaracteres -eq 5 ]]; then #Si es el primer instante del mismo proceso de las segundas líneas respecto a la anterior se mantendría el color
							bandaTiempoColor[n]+=${colores[${procPorUnidadTiempo[$k-1]} % 6]}$fondosAMeter
						else
							bandaTiempoColor[n]+=$fondosAMeter
						fi
					else
						bandaTiempoColor[n]+=${colores[${procPorUnidadTiempo[$k]} % 6]}$fondosAMeter
					fi
				else
					if [[ ${procPorUnidadTiempo[$k]} -eq 0 ]]; then
						bandaTiempoColor[n]+=$NORMAL$fondosAMeter
					else
						bandaTiempoColor[n]+=${colores[${procPorUnidadTiempo[$k]} % 6]}$fondosAMeter
					fi
				fi
			fi
		fi
		numCaracteres=$(($numCaracteres + $maxCaracteres))
	done
	# Añadir final de banda
	if [[ $(($numCaracteres + 5 + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
		n=$(($n + 1)) # Se pasa a la siguiente línea
		bandaTiempo[n]="     "
		bandaTiempoColor[n]="     "
		numCaracteres=5
	fi
	bandaTiempo[n]+=`printf "| T: %-${maxCaracteres}d" $reloj`
	bandaTiempoColor[n]+=$NORMAL`printf "| T: %-${maxCaracteres}d" $reloj`


	# GENERACIÓN STRING DE LAS UNIDADES DE LOS INSTANES DE TIEMPO (Línea 3 de la Banda de Tiempos)
	local bandaInstantes=("    |")
	local bandaInstantesColor=($NORMAL"    |")
	local n=0 # Línea de la banda
	local numCaracteres=5
	for (( k=0; k<=$reloj; k++ )); do
		if [[ ${procPorUnidadTiempo[$k]} -eq ${procPorUnidadTiempo[$(($k - 1))]} ]]; then #Cuando se mantiene el mismo proceso en ejecución
			if [[ $k -eq 0 || $k -eq $reloj ]]; then #En T=0 o T=momento actual, aumenta el contenido de las bandas
				if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
					n=$(($n + 1)) # Se pasa a la siguiente línea
					bandaInstantes[n]="     "
					bandaInstantesColor[n]=$NORMAL"     "
					numCaracteres=5
				fi
				bandaInstantes[n]+=`printf "%${maxCaracteres}d" $k`
				bandaInstantesColor[n]+=`printf "%${maxCaracteres}d" $k`
				numCaracteres=$(($numCaracteres + $maxCaracteres))
			else #En T distinto de 0 o momento actual, también aumenta el contenido de las bandas
				if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
					n=$(($n + 1)) # Se pasa a la siguiente línea
					bandaInstantes[n]="     "
					bandaInstantesColor[n]=$NORMAL"     "
					numCaracteres=5
				fi
				bandaInstantes[n]+=`printf "%${maxCaracteres}s" ""`
				bandaInstantesColor[n]+=`printf "%${maxCaracteres}s" ""`
				numCaracteres=$(($numCaracteres + $maxCaracteres))
			fi
		else #Cuando no se mantiene el mismo proceso en ejecución
			if [[ $(($numCaracteres + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
				n=$(($n + 1)) # Se pasa a la siguiente línea
				bandaInstantes[n]="     "
				bandaInstantesColor[n]=$NORMAL"     "
				numCaracteres=5
			fi
			bandaInstantes[n]+=`printf "%${maxCaracteres}d" $k`
			bandaInstantesColor[n]+=`printf "%${maxCaracteres}d" $k`
			numCaracteres=$(($numCaracteres + $maxCaracteres))
		fi
	done
	# Añadir final de banda
	if [[ $(($numCaracteres + 5 + $maxCaracteres + 1)) -gt $terminal ]]; then # El texto no cabe en la terminal
		n=$(($n + 1)) # Se pasa a la siguiente línea
		bandaInstantes[n]="     "
		bandaInstantesColor[n]=$NORMAL"     "
		numCaracteres=5
	fi
	bandaInstantes[n]+=`printf "|    %$(($maxCaracteres))s" ""`
	bandaInstantesColor[n]+=`printf "|    %$(($maxCaracteres))s" ""`

	# IMPRIMIR BANDAS
	# IMPRIMIR LAS 3 LÍNEAS DE LA BANDA DE TIEMPOS (COLOR y BN a pantalla y ficheros temporales) - Se meten ahora en los temporales para que la banda de tiempo vaya tras la banda de memoria
	for (( i=0; i<${#bandaProcesos[@]}; i++ )); do
		echo "${bandaProcesos[$i]}" >> $informeSinColorTotal
		echo -e "${bandaProcesosColor[$i]}" | tee -a $informeConColorTotal
		echo "${bandaTiempo[$i]}" >> $informeSinColorTotal
		echo -e "${bandaTiempoColor[$i]}" | tee -a $informeConColorTotal
		echo "${bandaInstantes[$i]}" >> $informeSinColorTotal
		echo -e "${bandaInstantesColor[$i]}" | tee -a $informeConColorTotal
	done
	echo -e "\n\n" >> $informeSinColorTotal
	echo -e "\n\n" >> $informeConColorTotal
	# Aquí van pasando los instantes de reloj para todo el algoritmo
	if [[ ${procPorUnidadTiempo[$k]} = ${procPorUnidadTiempo[$(($k - 1))]} ]]; then
		evento1=0
	else
		evento1=1 #Cuando no se mantiene el mismo proceso en ejecución
	fi

} #Fin de representacionLineaTemporal()

####################################################################################
# Sinopsis: Muestra en pantalla/informe una tabla con el resultado final tras la ejecución
# de todos los procesos
####################################################################################
function resultadoFinalDeLaEjecucion {
	echo -e $AMARILLO"\n\n RESULTADO FINAL DE LA EJECUCIÓN DE PROCESOS:"$NORMAL | tee -a $informeConColorTotal
	echo -e "\n\n RESULTADO FINAL DE LA EJECUCIÓN DE PROCESOS: " >>$informeSinColorTotal
	echo -e " Ref Tll Tej Mem Prio Tesp Tret Trej Part %Def Estado" | tee -a $informeConColorTotal
	echo " Ref Tll Tej Mem Prio Tesp Tret Trej Part %Def Estado" >> $informeSinColorTotal

	for (( i=1; i<=${#tiempo[@]}; i++ )); do
		varColor=" ${colores[$i % 6]}${proceso[$i]} "
		varBN=" ${proceso[$i]} "
		longitudLlegada=$((longCampoTablaEstrecho - ${#llegada[$i]})) #Longitud de la variable para calcular los espacios a introducir antes de la unidad de la Banda de Tiempo
		varColor+="${varhuecos:1:$longitudLlegada}""${colores[$i % 6]}${llegada[$i]} "
		varBN+="${varhuecos:1:$longitudLlegada}""${llegada[$i]} "
		longitudTiempo=$((longCampoTablaEstrecho - ${#tiempo[$i]}))
		varColor+="${varhuecos:1:$longitudTiempo}""${colores[$i % 6]}${tiempo[$i]} "
		varBN+="${varhuecos:1:$longitudTiempo}""${tiempo[$i]} "
		longitudMemoria=$((longCampoTablaEstrecho - ${#memoria[$i]}))
		varColor+="${varhuecos:1:$longitudMemoria}""${colores[$i % 6]}${memoria[$i]} "
		varBN+="${varhuecos:1:$longitudMemoria}""${memoria[$i]} "
		longitudPrioProc=$((longCampoTablaEstrecho - ${#prioProc[$i]}))
		varColor+="${varhuecos:1:$longitudPrioProc}""${colores[$i % 6]}${prioProc[$i]} "
		varBN+="${varhuecos:1:$longitudPrioProc}""${prioProc[$i]} "
		longitudTiempoNEsperaProceso=$((longCampoTablaAncho - ${#tiempoNEsperaProceso[$i]}))
		varColor+="${varhuecos:1:$longitudTiempoNEsperaProceso}""${colores[$i % 6]}${tiempoNEsperaProceso[$i]} "
		varBN+="${varhuecos:1:$longitudTiempoNEsperaProceso}""${tiempoNEsperaProceso[$i]} "
		longitudTiempoNRespuProceso=$((longCampoTablaAncho - ${#tiempoNRetornoProceso[$i]}))
		varColor+="${varhuecos:1:$longitudTiempoNRespuProceso}""${colores[$i % 6]}${tiempoNRetornoProceso[$i]} "
		varBN+="${varhuecos:1:$longitudTiempoNRespuProceso}""${tiempoNRetornoProceso[$i]} "
		longitudRestante=$((longCampoTablaAncho - ${#restante[$i]}))
		varColor+="${varhuecos:1:$longitudRestante}""${colores[$i % 6]}${restante[$i]} "
		varBN+="${varhuecos:1:$longitudRestante}""${restante[$i]} "

		varColor+="   -    - ""${colores[$i % 6]}${estado[$i]} \n"
		varBN+="   -    - ""${estado[$i]} \n"
		echo -ne "$varColor" | tee -a $informeConColorTotal
		echo -ne "$varBN" >> $informeSinColorTotal

	done
	 echo -en $AMARILLO"\n TIEMPO DE ESPERA Y RESPUESTA:\n"$NORMAL | tee -a $informeConColorTotal
	echo -e "\n TIEMPO DE ESPERA Y RESPUESTA:\n" >>$informeSinColorTotal
	echo -e " Tiempo medio de Espera: $promedio_espera,$promedio_esperad\tTiempo medio de Retorno: $promedio_respuesta,$promedio_respuestad" | tee -a $informeConColorTotal
	echo -e " Tiempo medio de Espera: $promedio_espera,$promedio_esperad\tTiempo medio de Retorno: $promedio_respuesta,$promedio_respuestad" >>$informeSinColorTotal
	echo -ne $ROJO"\n\n Pulsa ENTER para continuar "$NORMAL
	read enterContinuar
} #Fin de resultadoFinalDeLaEjecucion()

####################################################################################
# Sinopsis: Calcula de los promedios de tiempo de espera y de tiempo de retorno
####################################################################################
function calcularPromediosEsperaRespuesta {
	suma_espera=0
	suma_respuesta=0
	counter=0
	for (( ss=1; ss<=${#llegada[@]}; ss++ )); do
		if [[ ${procesoEnParticionOcupada[$ss]} -eq 1 || ${estad[$ss]} -ne 0 ]]; then
			let suma_espera=$(expr ${tiempoEsperaProceso[$ss]} + $suma_espera)
			let suma_respuesta=$(expr ${tiempoRetornoProceso[$ss]} + $suma_respuesta)
		fi
		if [[ ${estad[$ss]} -ne 0 ]]; then
			let counter=$counter+1
		fi
	done
	if [[ $counter -ne 0 ]]; then
		promedio_espera=$(expr $suma_espera / $counter)
		let promedio_esperad=$suma_espera*100/$counter-$promedio_espera*100
		promedio_respuesta=$(expr $suma_respuesta / $counter)
		let promedio_respuestad=$suma_respuesta*100/$counter-$promedio_respuesta*100

		if [[ $optejecucion -ne 5 ]]; then
			echo -ne $NORMAL"\n Tiempo medio de Espera: $promedio_espera,$promedio_esperad\tTiempo medio de Retorno: $promedio_respuesta,$promedio_respuestad\n" | tee -a $informeConColorTotal
			echo -ne "\n Tiempo medio de Espera: $promedio_espera,$promedio_esperad\tTiempo medio de Retorno: $promedio_respuesta,$promedio_respuestad\n" >>$informeSinColorTotal
		fi
	else
		if [[ $optejecucion -ne 5 ]]; then
			echo -ne $NORMAL"\n Tiempo medio de Espera: 0,0\tTiempo medio de Retorno: 0,0\n" | tee -a $informeConColorTotal
			echo -ne "\n Tiempo medio de Espera: 0,0\tTiempo medio de Retorno: 0,0\n" >>$informeSinColorTotal
		fi
	fi

	if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 5 ]]; then
		dibujaColaRR #Se representa la cola de procesos de Round-Robin  
		echo -e $NORMAL"$DatosColaRR\n" | tee -a $informeConColorTotal
		echo -e "$DatosColaRR\n" >>$informeSinColorTotal
	fi
} #Fin de calcularPromediosEsperaRespuesta()

####################################################################################
# Sinopsis: Muestra la cola de procesos de Round-Robin (RR).
####################################################################################
function dibujaColaRR {	#colaTiempoRR		
	ejecutandoinst=-1
	DatosColaRR=" Cola de Round-Robin: "
	for (( contadorRR=1; contadorRR<=${#llegada[@]} ; contadorRR++ )); do
		if [[ ${estad[$contadorRR]} -eq 3 ]]; then #Se localiza el proceso en ejecución.
			ejecutandoinst=$contadorRR
		fi
	done
	for (( contadorRRorden=$indiceColaTiempoRREnEjecucion; contadorRRorden<$indiceColaTiempoRRLibre ; contadorRRorden++ )); do
		for (( contadorRR=1; contadorRR<=${#llegada[@]} ; contadorRR++ )); do
			if [[ $ejecutandoinst -ne -1 && $ejecutandoinst -ne $contadorRR ]]; then #Si hay procesos en ejecución, se puede buscar el orden de RR del resto de procesos.
				if [[ ${colaTiempoRR[$contadorRR]} -eq $contadorRRorden ]]; then
					if [[ ${estad[$contadorRR]} -eq 2 || ${estad[$contadorRR]} -eq 4 ]]; then
						DatosColaRR="$DatosColaRR${proceso[$contadorRR]} / "
					fi
				fi
			fi
		done
	done
#    clear 
} #Fin de dibujaColaRR()

####################################################################################
# Sinopsis: Permite al usuario ver, o no, un informe. El informe se crearía siempre.
####################################################################################
function mostrarInforme {
#    clear
	echo -e $AMARILLO"\n SE HA GENERADO UN INFORME"$NORMAL
	echo -e "\n  1. Ver informe a color en pantalla (se usa 'cat')"
	echo -e "\n  2. Ver informe en blanco y negro pantalla (se usa 'cat')"
	echo -e "\n  3. Editar informe en blanco y negro (se usa 'gedit')"
	echo -e "\n  4. Salir\n\n  --> "
	read seleccionMenuMostrarInforme
	#Comprobación de que el número introducido por el usuario es 1, 2, 3 ó 4
	until [[ "0" -lt $seleccionMenuMostrarInforme && $seleccionMenuMostrarInforme -lt "5" ]];	do
		echo -ne " Error en la elección de una opción válida\n  --> "
		read seleccionMenuMostrarInforme
	done

	while [[ 1 -lt $seleccionMenuMostrarInforme || $seleccionMenuMostrarInforme -lt 4 ]]; do
		case "$seleccionMenuMostrarInforme" in
		'1')
			cat $informeConColorTotal
			break
			;;
		'2')
			cat $informeSinColorTotal
			break
			;;
		'3')
			gedit $informeSinColorTotal
			break
			;;
		'4')
			echo -e $ROJO"\n SE HA SALIDO DEL PROGRAMA"$NORMAL
			exit 0
			break
			;;
		*) #No es necesario. Existe por si se modifica y no se revisa el until anterior.
#            clear
			echo -ne " Error en la elección de una opción válida\n  --> "
			;;
		esac
	done
} #Fin de mostrarInforme()

####################################################################################
####################################################################################
##############                   PROGRAMA PRINCIPAL                #################
####################################################################################
#Llamada a todas las funciones de forma secuencial
revisarArbolDirectorios #Regenera el árbol de directorios si no se encuentra.
presentacionPantallaInforme
menuInicio
inicializaVectores
if [[ $seleccionMenuAlgoritmoGestionProcesos -eq 1 ]]; then
	algoritmoFCFS_AjustePrimerMejorPeor
elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 2 ]]; then
	algoritmoSJF_AjustePrimerMejorPeor
elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 3 ]]; then
	algoritmoSRPT_AjustePrimerMejorPeor
elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 4 ]]; then
	algoritmoPrioridades_AjustePrimerMejorPeor
elif [[ $seleccionMenuAlgoritmoGestionProcesos -eq 5 ]]; then
	algoritmoRoundRobin_AjustePrimerMejorPeor
fi
#        clear
resultadoFinalDeLaEjecucion # Al final se mete el resumen de l ejecución completa
mostrarInforme # Y por último se pregunta si se quiere ver alguno de los informes (BN o COLOR).
